/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FmOperandType {
    kOperandTypeUnknown,
    kOperandTypeUnsupported,
    kOperandTypeUnspecified,
    kOperandTypeBinary,
    kOperandTypeBlob,
    kOperandTypeBoolean,
    kOperandTypeDatabaseKey,
    kOperandTypeDate,
    kOperandTypeDateTime,
    kOperandTypeNull,
    kOperandTypeNumeric,
    kOperandTypeString,
    kOperandTypeTime,
    kOperandTypeTimeInterval,
    kOperandTypeTuple,
    kOperandTypeYMDInterval;


    public static FmOperandType fromFmDatatype(FmDatatype type) {
        switch (type) {
            case CHARACTER: 
            case CHARACTERLENGTH16: 
            case CHARACTERLENGTH32: 
            case NCHAR: 
            case NVARCHAR: {
                return kOperandTypeString;
            }
            case INT16: 
            case INT32: 
            case INT64: 
            case DECIMAL: 
            case NUMERIC: 
            case FLOAT: 
            case FLOAT32: 
            case FLOAT64: {
                return kOperandTypeNumeric;
            }
            case BINARY: 
            case BINARYLENGTH16: {
                return kOperandTypeBinary;
            }
            case DATE: {
                return kOperandTypeDate;
            }
            case DATETIME: 
            case TIMESTAMPTZ: {
                return kOperandTypeDateTime;
            }
            case TIME: 
            case TIMETZ: {
                return kOperandTypeTime;
            }
            case TIMEINTERVAL: 
            case INTERVALYM: {
                return kOperandTypeTimeInterval;
            }
            case DATABASEKEY: {
                return kOperandTypeDatabaseKey;
            }
            case BLOB: 
            case TEXTBLOB: {
                return kOperandTypeBlob;
            }
        }
        return kOperandTypeUnknown;
    }
}

