/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDataSource;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmEMDObjectNaming;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPackages;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmProject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSecurityObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSecurityView;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSecurityViewDefinition;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.CubeBase;
import com.ibm.cognos.fmeng.fmmd.model.Folder;
import com.ibm.cognos.fmeng.fmmd.model.GovernorBase;
import com.ibm.cognos.fmeng.fmmd.model.GovernorWithIntValue;
import com.ibm.cognos.fmeng.fmmd.model.GovernorWithListValue;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.Namespace;
import com.ibm.cognos.fmeng.fmmd.model.Package;
import com.ibm.cognos.fmeng.fmmd.model.Project;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.RelationalQuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.Section;
import com.ibm.cognos.fmeng.fmmd.model.SecurityViewDefinition;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.fmmd.util.CmHelper;
import com.ibm.cognos.fmeng.fmmd.util.EmfHelper;
import com.ibm.cognos.fmeng.fmmd.util.SearchFilter;
import com.ibm.cognos.fmeng.genmodel.AdminAccessType;
import com.ibm.cognos.fmeng.genmodel.CubeType;
import com.ibm.cognos.fmeng.genmodel.DataSourceRefsType;
import com.ibm.cognos.fmeng.genmodel.DecisionRoleType;
import com.ibm.cognos.fmeng.genmodel.FunctionSetType;
import com.ibm.cognos.fmeng.genmodel.FunctionSetsType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.GovernorsType;
import com.ibm.cognos.fmeng.genmodel.LocaleType;
import com.ibm.cognos.fmeng.genmodel.MeasureDimensionType;
import com.ibm.cognos.fmeng.genmodel.NamespaceType;
import com.ibm.cognos.fmeng.genmodel.PackageDefinition;
import com.ibm.cognos.fmeng.genmodel.PackageViewType;
import com.ibm.cognos.fmeng.genmodel.QuerySubjectBaseType;
import com.ibm.cognos.fmeng.genmodel.QuerySubjectType;
import com.ibm.cognos.fmeng.genmodel.RelationalDimensionType;
import com.ibm.cognos.fmeng.genmodel.RelationalQuerySubjectType;
import com.ibm.cognos.fmeng.genmodel.SectionType;
import com.ibm.cognos.fmeng.genmodel.SecurityObjectType;
import com.ibm.cognos.fmeng.genmodel.SecurityViewDefinitionType;
import com.ibm.cognos.fmeng.genmodel.SecurityViewType;
import com.ibm.cognos.fmeng.genmodel.SupportedLocalesType;
import com.ibm.cognos.fmeng.genmodel.VirtualCubeType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.DebugUtil;
import com.ibm.cognos.fmeng.utility.EMFCustomModelSerializer;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import com.ibm.cognos.fmeng.utility.PublishSerializationListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmPackage
extends FmReportObject
implements Package {
    public static FmPackage createObject(FMMDSession session, FmPackages parent, String objectName, FmEMDObjectNaming makeUniqueRule) {
        if (objectName == null || objectName.length() == 0) {
            objectName = FmPackage.getDefaultName(session.getActiveLocale());
        }
        PackageViewType emfObj = GenmodelFactory.eINSTANCE.createPackageViewType();
        FmPackage pkg = new FmPackage(session, emfObj);
        parent.addPackage(pkg);
        String uniqueName = pkg.makeUniqueName(objectName);
        String localeKey = FmModelFactory.getInstance().getProject(session).getDefaultLocale();
        pkg.setName(localeKey, uniqueName);
        pkg.addLocale(localeKey);
        pkg.setMaxModelVersions(0);
        return pkg;
    }

    public static FmPackage get(FMMDSession session, Object emfobj) {
        return new FmPackage(session, (PackageViewType)emfobj);
    }

    private FmPackage(FMMDSession session, PackageViewType emfObject) {
        super(session, emfObject);
    }

    @Override
    public FmObjectType getFmObjectType() {
        return FmObjectType.kPackage;
    }

    public String publishToCM(String cmPath, int tempModelRetention) {
        String cmPackagePath = null;
        List<String> names = this.getNameList();
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream(1000000);
            GZIPOutputStream gzipstream = new GZIPOutputStream(stream);
            PublishSerializationListener publishSerializer = PublishSerializationListener.create(this.m_session, this, true);
            EMFCustomModelSerializer serializer = new EMFCustomModelSerializer(gzipstream, (XMLResource)this.m_session.getResource(), publishSerializer);
            Project root = this.m_session.getProject();
            boolean bQueryMode = root.getDynamicQueryMode();
            serializer.serialize((EObject)root.getInternal(), true);
            gzipstream.flush();
            gzipstream.finish();
            CmHelper cmHelper = CmHelper.get(this.m_session, this.m_session.getPassport());
            ArrayList<String> fndNames = new ArrayList<String>();
            BaseClass foundPkg = cmHelper.findPackage(cmPath, names, fndNames);
            if (foundPkg != null) {
                cmPackagePath = foundPkg.getSearchPath().getValue();
            }
            cmPackagePath = cmHelper.createUpdatePackage(cmPackagePath != null && cmPackagePath.length() != 0 ? cmPackagePath : cmPath, this, cmPackagePath != null ? cmPackagePath.length() != 0 : false, tempModelRetention);
            cmHelper.setModelRetention(cmPackagePath, tempModelRetention);
            String modelPath = cmHelper.createModel(cmPackagePath, this.getMaxModelVersions() < 0, bQueryMode, stream);
            FmSecurityView view = this.getSecurityView();
            ArrayList<FmSecurityView> viewList = new ArrayList<FmSecurityView>();
            view.getAllReferencedViews(viewList);
            int i = 0;
            while (i < viewList.size()) {
                cmHelper.addModelView(modelPath, ((FmSecurityView)viewList.get(i)).getID());
                ++i;
            }
            if (tempModelRetention != this.getMaxModelVersions()) {
                int maxRetentionfromModel = this.getMaxModelVersions();
                maxRetentionfromModel = maxRetentionfromModel < 0 ? 1 : maxRetentionfromModel;
                cmHelper.setModelRetention(cmPackagePath, maxRetentionfromModel);
            }
        }
        catch (Exception e) {
            DebugUtil.GetInstance().debug(e);
            String[] args = new String[]{e.getLocalizedMessage()};
            FmMDException fmException = new FmMDException("BMT_MD_FAILED_TO_PUBLISH", args);
            throw fmException;
        }
        return cmPackagePath;
    }

    @Override
    public void setMaxModelVersions(int newModelRetention) {
        this.getPackageViewType().setMaxVersions(BigInteger.valueOf(newModelRetention));
    }

    @Override
    public int getMaxModelVersions() {
        return this.getPackageViewType().getMaxVersions().intValue();
    }

    public List<String> getPackageLocales() {
        ArrayList<String> localeStrs = new ArrayList<String>();
        SupportedLocalesType localesType = this.getPackageViewType().getLocales();
        if (localesType != null) {
            EList<LocaleType> locales = localesType.getLocale();
            int i = 0;
            while (i < locales.size()) {
                localeStrs.add(((LocaleType)locales.get(i)).getValue());
                ++i;
            }
        }
        return localeStrs;
    }

    public void setLocales(List<String> localeStrs) {
        SupportedLocalesType localesType = this.getPackageViewType().getLocales();
        if (localesType != null) {
            localesType.getLocale().clear();
        }
        int i = 0;
        while (i < localeStrs.size()) {
            this.addLocale(localeStrs.get(i));
            ++i;
        }
    }

    public void addLocale(String localeName) {
        SupportedLocalesType supportedLocalesType = this.getPackageViewType().getLocales();
        if (supportedLocalesType == null) {
            supportedLocalesType = GenmodelFactory.eINSTANCE.createSupportedLocalesType();
            this.getPackageViewType().setLocales(supportedLocalesType);
        }
        EList<LocaleType> locales = supportedLocalesType.getLocale();
        boolean fnd = false;
        int i = 0;
        while (i < locales.size()) {
            if (((LocaleType)locales.get(i)).getValue().equals(localeName)) {
                fnd = true;
                break;
            }
            ++i;
        }
        if (!fnd) {
            LocaleType localeType = GenmodelFactory.eINSTANCE.createLocaleType();
            localeType.setValue(localeName);
            locales.add(localeType);
        }
    }

    public boolean referencesSAPR3() {
        boolean bRefR3 = false;
        List<FmDataSource> dataSources = this.getFmProject().getDataSourcesFolder().getDataSourceCollection();
        final ArrayList<FmDataSource> r3OrECSources = new ArrayList<FmDataSource>();
        for (FmDataSource source : dataSources) {
            if (!"R3".equals(source.getInterface()) && !"EC".equals(source.getInterface())) continue;
            r3OrECSources.add(source);
        }
        if (dataSources.size() > 0) {
            final ArrayList r3ReferencingQuerySubjects = new ArrayList();
            SearchFilter filter = new SearchFilter(){

                public boolean foundElement(Object obj) {
                    DataSourceRefsType dsrefs = (DataSourceRefsType)obj;
                    EList<EObject> dataRefs = dsrefs.getDataSourceRef();
                    for (Object ref : dataRefs) {
                        for (FmDataSource r3Source : r3OrECSources) {
                            if (r3Source.getInternal() != ref) continue;
                            Object parent = FmPackage.this.m_session.getGateway().getParent(dsrefs);
                            while (parent != null && !(parent instanceof QuerySubjectBaseType)) {
                                parent = FmPackage.this.m_session.getGateway().getParent(parent);
                            }
                            if (parent == null) continue;
                            r3ReferencingQuerySubjects.add((FmQuerySubjectBase)FmModelFactory.getInstance().get(FmPackage.this.m_session, parent));
                        }
                    }
                    return false;
                }
            };
            HashSet<Integer> recurseInto = new HashSet<Integer>();
            recurseInto.add(148);
            recurseInto.add(88);
            recurseInto.add(37);
            recurseInto.add(72);
            recurseInto.add(35);
            recurseInto.add(166);
            HashSet<Integer> lookingFor = new HashSet<Integer>();
            lookingFor.add(32);
            EmfHelper.traverse(this.getFmProject().getInternal(), recurseInto, lookingFor, filter, false);
            if (r3ReferencingQuerySubjects.size() > 0) {
                FmSecurityView view = this.getSecurityView();
                int i = 0;
                while (i < r3ReferencingQuerySubjects.size()) {
                    FmBaseObject obj = (FmBaseObject)r3ReferencingQuerySubjects.get(i);
                    if (view.isObjectIncluded(obj)) {
                        bRefR3 = true;
                        break;
                    }
                    ++i;
                }
            }
        }
        return bRefR3;
    }

    public FmSecurityView getSecurityView() {
        EObject view = this.getPackageViewType().getDefinition().getViewref();
        if (view != null && view instanceof SecurityViewType) {
            return (FmSecurityView)FmModelFactory.getInstance().get(this.m_session, view);
        }
        return null;
    }

    @Override
    public void setSecurityView(FmSecurityView securityView) {
        PackageDefinition definition = this.getPackageViewType().getDefinition();
        if (definition == null) {
            definition = GenmodelFactory.eINSTANCE.createPackageDefinition();
            this.getPackageViewType().setDefinition(definition);
        }
        this.getPackageViewType().getDefinition().setViewref((EObject)securityView.getInternal());
    }

    public boolean containsDimensions() {
        return false;
    }

    public boolean isPP8Compatible() {
        return false;
    }

    public List<FmSecurityObject> getAdminSecurityObjects() {
        DecisionRoleType dRole;
        EList<SecurityObjectType> securityObjectEobjs = null;
        AdminAccessType adminAccess = this.getPackageViewType().getAdminAccess();
        if (adminAccess != null && (dRole = adminAccess.getDecisionRole()) != null) {
            securityObjectEobjs = dRole.getSecurityObject();
        }
        ArrayList<FmSecurityObject> securityObjs = null;
        if (securityObjectEobjs != null) {
            securityObjs = new ArrayList(securityObjectEobjs.size());
            for (SecurityObjectType st : securityObjectEobjs) {
                FmSecurityObject secObj = FmSecurityObject.get(this.m_session, st);
                securityObjs.add(secObj);
            }
        } else {
            securityObjs = new ArrayList<FmSecurityObject>(0);
        }
        return securityObjs;
    }

    public void setSecurity(List<FmSecurityObject> fmAdminSecurityObjects) {
        PackageViewType pckg = this.getPackageViewType();
        AdminAccessType adminAccess = pckg.getAdminAccess();
        if (adminAccess == null) {
            adminAccess = GenmodelFactory.eINSTANCE.createAdminAccessType();
            pckg.setAdminAccess(adminAccess);
        }
        if (fmAdminSecurityObjects.isEmpty()) {
            return;
        }
        DecisionRoleType dRole = adminAccess.getDecisionRole();
        if (dRole == null) {
            dRole = GenmodelFactory.eINSTANCE.createDecisionRoleType();
            adminAccess.setDecisionRole(dRole);
        }
        EList<SecurityObjectType> securityObjectList = dRole.getSecurityObject();
        securityObjectList.clear();
        int i = 0;
        while (i < fmAdminSecurityObjects.size()) {
            securityObjectList.add((Object)fmAdminSecurityObjects.get(i).getSecurityObjectType());
            ++i;
        }
    }

    public String getDefaultName() {
        FmProject project = FmModelFactory.getInstance().getProject(this.m_session);
        return this.getName(project.getDefaultLocale());
    }

    public static String getDefaultName(Locale locale) {
        return FmMessage.render("BMT_MDN_OBJECT_NAME_PACKAGE", locale);
    }

    @Override
    public void setIsNullSuppressionAllowed(boolean isNullSuppressionAllowed) {
        this.getPackageViewType().setIsNullSuppressionAllowed(isNullSuppressionAllowed);
    }

    @Override
    public boolean getIsNullSuppressionAllowed() {
        return this.getPackageViewType().isIsNullSuppressionAllowed();
    }

    @Override
    public void setIsMultiEdgeNullSuppressionAllowed(boolean isMultiEdgeNullSuppressionAllowed) {
        this.getPackageViewType().setIsMultiEdgeNullSuppressionAllowed(isMultiEdgeNullSuppressionAllowed);
    }

    @Override
    public boolean getIsMultiEdgeNullSuppressionAllowed() {
        return this.getPackageViewType().isIsMultiEdgeNullSuppressionAllowed();
    }

    @Override
    public void setIsAccessToNullSuppressionOptionsAllowed(boolean isAccessToNullSuppressionOptionsAllowed) {
        this.getPackageViewType().setIsAccessToNullSuppressionOptionsAllowed(isAccessToNullSuppressionOptionsAllowed);
    }

    @Override
    public boolean getIsAccessToNullSuppressionOptionsAllowed() {
        return this.getPackageViewType().isIsAccessToNullSuppressionOptionsAllowed();
    }

    @Override
    public void setUseV5DataServer(boolean useV5DataServer) {
        this.getPackageViewType().setUseV5DataServer(useV5DataServer);
    }

    @Override
    public boolean getUseV5DataServer() {
        return this.getPackageViewType().isUseV5DataServer();
    }

    public void addFunctionSet(String functionSetId) {
        FmSecurityView fmView = this.getSecurityView();
        if (fmView != null) {
            SecurityViewType eview = (SecurityViewType)fmView.m_emfObject;
            FunctionSetsType funcSets = eview.getFunctionSets();
            if (funcSets == null) {
                funcSets = GenmodelFactory.eINSTANCE.createFunctionSetsType();
                eview.setFunctionSets(funcSets);
            }
            EList<FunctionSetType> functionSetTypeList = funcSets.getFunctionSet();
            boolean fnd = false;
            int i = 0;
            while (i < functionSetTypeList.size()) {
                if (((FunctionSetType)functionSetTypeList.get(i)).getFunctionSetID().equals(functionSetId)) {
                    fnd = true;
                    break;
                }
                ++i;
            }
            if (!fnd) {
                FunctionSetType funcSetType = GenmodelFactory.eINSTANCE.createFunctionSetType();
                funcSetType.setFunctionSetID(functionSetId);
                functionSetTypeList.add(funcSetType);
            }
        }
    }

    private PackageViewType getPackageViewType() {
        return (PackageViewType)this.m_emfObject;
    }

    public void setSecurityImplementation(Package.SecurityImplementation security) {
        switch (security) {
            case viewBased: {
                this.getPackageViewType().setIsRoleBased(true);
                this.getSecurityView().setIsRoleBased(true);
                this.getSecurityView().setIsViewBased(true);
                break;
            }
            case roleBased: {
                this.getPackageViewType().setIsRoleBased(true);
                this.getSecurityView().setIsRoleBased(true);
                this.getSecurityView().setIsViewBased(false);
                break;
            }
            default: {
                this.getPackageViewType().setIsRoleBased(false);
                this.getSecurityView().setIsRoleBased(false);
                this.getSecurityView().setIsViewBased(false);
            }
        }
    }

    public void setIsRoleBased(boolean isRoleBased) {
        this.getPackageViewType().setIsRoleBased(isRoleBased);
        this.getSecurityView().setIsRoleBased(isRoleBased);
    }

    @Override
    public List<Package> getDependentPackages() {
        ArrayList<FmSecurityView> views = new ArrayList<FmSecurityView>();
        this.getSecurityView().getAllReferencedViews(views);
        ArrayList<Package> packages = new ArrayList<Package>();
        for (FmSecurityView view : views) {
            packages.addAll(view.getReferencingPackages());
        }
        return packages;
    }

    @Override
    public void publishToCM(String ContentManagerlocation, String externalizeQuerySubjectsToThisLocation) {
        this.publishToCM(ContentManagerlocation, this.getMaxModelVersions());
    }

    @Override
    public void publishToStream(OutputStream location, String externalizeQuerySubjectsToThisLocation) {
        try {
            PublishSerializationListener publishSerializer = PublishSerializationListener.create(this.m_session, this, true);
            EMFCustomModelSerializer serializer = new EMFCustomModelSerializer(location, (XMLResource)this.m_session.getResource(), publishSerializer);
            Project root = this.m_session.getProject();
            serializer.serialize((EObject)root.getInternal(), true);
            location.flush();
            location.close();
        }
        catch (IOException e) {
            String[] args = new String[]{e.getLocalizedMessage()};
            FmMDException fmException = new FmMDException("BMT_MD_FAILED_TO_PUBLISH", args);
            throw fmException;
        }
    }

    private List<EObject> getRefObjs() {
        return this.getPackageViewType().getRefobj();
    }

    @Override
    public void addPackageContents(List<? extends TopLevelObject> contents) {
        for (TopLevelObject topLevelObject : contents) {
            if (this.isAncestorPartOfPackage(topLevelObject)) continue;
            switch (topLevelObject.getFmObjectType()) {
                case folder: 
                case namespace: {
                    Section nmsp = (Section)topLevelObject;
                    List<ReportObject> l = nmsp.getAllCubesFoldersAndNamespaces();
                    this.removeChildObjects(l);
                    this.getPackageViewType().getRefobj().add((Object)((EObject)topLevelObject.getInternal()));
                    break;
                }
                case calculation: 
                case cube: 
                case filter: 
                case measureDimension: 
                case parameterMap: 
                case querySubject: 
                case relationalDimension: 
                case relationalQuerySubject: 
                case virtualCube: {
                    this.getPackageViewType().getRefobj().add((Object)((EObject)topLevelObject.getInternal()));
                    break;
                }
                default: {
                    throw new FmMDException("BMT_MD_INVALID_PACKAGE_OBJECT", topLevelObject.getFmObjectTypeName());
                }
            }
        }
    }

    public List<TopLevelObject> getExcludeContents(List<? extends TopLevelObject> contents) {
        ArrayList<TopLevelObject> list = new ArrayList<TopLevelObject>();
        for (TopLevelObject topLevelObject : contents) {
            if (!this.isAncestorPartOfPackage(topLevelObject)) continue;
            list.add(topLevelObject);
        }
        return list;
    }

    @Override
    public List<CubeBase> getAllCubes() {
        ArrayList<CubeBase> cubes = new ArrayList<CubeBase>();
        List<TopLevelObject> contents = this.getPackageContents();
        for (TopLevelObject r : contents) {
            if (r instanceof CubeBase) {
                cubes.add((CubeBase)r);
                continue;
            }
            if (!(r instanceof Section)) continue;
            cubes.addAll(((Section)r).getAllCubes());
        }
        return cubes;
    }

    @Override
    public List<TopLevelObject> getPackageContents() {
        ArrayList<TopLevelObject> results = new ArrayList<TopLevelObject>();
        for (EObject refObj : this.getPackageViewType().getRefobj()) {
            results.add(FmModelFactory.getInstance().get(this.m_session, refObj));
        }
        return results;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty((List<EObject>)this.getPackageViewType().getRefobj());
    }

    private boolean isEmpty(List<EObject> children) {
        for (EObject child : children) {
            boolean bEmpty = true;
            if (child instanceof NamespaceType || child instanceof SectionType) {
                bEmpty = this.isEmpty((List<EObject>)child.eContents());
            } else if (child instanceof RelationalQuerySubjectType || child instanceof RelationalDimensionType || child instanceof MeasureDimensionType || child instanceof QuerySubjectType || child instanceof CubeType || child instanceof VirtualCubeType) {
                bEmpty = false;
            }
            if (bEmpty) continue;
            return bEmpty;
        }
        return true;
    }

    @Override
    public void removeObjectFromPackage(TopLevelObject content) {
        this.getPackageViewType().getRefobj().remove(content.getInternal());
    }

    @Override
    public void setPublishLocationCMPath(String locationCMPath) {
        this.getPackageViewType().setPublishLocationCMPath(locationCMPath);
    }

    @Override
    public String getPublishLocationCMPath() {
        return this.getPackageViewType().getPublishLocationCMPath();
    }

    private boolean isAncestorPartOfPackage(BaseObject obj) {
        EObject parent = (EObject)obj.getInternal();
        while (parent != null) {
            if (this.getRefObjs().contains(parent)) {
                return true;
            }
            parent = parent.eContainer();
        }
        return false;
    }

    private void removeChildObjects(List<ReportObject> l) {
        int i = 0;
        while (i < l.size()) {
            this.getRefObjs().remove(l.get(i).getInternal());
            ++i;
        }
    }

    @Override
    public void addPackageContents(TopLevelObject object) {
        ArrayList<TopLevelObject> contents = new ArrayList<TopLevelObject>(1);
        contents.add(object);
        this.addPackageContents(contents);
    }

    public List<RelationalObject> getAllQuerySubjects() {
        ArrayList<RelationalObject> relationalObjects = new ArrayList<RelationalObject>();
        List<TopLevelObject> contents = this.getPackageContents();
        for (TopLevelObject r : contents) {
            if (r instanceof RelationalQuerySubject) {
                relationalObjects.add((RelationalObject)r);
                continue;
            }
            if (!(r instanceof Namespace) && !(r instanceof Folder)) continue;
            List<RelationalQuerySubject> childContents = ((Section)r).getAllRelationalQuerySubjects();
            for (RelationalObject relationalObject : childContents) {
                relationalObjects.add(relationalObject);
            }
        }
        return relationalObjects;
    }

    public List<RelationalObject> getAllDimensions() {
        ArrayList<RelationalObject> relationalObjects = new ArrayList<RelationalObject>();
        List<TopLevelObject> contents = this.getPackageContents();
        for (TopLevelObject r : contents) {
            if (r instanceof RelationalDimension || r instanceof MeasureDimension) {
                relationalObjects.add((RelationalObject)r);
                continue;
            }
            if (!(r instanceof Namespace) && !(r instanceof Folder)) continue;
            List<RelationalDimensionBase> childContents = ((Section)r).getAllRelationalDimensions();
            for (RelationalObject relationalObject : childContents) {
                relationalObjects.add(relationalObject);
            }
        }
        return relationalObjects;
    }

    public List<RelationalObject> getAllRelationalObjects() {
        ArrayList<RelationalObject> relationalObjects = new ArrayList<RelationalObject>();
        List<RelationalObject> qsbList = this.getAllQuerySubjects();
        List<RelationalObject> dimensionsList = this.getAllDimensions();
        for (RelationalObject rObj : qsbList) {
            relationalObjects.add(rObj);
        }
        for (RelationalObject rObj : dimensionsList) {
            relationalObjects.add(rObj);
        }
        return relationalObjects;
    }

    public List<ReportObject> getAllRelationalObjectsNamespacesAndFolders() {
        ArrayList<ReportObject> reportObjects = new ArrayList<ReportObject>();
        List<TopLevelObject> contents = this.getPackageContents();
        for (TopLevelObject r : contents) {
            if (r instanceof RelationalDimension || r instanceof MeasureDimension || r instanceof RelationalQuerySubject) {
                reportObjects.add((ReportObject)r);
                continue;
            }
            if (!(r instanceof Namespace) && !(r instanceof Folder)) continue;
            reportObjects.add((ReportObject)r);
            List<ReportObject> childContents = ((Section)r).getAllRelationalObjectsFoldersAndNamespaces();
            for (ReportObject rChild : childContents) {
                reportObjects.add(rChild);
            }
        }
        return reportObjects;
    }

    public List<ReportObject> getAllQuerySubjectsNamespacesAndFolders() {
        ArrayList<ReportObject> reportObjects = new ArrayList<ReportObject>();
        List<TopLevelObject> contents = this.getPackageContents();
        for (TopLevelObject r : contents) {
            if (r instanceof RelationalQuerySubject) {
                reportObjects.add((ReportObject)r);
                continue;
            }
            if (!(r instanceof Namespace) && !(r instanceof Folder)) continue;
            reportObjects.add((ReportObject)r);
            List<ReportObject> childContents = ((Section)r).getAllQuerySubjectsNamespacesAndFolders();
            for (ReportObject rChild : childContents) {
                reportObjects.add(rChild);
            }
        }
        return reportObjects;
    }

    public List<ReportObject> getAllDimensionalObjectsNamespacesAndFolders() {
        ArrayList<ReportObject> reportObjects = new ArrayList<ReportObject>();
        List<TopLevelObject> contents = this.getPackageContents();
        for (TopLevelObject r : contents) {
            if (r instanceof RelationalDimension || r instanceof MeasureDimension) {
                reportObjects.add((ReportObject)r);
                continue;
            }
            if (!(r instanceof Namespace) && !(r instanceof Folder)) continue;
            reportObjects.add((ReportObject)r);
            List<ReportObject> childContents = ((Section)r).getAllDimensionsNamespacesAndFolders();
            for (ReportObject rChild : childContents) {
                reportObjects.add(rChild);
            }
        }
        return reportObjects;
    }

    @Override
    public Set<String> getGovernorKeys() {
        GovernorsType govs = this.getGovernorsType();
        return govs.getGovernor().keySet();
    }

    @Override
    public String getGovernorValue(String key) {
        GovernorsType govs = this.getGovernorsType();
        return (String)govs.getGovernor().get((Object)key);
    }

    @Override
    public void setGovernor(String key, String value) {
        GovernorBase gb = this.m_session.getTaskReadGovernorsDefinition().getKeyToGovernorMap().get(key);
        if (gb != null) {
            block15: {
                GovernorBase temp;
                value = value.trim();
                if (gb.isTypeInt()) {
                    if (value.charAt(0) == '-') {
                        throw new FmMDException("BMT_MD_GOVERNOR_CAN_NOT_HAVE_NEGATIVE_VALUE", key);
                    }
                    try {
                        temp = (GovernorWithIntValue)gb;
                        if (temp.getMaxValue() != -1 && temp.getMaxValue() < Integer.parseInt(value)) {
                            throw new FmMDException("BMT_MD_GOVERNOR_MAX_VALUE_EXCEEDED", temp.getId(), String.valueOf(temp.getMaxValue()));
                        }
                        break block15;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new FmMDException("BMT_MD_GOVERNOR_CAN_ONLY_HAVE_POSITIVE_INTEGER_VALUES", key);
                    }
                }
                if (gb.isTypeBoolean()) {
                    if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                        throw new FmMDException("BMT_MD_GOVERNOR_CAN_ONLY_HAVE_BOOLEAN_VALUES", key);
                    }
                } else if (gb.isTypeList()) {
                    temp = (GovernorWithListValue)gb;
                    boolean acceptable = false;
                    List<String> allowedValues = temp.getListOfApplicableValues();
                    for (String allowedValue : allowedValues) {
                        if (!allowedValue.equalsIgnoreCase(value)) continue;
                        acceptable = true;
                    }
                    if (!acceptable) {
                        throw new FmMDException("BMT_MD_GOVERNOR_VALUE_NOT_ACCEPTABLE", key, value);
                    }
                }
            }
            GovernorsType govs = this.getGovernorsType();
            if (gb.getDefaultValueAsString().equals(value)) {
                govs.getGovernor().remove((Object)key);
            } else {
                govs.getGovernor().put((Object)key, (Object)value);
            }
        } else {
            throw new FmMDException("BMT_MD_GOVERNOR_IS_NOT_VALID", key);
        }
    }

    private GovernorsType getGovernorsType() {
        GovernorsType govs = this.getPackageViewType().getGovernors();
        if (govs == null) {
            govs = GenmodelFactory.eINSTANCE.createGovernorsType();
            this.getPackageViewType().setGovernors(govs);
        }
        return govs;
    }

    @Override
    public void resetGovernors() {
        GovernorsType govs = this.getGovernorsType();
        govs.getGovernor().clear();
    }

    @Override
    public boolean isStupidSpecialCaseCubeHandling() {
        return false;
    }

    public void addSecurityViewDefinition(FmSecurityViewDefinition secDef) {
        this.addSecurityViewDefinition((SecurityViewDefinitionType)secDef.getInternal());
    }

    protected void addSecurityViewDefinition(SecurityViewDefinitionType secDef) {
        this.getPackageViewType().getSecurityViewDefinition().add((Object)secDef);
    }

    @Override
    public SecurityViewDefinition createSecurityViewDefinition(String name) {
        return FmSecurityViewDefinition.createSecurityViewDefinition(this.m_session, this, name);
    }

    @Override
    public List<SecurityViewDefinition> getSecurityViewDefinitions() {
        ArrayList<SecurityViewDefinition> secDefs = new ArrayList<SecurityViewDefinition>();
        for (SecurityViewDefinitionType secDef : this.getPackageViewType().getSecurityViewDefinition()) {
            secDefs.add(FmSecurityViewDefinition.get(this.m_session, secDef));
        }
        return secDefs;
    }

    public static class FmEPublishTargetType {
        public static final short kFile = 0;
        public static final short kProject = 1;
        public static final short kContentManager = 2;
    }
}

