/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FilterDefinitionParentInternal;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmComplexProperty;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDataSource;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFilterDefinition;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmJoin;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSQLObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTable;
import com.ibm.cognos.fmeng.fmmd.model.Cardinality;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.FilterDefinition;
import com.ibm.cognos.fmeng.fmmd.model.Join;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.SQLObject;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.fmmd.util.FmRoute;
import com.ibm.cognos.fmeng.fmmd.util.FmRoutes;
import com.ibm.cognos.fmeng.genmodel.CardinalityEnum;
import com.ibm.cognos.fmeng.genmodel.FilterDefinitionType;
import com.ibm.cognos.fmeng.genmodel.FiltersType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.JoinType;
import com.ibm.cognos.fmeng.genmodel.MeasureType;
import com.ibm.cognos.fmeng.genmodel.PhysicalDefinitionType;
import com.ibm.cognos.fmeng.genmodel.QueryItemMappingType;
import com.ibm.cognos.fmeng.genmodel.QueryItemType;
import com.ibm.cognos.fmeng.genmodel.SqlObjectType;
import com.ibm.cognos.fmeng.genmodel.TableType;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmPhysicalDefinition
extends FmComplexProperty
implements FilterDefinitionParentInternal {
    public int count = 0;

    static FmPhysicalDefinition get(FMMDSession session, Object object) {
        return new FmPhysicalDefinition(session, object);
    }

    FmPhysicalDefinition(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    private PhysicalDefinitionType getPhysicalDefinition() {
        return (PhysicalDefinitionType)this.m_emfObject;
    }

    public FmTable createTable(DataSource ds, String name) {
        List<Table> tables;
        this.getPhysicalDefinition().getSqlObject().clear();
        if (this.getParent() instanceof MeasureDimension && (tables = this.getTables()).size() != 0) {
            FmTable table = (FmTable)tables.get(0);
            if (table.getDataSource().equals(ds) && table.getName().equals(name)) {
                return table;
            }
            throw new FmMDException("BMT_MD_ONE_TABLE_ONLY_FOR_MEASURE_DIMENSIONS", ((MeasureDimension)this.getParent()).getName(), table.getName());
        }
        FmTable table = FmTable.createTable(this.m_session, this, (FmDataSource)ds, name);
        return table;
    }

    public void addTable(FmTable table) {
        this.getPhysicalDefinition().getTable().add((Object)table.getTableType());
    }

    void addJoin(FmJoin join) {
        this.getPhysicalDefinition().getJoin().add((Object)join.getJoinType());
    }

    public FmQueryItemMapping createQueryItemMapping(QueryItemBase queryItem, String columnName, Table table) {
        FmQueryItemMapping mapping = null;
        if (queryItem instanceof FmQueryItem) {
            mapping = FmQueryItemMapping.createQueryItemMapping((FMMDSession)this.m_session, this, (FmQueryItem)queryItem, columnName, (FmTable)table);
        }
        if (queryItem instanceof FmMeasure) {
            mapping = FmQueryItemMapping.createQueryItemMapping((FMMDSession)this.m_session, this, (FmMeasure)queryItem, columnName, (FmTable)table);
        }
        return mapping;
    }

    public FmQueryItemMapping createQueryItemMapping(QueryItemBase queryItem, String columnName, SQLObject sqlObj) {
        FmQueryItemMapping mapping = FmQueryItemMapping.createQueryItemMapping((FMMDSession)this.m_session, this, (FmQueryItem)queryItem, columnName, (FmSQLObject)sqlObj);
        return mapping;
    }

    void addQueryItemMapping(FmQueryItemMapping mapping) {
        this.getPhysicalDefinition().getQueryItemMapping().add((Object)mapping.getQueryItemMappingType());
    }

    public FmTable findTable(String dataSourceName, String tableName) {
        for (TableType table : this.getPhysicalDefinition().getTable()) {
            FmTable fmTable = FmTable.get(this.m_session, table);
            if (!fmTable.getTableName().equals(tableName) || !fmTable.getDataSource().getName().equals(dataSourceName)) continue;
            return fmTable;
        }
        return null;
    }

    public Table findTable(DataSource dataSource, String tableName) {
        return this.findTable(dataSource.getName(), tableName);
    }

    public Table findTable(String name) {
        for (TableType table : this.getPhysicalDefinition().getTable()) {
            FmTable fmTable = FmTable.get(this.m_session, table);
            if (!fmTable.getName().equals(name)) continue;
            return fmTable;
        }
        return null;
    }

    public SQLObject findSQLObject(String name) {
        for (SqlObjectType obj : this.getPhysicalDefinition().getSqlObject()) {
            if (!obj.getName().equals(name)) continue;
            return FmSQLObject.get(this.m_session, obj);
        }
        return null;
    }

    protected static FmTable getTable(FMMDSession session, PhysicalDefinitionType def, String name) {
        if (def == null) {
            return null;
        }
        for (TableType someTable : def.getTable()) {
            if (!someTable.getName().equals(name)) continue;
            return FmTable.get(session, someTable);
        }
        return null;
    }

    protected static FmSQLObject getSQLObject(FMMDSession session, PhysicalDefinitionType def, String name) {
        if (def == null) {
            return null;
        }
        for (SqlObjectType someSQLObj : def.getSqlObject()) {
            if (!someSQLObj.getName().equals(name)) continue;
            return FmSQLObject.get(session, someSQLObj);
        }
        return null;
    }

    public String toString() {
        StringBuilder foo = new StringBuilder("Query Items:\n");
        for (QueryItemMappingType mapping : this.getPhysicalDefinition().getQueryItemMapping()) {
            foo.append("\tcolumn: ");
            foo.append(mapping.getColumnName());
            foo.append("\n");
        }
        foo.append("Tables:\n");
        for (TableType table : this.getPhysicalDefinition().getTable()) {
            foo.append("\ttable: ");
            foo.append(table.getName());
            foo.append("\n");
        }
        return foo.toString();
    }

    public List<Table> getTables() {
        ArrayList<Table> tables = new ArrayList<Table>();
        for (TableType tableType : this.getPhysicalDefinition().getTable()) {
            tables.add(FmTable.get(this.m_session, tableType));
        }
        return tables;
    }

    public List<QueryItemMapping> getQueryItemMappings() {
        ArrayList<QueryItemMapping> mappings = new ArrayList<QueryItemMapping>();
        for (QueryItemMappingType mappingType : this.getPhysicalDefinition().getQueryItemMapping()) {
            mappings.add(FmQueryItemMapping.get(this.m_session, mappingType));
        }
        return mappings;
    }

    public List<QueryItemMapping> getQueryItemMappings(Table table) {
        ArrayList<QueryItemMapping> mappings = new ArrayList<QueryItemMapping>();
        for (QueryItemMappingType mappingType : this.getPhysicalDefinition().getQueryItemMapping()) {
            FmQueryItemMapping mapping = FmQueryItemMapping.get(this.m_session, mappingType);
            if (!mapping.getTable().equals(table)) continue;
            mappings.add(mapping);
        }
        return mappings;
    }

    public FmJoin createJoin(String name, Table left, Table right) {
        FmJoin join = FmJoin.createJoin(this.m_session, this, name, (FmTable)left, (FmTable)right);
        return join;
    }

    public List<Join> getJoins() {
        ArrayList<Join> joins = new ArrayList<Join>();
        for (JoinType join : this.getPhysicalDefinition().getJoin()) {
            joins.add(new FmJoin(this.m_session, join));
        }
        return joins;
    }

    public List<Join> getJoins(Table table) {
        ArrayList<Join> joins = new ArrayList<Join>();
        for (JoinType join : this.getPhysicalDefinition().getJoin()) {
            FmJoin fmJoin = FmJoin.get(this.m_session, join);
            if (!fmJoin.getLeft().equals(table) && !fmJoin.getRight().equals(table)) continue;
            joins.add(fmJoin);
        }
        return joins;
    }

    public List<QueryItemBase> findMappedQueryItems(String dataSourceName, String tableName, String columnName) {
        ArrayList<QueryItemBase> items = new ArrayList<QueryItemBase>();
        FmTable table = this.findTable(dataSourceName, tableName);
        if (table == null) {
            return items;
        }
        for (QueryItemMappingType mappingType : this.getPhysicalDefinition().getQueryItemMapping()) {
            if (!mappingType.getColumnName().equals(columnName) || !mappingType.getPhysicalObjectRef().equals(table.getName())) continue;
            EObject item = mappingType.getQueryItem();
            if (item instanceof QueryItemType) {
                items.add(FmQueryItem.get(this.m_session, item));
                continue;
            }
            if (!(item instanceof MeasureType)) continue;
            items.add(FmMeasure.get(this.m_session, item));
        }
        return items;
    }

    public List<Join> findJoins(Table leftTable, Table rightTable, boolean bDirectional) {
        ArrayList<Join> joins = new ArrayList<Join>();
        FmTable start = (FmTable)leftTable;
        FmTable end = (FmTable)rightTable;
        if (bDirectional) {
            for (JoinType join : this.getPhysicalDefinition().getJoin()) {
                FmJoin someJoin = new FmJoin(this.m_session, join);
                if (!someJoin.getStart().equals(leftTable) || !someJoin.getEnd().equals(rightTable)) continue;
                joins.add(someJoin);
            }
        } else {
            for (JoinType someJoin : this.getPhysicalDefinition().getJoin()) {
                if (someJoin.getLeftPhysicalObjectRef().equals(start.getTableType().getName()) && someJoin.getRightPhysicalObjectRef().equals(end.getTableType().getName())) {
                    joins.add(FmJoin.get(this.m_session, someJoin));
                    continue;
                }
                if (!someJoin.getLeftPhysicalObjectRef().equals(end.getTableType().getName()) || !someJoin.getRightPhysicalObjectRef().equals(start.getTableType().getName())) continue;
                joins.add(FmJoin.get(this.m_session, someJoin));
            }
        }
        return joins;
    }

    @Override
    public String makeObjectNameUnique(String name, int type) {
        boolean bUnique = false;
        FmMDException.ASSERT(name != null && !"".equals(name), "Bad name for relational object.");
        String tempName = name;
        int i = 0;
        int size = -1;
        switch (type) {
            case 117: {
                size = this.getPhysicalDefinition().getQueryItemMapping().size();
                break;
            }
            case 169: {
                size = this.getPhysicalDefinition().getTable().size();
                break;
            }
            case 59: {
                size = this.getPhysicalDefinition().getJoin().size();
                break;
            }
            case 46: {
                size = this.getFilters().getFilterDefinition().size();
            }
        }
        while (!bUnique) {
            bUnique = true;
            String objName = null;
            int j = 0;
            while (j < size) {
                switch (type) {
                    case 117: {
                        objName = ((QueryItemMappingType)this.getPhysicalDefinition().getQueryItemMapping().get(j)).getName();
                        break;
                    }
                    case 169: {
                        objName = ((TableType)this.getPhysicalDefinition().getTable().get(j)).getName();
                        break;
                    }
                    case 59: {
                        objName = ((JoinType)this.getPhysicalDefinition().getJoin().get(j)).getName();
                        break;
                    }
                    case 46: {
                        objName = ((FilterDefinitionType)this.getFilters().getFilterDefinition().get(j)).getDisplayName();
                    }
                }
                if (objName.equals(tempName)) {
                    bUnique = false;
                    break;
                }
                ++j;
            }
            if (bUnique) continue;
            tempName = String.valueOf(name) + Integer.toString(++i);
        }
        return tempName;
    }

    public QueryItemMapping findMapping(QueryItemBase queryItem) {
        for (QueryItemMappingType mapping : this.getPhysicalDefinition().getQueryItemMapping()) {
            if (!mapping.getQueryItem().equals(queryItem.getInternal())) continue;
            return FmQueryItemMapping.get(this.m_session, mapping);
        }
        return null;
    }

    public Table findTable(QueryItem queryItem) {
        String id = "";
        for (QueryItemMappingType mapping : this.getPhysicalDefinition().getQueryItemMapping()) {
            if (!mapping.getQueryItem().equals(queryItem.getInternal())) continue;
            id = mapping.getPhysicalObjectRef();
            break;
        }
        if (!"".equals(id)) {
            for (TableType table : this.getPhysicalDefinition().getTable()) {
                if (!table.getName().equals(id)) continue;
                return FmTable.get(this.m_session, table);
            }
        }
        return null;
    }

    public void removeQueryItemMapping(QueryItemMapping mapping) {
        Table itemTable = mapping.getTable();
        List<QueryItemMapping> mappings = this.getQueryItemMappings();
        for (QueryItemMapping map : mappings) {
            if (!map.equals(mapping)) continue;
            this.m_session.getGateway().delete(((FmQueryItemMapping)map).getInternal());
        }
        if (itemTable == null) {
            return;
        }
        mappings = itemTable.getQueryItemMappings();
        if (mappings.size() > 0) {
            return;
        }
        ArrayList<Table> tablesWithColumns = new ArrayList<Table>();
        List<Table> allTables = this.getTables();
        List<Table> deleteCandidates = this.getTables();
        for (Table someTable : allTables) {
            if (someTable.getQueryItemMappings().size() <= 0) continue;
            tablesWithColumns.add(someTable);
        }
        for (Table tableA : tablesWithColumns) {
            deleteCandidates.remove(tableA);
            for (Table tableB : tablesWithColumns) {
                if (tableA.equals(tableB)) continue;
                FmRoutes routes = new FmRoutes(this.m_session.m_RoutesGovernor.get());
                routes.compute((FmTable)tableA, (FmTable)tableB);
                for (FmRoute someRoute : routes.getAllRoutes()) {
                    for (FmTable goodTable : someRoute.getNodeList()) {
                        deleteCandidates.remove(goodTable);
                    }
                }
            }
        }
        boolean bCanDeleteCandidates = true;
        for (Table table : allTables) {
            FmRoutes routes = new FmRoutes(this.m_session.m_RoutesGovernor.get(), 1, false);
            routes.compute((FmTable)table, (FmTable)table);
            if (!routes.hasRoutes()) continue;
            for (FmRoute route : routes.getAllRoutes()) {
                bCanDeleteCandidates = true;
                int i = 0;
                while (i < route.getNodeCount()) {
                    FmTable intermediateTable = (FmTable)route.getNode(i);
                    if (!intermediateTable.equals(table)) {
                        if (intermediateTable.getQueryItemMappings().size() > 0) {
                            bCanDeleteCandidates = false;
                            break;
                        }
                        for (FmJoin join : intermediateTable.getJoins()) {
                            FmTable otherSide = join.getOtherSide(intermediateTable);
                            FmTable prev = (FmTable)route.getNode(i - 1);
                            FmTable next = (FmTable)route.getNode(i + 1);
                            if (otherSide.equals(prev) || otherSide.equals(next)) continue;
                            bCanDeleteCandidates = false;
                            break;
                        }
                    }
                    ++i;
                }
                if (!bCanDeleteCandidates) continue;
                for (FmTable node : route.getNodeList()) {
                    FmTable table2 = node;
                    if (table2.equals(table)) continue;
                    deleteCandidates.add(table2);
                }
            }
        }
        for (Table deleteCandidate : deleteCandidates) {
            this.removeTable(deleteCandidate);
        }
    }

    public void removeJoin(Join join) {
        this.m_session.getGateway().delete(((FmJoin)join).getInternal());
    }

    public void removeTable(Table tbl) {
        List<Join> joins = this.getJoins();
        for (Join join : joins) {
            ((FmJoin)join).tableRemoved(tbl);
        }
        List<QueryItemMapping> mappings = this.getQueryItemMappings();
        for (QueryItemMapping mapping : mappings) {
            ((FmQueryItemMapping)mapping).tableRemoved(tbl);
        }
        ((FmTable)tbl).remove();
    }

    public Join findJoin(String name) {
        for (JoinType join : this.getPhysicalDefinition().getJoin()) {
            if (!join.getName().equals(name)) continue;
            return FmJoin.get(this.m_session, join);
        }
        return null;
    }

    public QueryItemMapping findMapping(String name) {
        for (QueryItemMappingType mapping : this.getPhysicalDefinition().getQueryItemMapping()) {
            if (!mapping.getName().equals(name)) continue;
            return FmQueryItemMapping.get(this.m_session, mapping);
        }
        return null;
    }

    public void addSQLObject(FmSQLObject sqlObject) {
        this.getPhysicalDefinition().getSqlObject().add((Object)sqlObject.getSqlObjectType());
    }

    public SQLObject createSQLObject(DataSource ds, String moniker, String sqlStatement) {
        this.getPhysicalDefinition().getTable().clear();
        this.getPhysicalDefinition().getJoin().clear();
        EList<QueryItemMappingType> mappings = this.getPhysicalDefinition().getQueryItemMapping();
        for (QueryItemMappingType qim : mappings) {
            qim.setPhysicalObjectRef(moniker);
            qim.setName(qim.getColumnName());
        }
        return FmSQLObject.createSQLObject(this.m_session, this, (FmDataSource)ds, moniker, sqlStatement);
    }

    public List<SQLObject> getSQLObjects() {
        ArrayList<SQLObject> objects = new ArrayList<SQLObject>();
        for (SqlObjectType obj : this.getPhysicalDefinition().getSqlObject()) {
            objects.add(FmSQLObject.get(this.m_session, obj));
        }
        return objects;
    }

    public void removeSQLObject(SQLObject object) {
        this.m_session.getGateway().delete(((FmSQLObject)object).getInternal());
    }

    @Override
    public FilterDefinition createFilterDefinition(String name, ExpressionBuilder expression) {
        return FmFilterDefinition.create(this.m_session, this, name, expression);
    }

    @Override
    public List<FilterDefinition> getFilterDefinitions() {
        ArrayList<FilterDefinition> filters = new ArrayList<FilterDefinition>();
        FiltersType filtersType = this.getFilters();
        for (FilterDefinitionType filterType : filtersType.getFilterDefinition()) {
            filters.add(FmFilterDefinition.get(this.m_session, filterType));
        }
        return filters;
    }

    @Override
    public void removeFilterDefinition(String displayName) {
        for (FilterDefinitionType filter : this.getFilters().getFilterDefinition()) {
            if (!filter.getDisplayName().equals(displayName)) continue;
            this.m_session.getGateway().delete(filter);
            break;
        }
    }

    private FiltersType getFilters() {
        FiltersType filtersType = this.getPhysicalDefinition().getFilters();
        if (filtersType == null) {
            filtersType = GenmodelFactory.eINSTANCE.createFiltersType();
            this.getPhysicalDefinition().setFilters(filtersType);
        }
        return filtersType;
    }

    @Override
    public void addFilterDefinition(FmFilterDefinition filter) {
        this.getFilters().getFilterDefinition().add((Object)filter.getFilterDefinitionType());
    }

    @Override
    public boolean isQueryItemInFilterScope(FmQueryItemBase qi) {
        for (QueryItemMapping mapping : this.getQueryItemMappings()) {
            if (!qi.equals(mapping.getQueryItem())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return ((RelationalObject)this.getParent()).getName();
    }

    public List<Table> getBottomTables() {
        ArrayList<Table> bottomTables = new ArrayList<Table>();
        EList<TableType> tables = this.getPhysicalDefinition().getTable();
        if (tables.size() == 1) {
            bottomTables.add(FmTable.get(this.getSession(), tables.get(0)));
        } else if (tables.size() > 1) {
            boolean removedOthers;
            bottomTables.addAll(this.getTables());
            ArrayList<Table> removedTables = new ArrayList<Table>();
            for (JoinType join : this.getPhysicalDefinition().getJoin()) {
                if (join.getLeftMaxCard() != CardinalityEnum.MANY && join.getRightMaxCard() == CardinalityEnum.MANY) {
                    this.removeTable(join.getLeftPhysicalObjectRef(), bottomTables, removedTables);
                }
                if (join.getRightMaxCard() == CardinalityEnum.MANY || join.getLeftMaxCard() != CardinalityEnum.MANY) continue;
                this.removeTable(join.getRightPhysicalObjectRef(), bottomTables, removedTables);
            }
            do {
                removedOthers = false;
                FmTable tableToRemove = null;
                for (Table removed : removedTables) {
                    for (FmJoin join : ((FmTable)removed).getJoins()) {
                        FmTable tableToConsider;
                        if (join.getLeftMaxcard() != Cardinality.ECardinality.one || join.getRightMaxcard() != Cardinality.ECardinality.one || removedTables.contains(tableToConsider = join.getOtherSide((FmTable)removed))) continue;
                        tableToRemove = tableToConsider;
                        break;
                    }
                    if (tableToRemove != null) break;
                }
                if (tableToRemove == null) continue;
                bottomTables.remove(tableToRemove);
                removedTables.add(tableToRemove);
                removedOthers = true;
            } while (removedOthers);
        }
        return bottomTables;
    }

    public Map<Integer, List<Table>> getSortedTables(List<Table> sortTables, List<Table> sortedTables, Map<Integer, List<Table>> hm1) {
        ArrayList<Table> bottomTables = new ArrayList<Table>();
        ArrayList<Table> allTables = new ArrayList<Table>();
        ArrayList<Join> allJoins = new ArrayList<Join>();
        allTables.addAll(sortTables);
        if (sortTables.size() == 1) {
            bottomTables.add(sortTables.get(0));
        } else if (sortTables.size() > 1) {
            boolean removedOthers;
            bottomTables.addAll(sortTables);
            ArrayList<Table> removedTables = new ArrayList<Table>();
            for (Table table1 : sortTables) {
                int i = sortTables.indexOf(table1) + 1;
                while (i < sortTables.size()) {
                    Table table2 = sortTables.get(i);
                    allJoins.addAll(this.findJoins(table1, table2, false));
                    ++i;
                }
            }
            for (Join join : allJoins) {
                if (join.getLeftMaxcard() != Cardinality.ECardinality.many && join.getRightMaxcard() == Cardinality.ECardinality.many) {
                    this.removeTable(join.getLeftTable().getName(), bottomTables, removedTables);
                }
                if (join.getRightMaxcard() == Cardinality.ECardinality.many || join.getLeftMaxcard() != Cardinality.ECardinality.many) continue;
                this.removeTable(join.getRightTable().getName(), bottomTables, removedTables);
            }
            do {
                removedOthers = false;
                FmTable tableToRemove = null;
                for (Table removed : removedTables) {
                    for (FmJoin join : ((FmTable)removed).getJoins()) {
                        FmTable tableToConsider;
                        if (join.getLeftMaxcard() != Cardinality.ECardinality.one || join.getRightMaxcard() != Cardinality.ECardinality.one || removedTables.contains(tableToConsider = join.getOtherSide((FmTable)removed))) continue;
                        tableToRemove = tableToConsider;
                        break;
                    }
                    if (tableToRemove != null) break;
                }
                if (tableToRemove == null) continue;
                bottomTables.remove(tableToRemove);
                removedTables.add(tableToRemove);
                removedOthers = true;
            } while (removedOthers);
        }
        HashSet<Table> unJoinedTables = this.getUnJoinedTables();
        Iterator it = bottomTables.iterator();
        while (it.hasNext()) {
            Table someTable = (Table)it.next();
            if (!unJoinedTables.contains(someTable)) continue;
            it.remove();
        }
        if (this.count > 1 && bottomTables.size() == 0) {
            hm1.put(this.count, new ArrayList<Table>(unJoinedTables));
            return hm1;
        }
        sortedTables.addAll(bottomTables);
        hm1.put(this.count, bottomTables);
        ++this.count;
        if (sortedTables.size() != this.getTables().size()) {
            sortTables.removeAll(sortedTables);
            this.getSortedTables(sortTables, sortedTables, hm1);
        }
        return hm1;
    }

    private void removeTable(String tableToRemove, List<Table> tables, List<Table> removedTables) {
        Iterator<Table> it = tables.iterator();
        while (it.hasNext()) {
            Table table = it.next();
            if (!table.getName().equals(tableToRemove)) continue;
            it.remove();
            if (removedTables.contains(table)) continue;
            removedTables.add(table);
        }
    }

    public HashSet<Table> getUnJoinedTables() {
        List<Table> tables = this.getTables();
        HashSet<TableType> joinedTables = new HashSet<TableType>();
        HashSet<Table> unJoinedTables = new HashSet<Table>();
        if (tables.size() > 1) {
            joinedTables.addAll(this.getJoinedTables());
            for (Table someTable : tables) {
                FmTable tableToCheck = (FmTable)someTable;
                if (joinedTables.contains(tableToCheck.getTableType())) continue;
                unJoinedTables.add(tableToCheck);
            }
        }
        return unJoinedTables;
    }

    public HashSet<TableType> getJoinedTables() {
        List<Table> tables = this.getTables();
        HashSet<TableType> joinedTables = new HashSet<TableType>();
        if (tables.size() > 1) {
            for (Join join : this.getJoins()) {
                FmTable left = (FmTable)join.getLeftTable();
                FmTable right = (FmTable)join.getRightTable();
                joinedTables.add(left.getTableType());
                joinedTables.add(right.getTableType());
            }
        }
        return joinedTables;
    }

    public List<Table> getCommonTables(RelationalObject right) {
        ArrayList<Table> commonTables = new ArrayList<Table>();
        for (TableType tableLeft : this.getPhysicalDefinition().getTable()) {
            for (TableType tableRight : ((FmRelationalObject)right).getPhysicalDefinition().getPhysicalDefinition().getTable()) {
                if (!tableLeft.getName().equals(tableRight.getName()) || !tableLeft.getDataSourceRef().equals(tableRight.getDataSourceRef())) continue;
                commonTables.add(FmTable.get(this.m_session, tableLeft));
            }
        }
        return commonTables;
    }

    public List<QueryItemMapping> getQueryItemMappings(List<QueryItemBase> items) {
        HashSet<QueryItemMappingType> mappings = new HashSet<QueryItemMappingType>();
        this.findMappings(items, mappings);
        ArrayList<QueryItemMapping> mappingsList = new ArrayList<QueryItemMapping>();
        for (QueryItemMappingType mapping : mappings) {
            mappingsList.add(FmQueryItemMapping.get(this.m_session, mapping));
        }
        return mappingsList;
    }

    private void findMappings(List<QueryItemBase> items, HashSet<QueryItemMappingType> mappings) {
        for (QueryItemBase item : items) {
            if (item.getExpression() == null || item.getExpression().getComponents().size() == 0) {
                for (QueryItemMappingType mapping : this.getPhysicalDefinition().getQueryItemMapping()) {
                    if (!mapping.getQueryItem().equals(item.getInternal())) continue;
                    mappings.add(mapping);
                }
                continue;
            }
            ArrayList<QueryItemBase> subItems = new ArrayList<QueryItemBase>();
            for (Object obj : item.getExpression().getComponents()) {
                if (!(obj instanceof QueryItemBase)) continue;
                subItems.add((FmQueryItemBase)obj);
            }
            this.findMappings(subItems, mappings);
        }
    }

    public void updateObject(DataSource ds) {
        for (QueryItemMapping qim : this.getQueryItemMappings()) {
            DataSource qDS = qim.getTable().getDataSource();
            if (!qDS.equals(ds)) continue;
            MdColumn column = qim.getPhysicalColumn();
            QueryItemBase qi = qim.getQueryItem();
            if (column == null) continue;
            qi.copyColumnProperties(column);
        }
    }
}

