/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmDataSource;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDataSources;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmEMDObjectNaming;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMultilingualAttribute;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmNamespace;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPackage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPackages;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmParameterMap;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmParameterMaps;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQosOverride;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalParameterMap;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSecurityObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSecurityView;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSecurityViews;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Copyable;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.Namespace;
import com.ibm.cognos.fmeng.fmmd.model.Package;
import com.ibm.cognos.fmeng.fmmd.model.ParameterMap;
import com.ibm.cognos.fmeng.fmmd.model.ParameterMapBase;
import com.ibm.cognos.fmeng.fmmd.model.Project;
import com.ibm.cognos.fmeng.fmmd.model.QosOverride;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.RelationalParameterMap;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.LocaleMappingType;
import com.ibm.cognos.fmeng.genmodel.LocaleType;
import com.ibm.cognos.fmeng.genmodel.MultilingualAttributeType;
import com.ibm.cognos.fmeng.genmodel.NameType;
import com.ibm.cognos.fmeng.genmodel.ProjectType;
import com.ibm.cognos.fmeng.genmodel.QosOverrideType;
import com.ibm.cognos.fmeng.genmodel.QosOverridesType;
import com.ibm.cognos.fmeng.genmodel.QueryItemType;
import com.ibm.cognos.fmeng.genmodel.QueryModeType;
import com.ibm.cognos.fmeng.genmodel.ReportObjectType;
import com.ibm.cognos.fmeng.genmodel.SupportedLocalesType;
import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.metadata.MdBase;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.gateway.EMFModelGateway;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmProject
extends FmModelObject
implements Project {
    public static FmProject get(FMMDSession session, Object emfobj) {
        return new FmProject(session, (ProjectType)emfobj);
    }

    FmProject(FMMDSession session, ProjectType emfObject) {
        super(session, emfObject);
    }

    public ProjectType getProjectType() {
        return (ProjectType)this.m_emfObject;
    }

    @Override
    public void setDefaultLocale(String localeString) {
        String currentDefault = this.getProjectType().getDefaultLocale();
        this.getProjectType().setDefaultLocale(localeString);
        EList<NameType> names = this.getProjectType().getNamespace().getName();
        this.changeDefaultLocale((List<NameType>)names, currentDefault, localeString);
        this.addLocale(localeString);
        TreeIterator it = this.getProjectType().eAllContents();
        while (it.hasNext()) {
            EObject childObj = (EObject)it.next();
            if (childObj instanceof ReportObjectType) {
                ReportObjectType rObj = (ReportObjectType)childObj;
                this.changeDefaultLocale((List<NameType>)rObj.getName(), currentDefault, localeString);
            }
            if (!(childObj instanceof MultilingualAttributeType)) continue;
            FmMultilingualAttribute attr = FmMultilingualAttribute.get(this.m_session, childObj);
            attr.changeDefaultLocale(currentDefault, localeString);
        }
    }

    public void changeDefaultLocale(List<NameType> names, String currentDefault, String localeString) {
        NameType newName = GenmodelFactory.eINSTANCE.createNameType();
        boolean found = false;
        for (NameType name : names) {
            if (!name.getLocale().equals(localeString)) continue;
            found = true;
            break;
        }
        if (!found) {
            for (NameType name : names) {
                if (!name.getLocale().equals(currentDefault)) continue;
                newName.setLocale(localeString);
                newName.setValue(name.getValue());
                break;
            }
            names.add(newName);
        }
    }

    @Override
    public String getDefaultLocale() {
        return this.getProjectType().getDefaultLocale();
    }

    public Locale getDefaultLocale1() {
        return new Locale(this.getProjectType().getDefaultLocale());
    }

    @Override
    public boolean canDelete() {
        return false;
    }

    @Override
    public FmObjectType getFmObjectType() {
        return FmObjectType.project;
    }

    @Override
    public List<String> getSupportedLocales() {
        SupportedLocalesType locales = this.getProjectType().getLocales();
        EList<LocaleType> localeList = locales.getLocale();
        ArrayList<String> localeArray = new ArrayList<String>();
        int i = 0;
        while (i < localeList.size()) {
            localeArray.add(((LocaleType)localeList.get(i)).getValue());
            ++i;
        }
        return localeArray;
    }

    @Override
    public boolean hasLocale(String name) {
        SupportedLocalesType locales = this.getProjectType().getLocales();
        EList<LocaleType> localeList = locales.getLocale();
        for (LocaleType locale : localeList) {
            if (!locale.getValue().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addLocale(String localeStr) {
        if (localeStr == null || localeStr.equals("")) {
            String[] args = new String[]{localeStr};
            throw new FmMDException("BMT_MD_LOCALE_NOTSUPPORTED", args);
        }
        EList<LocaleType> locales = this.getProjectType().getLocales().getLocale();
        for (LocaleType lt : locales) {
            if (!lt.getValue().equalsIgnoreCase(localeStr)) continue;
            return;
        }
        FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.PLATFORM, this.m_session, "Adding locale to project: " + localeStr);
        LocaleType locale = GenmodelFactory.eINSTANCE.createLocaleType();
        locale.setValue(localeStr.toLowerCase());
        this.getProjectType().getLocales().getLocale().add((Object)locale);
    }

    public FmDataSources getDataSourcesFolder() {
        return FmDataSources.get(this.m_session, this.getProjectType().getDataSources());
    }

    @Override
    public List<DataSource> getDataSources() {
        return this.getDataSourcesFolder().getDataSourceCollection();
    }

    public FmPackages getPackagesFolder() {
        return FmPackages.get(this.m_session, this.getProjectType().getPackages());
    }

    @Override
    public List<Package> getPackages() {
        return this.getPackagesFolder().getPackageCollection();
    }

    public FmSecurityViews getSecurityViewsFolder() {
        return FmSecurityViews.get(this.m_session, this.getProjectType().getSecurityViews());
    }

    @Override
    public Namespace getRootNamespace() {
        return FmNamespace.get(this.m_session, this.getProjectType().getNamespace());
    }

    public FmParameterMaps getParameterMapsFolder() {
        return FmParameterMaps.get(this.m_session, this.getProjectType().getParameterMaps());
    }

    @Override
    public List<QosOverride> getQosOverrides() {
        QosOverridesType fs = this.getProjectType().getQosOverrides();
        EList<QosOverrideType> overRides = fs.getQosOverride();
        ArrayList<QosOverride> res = new ArrayList<QosOverride>(overRides.size());
        for (QosOverrideType fst : overRides) {
            res.add(FmQosOverride.get(this.m_session, fst));
        }
        return res;
    }

    public void removeQosOverrideWithFunctionId(String value) {
        QosOverridesType fs = this.getProjectType().getQosOverrides();
        EList<QosOverrideType> overRides = fs.getQosOverride();
        Iterator it = overRides.iterator();
        while (it.hasNext()) {
            QosOverrideType qot = (QosOverrideType)it.next();
            if (!value.equals(qot.getFunctionId())) continue;
            it.remove();
        }
    }

    public FmQosOverride addFunctionSetOverride(String propValue) {
        QosOverridesType QosO = this.getProjectType().getQosOverrides();
        if (QosO == null) {
            QosO = GenmodelFactory.eINSTANCE.createQosOverridesType();
            this.getProjectType().setQosOverrides(QosO);
        }
        return FmQosOverride.addFunctionSetOverride(propValue, QosO, this.m_session);
    }

    public FmQosOverride getFunctionSetOverride(String propValue) {
        QosOverridesType QosO = this.getProjectType().getQosOverrides();
        if (QosO == null) {
            return null;
        }
        EList<QosOverrideType> functionSetsOverrides = QosO.getQosOverride();
        for (QosOverrideType ovr : functionSetsOverrides) {
            if (!propValue.equals(ovr.getFunctionId())) continue;
            return FmQosOverride.get(this.m_session, ovr);
        }
        return null;
    }

    @Override
    public DataSource createDataSource(String name) {
        return FmDataSource.createDataSource(this.m_session, name, FmEMDObjectNaming.kMakeUnique);
    }

    public FmDataSource createDataSource(DataSource srcDS, String name) {
        return this.getDataSourcesFolder().createDataSource(srcDS, name);
    }

    @Override
    public DataSource findOrCreateDataSource(MdBase mdTableOrColumn) {
        return this.getDataSourcesFolder().findOrCreateDataSource(mdTableOrColumn);
    }

    @Override
    public DataSource findDataSource(String cmDataSourceName, String catalogName, String schemaName, String cubeName) {
        return this.getDataSourcesFolder().findDataSource(cmDataSourceName, catalogName, schemaName, cubeName);
    }

    @Override
    public DataSource findDataSource(String modelDSName) {
        return this.getDataSourcesFolder().findDataSource(modelDSName);
    }

    @Override
    public DataSource createDataSource(String cmDataSourceName, String catalogName, String schemaName, String cubeName, String queryType, String interfaceType) {
        return this.getDataSourcesFolder().createDataSource(cmDataSourceName, catalogName, schemaName, cubeName, queryType, interfaceType);
    }

    @Override
    public void removeLocales(List<String> removedLocales) {
        String defaultLocale = this.getDefaultLocale();
        for (String sLocale : removedLocales) {
            if (!sLocale.equalsIgnoreCase(defaultLocale)) continue;
            Object[] msgParams = new Object[]{defaultLocale};
            throw new FmMDException("BMT_MD_LOCALE_REMOVE_DEFAULT", msgParams);
        }
        Iterator<String> it = removedLocales.iterator();
        while (it.hasNext()) {
            String locale = it.next();
            if (this.hasLocale(locale)) continue;
            it.remove();
        }
        if (removedLocales.isEmpty()) {
            return;
        }
        FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.PLATFORM, this.m_session, "Removing locales from project: " + removedLocales.toString());
        EObject start = (EObject)this.m_emfObject;
        ArrayList<Object> nameTypes = new ArrayList<Object>();
        TreeIterator allContents = start.eAllContents();
        EMFModelGateway gw = this.m_session.getGateway();
        ArrayList<FmQueryItem> qiToRemove = new ArrayList<FmQueryItem>();
        ArrayList lmToRemove = new ArrayList();
        while (allContents.hasNext()) {
            Object name2;
            EObject currentObj = (EObject)allContents.next();
            if (currentObj instanceof ReportObjectType) {
                ReportObjectType rObj = (ReportObjectType)currentObj;
                EList<NameType> objLocales = rObj.getName();
                for (Object name2 : objLocales) {
                    for (String removedLocale : removedLocales) {
                        if (!name2.getLocale().equals(removedLocale)) continue;
                        nameTypes.add(name2);
                    }
                }
                objLocales = rObj.getDescription();
                for (Object name2 : objLocales) {
                    for (String removedLocale : removedLocales) {
                        if (!name2.getLocale().equals(removedLocale)) continue;
                        nameTypes.add(name2);
                    }
                }
            }
            if (!(currentObj instanceof LocaleMappingType)) continue;
            Iterator localeObj = (LocaleMappingType)currentObj;
            name2 = removedLocales.iterator();
            while (name2.hasNext()) {
                String removedLocale = name2.next();
                if (!localeObj.getLocale().equals(removedLocale)) continue;
                QueryItemType qItem = localeObj.getQueryItem();
                if (qItem != null) {
                    FmQueryItem queryItem = FmQueryItem.get(this.getSession(), localeObj.getQueryItem());
                    qiToRemove.add(queryItem);
                }
                lmToRemove.add(localeObj);
            }
        }
        for (QueryItem qi : qiToRemove) {
            this.m_session.getTaskDimensionBuilder(qi.getRelationalParent()).removeQueryItem(qi);
        }
        for (LocaleMappingType lm : lmToRemove) {
            gw.delete(lm);
        }
        for (NameType name : nameTypes) {
            gw.delete(name);
        }
        EList<LocaleType> supportedLocales = this.getProjectType().getLocales().getLocale();
        block11: for (String sLocale : removedLocales) {
            int i = 0;
            while (i < supportedLocales.size()) {
                LocaleType loc = (LocaleType)supportedLocales.get(i);
                if (sLocale.equalsIgnoreCase(loc.getValue())) {
                    supportedLocales.remove(loc);
                    continue block11;
                }
                ++i;
            }
        }
    }

    @Override
    public Package createPackage(String packageName, String desc, String screentip, List<String> localeStrs, List<ReportObject> includeObjects, List<ReportObject> excludeObjects, List<ReportObject> hideObjects, List<Package> dependentPackages) {
        FmEMDObjectNaming makeUniqueRule = FmEMDObjectNaming.kMakeUnique;
        FmPackage pkg = FmPackage.createObject(this.m_session, this.getPackagesFolder(), packageName, makeUniqueRule);
        FmSecurityView sv = FmSecurityView.createObject(this.m_session, this.getSecurityViewsFolder(), packageName, makeUniqueRule);
        ArrayList<FmSecurityView> includeViews = new ArrayList<FmSecurityView>();
        if (dependentPackages != null) {
            for (Package dependentPkg : dependentPackages) {
                includeViews.add(((FmPackage)dependentPkg).getSecurityView());
            }
        }
        sv.setDefinition(includeObjects, excludeObjects, hideObjects, includeViews);
        pkg.setSecurityView(sv);
        if (localeStrs != null && !localeStrs.isEmpty()) {
            pkg.setLocales(localeStrs);
        }
        String localeKey = this.m_session.getDefaultLocale();
        pkg.setDescription(localeKey, desc);
        pkg.setScreenTip(localeKey, screentip);
        ArrayList<FmSecurityObject> fmAdminSecurityObjects = new ArrayList<FmSecurityObject>();
        pkg.setSecurity(fmAdminSecurityObjects);
        return pkg;
    }

    @Override
    public Package createPackage(String packageName, String packagePath) {
        FmEMDObjectNaming makeUniqueRule = FmEMDObjectNaming.kMakeUnique;
        FmPackage pkg = FmPackage.createObject(this.m_session, this.getPackagesFolder(), packageName, makeUniqueRule);
        pkg.setPublishLocationCMPath(packagePath);
        return pkg;
    }

    @Override
    public ParameterMap createParameterMap(String parameterMapName) {
        FmEMDObjectNaming makeUniqueRule = FmEMDObjectNaming.kMakeUnique;
        FmParameterMap paramMap = FmParameterMap.createObject(this.m_session, this.getParameterMapsFolder(), parameterMapName, makeUniqueRule);
        return paramMap;
    }

    @Override
    public ParameterMap createParameterMap(String name, boolean manual) {
        return FmParameterMap.createParameterMap(this.m_session, this.getParameterMapsFolder(), name, manual);
    }

    @Override
    public RelationalParameterMap createRelationalParameterMap(String name) {
        return FmRelationalParameterMap.createRelationalParameterMap(this.m_session, this.getParameterMapsFolder(), name);
    }

    @Override
    public List<ParameterMapBase> getParameterMaps() {
        return this.getParameterMapsFolder().getParameterMaps();
    }

    @Override
    public ParameterMap getGovernorParameterMap() {
        List<ParameterMapBase> pMaps = this.getParameterMaps();
        for (ParameterMapBase pMap : pMaps) {
            if (!pMap.getName().equals("_governor")) continue;
            return (ParameterMap)pMap;
        }
        return null;
    }

    @Override
    public void setUseMFW(Project.UseMFW use) {
        switch (use) {
            case eFalse: {
                this.getProjectType().setUseMFW("false");
                break;
            }
            case eTrue: {
                this.getProjectType().setUseMFW("true");
                break;
            }
            case eAlways: {
                this.getProjectType().setUseMFW("always");
            }
        }
    }

    @Override
    public Project.UseMFW getUseMFW() {
        String use = this.getProjectType().getUseMFW();
        if ("always".equals(use)) {
            return Project.UseMFW.eAlways;
        }
        if ("true".equals(use)) {
            return Project.UseMFW.eTrue;
        }
        if ("false".equals(use)) {
            return Project.UseMFW.eFalse;
        }
        this.getProjectType().setUseMFW("always");
        return Project.UseMFW.eAlways;
    }

    @Override
    public void setDynamicQueryMode(boolean bDynamic) {
        QueryModeType queryMode = bDynamic ? QueryModeType.DYNAMIC : QueryModeType.MIXED;
        this.getProjectType().setQueryMode(queryMode);
    }

    @Override
    public boolean getDynamicQueryMode() {
        return this.getProjectType().getQueryMode() == QueryModeType.DYNAMIC;
    }

    @Override
    public ParameterMapBase findParameterMap(String name) {
        return this.getParameterMapsFolder().findParameterMap(name);
    }

    @Override
    public void copyParameterMap(ParameterMap pmap) {
        if (!pmap.isManual()) {
            FmMDException.ASSERT(this.getSession().equals(pmap.getSession()), "Don't call this method for query-item based parameter maps from different sessions.");
        }
        ArrayList<Copyable> toCopy = new ArrayList<Copyable>(1);
        toCopy.add(pmap);
        List<BaseObject> copied = this.getParameterMapsFolder().copy(toCopy);
        FmParameterMap copiedPM = null;
        for (BaseObject obj : copied) {
            if (!(obj instanceof ParameterMap)) continue;
            copiedPM = (FmParameterMap)obj;
            break;
        }
        FmMDException.ASSERT(copiedPM != null, "Couldn't find copied parameter map.");
        copiedPM.cleanEntries();
    }
}

