/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmProxyBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualCube;
import com.ibm.cognos.fmeng.fmmd.model.CubeBase;
import com.ibm.cognos.fmeng.fmmd.model.ProxyCube;
import com.ibm.cognos.fmeng.fmmd.model.SourceObject;
import com.ibm.cognos.fmeng.fmmd.model.VirtualCube;
import com.ibm.cognos.fmeng.metadata.MdCube;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmProxyCube
extends FmProxyBase
implements ProxyCube {
    private CubeBase m_modelCube;
    private MdCube m_metadataCube;

    public static List<FmProxyCube> collectCubes(List<Object> objectPair) {
        ArrayList<FmProxyCube> cubes = new ArrayList<FmProxyCube>();
        for (Object obj : objectPair) {
            if (obj instanceof CubeBase) {
                cubes.add(new FmProxyCube((CubeBase)obj));
            }
            if (!(obj instanceof MdCube)) continue;
            cubes.add(new FmProxyCube((MdCube)obj));
        }
        return cubes;
    }

    public FmProxyCube(CubeBase cube) {
        this.m_modelCube = cube;
        this.m_metadataCube = null;
    }

    public FmProxyCube(MdCube cube) {
        this.m_metadataCube = cube;
        this.m_modelCube = null;
    }

    public FmProxyCube(SourceObject obj) {
        if (obj.isModelSource()) {
            this.m_modelCube = (CubeBase)obj.getModelSource();
        } else {
            this.m_metadataCube = (MdCube)obj.getMetadataSource();
        }
    }

    @Override
    public Object getSource() {
        if (this.m_metadataCube != null) {
            return this.m_metadataCube;
        }
        return this.m_modelCube;
    }

    public SourceObject createSourceCube(FmVirtualCube vCube) {
        if (this.m_metadataCube != null) {
            return vCube.createSourceCube(this.m_metadataCube);
        }
        return vCube.createSourceCube(this.m_modelCube);
    }

    @Override
    public String getName() {
        if (this.m_metadataCube != null) {
            return this.m_metadataCube.getName();
        }
        return this.m_modelCube.getName();
    }

    public static List<FmProxyCube> collectCubes(VirtualCube vCube) {
        List<SourceObject> objs = vCube.getSourceObjects();
        ArrayList<FmProxyCube> cubes = new ArrayList<FmProxyCube>();
        for (SourceObject obj : objs) {
            cubes.add(new FmProxyCube(obj));
        }
        return cubes;
    }
}

