/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmProxyBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmProxyCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualDimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.SourceObject;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.fmmd.model.VirtualCube;
import com.ibm.cognos.fmeng.fmmd.model.VirtualDimension;
import com.ibm.cognos.fmeng.fmmd.model.VirtualDimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.VirtualMeasureDimension;
import com.ibm.cognos.fmeng.metadata.MdCube;
import com.ibm.cognos.fmeng.metadata.MdDimension;
import com.ibm.cognos.fmeng.metadata.MdHierarchy;
import com.ibm.cognos.fmeng.metadata.MdMeasureDimension;
import com.ibm.cognos.fmeng.metadata.MdOLAPBase;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmProxyDimension
extends FmProxyBase {
    private DimensionBase m_modelDimension;
    private MdDimension m_metadataDimension;
    private MdMeasureDimension m_metadataMeasureDimension;
    private boolean m_isMeasureDimension;

    public static FmProxyDimension setDimension(SourceObject object) {
        if (object.isModelSource()) {
            TopLevelObject obj = object.getModelSource();
            if (obj instanceof RelationalDimension) {
                return new FmProxyDimension((RelationalDimension)obj);
            }
            if (obj instanceof VirtualDimension) {
                return new FmProxyDimension((VirtualDimension)obj);
            }
            if (obj instanceof VirtualMeasureDimension) {
                return new FmProxyDimension((VirtualMeasureDimension)obj);
            }
            if (obj instanceof MeasureDimension) {
                return new FmProxyDimension((MeasureDimension)obj);
            }
        } else {
            MdOLAPBase mdBase = object.getMetadataSource();
            if (mdBase instanceof MdDimension) {
                return new FmProxyDimension((MdDimension)mdBase);
            }
            if (mdBase instanceof MdMeasureDimension) {
                return new FmProxyDimension((MdMeasureDimension)mdBase);
            }
        }
        return null;
    }

    public static List<FmProxyDimension> collectDimensions(FmProxyCube sourceCube) {
        ArrayList<FmProxyDimension> sourceDims;
        block4: {
            block5: {
                block3: {
                    sourceDims = new ArrayList<FmProxyDimension>();
                    if (!(sourceCube.getSource() instanceof Cube)) break block3;
                    Cube cube = (Cube)sourceCube.getSource();
                    for (RelationalDimensionBase dim : cube.getReferencedDimensions()) {
                        if (dim.getDimensionStyle() == DimensionBase.DimensionStyle.measure) continue;
                        sourceDims.add(new FmProxyDimension((RelationalDimension)dim));
                    }
                    break block4;
                }
                if (!(sourceCube.getSource() instanceof VirtualCube)) break block5;
                VirtualCube cube = (VirtualCube)sourceCube.getSource();
                for (VirtualDimensionBase dim : cube.getDimensions()) {
                    if (dim.getDimensionStyle() == DimensionBase.DimensionStyle.measure) continue;
                    sourceDims.add(new FmProxyDimension((VirtualDimension)dim));
                }
                break block4;
            }
            if (!(sourceCube.getSource() instanceof MdCube)) break block4;
            MdCube cube = (MdCube)sourceCube.getSource();
            for (MdDimension dim : cube.getDimensions()) {
                sourceDims.add(new FmProxyDimension(dim));
            }
        }
        return sourceDims;
    }

    public static List<FmProxyDimension> collectMeasureDimensions(FmProxyCube sourceCube) {
        ArrayList<FmProxyDimension> sourceDims = new ArrayList<FmProxyDimension>();
        if (sourceCube.getSource() instanceof Cube) {
            Cube cube = (Cube)sourceCube.getSource();
            sourceDims.add(new FmProxyDimension(cube.getMeasureDimension()));
        } else if (sourceCube.getSource() instanceof VirtualCube) {
            VirtualCube cube = (VirtualCube)sourceCube.getSource();
            sourceDims.add(new FmProxyDimension(cube.getMeasureDimension()));
        } else if (sourceCube.getSource() instanceof MdCube) {
            MdCube cube = (MdCube)sourceCube.getSource();
            sourceDims.add(new FmProxyDimension(cube.getMeasureDimension()));
        }
        return sourceDims;
    }

    public FmProxyDimension(DimensionBase dim) {
        this.m_modelDimension = dim;
        this.m_isMeasureDimension = dim != null ? dim.getDimensionStyle() == DimensionBase.DimensionStyle.measure : false;
        this.m_metadataDimension = null;
    }

    public FmProxyDimension(MdDimension dim) {
        this.m_modelDimension = null;
        this.m_isMeasureDimension = false;
        this.m_metadataDimension = dim;
        this.m_metadataMeasureDimension = null;
    }

    public FmProxyDimension(SourceObject sObj) {
        if (sObj.isModelSource()) {
            this.m_modelDimension = (DimensionBase)sObj.getModelSource();
            this.m_isMeasureDimension = sObj.getModelSource() instanceof MeasureDimension;
        } else if (sObj.getMetadataSource() instanceof MeasureDimension) {
            this.m_metadataMeasureDimension = (MdMeasureDimension)sObj.getMetadataSource();
            this.m_isMeasureDimension = true;
        } else {
            this.m_metadataDimension = (MdDimension)sObj.getMetadataSource();
            this.m_isMeasureDimension = false;
        }
    }

    public FmProxyDimension(MdMeasureDimension dim) {
        this.m_modelDimension = null;
        this.m_isMeasureDimension = true;
        this.m_metadataDimension = null;
        this.m_metadataMeasureDimension = dim;
    }

    @Override
    public String getName() {
        if (this.m_modelDimension != null) {
            return this.m_modelDimension.getName();
        }
        if (this.m_metadataDimension != null) {
            return this.m_metadataDimension.getName();
        }
        return this.m_metadataMeasureDimension.getName();
    }

    public SourceObject createSource(SourceObject srcParent, FmVirtualDimensionBase vDim) {
        if (this.m_modelDimension != null) {
            return vDim.createSourceObject(srcParent, this.m_modelDimension);
        }
        if (this.m_metadataDimension != null) {
            return vDim.createSourceObject(srcParent, this.m_metadataDimension);
        }
        return vDim.createSourceObject(srcParent, this.m_metadataMeasureDimension);
    }

    @Override
    public Object getSource() {
        if (this.m_modelDimension != null) {
            return this.m_modelDimension;
        }
        if (this.m_metadataDimension != null) {
            return this.m_metadataDimension;
        }
        return this.m_metadataMeasureDimension;
    }

    public String toString() {
        if (this.m_modelDimension != null) {
            return "Proxy for relational dimension: " + this.m_modelDimension.getID();
        }
        if (this.m_metadataDimension != null) {
            return "Proxy for metadata dimension: " + this.m_metadataDimension.getName();
        }
        return "Proxy for metadata measure dimension: " + this.m_metadataMeasureDimension.getName();
    }

    public boolean getMeasureDimension() {
        return this.m_isMeasureDimension;
    }

    public boolean isParentChild() {
        if (this.m_isMeasureDimension) {
            return true;
        }
        if (this.m_metadataDimension != null) {
            List<MdHierarchy> hierarchies = this.m_metadataDimension.getHierarchies();
            if (hierarchies.size() == 1) {
                return hierarchies.get(0).getParentChild();
            }
            return false;
        }
        if (this.m_modelDimension != null) {
            if (this.m_modelDimension instanceof RelationalDimension) {
                return ((RelationalDimension)this.m_modelDimension).getParentChild();
            }
            if (this.m_modelDimension instanceof VirtualDimension) {
                return ((VirtualDimension)this.m_modelDimension).getParentChild();
            }
        }
        FmMDException.ASSERT(false, "Unknown dimension type encountered while building a virtual cube.");
        return false;
    }

    public DimensionBase.DimensionStyle getDimensionStyle() {
        if (this.m_modelDimension != null) {
            return this.m_modelDimension.getDimensionStyle();
        }
        if (this.m_metadataDimension != null) {
            return this.m_metadataDimension.getDimensionStyle();
        }
        if (this.m_metadataMeasureDimension != null) {
            return DimensionBase.DimensionStyle.measure;
        }
        FmMDException.ASSERT(false, "Unknown dimension type encountered while building a virtual cube.");
        return null;
    }

    public static List<FmProxyDimension> collectDimensions(VirtualDimension vDim) {
        List<SourceObject> objs = vDim.getSourceObjects();
        ArrayList<FmProxyDimension> dims = new ArrayList<FmProxyDimension>();
        for (SourceObject obj : objs) {
            dims.add(new FmProxyDimension(obj));
        }
        return dims;
    }
}

