/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmProxyBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmProxyDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.SourceObject;
import com.ibm.cognos.fmeng.fmmd.model.VirtualDimension;
import com.ibm.cognos.fmeng.fmmd.model.VirtualHierarchy;
import com.ibm.cognos.fmeng.metadata.MdDimension;
import com.ibm.cognos.fmeng.metadata.MdHierarchy;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmProxyHierarchy
extends FmProxyBase {
    private RelationalHierarchy m_modelHierarchy;
    private VirtualHierarchy m_virtualHierarchy;
    private MdHierarchy m_metadataHierarchy;

    public static List<FmProxyHierarchy> collect(FmProxyDimension dimension) {
        ArrayList<FmProxyHierarchy> hierarchies;
        block4: {
            block5: {
                block3: {
                    hierarchies = new ArrayList<FmProxyHierarchy>();
                    if (!(dimension.getSource() instanceof RelationalDimension)) break block3;
                    for (RelationalHierarchy hierarchy : ((RelationalDimension)dimension.getSource()).getAllHierarchies()) {
                        hierarchies.add(new FmProxyHierarchy(hierarchy));
                    }
                    break block4;
                }
                if (!(dimension.getSource() instanceof VirtualDimension)) break block5;
                for (VirtualHierarchy hierarchy : ((VirtualDimension)dimension.getSource()).getHierarchies()) {
                    hierarchies.add(new FmProxyHierarchy(hierarchy));
                }
                break block4;
            }
            if (!(dimension.getSource() instanceof MdDimension)) break block4;
            for (MdHierarchy hierarchy : ((MdDimension)dimension.getSource()).getHierarchies()) {
                hierarchies.add(new FmProxyHierarchy(hierarchy));
            }
        }
        return hierarchies;
    }

    public FmProxyHierarchy(RelationalHierarchy hierarchy) {
        this.m_modelHierarchy = hierarchy;
        this.m_virtualHierarchy = null;
        this.m_metadataHierarchy = null;
    }

    public FmProxyHierarchy(VirtualHierarchy hierarchy) {
        this.m_modelHierarchy = null;
        this.m_virtualHierarchy = hierarchy;
        this.m_metadataHierarchy = null;
    }

    public FmProxyHierarchy(MdHierarchy hierarchy) {
        this.m_modelHierarchy = null;
        this.m_virtualHierarchy = null;
        this.m_metadataHierarchy = hierarchy;
    }

    public FmProxyHierarchy(SourceObject obj) {
        if (obj.isModelSource()) {
            if (obj.getModelSource() instanceof VirtualHierarchy) {
                this.m_virtualHierarchy = (VirtualHierarchy)obj.getModelSource();
            } else {
                this.m_modelHierarchy = (RelationalHierarchy)obj.getModelSource();
            }
        } else {
            this.m_metadataHierarchy = (MdHierarchy)obj.getMetadataSource();
        }
    }

    @Override
    public String getName() {
        if (this.m_modelHierarchy != null) {
            return this.m_modelHierarchy.getName();
        }
        if (this.m_virtualHierarchy != null) {
            return this.m_virtualHierarchy.getName();
        }
        return this.m_metadataHierarchy.getName();
    }

    @Override
    public Object getSource() {
        if (this.m_modelHierarchy != null) {
            return this.m_modelHierarchy;
        }
        if (this.m_virtualHierarchy != null) {
            return this.m_virtualHierarchy;
        }
        return this.m_metadataHierarchy;
    }

    public SourceObject createSource(SourceObject srcParent, FmVirtualHierarchy vChildObj) {
        if (this.m_modelHierarchy != null) {
            return vChildObj.createSourceObject(srcParent, this.m_modelHierarchy);
        }
        if (this.m_virtualHierarchy != null) {
            return vChildObj.createSourceObject(srcParent, this.m_virtualHierarchy);
        }
        return vChildObj.createSourceObject(srcParent, this.m_metadataHierarchy);
    }

    public boolean isParentChild() {
        if (this.m_modelHierarchy != null) {
            return this.m_modelHierarchy.getParentChild();
        }
        if (this.m_virtualHierarchy != null) {
            return this.m_virtualHierarchy.getParentChild();
        }
        return this.m_metadataHierarchy.getParentChild();
    }

    public String toString() {
        if (this.m_modelHierarchy != null) {
            return "Proxy for relational hierarchy: " + this.m_modelHierarchy.getID();
        }
        if (this.m_virtualHierarchy != null) {
            return "Proxy for virtual hierarchy: " + this.m_virtualHierarchy.getID();
        }
        return "Proxy for metadata hierarchy: " + this.m_metadataHierarchy.getName();
    }

    public boolean getHasRelativeTimeMembers() {
        if (this.m_modelHierarchy != null) {
            return this.m_modelHierarchy.getHasRelativeTimeMembers();
        }
        if (this.m_virtualHierarchy != null) {
            return this.m_virtualHierarchy.getHasRelativeTimeMembers();
        }
        return false;
    }

    public static List<FmProxyHierarchy> collectHeirarchies(VirtualHierarchy vHier) {
        List<SourceObject> objs = vHier.getSourceObjects();
        ArrayList<FmProxyHierarchy> hiers = new ArrayList<FmProxyHierarchy>();
        for (SourceObject obj : objs) {
            hiers.add(new FmProxyHierarchy(obj));
        }
        return hiers;
    }
}

