/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmProxyBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmProxyHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualLevel;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.LevelReference;
import com.ibm.cognos.fmeng.fmmd.model.LevelStyle;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.SourceObject;
import com.ibm.cognos.fmeng.fmmd.model.VirtualHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.VirtualLevel;
import com.ibm.cognos.fmeng.metadata.MdHierarchy;
import com.ibm.cognos.fmeng.metadata.MdLevel;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmProxyLevel
extends FmProxyBase {
    private Level m_modelLevel;
    private VirtualLevel m_virtualLevel;
    private MdLevel m_metadataLevel;

    public static List<FmProxyLevel> collectLevels(FmProxyHierarchy parent) {
        ArrayList<FmProxyLevel> levels;
        block5: {
            block6: {
                block4: {
                    levels = new ArrayList<FmProxyLevel>();
                    if (!(parent.getSource() instanceof RelationalHierarchy)) break block4;
                    RelationalHierarchy hier = (RelationalHierarchy)parent.getSource();
                    if (!hier.isMultiRoot()) {
                        levels.add(new FmProxyLevel(hier.getAllLevel()));
                    }
                    for (LevelReference lvlRef : hier.getLevelReferences()) {
                        levels.add(new FmProxyLevel(lvlRef.getLevel()));
                    }
                    break block5;
                }
                if (!(parent.getSource() instanceof VirtualHierarchy)) break block6;
                VirtualHierarchy hier = (VirtualHierarchy)parent.getSource();
                for (VirtualLevel level : hier.getLevels()) {
                    levels.add(new FmProxyLevel(level));
                }
                break block5;
            }
            if (!(parent.getSource() instanceof MdHierarchy)) break block5;
            MdHierarchy hier = (MdHierarchy)parent.getSource();
            for (MdLevel level : hier.getLevels()) {
                levels.add(new FmProxyLevel(level));
            }
        }
        return levels;
    }

    public FmProxyLevel(Level level) {
        this.m_modelLevel = level;
        this.m_virtualLevel = null;
        this.m_metadataLevel = null;
    }

    public FmProxyLevel(VirtualLevel level) {
        this.m_modelLevel = null;
        this.m_virtualLevel = level;
        this.m_metadataLevel = null;
    }

    public FmProxyLevel(MdLevel level) {
        this.m_modelLevel = null;
        this.m_virtualLevel = null;
        this.m_metadataLevel = level;
    }

    public FmProxyLevel(SourceObject obj) {
        if (obj.isModelSource()) {
            if (obj.getModelSource() instanceof VirtualHierarchy) {
                this.m_virtualLevel = (VirtualLevel)obj.getModelSource();
            } else {
                this.m_modelLevel = (Level)obj.getModelSource();
            }
        } else {
            this.m_metadataLevel = (MdLevel)obj.getMetadataSource();
        }
    }

    @Override
    public String getName() {
        if (this.m_modelLevel != null) {
            return this.m_modelLevel.getName();
        }
        if (this.m_virtualLevel != null) {
            return this.m_virtualLevel.getName();
        }
        if (this.m_metadataLevel != null) {
            return this.m_metadataLevel.getName();
        }
        return null;
    }

    @Override
    public Object getSource() {
        if (this.m_modelLevel != null) {
            return this.m_modelLevel;
        }
        if (this.m_virtualLevel != null) {
            return this.m_virtualLevel;
        }
        if (this.m_metadataLevel != null) {
            return this.m_metadataLevel;
        }
        return null;
    }

    public SourceObject createSource(SourceObject srcParent, FmVirtualLevel vChildObj) {
        if (this.m_modelLevel != null) {
            return vChildObj.createSourceObject(srcParent, this.m_modelLevel);
        }
        if (this.m_virtualLevel != null) {
            return vChildObj.createSourceObject(srcParent, this.m_virtualLevel);
        }
        if (this.m_metadataLevel != null) {
            return vChildObj.createSourceObject(srcParent, this.m_metadataLevel);
        }
        return null;
    }

    public LevelStyle getLevelStyle() {
        if (this.m_modelLevel != null) {
            return this.m_modelLevel.getLevelStyle();
        }
        if (this.m_virtualLevel != null) {
            return this.m_virtualLevel.getLevelStyle();
        }
        if (this.m_metadataLevel != null) {
            return LevelStyle.regular;
        }
        return null;
    }

    public Object isAllLevel() {
        if (this.m_modelLevel != null) {
            return this.m_modelLevel.isAllLevel();
        }
        return null;
    }

    public static List<FmProxyLevel> collectLevels(VirtualLevel vLevel) {
        List<SourceObject> objs = vLevel.getSourceObjects();
        ArrayList<FmProxyLevel> levels = new ArrayList<FmProxyLevel>();
        for (SourceObject obj : objs) {
            levels.add(new FmProxyLevel(obj));
        }
        return levels;
    }
}

