/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmAggregateRule;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmProxyBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmProxyDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualMeasure;
import com.ibm.cognos.fmeng.fmmd.model.AggregateRule;
import com.ibm.cognos.fmeng.fmmd.model.FmRegularAggregate;
import com.ibm.cognos.fmeng.fmmd.model.Measure;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.SourceObject;
import com.ibm.cognos.fmeng.fmmd.model.VirtualCube;
import com.ibm.cognos.fmeng.fmmd.model.VirtualMeasure;
import com.ibm.cognos.fmeng.fmmd.model.VirtualMeasureDimension;
import com.ibm.cognos.fmeng.genmodel.AggregateRuleType;
import com.ibm.cognos.fmeng.genmodel.AggregateRulesType;
import com.ibm.cognos.fmeng.metadata.MdMeasure;
import com.ibm.cognos.fmeng.metadata.MdMeasureDimension;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmProxyMeasure
extends FmProxyBase {
    private VirtualMeasure m_virtualMeasure;
    private Measure m_modelMeasure;
    private MdMeasure m_metadataMeasure;
    private SourceObject m_cubeSource;

    public static List<FmProxyMeasure> collectMeasures(FmProxyDimension parent) {
        ArrayList<FmProxyMeasure> measures;
        block5: {
            block7: {
                block6: {
                    block4: {
                        measures = new ArrayList<FmProxyMeasure>();
                        if (!(parent.getSource() instanceof MeasureDimension)) break block4;
                        for (Measure measure : ((MeasureDimension)parent.getSource()).getAllMeasures()) {
                            measures.add(new FmProxyMeasure(measure));
                        }
                        break block5;
                    }
                    if (!(parent.getSource() instanceof VirtualMeasureDimension)) break block6;
                    for (VirtualMeasure measure : ((VirtualMeasureDimension)parent.getSource()).getAllMeasures()) {
                        measures.add(new FmProxyMeasure(measure));
                    }
                    break block5;
                }
                if (!(parent.getSource() instanceof VirtualCube)) break block7;
                for (VirtualMeasure measure : ((VirtualCube)parent.getSource()).getMeasureDimension().getAllMeasures()) {
                    measures.add(new FmProxyMeasure(measure));
                }
                break block5;
            }
            if (!(parent.getSource() instanceof MdMeasureDimension)) break block5;
            for (MdMeasure measure : ((MdMeasureDimension)parent.getSource()).getAllMeasures()) {
                measures.add(new FmProxyMeasure(measure));
            }
        }
        return measures;
    }

    public FmProxyMeasure(Measure measure) {
        this.m_modelMeasure = measure;
        this.m_virtualMeasure = null;
        this.m_metadataMeasure = null;
    }

    public FmProxyMeasure(VirtualMeasure measure) {
        this.m_modelMeasure = null;
        this.m_virtualMeasure = measure;
        this.m_metadataMeasure = null;
    }

    public FmProxyMeasure(MdMeasure measure) {
        this.m_modelMeasure = null;
        this.m_virtualMeasure = null;
        this.m_metadataMeasure = measure;
    }

    public FmProxyMeasure(SourceObject sObj) {
        this.m_cubeSource = sObj.getCubeSource();
        if (sObj.isModelSource()) {
            if (sObj.getModelSource() instanceof VirtualMeasure) {
                this.m_virtualMeasure = (VirtualMeasure)sObj.getModelSource();
            } else {
                this.m_modelMeasure = (Measure)sObj.getModelSource();
            }
        } else {
            this.m_metadataMeasure = (MdMeasure)sObj.getMetadataSource();
        }
    }

    public SourceObject getCubeSource() {
        return this.m_cubeSource;
    }

    public List<AggregateRule> getAggregateRules() {
        if (this.m_modelMeasure != null) {
            FmMeasure measure = (FmMeasure)this.m_modelMeasure;
            AggregateRulesType art = measure.getMeasureType().getAggregateRules();
            if (art != null) {
                EList<AggregateRuleType> arl = art.getAggregateRule();
                ArrayList<AggregateRule> res = new ArrayList<AggregateRule>(arl.size());
                for (AggregateRuleType ar : arl) {
                    res.add(FmAggregateRule.get(measure.m_session, ar));
                }
                return res;
            }
            return new ArrayList<AggregateRule>(0);
        }
        return new ArrayList<AggregateRule>(0);
    }

    public boolean isNonDistributive() {
        if (this.m_modelMeasure != null) {
            FmMeasure measure = (FmMeasure)this.m_modelMeasure;
            FmRegularAggregate agg = measure.getRegularAggregate();
            return this.checkIsNonDistributive(agg);
        }
        if (this.m_metadataMeasure != null) {
            MdMeasure meas = this.m_metadataMeasure;
            FmRegularAggregate agg = meas.getRegularAggregate();
            return this.checkIsNonDistributive(agg);
        }
        if (this.m_virtualMeasure != null) {
            List<FmProxyMeasure> vMeasures = this.m_virtualMeasure.getProxyMeasures();
            return this.checkIsNonDistributiveForVirtualObjects(vMeasures);
        }
        return false;
    }

    public boolean checkIsNonDistributiveForVirtualObjects(List<FmProxyMeasure> vMeasures2) {
        boolean found = false;
        List<FmProxyMeasure> vMeasures = vMeasures2;
        for (FmProxyMeasure vMeas : vMeasures) {
            if (!(vMeas.getSource() instanceof VirtualMeasure)) {
                FmRegularAggregate agg;
                if (vMeas.m_modelMeasure != null) {
                    FmMeasure measure = (FmMeasure)vMeas.m_modelMeasure;
                    agg = measure.getRegularAggregate();
                    found = this.checkIsNonDistributive(agg);
                } else if (vMeas.m_metadataMeasure != null) {
                    MdMeasure meas = vMeas.m_metadataMeasure;
                    agg = meas.getRegularAggregate();
                    found = this.checkIsNonDistributive(agg);
                }
                if (!found) continue;
                return found;
            }
            return this.checkIsNonDistributiveForVirtualObjects(vMeas.m_virtualMeasure.getProxyMeasures());
        }
        return found;
    }

    public boolean checkIsNonDistributive(FmRegularAggregate agg) {
        switch (agg) {
            case automatic: 
            case average: 
            case calculated: 
            case countDistinct: 
            case median: 
            case standardDeviation: 
            case unknown: 
            case unsupported: 
            case variance: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getName() {
        if (this.m_virtualMeasure != null) {
            return this.m_virtualMeasure.getName();
        }
        if (this.m_modelMeasure != null) {
            return this.m_modelMeasure.getName();
        }
        if (this.m_metadataMeasure != null) {
            return this.m_metadataMeasure.getName();
        }
        return "";
    }

    @Override
    public Object getSource() {
        if (this.m_virtualMeasure != null) {
            return this.m_virtualMeasure;
        }
        if (this.m_modelMeasure != null) {
            return this.m_modelMeasure;
        }
        return this.m_metadataMeasure;
    }

    public SourceObject createSource(SourceObject srcParent, FmVirtualMeasure vChildObj) {
        if (this.m_modelMeasure != null) {
            return vChildObj.createSourceObject(srcParent, this.m_modelMeasure);
        }
        if (this.m_metadataMeasure != null) {
            return vChildObj.createSourceObject(srcParent, this.m_metadataMeasure);
        }
        return vChildObj.createSourceObject(srcParent, this.m_virtualMeasure);
    }

    public String getFormat() {
        if (this.m_modelMeasure != null) {
            return this.m_modelMeasure.getFormat();
        }
        if (this.m_metadataMeasure != null) {
            return this.m_metadataMeasure.getFormat();
        }
        return this.m_virtualMeasure.getFormat();
    }

    public boolean getHidden() {
        if (this.m_modelMeasure != null) {
            return this.m_modelMeasure.getHidden();
        }
        if (this.m_virtualMeasure != null) {
            return this.m_virtualMeasure.getHidden();
        }
        return false;
    }

    public static List<FmProxyMeasure> collectMeasures(VirtualMeasure vMeas) {
        List<SourceObject> objs = vMeas.getSourceObjects();
        ArrayList<FmProxyMeasure> measures = new ArrayList<FmProxyMeasure>();
        for (SourceObject obj : objs) {
            measures.add(new FmProxyMeasure(obj));
        }
        return measures;
    }
}

