/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmAttributeReference;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCalculation;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmEMDObjectNaming;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevelReference;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLocaleMapping;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasureDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMultilingualAttribute;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMultilingualAttributeMap;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemFolder;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmShortcut;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmUnresolvedReference;
import com.ibm.cognos.fmeng.fmmd.impl.model.MoveListener;
import com.ibm.cognos.fmeng.fmmd.impl.model.QueryItemParentInternal;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.LevelReference;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemParent;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.Shortcut;
import com.ibm.cognos.fmeng.genmodel.DataRuleValueType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.LevelType;
import com.ibm.cognos.fmeng.genmodel.LocaleMappingType;
import com.ibm.cognos.fmeng.genmodel.QueryItemType;
import com.ibm.cognos.fmeng.genmodel.QuerySubjectType;
import com.ibm.cognos.fmeng.genmodel.RelationalDimensionType;
import com.ibm.cognos.fmeng.genmodel.RelationalHierarchyType;
import com.ibm.cognos.fmeng.genmodel.RelationalParameterMapType;
import com.ibm.cognos.fmeng.genmodel.RelationalQuerySubjectType;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.UnresolvedReference;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmQueryItem
extends FmQueryItemBase
implements QueryItem {
    public static FmQueryItem get(FMMDSession session, Object emfobj) {
        if (emfobj instanceof UnresolvedReference) {
            FmUnresolvedReference ref = new FmUnresolvedReference(session, (UnresolvedReference)emfobj);
            String type = FmMessage.render("BMT_PRP_queryItemID", session.getActiveLocale());
            Object[] msgParams = new Object[]{ref.getReference(), type};
            throw new FmMDException("BMT_MD_UNRESOLVED_REFERENCE", msgParams);
        }
        return new FmQueryItem(session, (QueryItemType)emfobj);
    }

    public static FmQueryItem createQueryItemFromQueryItem(FMMDSession session, FmQueryItemBase item, QueryItemParentInternal parent, String objectName, FmEMDObjectNaming eMDObjectNaming, FmShortcut shortcut) {
        FmQueryItem qi = FmQueryItem.createQueryItem(session, parent, objectName, eMDObjectNaming);
        qi.copyReplicableProperties(item);
        qi.setExpression(item, shortcut);
        return qi;
    }

    public static FmQueryItem createQueryItemFromCalculation(FMMDSession session, FmCalculation calc, QueryItemParentInternal parent, String objectName, FmEMDObjectNaming fmEMDObjectNaming) {
        FmQueryItem qi = FmQueryItem.createQueryItem(session, parent, objectName, fmEMDObjectNaming);
        qi.copyReplicableProperties(calc);
        qi.setExpression(calc);
        return qi;
    }

    public static FmQueryItem createQueryItemFromCalculationShortcut(FMMDSession session, QueryItemParentInternal parent, Shortcut sc, String objectName) {
        FmQueryItem qi = FmQueryItem.createQueryItem(session, parent, objectName, FmEMDObjectNaming.kMakeUnique);
        qi.setExpression(sc);
        return qi;
    }

    public static FmQueryItem createQueryItemFrom(FMMDSession session, ExpressionBuilder expression, QueryItemParentInternal parent, String objectName, FmEMDObjectNaming eMDObjectNaming) {
        FmQueryItem qi = FmQueryItem.createQueryItem(session, parent, objectName, eMDObjectNaming);
        if (expression != null) {
            qi.setExpression(expression);
        }
        return qi;
    }

    public static FmQueryItem createQueryItemFromColumn(FMMDSession session, QueryItemParentInternal parent, String name, MdColumn column) {
        FmQueryItem qi = FmQueryItem.createQueryItem(session, parent, name, FmEMDObjectNaming.kMakeUnique);
        qi.copyColumnProperties(column);
        return qi;
    }

    private static FmQueryItem createQueryItem(FMMDSession session, QueryItemParentInternal parent, String objectName, FmEMDObjectNaming fmEMDObjectNaming) {
        FmLevel level;
        DimensionBase object;
        if (objectName == null || objectName.length() == 0) {
            objectName = FmQueryItem.getDefaultName(session.getActiveLocale());
        }
        QueryItemType emfObj = GenmodelFactory.eINSTANCE.createQueryItemType();
        FmQueryItem queryItem = new FmQueryItem(session, emfObj);
        parent.addQueryItem(queryItem);
        if (parent instanceof FmLevel && (object = (level = (FmLevel)parent).getDimension()) instanceof FmRelationalDimension) {
            List<RelationalHierarchy> list = ((FmRelationalDimension)object).getAllHierarchies();
            block0: for (RelationalHierarchy obj : list) {
                if (!(obj instanceof FmRelationalHierarchy)) continue;
                List<LevelReference> lrefs = ((FmRelationalHierarchy)obj).getLevelReferences();
                for (LevelReference lref : lrefs) {
                    if (!lref.getLevel().equals(level)) continue;
                    FmLevelReference fmLref = (FmLevelReference)lref;
                    FmAttributeReference.createAttributeReference(session, fmLref, queryItem);
                    continue block0;
                }
            }
        }
        String uniqueName = queryItem.makeUniqueName(objectName);
        String localeKey = FmModelFactory.getInstance().getProject(session).getDefaultLocale();
        queryItem.setName(localeKey, uniqueName);
        if (parent instanceof MeasureDimension) {
            FmMeasureDimension measDim = (FmMeasureDimension)parent;
            measDim.createDataRule(emfObj, DataRuleValueType.ALWAYS_MATCHING);
        }
        return queryItem;
    }

    public static String getDefaultName(Locale locale) {
        return FmMessage.render("BMT_MDN_OBJECT_NAME_QUERYITEM", locale);
    }

    protected FmQueryItem(FMMDSession session, QueryItemType emfObject) {
        super(session, emfObject);
    }

    @Override
    public FmObjectType getFmObjectType() {
        return FmObjectType.queryItem;
    }

    public void copyNames(QueryItem nameSource, BaseObject.PrefixName namingStrategy, QueryItemParent parentObject) {
        this.copyNames((FmReportObject)((Object)nameSource), namingStrategy, (FmBaseObject)((Object)parentObject));
    }

    protected QueryItemType getQueryItemType() {
        return (QueryItemType)this.m_emfObject;
    }

    @Override
    protected FmQueryItemBase.EItemType getReportItemType() {
        return FmQueryItemBase.EItemType.kItemQueryItem;
    }

    @Override
    public MdColumn getMultilingualAttributeAsColumn(String locale) {
        if (this.getSession().getDefaultLocale().equals(locale)) {
            EObject parent = this.getQueryItemType().eContainer();
            while (parent != null) {
                if (parent instanceof RelationalDimensionType) {
                    FmRelationalDimension dim = FmRelationalDimension.get(this.m_session, parent);
                    QueryItemMapping mapping = dim.findMapping(this);
                    MdTable physicalTable = dim.findMapping(this).getTable().getPhysicalTable(true);
                    if (mapping != null && physicalTable != null) {
                        return physicalTable.findColumn(mapping.getColumnName());
                    }
                }
                parent = parent.eContainer();
            }
            return null;
        }
        FmMultilingualAttributeMap map = this.getMultilingualAttributeMap();
        if (map != null) {
            return map.getMultilingualAttributeAsColumn(this, locale);
        }
        return null;
    }

    @Override
    public Expression getMultilingualAttributeAsExpression(String locale) {
        if (this.getSession().getDefaultLocale().equals(locale)) {
            return this.getExpression();
        }
        FmMultilingualAttributeMap map = this.getMultilingualAttributeMap();
        if (map != null) {
            return map.getMultilingualAttributeAsExpression(this, locale);
        }
        return null;
    }

    public List<QueryItem> getMultilingualAttributeQueryItems() {
        FmMultilingualAttribute attrMap;
        String defaultLocale = this.m_session.getProject().getDefaultLocale();
        ArrayList<QueryItem> retItems = new ArrayList<QueryItem>();
        FmMultilingualAttributeMap map = this.getMultilingualAttributeMap();
        if (map != null && (attrMap = map.findAttribute(this)) != null) {
            List<FmLocaleMapping> localeMappings = attrMap.getLocaleMappingList();
            for (FmLocaleMapping m : localeMappings) {
                QueryItem item;
                if (m.getlocale().equals(defaultLocale) || (item = m.getQueryItem()) == null) continue;
                retItems.add(m.getQueryItem());
            }
        }
        return retItems;
    }

    @Override
    public boolean isMultilingual() {
        FmMultilingualAttributeMap map = this.getMultilingualAttributeMap();
        if (map != null) {
            return map.isMultilingual(this);
        }
        return false;
    }

    @Override
    public void removeMultilingualAttribute(String locale) {
        FmMultilingualAttributeMap map = this.getMultilingualAttributeMap();
        if (map != null) {
            map.removeMultilingualAttribute(this, locale);
        }
    }

    @Override
    public void setMultilingual(boolean multilingual) {
        FmMultilingualAttributeMap map = this.getMultilingualAttributeMap();
        if (map != null) {
            map.setMultilingual(this, multilingual);
        }
    }

    @Override
    public void setMultilingualAttribute(String locale, MdColumn column) {
        if (this.getSession().getDefaultLocale().equals(locale)) {
            this.m_session.getTaskDimensionBuilder(this.getRelationalParent()).addQueryItemMapping(this, column);
            return;
        }
        FmMultilingualAttributeMap map = this.getMultilingualAttributeMap();
        if (map != null) {
            map.setMultilingualAttribute(this, locale, column);
        }
    }

    @Override
    public void setMultilingualAttribute(String locale, ExpressionBuilder expression) {
        if (this.getSession().getDefaultLocale().equals(locale)) {
            this.setExpression(expression);
            return;
        }
        FmMultilingualAttributeMap map = this.getMultilingualAttributeMap();
        if (map != null) {
            map.setMultilingualAttribute(this, locale, expression);
        }
    }

    protected FmMultilingualAttributeMap getMultilingualAttributeMap() {
        EObject parent = this.getQueryItemType().eContainer();
        while (parent != null) {
            if (parent instanceof RelationalQuerySubjectType || parent instanceof RelationalParameterMapType || parent instanceof QuerySubjectType) {
                return null;
            }
            if (parent instanceof LocaleMappingType) {
                FmMDException.ASSERT(false, "This query item is part of a multilingual attribute.");
            }
            if (parent instanceof LevelType) {
                return FmLevel.get(this.m_session, parent).getMultilingualAttributeMap();
            }
            if (parent instanceof RelationalHierarchyType) {
                return FmRelationalHierarchy.get(this.m_session, parent).getMultilingualAttributeMap();
            }
            parent = parent.eContainer();
        }
        FmMDException.ASSERT(false, "Failed to find multilingual attribute map");
        return null;
    }

    @Override
    public RelationalHierarchy getHierarchy() {
        EObject obj = (EObject)this.m_emfObject;
        while (obj != null) {
            if (obj instanceof RelationalDimensionType) {
                RelationalDimensionType dim = (RelationalDimensionType)obj;
                EList<RelationalHierarchyType> hiers = dim.getRelationalHierarchy();
                if (hiers.size() != 1) break;
                return FmRelationalHierarchy.get(this.m_session, (EObject)hiers.get(0));
            }
            obj = obj.eContainer();
        }
        return null;
    }

    @Override
    public void moveObject(FmBaseObject targetParent, MoveListener listener) {
        EList<QueryItemType> targetQueryItems;
        if (targetParent instanceof FmQueryItemFolder && (targetQueryItems = ((FmQueryItemFolder)targetParent).getQueryItemFolderType().getQueryItem()).isEmpty()) {
            QueryItemType tmp = GenmodelFactory.eINSTANCE.createQueryItemType();
            targetQueryItems.add((Object)tmp);
            targetQueryItems.add((Object)((QueryItemType)this.m_emfObject));
            targetQueryItems.remove((Object)tmp);
            this.makeAllNamesUnique(BaseObject.PrefixName.kStandard, targetParent, listener);
            return;
        }
        super.moveObject(targetParent, listener);
    }
}

