/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPhysicalDefinition;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPseudoModelObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSQLObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTable;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.SQLObject;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.MeasureType;
import com.ibm.cognos.fmeng.genmodel.PhysicalDefinitionType;
import com.ibm.cognos.fmeng.genmodel.QueryItemMappingType;
import com.ibm.cognos.fmeng.genmodel.QueryItemType;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import org.eclipse.emf.ecore.EObject;

public class FmQueryItemMapping
extends FmPseudoModelObject
implements QueryItemMapping {
    FmQueryItemMapping(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    public static FmQueryItemMapping createQueryItemMapping(FMMDSession session, FmPhysicalDefinition fmPhysicalDefinition, FmQueryItem queryItem, String columnName, FmTable table) {
        String name = fmPhysicalDefinition.makeObjectNameUnique(columnName, 117);
        QueryItemMappingType qimt = GenmodelFactory.eINSTANCE.createQueryItemMappingType();
        qimt.setName(name);
        qimt.setColumnName(columnName);
        qimt.setPhysicalObjectRef(table.getName());
        qimt.setQueryItem(queryItem.getQueryItemType());
        FmQueryItemMapping fmQimt = new FmQueryItemMapping(session, qimt);
        fmPhysicalDefinition.addQueryItemMapping(fmQimt);
        return fmQimt;
    }

    public static FmQueryItemMapping createQueryItemMapping(FMMDSession session, FmPhysicalDefinition fmPhysicalDefinition, FmMeasure srcItem, String columnName, FmTable table) {
        String name = fmPhysicalDefinition.makeObjectNameUnique(columnName, 117);
        QueryItemMappingType qimt = GenmodelFactory.eINSTANCE.createQueryItemMappingType();
        qimt.setName(name);
        qimt.setColumnName(columnName);
        qimt.setPhysicalObjectRef(table.getName());
        qimt.setQueryItem(srcItem.getMeasureType());
        FmQueryItemMapping fmQimt = new FmQueryItemMapping(session, qimt);
        fmPhysicalDefinition.addQueryItemMapping(fmQimt);
        return fmQimt;
    }

    public static FmQueryItemMapping createQueryItemMapping(FMMDSession session, FmPhysicalDefinition fmPhysicalDefinition, FmQueryItem queryItem, String columnName, FmSQLObject sqlObj) {
        String name = fmPhysicalDefinition.makeObjectNameUnique(columnName, 117);
        QueryItemMappingType qimt = GenmodelFactory.eINSTANCE.createQueryItemMappingType();
        qimt.setName(name);
        qimt.setColumnName(columnName);
        qimt.setPhysicalObjectRef(sqlObj.getName());
        qimt.setQueryItem(queryItem.getQueryItemType());
        FmQueryItemMapping fmQimt = new FmQueryItemMapping(session, qimt);
        fmPhysicalDefinition.addQueryItemMapping(fmQimt);
        return fmQimt;
    }

    public QueryItemMappingType getQueryItemMappingType() {
        return (QueryItemMappingType)this.m_emfObject;
    }

    public String getObjectRef() {
        return this.getQueryItemMappingType().getPhysicalObjectRef();
    }

    public static FmQueryItemMapping get(FMMDSession session, Object emfobj) {
        return new FmQueryItemMapping(session, emfobj);
    }

    public QueryItemBase getQueryItem() {
        EObject queryItem = this.getQueryItemMappingType().getQueryItem();
        if (queryItem instanceof MeasureType) {
            return FmMeasure.get(this.m_session, this.getQueryItemMappingType().getQueryItem());
        }
        if (queryItem instanceof QueryItemType) {
            return FmQueryItem.get(this.m_session, this.getQueryItemMappingType().getQueryItem());
        }
        throw new FmMDException("BMT_MD_INVALID_QUERY_ITEM_MAPPING", this.getQueryItemMappingType().getName(), this.getRelationalParent().getName());
    }

    public String toString() {
        return "FmQueryItemMapping [getColumnName()=" + this.getColumnName() + ", getName()=" + this.getName() + ", getTable()=" + this.getTable() + "]";
    }

    public String getColumnName() {
        return this.getQueryItemMappingType().getColumnName();
    }

    public void setColumnName(String columnName) {
        this.getQueryItemMappingType().setColumnName(columnName);
    }

    public Table getTable() {
        PhysicalDefinitionType parentObject = (PhysicalDefinitionType)this.getQueryItemMappingType().eContainer();
        return FmPhysicalDefinition.getTable(this.m_session, parentObject, this.getObjectRef());
    }

    public SQLObject getSQLObject() {
        PhysicalDefinitionType parentObject = (PhysicalDefinitionType)this.getQueryItemMappingType().eContainer();
        return FmPhysicalDefinition.getSQLObject(this.m_session, parentObject, this.getObjectRef());
    }

    protected boolean tableRemoved(Table tbl) {
        FmTable table = (FmTable)tbl;
        if (table.getName().equals(this.getObjectRef())) {
            this.remove();
            return true;
        }
        return false;
    }

    protected boolean queryItemRemoved(QueryItemBase qi) {
        if (this.getQueryItem().equals(qi)) {
            this.remove();
            return true;
        }
        return false;
    }

    public RelationalObject getRelationalParent() {
        BaseObject parent = this.getParent();
        while (parent != null && !(parent instanceof RelationalObject)) {
            parent = parent.getParent();
        }
        return (RelationalObject)parent;
    }

    public MdColumn getPhysicalColumn() {
        MdTable table = this.getTable().getPhysicalTable(false);
        if (table == null) {
            return null;
        }
        return table.findColumn(this.getColumnName());
    }
}

