/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCalculation;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDataSource;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDbQuery;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDeterminant;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmEMDObjectNaming;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmExpression;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemFolder;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryOperation;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationship;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSection;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmShortcut;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmStoredProcedure;
import com.ibm.cognos.fmeng.fmmd.impl.model.ImpactListener;
import com.ibm.cognos.fmeng.fmmd.impl.model.QueryItemParentInternal;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveListener;
import com.ibm.cognos.fmeng.fmmd.impl.task.FmUsageAggregateTransformer;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.BasedOn;
import com.ibm.cognos.fmeng.fmmd.model.Calculation;
import com.ibm.cognos.fmeng.fmmd.model.Determinant;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.FmUsage;
import com.ibm.cognos.fmeng.fmmd.model.MeasureFolder;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemFolder;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemFolderParent;
import com.ibm.cognos.fmeng.fmmd.model.QuerySetOperation;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubjectRef;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.Shortcut;
import com.ibm.cognos.fmeng.fmmd.model.ShortcutTarget;
import com.ibm.cognos.fmeng.fmmd.model.UsageAggregate;
import com.ibm.cognos.fmeng.fmmd.util.EmfHelper;
import com.ibm.cognos.fmeng.fmmd.util.EmfRecurseHelper;
import com.ibm.cognos.fmeng.fmmd.util.ObjectHelper;
import com.ibm.cognos.fmeng.fmmd.util.ObjectReferenceHelper;
import com.ibm.cognos.fmeng.genmodel.DeterminantType;
import com.ibm.cognos.fmeng.genmodel.DeterminantsType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.QueryItemFolderType;
import com.ibm.cognos.fmeng.genmodel.QueryItemType;
import com.ibm.cognos.fmeng.genmodel.QuerySubjectType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.platform.impl.gateway.EMFModelGateway;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmQuerySubject
extends FmQuerySubjectBase
implements QueryItemFolderParent,
QueryItemParentInternal,
BasedOn,
QuerySubject {
    public static FmQuerySubject get(FMMDSession session, Object emfobj) {
        return new FmQuerySubject(session, (QuerySubjectType)emfobj);
    }

    private FmQuerySubject(FMMDSession session, QuerySubjectType emfObject) {
        super(session, emfObject);
    }

    @Override
    public FmObjectType getFmObjectType() {
        return FmObjectType.querySubject;
    }

    protected static FmQuerySubject createModelQuery(FMMDSession session, FmSection parent, String objectName) {
        FmQuerySubject qs = FmQuerySubject.createQuerySubjectBase(session, parent, objectName);
        qs.setDefinitionType(QuerySubjectBase.EDefinitionType.kTypeModelQuery);
        ((EMFSession)session).getGateway().createAllMandatory(qs.getInternal(), true);
        return qs;
    }

    protected static FmQuerySubject createDbQuerySubject(FMMDSession session, FmSection parent, String objectName, FmDataSource dataSource) {
        FmQuerySubject qs = FmQuerySubject.createQuerySubjectBase(session, parent, objectName);
        qs.intializeDbQueryDefinition(dataSource);
        return qs;
    }

    protected static FmQuerySubject createStoredProcedure(FMMDSession session, FmSection parent, String objectName, FmDataSource dataSource, String canonicalName) {
        FmQuerySubject qs = FmQuerySubject.createQuerySubjectBase(session, parent, objectName);
        qs.intializeStoredProcedureDefinition(dataSource, canonicalName, FmStoredProcedure.EProcType.procedure);
        return qs;
    }

    private void intializeStoredProcedureDefinition(FmDataSource dataSource, String canonicalName, FmStoredProcedure.EProcType type) {
        this.setDefinitionType(QuerySubjectBase.EDefinitionType.kTypeStoredProcedureQuery);
        FmStoredProcedure spDef = this.getDefinition().getStoredProcedure();
        spDef.init(dataSource, canonicalName, type);
    }

    protected static FmQuerySubject createModelSetQuery(FMMDSession session, FmSection parent, String objectName, QuerySubjectRef ref1, QuerySubjectRef ref2, QuerySetOperation.ESetOperation setOp, QuerySetOperation.EDuplicates dup) {
        if (ref1 == null || ref2 == null) {
            throw new FmMDException("BMT_MD_SOURCE_QSET_NOT_DIMENSION_ERROR");
        }
        FmQuerySubject qs = FmQuerySubject.createQuerySubjectBase(session, parent, objectName);
        qs.intializeModelSetDefinition(ref1, ref2, setOp, dup);
        return qs;
    }

    private void intializeModelSetDefinition(QuerySubjectRef refobj1, QuerySubjectRef refobj2, QuerySetOperation.ESetOperation setOp, QuerySetOperation.EDuplicates dup) {
        this.setDefinitionType(QuerySubjectBase.EDefinitionType.kTypeModelSetQuery);
        FmQueryOperation queryOp = this.getDefinition().getQueryOperation();
        queryOp.setQuerySubjectRefs(refobj1, refobj2);
        queryOp.setSetOperation(setOp);
        queryOp.setDuplicates(dup);
    }

    private void intializeDbQueryDefinition(FmDataSource dataSource) {
        this.setDefinitionType(QuerySubjectBase.EDefinitionType.kTypeDatabaseQuery);
        FmDbQuery dbQueryDef = this.getDefinition().getDbQuery();
        dbQueryDef.init(dataSource);
    }

    static FmQuerySubject createQuerySubjectBase(FMMDSession session, FmSection parent, String objectName) {
        if (objectName == null || objectName.length() == 0) {
            objectName = FmQuerySubject.getDefaultName(session.getActiveLocale());
        }
        QuerySubjectType emfObj = GenmodelFactory.eINSTANCE.createQuerySubjectType();
        FmQuerySubject qs = new FmQuerySubject(session, emfObj);
        parent.addQuerySubject(qs);
        String uniqueName = qs.makeUniqueName(objectName);
        String localeKey = FmModelFactory.getInstance().getProject(session).getDefaultLocale();
        qs.setName(localeKey, uniqueName);
        return qs;
    }

    @Override
    public QueryItemFolder createQueryItemFolder(String objectName) {
        FmQueryItemFolder qf = FmQueryItemFolder.createQueryItemFolder(this.m_session, this, objectName, FmEMDObjectNaming.kMakeUnique);
        return qf;
    }

    @Override
    public QueryItem createExternalQueryItem(String objectName, String externalName) {
        FmQueryItem qi = FmQueryItem.createQueryItemFrom(this.m_session, null, this, objectName, FmEMDObjectNaming.kMakeUnique);
        qi.setExternalName(externalName);
        return qi;
    }

    @Override
    public QueryItem createQueryItem(String objectName, ExpressionBuilder expr) {
        FmQueryItem qi = FmQueryItem.createQueryItemFrom(this.m_session, expr, this, objectName, FmEMDObjectNaming.kMakeUnique);
        return qi;
    }

    @Override
    public FmQueryItem createQueryItemFromCalculation(String objectName, Calculation calc) {
        FmQueryItem qi = FmQueryItem.createQueryItemFromCalculation(this.m_session, (FmCalculation)calc, this, objectName, FmEMDObjectNaming.kMakeUnique);
        return qi;
    }

    @Override
    public FmQueryItem createQueryItemFromQueryItem(String objectName, QueryItemBase qi, Shortcut sc) {
        FmQueryItem qs = FmQueryItem.createQueryItemFromQueryItem(this.m_session, (FmQueryItemBase)qi, this, objectName, FmEMDObjectNaming.kMakeUnique, (FmShortcut)sc);
        return qs;
    }

    public static String getDefaultName(Locale locale) {
        return FmMessage.render("BMT_MDN_OBJECT_NAME_QUERYSUBJECT", locale);
    }

    @Override
    void addChild(Object eObj) {
        switch (this.m_session.getGateway().getClassifierType(eObj)) {
            case 119: {
                this.addQueryItem((QueryItemType)eObj);
                return;
            }
            case 115: {
                this.addQueryItemFolder((QueryItemFolderType)eObj);
                return;
            }
        }
        super.addChild(eObj);
    }

    public QuerySubjectType getQuerySubjectTypeObj() {
        return (QuerySubjectType)this.m_emfObject;
    }

    private void addQueryItem(QueryItemType eObject) {
        this.getQuerySubjectTypeObj().getQueryItem().add((Object)eObject);
    }

    private void addQueryItemFolder(QueryItemFolderType eObject) {
        this.getQuerySubjectTypeObj().getQueryItemFolder().add((Object)eObject);
    }

    @Override
    public Determinant addDeterminant(String name) {
        FmDeterminant det = FmDeterminant.create(this.m_session, name);
        DeterminantsType determinantsParent = this.getQuerySubjectTypeObj().getDeterminants();
        if (determinantsParent == null) {
            determinantsParent = GenmodelFactory.eINSTANCE.createDeterminantsType();
            this.getQuerySubjectTypeObj().setDeterminants(determinantsParent);
        }
        EList<DeterminantType> determinants = determinantsParent.getDeterminant();
        determinants.add(det.getDeterminantType());
        return det;
    }

    public void removeDeterminant(Determinant det) {
        this.m_session.getGateway().delete(det.getInternal());
    }

    @Override
    public void clearDeterminants() {
        List<Determinant> determinants = this.getDeterminants();
        for (Determinant d : determinants) {
            this.removeDeterminant(d);
        }
    }

    public void applyDeterminantCoverage(List<FmQueryItem> queryItems, FmQueryItemBase.ESourceType eSourceType) {
        List<Determinant> vhDeterminants = this.getDeterminants();
        if (vhDeterminants.size() == 0) {
            return;
        }
        Determinant hUniqueDeterminant = null;
        for (Determinant det : vhDeterminants) {
            if (!det.isIdentifiesRow()) continue;
            hUniqueDeterminant = det;
            break;
        }
        for (FmQueryItem queryItem : queryItems) {
            Determinant hAddToDeterminant = hUniqueDeterminant;
            if (hUniqueDeterminant == null && eSourceType == FmQueryItemBase.ESourceType.kSourceModel) {
                hAddToDeterminant = this.locateDeterminantForModelItem(vhDeterminants, queryItem);
            }
            if (hAddToDeterminant == null) {
                hAddToDeterminant = (FmDeterminant)vhDeterminants.get(0);
            }
            FmMDException.ASSERT(hAddToDeterminant != null, "Cannot be null");
            hAddToDeterminant.addAttribute(queryItem);
        }
    }

    private Determinant locateDeterminantForModelItem(List<Determinant> vDeterminants, FmQueryItemBase hSourceItem) {
        Determinant hDeterminant = null;
        FmExpression exprObj = (FmExpression)hSourceItem.getExpression();
        FmMDException.ASSERT(exprObj != null, "expression property must exist for a model-sourced queryItem");
        List<ReportObject> vReferencedObjects = exprObj.getRefObjs(true);
        for (ReportObject refdObject : vReferencedObjects) {
            for (Determinant det : vDeterminants) {
                List<QueryItem> vKeys = det.getKeys();
                for (QueryItem key : vKeys) {
                    if (!key.equals(refdObject)) continue;
                    return det;
                }
                List<QueryItem> vAtbs = det.getAttributes();
                for (QueryItem att : vAtbs) {
                    if (!att.equals(refdObject)) continue;
                    return det;
                }
            }
        }
        return hDeterminant;
    }

    @Override
    public List<Determinant> getDeterminants() {
        EList<DeterminantType> dets;
        ArrayList<Determinant> determinants = new ArrayList<Determinant>();
        DeterminantsType dt = this.getQuerySubjectTypeObj().getDeterminants();
        if (dt != null && (dets = dt.getDeterminant()) != null) {
            for (DeterminantType det : dets) {
                FmDeterminant deter = FmDeterminant.get(this.m_session, det);
                determinants.add(deter);
            }
        }
        return determinants;
    }

    @Override
    public void pushUniqueDeterminantsToBottom() {
        DeterminantsType dt = this.getQuerySubjectTypeObj().getDeterminants();
        if (dt != null) {
            ArrayList<DeterminantType> udList = new ArrayList<DeterminantType>();
            EList<DeterminantType> dets = dt.getDeterminant();
            Iterator it = dets.iterator();
            while (it.hasNext()) {
                DeterminantType det = (DeterminantType)it.next();
                if (!det.isIdentifiesRow()) continue;
                udList.add(det);
                it.remove();
            }
            for (DeterminantType ud : udList) {
                dets.add(ud);
            }
        }
    }

    @Override
    public boolean verifyDuplicateDeterminants(List<QueryItem> hKeys, StringBuffer duplicateName) {
        if (hKeys != null) {
            List<Determinant> determinants = this.getDeterminants();
            for (Determinant det : determinants) {
                if (!hKeys.equals(det.getKeys())) continue;
                duplicateName.append(det.getName());
                return true;
            }
        }
        return false;
    }

    @Override
    public void addQueryItemFolder(QueryItemFolder folder) {
        this.addQueryItemFolder(((FmQueryItemFolder)folder).getQueryItemFolderType());
    }

    @Override
    public void addQueryItem(QueryItem queryItem) {
        this.addQueryItem(((FmQueryItem)queryItem).getQueryItemType());
    }

    @Override
    public List<QueryItem> getAllQueryItems() {
        EmfRecurseHelper allStuff = new EmfRecurseHelper(this.m_session, this.m_emfObject);
        allStuff.addRecurseInto(115);
        return allStuff.collect(119);
    }

    @Override
    public List<QueryItem> getQueryItems() {
        return ObjectHelper.getQueryItems(this.m_session, this.getQuerySubjectTypeObj());
    }

    @Override
    public List<? extends FmQueryItemBase> getQueryItems(FmQuerySubjectBase.EQueryItemsScope eQItemScope, FmQuerySubjectBase.EQueryItemsSource eQItemSource) {
        FmMDException.ASSERT(eQItemScope == FmQuerySubjectBase.EQueryItemsScope.kScopeAll || eQItemScope == FmQuerySubjectBase.EQueryItemsScope.kScopeDefaultHierarchyOnly, "Not supported");
        ArrayList<? extends FmQueryItemBase> hQItems = new ArrayList<FmQueryItemBase>();
        List<QueryItem> descendingQItems = this.getAllQueryItems();
        hQItems.addAll(this.filterItemsBySourceType(descendingQItems, eQItemSource));
        return hQItems;
    }

    public List<QueryItem> getFactQueryItems() {
        List<QueryItem> fmQueryItems = this.getAllQueryItems();
        ArrayList<QueryItem> qItems = new ArrayList<QueryItem>();
        for (QueryItem qi : fmQueryItems) {
            if (qi.getUsage() != FmUsage.fact) continue;
            qItems.add(qi);
        }
        return qItems;
    }

    public List<QueryItem> getNonFactQueryItems() {
        List<QueryItem> fmQueryItems = this.getAllQueryItems();
        ArrayList<QueryItem> qItems = new ArrayList<QueryItem>();
        for (QueryItem qi : fmQueryItems) {
            if (qi.getUsage() == FmUsage.fact) continue;
            qItems.add(qi);
        }
        return qItems;
    }

    @Override
    public void transformAggregate(List<? extends QueryItemBase> vhQueryItems, boolean bReset) {
        if (vhQueryItems.isEmpty()) {
            vhQueryItems = this.getAllQueryItems();
        }
        QuerySubjectBase.EDefinitionType eDefType = this.getDefinitionType();
        switch (eDefType) {
            case kTypeDatabaseQuery: 
            case kTypeStoredProcedureQuery: 
            case kTypeModelSetQuery: {
                this.usageAggregateForExternallySourced(false, vhQueryItems, bReset);
                break;
            }
            case kTypeModelQuery: {
                this.usageAggregateForModelSourced(false, vhQueryItems, bReset);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public void transformUsage(List<? extends QueryItemBase> vhQueryItems, boolean bReset) {
        if (vhQueryItems.isEmpty()) {
            vhQueryItems = this.getAllQueryItems();
        }
        QuerySubjectBase.EDefinitionType eDefType = this.getDefinitionType();
        switch (eDefType) {
            case kTypeDatabaseQuery: 
            case kTypeStoredProcedureQuery: 
            case kTypeModelSetQuery: {
                this.usageAggregateForExternallySourced(true, vhQueryItems, bReset);
                break;
            }
            case kTypeModelQuery: {
                this.usageAggregateForModelSourced(true, vhQueryItems, bReset);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void usageAggregateForExternallySourced(boolean bSetUsage, List<? extends UsageAggregate> vhQItems, boolean bReset) {
        List<Object> vhKeys = new ArrayList();
        if (bSetUsage) {
            vhKeys = this.getDeterminantKeys();
            vhKeys.addAll(this.getItemsParticipatingInRelationships());
        }
        FmUsageAggregateTransformer myUsageHandler = new FmUsageAggregateTransformer(this.m_session, bReset);
        for (UsageAggregate usageAggregate : vhQItems) {
            if (bSetUsage) {
                myUsageHandler.determineBasicUsage(usageAggregate, vhKeys);
                continue;
            }
            myUsageHandler.determineBasicAggregate(usageAggregate);
        }
    }

    private void usageAggregateForModelSourced(boolean bSetUsage, List<? extends QueryItemBase> vhQItems, boolean bReset) {
        List<Object> vhKeys = new ArrayList();
        if (bSetUsage) {
            vhKeys = this.getDeterminantKeys();
            vhKeys.addAll(this.getItemsParticipatingInRelationships());
        }
        FmUsageAggregateTransformer myUsageHandler = new FmUsageAggregateTransformer(this.m_session, bReset);
        for (QueryItemBase queryItemBase : vhQItems) {
            UsageAggregate hBasedOn = this.getFirstUsageAggregateItem(queryItemBase.getExpression());
            if (bSetUsage) {
                myUsageHandler.determineBasedOnUsage(queryItemBase, hBasedOn, vhKeys);
                continue;
            }
            myUsageHandler.determineBasedOnAggregate(queryItemBase, hBasedOn);
        }
    }

    private UsageAggregate getFirstUsageAggregateItem(Expression expr) {
        List<ReportObject> refdItems = expr.getRefObjs(true);
        for (ReportObject refdItem : refdItems) {
            Shortcut sc;
            ShortcutTarget target;
            if (refdItem instanceof UsageAggregate) {
                return (UsageAggregate)refdItem;
            }
            if (!(refdItem instanceof Shortcut) || !((target = (sc = (Shortcut)refdItem).getRefobj()) instanceof UsageAggregate)) continue;
            return (UsageAggregate)((Object)target);
        }
        return null;
    }

    private List<QueryItemBase> getDeterminantKeys() {
        ArrayList<QueryItemBase> keys = new ArrayList<QueryItemBase>();
        List<Determinant> dets = this.getDeterminants();
        for (Determinant det : dets) {
            keys.addAll(det.getKeys());
        }
        return keys;
    }

    private List<QueryItemBase> getItemsParticipatingInRelationships() {
        ArrayList<QueryItemBase> itemsInRels = new ArrayList<QueryItemBase>();
        List<QueryItem> allItems = this.getAllQueryItems();
        List<Object> relationships = ObjectReferenceHelper.getRelationshipsFor(this.m_session.getProject(), this, true);
        if (relationships != null) {
            for (Object rel : relationships) {
                FmRelationship relationship;
                List<ReportObject> refItems;
                if (!(rel instanceof FmRelationship) || (refItems = (relationship = (FmRelationship)FmModelFactory.getInstance().get(this.m_session, rel)).getExpression().getRefObjs(true)) == null) continue;
                for (ReportObject obj : refItems) {
                    FmQueryItem item;
                    if (!(obj instanceof FmQueryItem) || !allItems.contains(item = (FmQueryItem)obj)) continue;
                    itemsInRels.add(item);
                }
            }
        }
        return itemsInRels;
    }

    public void insertDeterminant(Determinant prop, Determinant beforeProp) {
        DeterminantsType dt = this.getQuerySubjectTypeObj().getDeterminants();
        EList<DeterminantType> dts = dt.getDeterminant();
        dts.remove(prop.getInternal());
        int index = -1;
        if (beforeProp != null) {
            index = dts.indexOf(beforeProp.getInternal());
        }
        if (index != -1) {
            dts.add(index, ((FmDeterminant)prop).getDeterminantType());
        } else {
            dts.add(((FmDeterminant)prop).getDeterminantType());
        }
    }

    @Override
    public Determinant getDeteriminant(String name) {
        List<Determinant> dets = this.getDeterminants();
        for (Determinant det : dets) {
            if (!name.equals(det.getName())) continue;
            return det;
        }
        return null;
    }

    public void removeInvalidDeterminants() {
        List<Determinant> dets = this.getDeterminants();
        for (Determinant det : dets) {
            FmDeterminant fmDet = (FmDeterminant)det;
            if (fmDet.isValid()) continue;
            this.removeDeterminant(fmDet);
        }
    }

    @Override
    public void getReferencedObjects(Set<BaseObject> objects) {
        List<Determinant> determinants = this.getDeterminants();
        for (Determinant det : determinants) {
            List<QueryItem> atts = det.getAttributes();
            for (QueryItem att : atts) {
                objects.add((FmQueryItem)att);
            }
            List<QueryItem> keys = det.getAttributes();
            for (QueryItem key : keys) {
                objects.add((FmQueryItem)key);
            }
        }
        super.getReferencedObjects(objects);
    }

    @Override
    public void prepareForObjectDeletion(RemoveInfo info, FmBaseObject object, RemoveListener listener) {
        List<Determinant> determinants = this.getDeterminants();
        for (Determinant det : determinants) {
            List<QueryItem> atts = det.getAttributes();
            for (QueryItem att : atts) {
                if (!att.equals(object)) continue;
                det.removeAttribute(att);
            }
            List<QueryItem> keys = det.getKeys();
            for (QueryItem key : keys) {
                if (!key.equals(object)) continue;
                det.removeKey(key);
            }
            if (det.getKeys().size() != 0) continue;
            listener.deleteDeterminant(this, (FmDeterminant)det);
            this.removeDeterminant((FmDeterminant)det);
        }
        super.prepareForObjectDeletion(info, object, listener);
    }

    @Override
    public void syncItemsToDefinition(boolean updateTableType, ImpactListener listener) {
        super.syncItemsToDefinition(updateTableType, listener);
        this.removeInvalidDeterminants();
    }

    public List<QueryItem> getQueryItemsInAllDeterminants() {
        ArrayList<QueryItem> items = new ArrayList<QueryItem>();
        List<Determinant> dets = this.getDeterminants();
        if (!dets.isEmpty()) {
            for (Determinant det : dets) {
                items.addAll(det.getKeys());
                items.addAll(det.getAttributes());
            }
        }
        return items;
    }

    public List<QueryItem> getQueryItemsNotInDeterminants() {
        ArrayList<QueryItem> items = new ArrayList<QueryItem>();
        List<QueryItem> allItems = this.getAllQueryItems();
        List<QueryItem> detItems = this.getQueryItemsInAllDeterminants();
        for (QueryItem item : allItems) {
            if (detItems.contains(item)) continue;
            items.add(item);
        }
        return items;
    }

    public List<QueryItemFolder> getAllQueryItemFolders() {
        HashSet<Integer> recurseInto = new HashSet<Integer>();
        HashMap<Integer, List<Object>> collect = new HashMap<Integer, List<Object>>();
        recurseInto.add(115);
        ArrayList qItems = new ArrayList();
        collect.put(115, qItems);
        EmfHelper.collect(this.m_emfObject, recurseInto, collect);
        ArrayList<QueryItemFolder> res = new ArrayList<QueryItemFolder>();
        for (Object qItem : qItems) {
            res.add((FmQueryItemFolder)FmModelFactory.getInstance().get(this.m_session, qItem));
        }
        return res;
    }

    public QueryItemFolder findOrCreateQueryItemFolderFrom(MeasureFolder measureFolder) {
        String folderName = measureFolder.getName();
        QueryItemFolder qif = this.findQueryItemFolder(folderName);
        if (qif == null) {
            QueryItemFolderType qifEmfObj = GenmodelFactory.eINSTANCE.createQueryItemFolderType();
            EMFModelGateway.copyChidrenFrom(measureFolder.getInternal(), qifEmfObj);
            qif = FmQueryItemFolder.get(this.m_session, qifEmfObj);
            this.addQueryItemFolder(qif);
        }
        return qif;
    }

    private QueryItemFolder findQueryItemFolder(String folderName) {
        List<QueryItemFolder> qifs = this.getAllQueryItemFolders();
        if (qifs != null) {
            for (QueryItemFolder qif : qifs) {
                if (!folderName.equals(qif.getName())) continue;
                return qif;
            }
        }
        return null;
    }

    @Override
    public QueryItem findQueryItemByExternalName(String externalName) {
        List<QueryItem> qis = this.getAllQueryItems();
        for (QueryItem qi : qis) {
            String xname = qi.getExternalName();
            if (xname == null || !xname.equals(externalName)) continue;
            return qi;
        }
        return null;
    }
}

