/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.helpers.XExecuteCommandHelper;
import com.ibm.cognos.fmeng.fmmd.helpers.XResponseDomHelper;
import com.ibm.cognos.fmeng.fmmd.impl.model.EObjectSourceType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmComplexProperty;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDataSource;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDataSources;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDbQuery;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDefinition;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmExpression;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFilter;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFilterDefinition;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFilters;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmNamespace;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPreviewFilter;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPreviewFilters;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRefobjViaShortcut;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationship;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSection;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSecurityFilterDefinition;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSecurityFilters;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSecurityObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSecurityView;
import com.ibm.cognos.fmeng.fmmd.impl.model.ImpactListener;
import com.ibm.cognos.fmeng.fmmd.impl.model.QueryItemParentInternal;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveListener;
import com.ibm.cognos.fmeng.fmmd.impl.task.DefaultImpactListener;
import com.ibm.cognos.fmeng.fmmd.impl.task.FmQueryItemSynchronizer;
import com.ibm.cognos.fmeng.fmmd.impl.task.PhysicalSqlName;
import com.ibm.cognos.fmeng.fmmd.impl.task.TestObjectMixin;
import com.ibm.cognos.fmeng.fmmd.impl.task.planner.XConnectionManager;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.DbQuery;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.ModelQuery;
import com.ibm.cognos.fmeng.fmmd.model.QueryChild;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.QuerySetOperation;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.model.Relationship;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipEnd;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.StoredProcedure;
import com.ibm.cognos.fmeng.fmmd.util.Joinable;
import com.ibm.cognos.fmeng.fmmd.util.StringHelper;
import com.ibm.cognos.fmeng.fmmd.util.TestOptions;
import com.ibm.cognos.fmeng.genmodel.DbQueryType;
import com.ibm.cognos.fmeng.genmodel.DefinitionType;
import com.ibm.cognos.fmeng.genmodel.ExpressionType;
import com.ibm.cognos.fmeng.genmodel.ExternalizeMethodType;
import com.ibm.cognos.fmeng.genmodel.FilterDefinitionType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.MdQueryType;
import com.ibm.cognos.fmeng.genmodel.ModelQueryType;
import com.ibm.cognos.fmeng.genmodel.PreviewFilterType;
import com.ibm.cognos.fmeng.genmodel.PreviewFiltersType;
import com.ibm.cognos.fmeng.genmodel.QueryOperationType;
import com.ibm.cognos.fmeng.genmodel.QuerySubjectBaseType;
import com.ibm.cognos.fmeng.genmodel.QuerySubjectRefsType;
import com.ibm.cognos.fmeng.genmodel.SecurityFilterDefinitionType;
import com.ibm.cognos.fmeng.genmodel.SecurityFiltersType;
import com.ibm.cognos.fmeng.genmodel.SqlType;
import com.ibm.cognos.fmeng.genmodel.StoredProcedureType;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.gateway.EMFModelGateway;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FmQuerySubjectBase
extends FmReportObject
implements QuerySubjectBase,
QueryItemParentInternal,
Joinable<FmQuerySubjectBase, FmRelationship>,
Comparable<FmQuerySubjectBase> {
    public static FmQuerySubjectBase getQueryParent(QueryChild qc) {
        BaseObject parent = qc;
        while (parent != null && !(parent instanceof FmQuerySubjectBase)) {
            parent = parent.getParent();
        }
        return (FmQuerySubjectBase)parent;
    }

    FmQuerySubjectBase(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    public QuerySubjectBaseType getQuerySubjectBaseType() {
        return (QuerySubjectBaseType)this.m_emfObject;
    }

    public FmDefinition getDefinition() {
        DefinitionType eObj = this.getQuerySubjectBaseType().getDefinition();
        return FmDefinition.get(this.m_session, eObj);
    }

    public void setDefinition(FmDefinition def) {
        this.getQuerySubjectBaseType().setDefinition((DefinitionType)def.getInternal());
    }

    @Override
    public QuerySubjectBase.EDefinitionType getDefinitionType() {
        QuerySubjectBase.EDefinitionType definitionType = QuerySubjectBase.EDefinitionType.kTypeUnknown;
        DefinitionType eObj = this.getQuerySubjectBaseType().getDefinition();
        if (eObj != null) {
            if (eObj.getDbQuery() != null) {
                definitionType = QuerySubjectBase.EDefinitionType.kTypeDatabaseQuery;
            } else if (eObj.getModelQuery() != null) {
                definitionType = QuerySubjectBase.EDefinitionType.kTypeModelQuery;
            } else if (eObj.getMdQuery() != null) {
                definitionType = QuerySubjectBase.EDefinitionType.kTypeMultiDimensionalQuery;
            } else if (eObj.getStoredProcedure() != null) {
                definitionType = QuerySubjectBase.EDefinitionType.kTypeStoredProcedureQuery;
            } else if (eObj.getQueryOperation() != null) {
                definitionType = QuerySubjectBase.EDefinitionType.kTypeModelSetQuery;
            }
        }
        return definitionType;
    }

    public String getLocalizedDefinitionType() {
        String key = null;
        switch (this.getDefinitionType()) {
            case kTypeDatabaseQuery: {
                key = "BMT_PRP_querySubjectTypeDBQueryID";
                break;
            }
            case kTypeModelQuery: {
                key = "BMT_PRP_querySubjectTypeModelID";
                break;
            }
            case kTypeMultiDimensionalQuery: {
                key = "BMT_PRP_querySubjectTypeMDQueryID";
                break;
            }
            case kTypeStoredProcedureQuery: {
                key = "BMT_PRP_querySubjectTypeStoredProcedureID";
                break;
            }
            case kTypeModelSetQuery: {
                key = "BMT_PRP_querySubjectTypeQueryOperationID";
                break;
            }
            default: {
                FmMDException.ASSERT(false, "Bad query subject definition type: " + this.getDefinitionType().toString());
            }
        }
        return FmMessage.render(key, this.m_session.getActiveLocale());
    }

    protected void setDefinitionType(QuerySubjectBase.EDefinitionType eDefType) {
        Object typeObj = null;
        DefinitionType eObj = GenmodelFactory.eINSTANCE.createDefinitionType();
        switch (eDefType) {
            case kTypeDatabaseQuery: {
                typeObj = GenmodelFactory.eINSTANCE.createDbQueryType();
                eObj.setDbQuery((DbQueryType)typeObj);
                break;
            }
            case kTypeModelQuery: {
                typeObj = GenmodelFactory.eINSTANCE.createModelQueryType();
                eObj.setModelQuery((ModelQueryType)typeObj);
                break;
            }
            case kTypeMultiDimensionalQuery: {
                typeObj = GenmodelFactory.eINSTANCE.createMdQueryType();
                eObj.setMdQuery((MdQueryType)typeObj);
                break;
            }
            case kTypeStoredProcedureQuery: {
                typeObj = GenmodelFactory.eINSTANCE.createStoredProcedureType();
                eObj.setStoredProcedure((StoredProcedureType)typeObj);
                break;
            }
            case kTypeModelSetQuery: {
                typeObj = GenmodelFactory.eINSTANCE.createQueryOperationType();
                eObj.setQueryOperation((QueryOperationType)typeObj);
                break;
            }
            default: {
                FmMDException.ASSERT(false, "Wrong definition type");
            }
        }
        this.getQuerySubjectBaseType().setDefinition(eObj);
    }

    @Override
    public EObjectSourceType determineSourceType() {
        return this.determineSourceType(null);
    }

    public EObjectSourceType determineSourceType(HashSet<FmBaseObject> hVisitedObjs) {
        if (hVisitedObjs == null) {
            hVisitedObjs = new HashSet();
        }
        EObjectSourceType eSourceType = EObjectSourceType.kUnknown;
        QuerySubjectBase.EDefinitionType eDefType = this.getDefinitionType();
        switch (eDefType) {
            case kTypeDatabaseQuery: 
            case kTypeStoredProcedureQuery: {
                eSourceType = EObjectSourceType.kRelational;
                break;
            }
            case kTypeMultiDimensionalQuery: {
                eSourceType = EObjectSourceType.kMultidimensional;
                break;
            }
            case kTypeModelQuery: {
                List<? extends FmQueryItemBase> hDerivedQIs = this.getQueryItems(EQueryItemsScope.kScopeAll, EQueryItemsSource.kSourceAll);
                int idx = 0;
                while (idx < hDerivedQIs.size() && eSourceType == EObjectSourceType.kUnknown) {
                    FmQueryItemBase item = hDerivedQIs.get(idx);
                    List<ReportObject> refdItems = item.getExpression().getRefObjs(true);
                    int refIdx = 0;
                    while (refIdx < refdItems.size() && eSourceType == EObjectSourceType.kUnknown) {
                        ReportObject target = refdItems.get(refIdx);
                        if (target != null && target instanceof QueryChild && !hVisitedObjs.contains(target) && !hDerivedQIs.contains(target)) {
                            hVisitedObjs.add((FmBaseObject)((Object)target));
                            eSourceType = FmQuerySubjectBase.getQueryParent((QueryChild)target).determineSourceType(hVisitedObjs);
                        }
                        ++refIdx;
                    }
                    ++idx;
                }
                break;
            }
            case kTypeModelSetQuery: {
                break;
            }
            default: {
                eSourceType = EObjectSourceType.kRelational;
            }
        }
        return eSourceType;
    }

    public abstract List<? extends FmQueryItemBase> getQueryItems(EQueryItemsScope var1, EQueryItemsSource var2);

    List<? extends FmQueryItemBase> filterItemsBySourceType(List<? extends QueryItemBase> hSourceItems, EQueryItemsSource eQItemSource) {
        ArrayList<FmQueryItemBase> hFilteredItems = new ArrayList<FmQueryItemBase>();
        for (QueryItemBase queryItemBase : hSourceItems) {
            FmQueryItemBase sourceItem = (FmQueryItemBase)queryItemBase;
            if (eQItemSource == EQueryItemsSource.kSourceAll) {
                hFilteredItems.add(sourceItem);
                continue;
            }
            FmQueryItemBase.ESourceType eSource = sourceItem.getSourceType();
            if ((eQItemSource != EQueryItemsSource.kSourceExternalOnly || eSource != FmQueryItemBase.ESourceType.kSourceExternal) && (eQItemSource != EQueryItemsSource.kSourceModelOnly || eSource != FmQueryItemBase.ESourceType.kSourceModel)) continue;
            hFilteredItems.add(sourceItem);
        }
        return hFilteredItems;
    }

    String fixupSqlDataSources(String strSql, XResponseDomHelper hlprResponse) {
        if (strSql.equals("")) {
            return "";
        }
        ArrayList<XResponseDomHelper.DataSource> outDataSources = new ArrayList<XResponseDomHelper.DataSource>();
        hlprResponse.getResponseDataSources(outDataSources);
        FmDataSources dataSources = FmModelFactory.getInstance().getProject(this.m_session).getDataSourcesFolder();
        for (XResponseDomHelper.DataSource ds : outDataSources) {
            FmDataSource objDataSource = dataSources.findOrCreateDataSource("", ds.s_cmName, ds.s_catalog, ds.s_schema, "", "", "");
            String dsSymbol = objDataSource.getDataSourceIndicator();
            PhysicalSqlName.makePhysicalSqlName(ds.s_cmName);
            PhysicalSqlName.makePhysicalSqlName(ds.s_catalog);
            PhysicalSqlName.makePhysicalSqlName(ds.s_schema);
            String str3PartName = String.valueOf(PhysicalSqlName.makePhysicalSqlName(ds.s_cmName)) + "." + PhysicalSqlName.makePhysicalSqlName(ds.s_catalog) + "." + PhysicalSqlName.makePhysicalSqlName(ds.s_schema) + ".";
            strSql = StringHelper.replaceAll(strSql, str3PartName, dsSymbol);
        }
        return strSql;
    }

    public FmSecurityFilters getSecurityFilters() {
        SecurityFiltersType pvft = this.getQuerySubjectBaseType().getSecurityFilters();
        if (pvft == null) {
            FmSecurityFilters pf = FmSecurityFilters.create(this.m_session);
            this.getQuerySubjectBaseType().setSecurityFilters(pf.getSecurityFiltersType());
            return pf;
        }
        return FmSecurityFilters.get(this.m_session, pvft);
    }

    public void setSecurityFilters(FmSecurityFilters filters) {
        List<FmSecurityFilterDefinition> fils = filters.getFilterDefinition();
        for (FmSecurityFilterDefinition f : fils) {
            this.getQuerySubjectBaseType().getSecurityFilters().getSecurityFilterDefinition().add((Object)((SecurityFilterDefinitionType)f.getInternal()));
        }
    }

    public FmPreviewFilters getPreviewFiltersCollector() {
        PreviewFiltersType pvft = this.getQuerySubjectBaseType().getPreviewFilters();
        if (pvft == null) {
            FmPreviewFilters pf = FmPreviewFilters.create(this.m_session);
            this.getQuerySubjectBaseType().setPreviewFilters(pf.getPreviewFiltersType());
            return pf;
        }
        return FmPreviewFilters.get(this.m_session, pvft);
    }

    public void setPreviewFilters(FmPreviewFilters filters) {
        List<FmPreviewFilter> fils = filters.getPreviewFilter();
        for (FmPreviewFilter f : fils) {
            this.getQuerySubjectBaseType().getPreviewFilters().getPreviewFilter().add((Object)((PreviewFilterType)f.getInternal()));
        }
    }

    public FmFilters getFilters() {
        DefinitionType eObj = this.getQuerySubjectBaseType().getDefinition();
        FmFilters filters = null;
        boolean canHaveFilters = true;
        QuerySubjectBase.EDefinitionType defType = this.getDefinitionType();
        switch (defType) {
            case kTypeDatabaseQuery: {
                DbQueryType dbQuery = eObj.getDbQuery();
                filters = FmFilters.get(this.m_session, dbQuery.getFilters());
                break;
            }
            case kTypeModelQuery: {
                ModelQueryType modelQuery = eObj.getModelQuery();
                filters = FmFilters.get(this.m_session, modelQuery.getFilters());
                break;
            }
            case kTypeMultiDimensionalQuery: {
                MdQueryType mdQuery = eObj.getMdQuery();
                filters = FmFilters.get(this.m_session, mdQuery.getFilters());
                break;
            }
            case kTypeModelSetQuery: {
                QueryOperationType qOperation = eObj.getQueryOperation();
                filters = FmFilters.get(this.m_session, qOperation.getFilters());
                break;
            }
            default: {
                canHaveFilters = false;
            }
        }
        if (filters == null && canHaveFilters) {
            filters = this.createFilters();
        }
        return filters;
    }

    public List<FmSecurityFilterDefinition> getSecurityFiltersDefinition() {
        List<FmSecurityFilterDefinition> filtersDef = null;
        FmSecurityFilters secFilters = this.getSecurityFilters();
        if (secFilters != null) {
            filtersDef = secFilters.getFilterDefinition();
        }
        return filtersDef;
    }

    public List<FmPreviewFilter> getPreviewFilters() {
        List<FmPreviewFilter> previewFilterList = null;
        FmPreviewFilters pvFilters = this.getPreviewFiltersCollector();
        if (pvFilters != null) {
            previewFilterList = pvFilters.getPreviewFilter();
        }
        return previewFilterList;
    }

    public List<FmFilterDefinition> getFiltersDefinition() {
        FmFilters filters = this.getFilters();
        if (filters != null) {
            return filters.getFilterDefinition();
        }
        return new ArrayList<FmFilterDefinition>();
    }

    private FmFilters createFilters() {
        DefinitionType eObj = this.getQuerySubjectBaseType().getDefinition();
        FmFilters filters = FmFilters.create(this.m_session);
        QuerySubjectBase.EDefinitionType defType = this.getDefinitionType();
        switch (defType) {
            case kTypeDatabaseQuery: {
                DbQueryType dbQuery = eObj.getDbQuery();
                dbQuery.setFilters(filters.getFiltersType());
                break;
            }
            case kTypeModelQuery: {
                ModelQueryType modelQuery = eObj.getModelQuery();
                modelQuery.setFilters(filters.getFiltersType());
                break;
            }
            case kTypeMultiDimensionalQuery: {
                MdQueryType mdQuery = eObj.getMdQuery();
                mdQuery.setFilters(filters.getFiltersType());
                break;
            }
            case kTypeModelSetQuery: {
                QueryOperationType qOperation = eObj.getQueryOperation();
                qOperation.setFilters(filters.getFiltersType());
                break;
            }
            default: {
                FmMDException.ASSERT(false, "Wrong definition type");
            }
        }
        return filters;
    }

    public FmSecurityFilterDefinition addSecurityFilter(String sSearchPath, String sDisplayPath, String sBasedOn) {
        this.verifySecurityFilterIsUnique(sSearchPath, null);
        FmSecurityFilterDefinition newFilter = FmSecurityFilterDefinition.create(this.m_session, sSearchPath, sDisplayPath);
        if (sBasedOn != null && !sBasedOn.equals("")) {
            newFilter.setBasedOn(sBasedOn);
        }
        return newFilter;
    }

    public FmSecurityFilterDefinition createSecurityFilterDefinition(String displayName, FmSecurityView securityView) {
        FmSecurityFilters filters = this.getSecurityFilters();
        FmSecurityFilterDefinition filterDef = FmSecurityFilterDefinition.createSecurityFilterDefinition(this.m_session, filters, securityView);
        return filterDef;
    }

    private void verifySecurityFilterIsUnique(String inCMSearchPath, FmSecurityObject existingSecurityObj) {
        ArrayList vSFDefs = (ArrayList)this.getSecurityFiltersDefinition();
        ArrayList<FmSecurityObject> vSecurityObjs = new ArrayList<FmSecurityObject>();
        int i = 0;
        while (i < vSFDefs.size()) {
            FmSecurityObject temp = ((FmSecurityFilterDefinition)vSFDefs.get(i)).getSecurityObject();
            if (temp != null) {
                vSecurityObjs.add(temp);
            }
            ++i;
        }
        boolean bFilterExists = false;
        int idx = 0;
        while (idx < vSecurityObjs.size()) {
            String sCMSearchPath = ((FmSecurityObject)vSecurityObjs.get(idx)).getCMSearchPath();
            boolean bl = bFilterExists = sCMSearchPath.equals(inCMSearchPath) && !((FmSecurityObject)vSecurityObjs.get(idx)).equals(existingSecurityObj);
            if (bFilterExists) break;
            ++idx;
        }
        if (bFilterExists) {
            String sCMDisplayPath = ((FmSecurityObject)vSecurityObjs.get(idx)).getDisplayPathDynamic();
            Object[] msgParams = new Object[2];
            msgParams[0] = sCMDisplayPath;
            throw new FmMDException("BMT_MD_DUPLICATE_SECURITY_FILTER", msgParams);
        }
    }

    @Override
    void renderNameUniqueMessage(String name, String type) {
        Object[] msgParams = new Object[]{type, name};
        throw new FmMDException("BMT_MD_DUPLICATE_OBJECT_NAME_WITHIN_QUERYSUBJECT", msgParams);
    }

    @Override
    public void setExternalizeMethod(QuerySubjectBase.ExternalizeMethod value) {
        this.getQuerySubjectBaseType().setExternalizeMethod(ExternalizeMethodType.values()[value.ordinal()]);
    }

    @Override
    public QuerySubjectBase.ExternalizeMethod getExternalizeMethod() {
        return QuerySubjectBase.ExternalizeMethod.values()[this.getQuerySubjectBaseType().getExternalizeMethod().ordinal()];
    }

    @Override
    public void setExternalizeAutoSummary(boolean value) {
        this.getQuerySubjectBaseType().setExternalizeAutoSummary(value);
    }

    @Override
    public boolean getExternalizeAutoSummary() {
        return this.getQuerySubjectBaseType().isExternalizeAutoSummary();
    }

    public void makeQueryItemsExternallyBased(XResponseDomHelper hlprResponse) {
        ArrayList<Map<XResponseDomHelper.EColumnProp, String>> outColumns = new ArrayList<Map<XResponseDomHelper.EColumnProp, String>>();
        hlprResponse.getColumnList(outColumns);
        List<? extends FmQueryItemBase> hItems = this.getQueryItems(EQueryItemsScope.kScopeAll, EQueryItemsSource.kSourceModelOnly);
        FmMDException.ASSERT(hItems.size() == outColumns.size(), null);
        int idx = 0;
        while (idx < hItems.size()) {
            hItems.get(idx).setExternalName((String)((Map)outColumns.get(idx)).get((Object)XResponseDomHelper.EColumnProp.name));
            hItems.get(idx).setDatatype(FmDatatype.getValueOf((String)((Map)outColumns.get(idx)).get((Object)XResponseDomHelper.EColumnProp.dataType)));
            ++idx;
        }
    }

    public void syncItemsToDefinition(boolean updateTableType) {
        this.syncItemsToDefinition(updateTableType, new DefaultImpactListener());
    }

    public void syncItemsToDefinition(boolean updateTableType, ImpactListener listener) {
        if (this.getDefinition().getDbQuery() != null || this.getDefinition().getStoredProcedure() != null || this.getDefinition().getQueryOperation() != null) {
            FmQueryItemSynchronizer myQISynchronizer = new FmQueryItemSynchronizer(this);
            boolean refreshTableType = false;
            if (updateTableType && this.getDefinition().getDbQuery() != null && this.getDefinition().getDbQuery().getTableType() == FmDbQuery.TableType.unknown) {
                refreshTableType = true;
            }
            if (refreshTableType) {
                myQISynchronizer.setUpdateTableType(true);
            }
            myQISynchronizer.update(listener);
            if (this.getDefinition().getStoredProcedure() == null) {
                TestOptions sOptions = new TestOptions();
                sOptions.s_bIsForEvaluate = true;
                Element elmResponse = TestObjectMixin.doTest(this.m_session, sOptions, this);
                if (elmResponse != null) {
                    XResponseDomHelper hlprResponse = new XResponseDomHelper();
                    hlprResponse.take(elmResponse);
                    this.adjustQueryItemsProperties(hlprResponse);
                    if (this.getDefinition().getDbQuery() != null) {
                        this.updateDataSourceRefs(hlprResponse);
                    }
                }
            }
        }
        this.setUsageAggregates();
    }

    protected void adjustQueryItemsProperties(XResponseDomHelper hlprResponse) {
        ArrayList<QueryItemBase> vhTestableItems = new ArrayList<QueryItemBase>();
        vhTestableItems.addAll(this.getAllQueryItems());
        this.adjustQueryItemsProperties(hlprResponse, vhTestableItems);
    }

    void adjustQueryItemsProperties(XResponseDomHelper hlprResponse, List<QueryItemBase> vhTestableItems) {
        ArrayList<Map<XResponseDomHelper.EColumnProp, String>> outColumns = new ArrayList<Map<XResponseDomHelper.EColumnProp, String>>();
        hlprResponse.getColumnList(outColumns);
        FmMDException.ASSERT(vhTestableItems.size() == outColumns.size(), null);
        int idx = 0;
        while (idx < vhTestableItems.size()) {
            String precisionStr;
            QueryItemBase qi = vhTestableItems.get(idx);
            Map valueMap = (Map)outColumns.get(idx);
            String dataType = (String)valueMap.get((Object)XResponseDomHelper.EColumnProp.dataType);
            String length = (String)valueMap.get((Object)XResponseDomHelper.EColumnProp.length);
            long lengthValue = 0L;
            if (length != null) {
                lengthValue = Long.parseLong(length);
            }
            FmDatatype bmtDataType = XConnectionManager.getInstance().convertTypeToFMType(dataType, lengthValue);
            String externalName = (String)valueMap.get((Object)XResponseDomHelper.EColumnProp.name);
            if (externalName != null) {
                qi.setExternalName(externalName);
            }
            if (bmtDataType != null) {
                qi.setDatatype(bmtDataType);
            }
            if (bmtDataType == FmDatatype.UNSUPPORTED) {
                qi.setHidden(true);
            }
            if (bmtDataType == FmDatatype.BLOB || bmtDataType == FmDatatype.TEXTBLOB) {
                qi.setUnSortable(true);
            }
            qi.setSize(lengthValue);
            String scaleStr = (String)valueMap.get((Object)XResponseDomHelper.EColumnProp.scale);
            if (scaleStr != null) {
                int scale = Integer.parseInt(scaleStr);
                qi.setScale(scale);
            }
            if ((precisionStr = (String)valueMap.get((Object)XResponseDomHelper.EColumnProp.precision)) != null) {
                int precision = Integer.parseInt(precisionStr);
                qi.setPrecision(precision);
            }
            qi.setNullable("true".equals(valueMap.get((Object)XResponseDomHelper.EColumnProp.nullsAllowed)));
            String collationSequenceLevel = (String)valueMap.get((Object)XResponseDomHelper.EColumnProp.collationSequenceLevel);
            String collationSequenceName = (String)valueMap.get((Object)XResponseDomHelper.EColumnProp.collationSequenceName);
            String originalCollationSequenceName = (String)valueMap.get((Object)XResponseDomHelper.EColumnProp.originalCollationSequenceName);
            String originalEncodingName = (String)valueMap.get((Object)XResponseDomHelper.EColumnProp.originalEncodingName);
            if (collationSequenceName != null) {
                qi.setCollationSequenceName(collationSequenceName);
            }
            if (collationSequenceLevel != null) {
                qi.setCollationSequenceLevel(Integer.parseInt(collationSequenceLevel));
            }
            if (originalCollationSequenceName != null) {
                qi.setOriginalCollationSequenceName(originalCollationSequenceName);
            }
            if (originalEncodingName != null) {
                qi.setOriginalEncodingName(originalEncodingName);
            }
            ++idx;
        }
    }

    private void updateDataSourceRefs(XResponseDomHelper hlprResponse) {
        ArrayList<XResponseDomHelper.DataSource> dataSources = new ArrayList<XResponseDomHelper.DataSource>();
        hlprResponse.getResponseDataSources(dataSources);
        ArrayList<FmDataSource> fmDataSourceList = new ArrayList<FmDataSource>();
        FmDataSources dsfolder = this.getFmProject().getDataSourcesFolder();
        for (XResponseDomHelper.DataSource ds : dataSources) {
            FmDataSource fmDataSource = dsfolder.findOrCreateDataSource(ds.s_modelName, ds.s_cmName, ds.s_catalog, ds.s_schema, "", "", "");
            if (fmDataSource == null) continue;
            fmDataSourceList.add(fmDataSource);
        }
        List<FmDataSource> currDataSources = this.getDefinition().getDataSources();
        for (FmDataSource currDs : currDataSources) {
            if (fmDataSourceList.contains(currDs)) continue;
            this.getDefinition().removeDataSource(currDs);
        }
        for (FmDataSource currDs : fmDataSourceList) {
            if (currDataSources.contains(currDs)) continue;
            this.getDefinition().addDataSource(currDs);
        }
    }

    public void setUsageAggregates() {
        List<QueryItem> qItems = this.getAllQueryItems();
        this.transformUsage(qItems, false);
        this.transformAggregate(qItems, false);
    }

    public abstract void transformAggregate(List<? extends QueryItemBase> var1, boolean var2);

    public abstract void transformUsage(List<? extends QueryItemBase> var1, boolean var2);

    @Override
    public abstract List<QueryItem> getAllQueryItems();

    public void removeFilterDefinition(FmFilterDefinition def) {
        FmFilters filters = this.getFilters();
        filters.removeFilterDefinition(def);
    }

    public void removePreviewFilter(FmPreviewFilter pf) {
        FmPreviewFilters pvFilters = this.getPreviewFiltersCollector();
        pvFilters.removePreviewFilter(pf);
    }

    public void removeSecurityFilter(FmSecurityFilterDefinition sf) {
        FmSecurityFilters filters = this.getSecurityFilters();
        filters.removeSecurityFilter(sf);
    }

    public void insertFilterDefinition(FmFilterDefinition prop, FmFilterDefinition beforeProp) {
        FmFilters filters = this.getFilters();
        filters.moveFilterDefinition(prop, beforeProp);
    }

    public void insertPreviewFilter(FmPreviewFilter prop, FmPreviewFilter beforeProp) {
        FmPreviewFilters filters = this.getPreviewFiltersCollector();
        filters.movePreviewFilter(prop, beforeProp);
    }

    public void insertSecurityFilter(FmSecurityFilterDefinition prop, FmSecurityFilterDefinition beforeProp) {
        FmSecurityFilters filters = this.getSecurityFilters();
        filters.moveSecurityFilter(prop, beforeProp);
    }

    @Override
    public void getReferencedObjects(Set<BaseObject> objects) {
        List<FmPreviewFilter> filters = this.getPreviewFilters();
        for (FmPreviewFilter filter : filters) {
            filter.getReferencedObjects(objects);
        }
        List<FmSecurityFilterDefinition> securityFilters = this.getSecurityFiltersDefinition();
        for (FmSecurityFilterDefinition filterDef : securityFilters) {
            filterDef.getReferencedObjects(objects);
        }
        List<FmFilterDefinition> filterDefs = this.getFiltersDefinition();
        if (filterDefs != null) {
            for (FmFilterDefinition filter : filterDefs) {
                filter.getReferencedObjects(objects);
            }
        }
        List<FmDataSource> referencedDataSources = this.getReferencedDataSources();
        objects.addAll(referencedDataSources);
        FmDbQuery dbQuery = this.getDefinition().getDbQuery();
        if (dbQuery != null) {
            dbQuery.getBalticReferences(objects);
        }
    }

    private List<FmDataSource> getReferencedDataSources() {
        StoredProcedureType sp;
        FmDataSource bo;
        MdQueryType mdqt;
        DbQueryType dbqt = this.getQuerySubjectBaseType().getDefinition().getDbQuery();
        ArrayList<FmDataSource> res = new ArrayList<FmDataSource>();
        if (dbqt != null) {
            for (Object ds : dbqt.getSources().getDataSourceRef()) {
                FmDataSource bo2 = (FmDataSource)FmModelFactory.getInstance().get(this.m_session, ds);
                res.add(bo2);
            }
        }
        if ((mdqt = this.getQuerySubjectBaseType().getDefinition().getMdQuery()) != null) {
            for (Object ds : mdqt.getSources().getDataSourceRef()) {
                bo = (FmDataSource)FmModelFactory.getInstance().get(this.m_session, ds);
                res.add(bo);
            }
        }
        if ((sp = this.getQuerySubjectBaseType().getDefinition().getStoredProcedure()) != null) {
            EObject ds = sp.getDataSourceRef();
            bo = (FmDataSource)FmModelFactory.getInstance().get(this.m_session, ds);
            res.add(bo);
        }
        return res;
    }

    @Override
    public void prepareForObjectDeletion(RemoveInfo info, FmBaseObject object, RemoveListener listener) {
        FmDefinition def;
        FmDbQuery dbQuery;
        QueryOperationType ot;
        List<FmPreviewFilter> filters = this.getPreviewFilters();
        for (FmPreviewFilter filter : filters) {
            filter.breakReferencesTo(object);
        }
        boolean invalidated = false;
        List<FmSecurityFilterDefinition> securityFilters = this.getSecurityFiltersDefinition();
        for (FmSecurityFilterDefinition filterDef : securityFilters) {
            if (!filterDef.breakReferencesTo(object)) continue;
            invalidated = true;
        }
        List<FmFilterDefinition> filterDefs = this.getFiltersDefinition();
        for (FmFilterDefinition filter : filterDefs) {
            if (!filter.breakReferencesTo(object)) continue;
            invalidated = true;
        }
        DefinitionType defType = this.getQuerySubjectBaseType().getDefinition();
        QueryOperationType queryOperationType = ot = defType != null ? defType.getQueryOperation() : null;
        if (ot != null) {
            QuerySubjectRefsType refs = ot.getQuerySubjectRefs();
            invalidated = this.m_session.breakObjectReferences(object, (List<EObject>)refs.getRefobj());
        }
        FmDbQuery fmDbQuery = dbQuery = (def = this.getDefinition()) != null ? def.getDbQuery() : null;
        if (dbQuery != null) {
            dbQuery.clearBalticKeyAndIndexReferencesTo(object);
        }
        if (invalidated) {
            listener.invalidateObject(this);
        }
        super.prepareForObjectDeletion(info, object, listener);
    }

    public void convertMdQueryToDbquery() {
        FmMDException.ASSERT(QuerySubjectBase.EDefinitionType.kTypeModelQuery == this.getDefinitionType(), null);
        DefinitionType def = this.getQuerySubjectBaseType().getDefinition();
        SqlType sql = def.getModelQuery().getSql();
        TestOptions sOptions = new TestOptions();
        sOptions.s_bIsForEvaluate = true;
        Element elmResponse = TestObjectMixin.doTest(this.m_session, sOptions, this);
        XResponseDomHelper hlprResponse = new XResponseDomHelper();
        hlprResponse.take(elmResponse);
        this.makeQueryItemsExternallyBased(hlprResponse);
        this.setDefinitionType(QuerySubjectBase.EDefinitionType.kTypeDatabaseQuery);
        DbQueryType dbQyeryType = this.getQuerySubjectBaseType().getDefinition().getDbQuery();
        this.updateDataSourceRefs(hlprResponse);
        String cognosSQL = hlprResponse.getQueryFeedback(XExecuteCommandHelper.EQueryFeedback.CognosCommandText);
        String sqlStr = this.fixupSqlDataSources(cognosSQL, hlprResponse);
        EMFModelGateway.setSqlTypeValue(sql, sqlStr);
        dbQyeryType.setSql(sql);
    }

    public boolean isUpdateSubject() {
        return ((FmSection)this.getParent()).isUpdateSubject(this);
    }

    @Override
    public StoredProcedure getStoredProcedure() {
        return this.getDefinition().getStoredProcedure();
    }

    @Override
    public DbQuery getDBQuery() {
        return this.getDefinition().getDbQuery();
    }

    @Override
    public ModelQuery getModelQuery() {
        return this.getDefinition().getModelQuery();
    }

    @Override
    public QuerySetOperation getQueryOperation() {
        return this.getDefinition().getQueryOperation();
    }

    public BaseObject makeEmbeddedFilterGlobal(Object embeddedFilterObj, String suggestedName) {
        FmComplexProperty embeddedFilter = null;
        if (embeddedFilterObj instanceof FilterDefinitionType) {
            embeddedFilter = FmFilterDefinition.get(this.m_session, embeddedFilterObj);
        } else if (embeddedFilterObj instanceof PreviewFilterType) {
            embeddedFilter = FmPreviewFilter.get(this.m_session, embeddedFilterObj);
        } else if (embeddedFilterObj instanceof SecurityFilterDefinitionType) {
            embeddedFilter = FmSecurityFilterDefinition.get(this.m_session, embeddedFilterObj);
        } else {
            throw new FmMDException("BMT_MD_INVALID_PARAMETER", "makeEmbeddedFilterGlobal");
        }
        FmNamespace parent = this.getParentNamespace();
        FmFilter globalFilter = FmFilter.createFilter((FMMDSession)this.m_session, parent, suggestedName);
        FmExpression expression = embeddedFilter.getExpression();
        ExpressionType copy = (ExpressionType)this.m_session.getGateway().copyObject(expression.getExpressionType());
        globalFilter.getFilterType().setExpression(copy);
        embeddedFilter.setRefobj(globalFilter);
        embeddedFilter.unSetExpression();
        embeddedFilter.unSetDisplayName();
        return globalFilter;
    }

    @Override
    public List<FmRelationship> getJoins() {
        ArrayList<FmRelationship> joins = new ArrayList<FmRelationship>();
        ArrayList<BaseObject> objs = new ArrayList<BaseObject>();
        this.getReferencingObjects(objs);
        for (BaseObject obj : objs) {
            if (!(obj instanceof FmRelationship)) continue;
            joins.add((FmRelationship)obj);
        }
        return joins;
    }

    @Override
    public int compareTo(FmQuerySubjectBase o) {
        return this.getName().compareTo(o.getName());
    }

    @Override
    public QueryItem createQueryItemFromColumn(String name, MdColumn column) {
        return FmQueryItem.createQueryItemFromColumn(this.m_session, this, name, column);
    }

    @Override
    public QueryItem findQueryItemReferencing(QueryItem dbQueryItem) {
        for (QueryItem qi : this.getAllQueryItems()) {
            FmRefobjViaShortcut refObj;
            FmQueryItem candidateQI;
            Object comp;
            List<Object> comps;
            Expression expr = qi.getExpression();
            if (expr == null || (comps = expr.getComponents()).size() != 1 || !((comp = comps.get(0)) instanceof FmQueryItem ? (candidateQI = (FmQueryItem)comps.get(0)).equals(dbQueryItem) : comp instanceof FmRefobjViaShortcut && (refObj = (FmRefobjViaShortcut)comp).getRefobj().equals(dbQueryItem))) continue;
            return qi;
        }
        return null;
    }

    @Override
    public List<Relationship> getRelationships(RelationshipEnd other) {
        return this.m_session.getProject().getRootNamespace().getAllRelationships(this, other);
    }

    @Override
    public List<Relationship> getRelationships() {
        return this.m_session.getProject().getRootNamespace().getAllRelationships(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EQueryItemsScope {
        kScopeAll,
        kScopeDefaultHierarchyOnly;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EQueryItemsSource {
        kSourceAll,
        kSourceExternalOnly,
        kSourceModelOnly;

    }
}

