/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FilterFolderParentInternal;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmEMDObjectNaming;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimensionBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.HierarchyParentInternal;
import com.ibm.cognos.fmeng.fmmd.impl.model.LevelParentInternal;
import com.ibm.cognos.fmeng.fmmd.impl.model.RelationalDimensionParentInternal;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveListener;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalFilter;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.Relationship;
import com.ibm.cognos.fmeng.fmmd.model.Role;
import com.ibm.cognos.fmeng.fmmd.util.ObjectHelper;
import com.ibm.cognos.fmeng.genmodel.DimensionStyleType;
import com.ibm.cognos.fmeng.genmodel.FilterFolderType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.LevelType;
import com.ibm.cognos.fmeng.genmodel.LevelsType;
import com.ibm.cognos.fmeng.genmodel.MultilingualSupportType;
import com.ibm.cognos.fmeng.genmodel.QueryItemType;
import com.ibm.cognos.fmeng.genmodel.RelationalDimensionType;
import com.ibm.cognos.fmeng.genmodel.RelationalHierarchyType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.dom4j.Element;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmRelationalDimension
extends FmRelationalDimensionBase
implements RelationalDimension,
LevelParentInternal,
HierarchyParentInternal<RelationalHierarchy>,
FilterFolderParentInternal {
    public static FmRelationalDimension get(FMMDSession session, Object emfobj) {
        return new FmRelationalDimension(session, (RelationalDimensionType)emfobj);
    }

    public static String getDefaultName(Locale locale) {
        return FmMessage.render("BMT_MDN_OBJECT_NAME_DIMENSION", locale);
    }

    public static FmRelationalDimension createRelationalDimension(FMMDSession session, RelationalDimensionParentInternal parent, String objectName, DimensionBase.DimensionStyle style) {
        if (objectName == null || objectName.length() == 0) {
            objectName = FmRelationalDimension.getDefaultName(session.getActiveLocale());
        }
        FmMDException.ASSERT(parent != null, "null dimension parrent");
        RelationalDimensionType emfObj = GenmodelFactory.eINSTANCE.createRelationalDimensionType();
        LevelsType emfLevelsObj = GenmodelFactory.eINSTANCE.createLevelsType();
        emfObj.setLevels(emfLevelsObj);
        FmRelationalDimension dim = new FmRelationalDimension(session, emfObj);
        dim.setDimensionStyle(style);
        parent.addDimension(dim);
        String uniqueName = dim.makeUniqueName(objectName);
        String localeKey = FmModelFactory.getInstance().getProject(session).getDefaultLocale();
        dim.setName(localeKey, uniqueName);
        dim.createPhysicalDefintion();
        return dim;
    }

    private FmRelationalDimension(FMMDSession session, RelationalDimensionType emfObject) {
        super(session, emfObject);
    }

    RelationalDimensionType getRelationalDimensionType() {
        return (RelationalDimensionType)this.m_emfObject;
    }

    @Override
    public FmObjectType getFmObjectType() {
        return FmObjectType.relationalDimension;
    }

    @Override
    public FmRelationalHierarchy createHierarchy(String name) {
        EList<RelationalHierarchyType> hiers = this.getRelationalDimensionType().getRelationalHierarchy();
        if (hiers.size() == 1 && ((RelationalHierarchyType)hiers.get(0)).isParentChild()) {
            throw new FmMDException("BMT_MD_NO_CREATE_LEVEL_HIER");
        }
        FmRelationalHierarchy hier = FmRelationalHierarchy.createHierarchy(this.m_session, this, name, false, FmEMDObjectNaming.kMakeUnique);
        return hier;
    }

    @Override
    public FmRelationalHierarchy createParentChildHierarchy(String name) {
        if (this.getRelationalDimensionType().getRelationalHierarchy().size() > 0) {
            throw new FmMDException("BMT_MD_NO_CREATE_PARENT_CHILD_HIER");
        }
        FmRelationalHierarchy hier = FmRelationalHierarchy.createHierarchy(this.m_session, this, name, true, FmEMDObjectNaming.kMakeUnique);
        return hier;
    }

    @Override
    void addChild(Object eObj) {
        switch (this.m_session.getGateway().getClassifierType(eObj)) {
            case 130: {
                this.getRelationalDimensionType().getRelationalHierarchy().add((Object)((RelationalHierarchyType)eObj));
                return;
            }
            case 66: {
                this.getRelationalDimensionType().getLevels().getLevel().add((Object)((LevelType)eObj));
                return;
            }
            case 47: {
                this.getRelationalDimensionType().setFilterFolder((FilterFolderType)eObj);
                return;
            }
        }
        super.addChild(eObj);
    }

    @Override
    public void addHierarchy(RelationalHierarchy hierarchy) {
        this.getRelationalDimensionType().getRelationalHierarchy().add((Object)((FmRelationalHierarchy)hierarchy).getRelationalHierarchyType());
        if (this.getRelationalDimensionType().getRelationalHierarchy().size() == 1) {
            this.setDefaultHierarchy(hierarchy);
        }
    }

    @Override
    public void addLevel(Level level) {
        this.getRelationalDimensionType().getLevels().getLevel().add((Object)((FmLevel)level).getLevelType());
    }

    @Override
    public Level createLevel(String name) {
        FmLevel level = FmLevel.createLevel(this.m_session, this, name);
        return level;
    }

    public Level createLevelFromLevel(Level srcLevel) {
        return FmLevel.createLevelFromLevel(this.m_session, this, srcLevel);
    }

    @Override
    public List<Level> getAllLevels() {
        ArrayList<Level> levels = new ArrayList<Level>();
        EList<RelationalHierarchyType> hiers = this.getRelationalDimensionType().getRelationalHierarchy();
        for (RelationalHierarchyType hier : hiers) {
            if (hier.getLevel() == null) continue;
            levels.add(FmLevel.get(this.m_session, hier.getLevel()));
        }
        for (LevelType level : this.getRelationalDimensionType().getLevels().getLevel()) {
            levels.add(FmLevel.get(this.m_session, level));
        }
        return levels;
    }

    public Level getLastLevel() {
        List<Level> levels = this.getAllLevels();
        if (!levels.isEmpty()) {
            return levels.get(levels.size() - 1);
        }
        return null;
    }

    @Override
    public DimensionBase.DimensionStyle getDimensionStyle() {
        if (this.getRelationalDimensionType().getDimensionStyle() == DimensionStyleType.TIME) {
            return DimensionBase.DimensionStyle.time;
        }
        return DimensionBase.DimensionStyle.regular;
    }

    public boolean isTimeDimension() {
        return this.getRelationalDimensionType().getDimensionStyle() == DimensionStyleType.TIME;
    }

    @Override
    public List<RelationalHierarchy> getAllHierarchies() {
        ArrayList<RelationalHierarchy> hierarchies = new ArrayList<RelationalHierarchy>();
        for (RelationalHierarchyType hier : this.getRelationalDimensionType().getRelationalHierarchy()) {
            hierarchies.add(FmRelationalHierarchy.get(this.m_session, hier));
        }
        return hierarchies;
    }

    @Override
    public RelationalHierarchy getDefaultHierarchy() {
        if (this.getRelationalDimensionType().getDefaultHierarchy() != null) {
            return FmRelationalHierarchy.get(this.m_session, this.getRelationalDimensionType().getDefaultHierarchy());
        }
        return null;
    }

    @Override
    public void setDefaultHierarchy(RelationalHierarchy hier) {
        this.getRelationalDimensionType().setDefaultHierarchy(((FmRelationalHierarchy)hier).getRelationalHierarchyType());
    }

    @Override
    public void setDimensionStyle(DimensionBase.DimensionStyle style) {
        if (style == DimensionBase.DimensionStyle.measure) {
            throw new FmMDException("BMT_MD_DIMENSION_STYLE_MAY_NOT_BE_CHANGED", this.getName());
        }
        if (style == DimensionBase.DimensionStyle.time) {
            this.getRelationalDimensionType().setDimensionStyle(DimensionStyleType.TIME);
        } else {
            this.getRelationalDimensionType().setDimensionStyle(DimensionStyleType.REGULAR);
        }
    }

    @Override
    public void prepareForObjectDeletion(RemoveInfo info, FmBaseObject object, RemoveListener listener) {
        RelationalHierarchy defaultHierarchy;
        super.prepareForObjectDeletion(info, object, listener);
        if (object instanceof FmRelationalHierarchy && (defaultHierarchy = this.getDefaultHierarchy()) != null && defaultHierarchy.equals(object)) {
            for (RelationalHierarchy hierarchy : this.getAllHierarchies()) {
                if (hierarchy.equals(defaultHierarchy)) continue;
                this.setDefaultHierarchy(hierarchy);
                break;
            }
        }
    }

    @Override
    public boolean isRollupDimension() {
        BaseObject parent = this.getParent();
        return parent instanceof Cube && ((Cube)parent).isAggregateCube();
    }

    @Override
    public boolean getParentChild() {
        return this.getRelationalDimensionType().getLevels().getLevel().isEmpty() && this.getRelationalDimensionType().getRelationalHierarchy().size() == 1 && ((RelationalHierarchyType)this.getRelationalDimensionType().getRelationalHierarchy().get(0)).isParentChild();
    }

    @Override
    public RelationalDimension.MultilingualSupport getMultilingualSupport() {
        return RelationalDimension.MultilingualSupport.valueOf(this.getRelationalDimensionType().getMultilingualSupport().toString());
    }

    @Override
    public void setMultilingualSupport(RelationalDimension.MultilingualSupport support) {
        switch (support) {
            case byColumn: {
                this.getRelationalDimensionType().setMultilingualSupport(MultilingualSupportType.BY_COLUMN);
                break;
            }
            case byRow: {
                this.getRelationalDimensionType().setMultilingualSupport(MultilingualSupportType.BY_ROW);
                break;
            }
            default: {
                this.getRelationalDimensionType().setMultilingualSupport(MultilingualSupportType.DISABLED);
            }
        }
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public Element doTestDataQuery(List<QueryItem> projectItems, int maxRows, boolean validateFirst, boolean autosum) {
        if (validateFirst && !this.sanityTest()) {
            throw new FmMDException("BMT_MD_MODEL_ERRORS_QUERYSUBJECT", this.getName());
        }
        return this.executeDataQuery(projectItems, maxRows, autosum);
    }

    @Override
    public List<QueryItem> getLevelKeys() {
        ArrayList<QueryItem> levelKeys = new ArrayList<QueryItem>();
        if (this.getParentChild()) {
            levelKeys.add(this.getDefaultHierarchy().getChildItem());
        } else {
            ArrayList<EObject> uniqueLevelKeys = new ArrayList<EObject>();
            for (LevelType level : this.getRelationalDimensionType().getLevels().getLevel()) {
                if (level.getLevelKeys() == null) continue;
                for (EObject qi : level.getLevelKeys().getRefObj()) {
                    boolean bFound = false;
                    for (EObject currKey : uniqueLevelKeys) {
                        if (!currKey.equals(qi)) continue;
                        bFound = true;
                        break;
                    }
                    if (bFound) continue;
                    uniqueLevelKeys.add(qi);
                }
            }
            for (EObject qi : uniqueLevelKeys) {
                levelKeys.add(FmQueryItem.get(this.m_session, qi));
            }
        }
        return levelKeys;
    }

    @Override
    public List<QueryItem> getSecurableAttributes() {
        QueryItem attr;
        List<QueryItem> securableAttributes = null;
        if (this.getParentChild()) {
            RelationalHierarchyType defaultHier = (RelationalHierarchyType)this.getRelationalDimensionType().getDefaultHierarchy();
            ArrayList<QueryItemType> items = new ArrayList<QueryItemType>();
            items.addAll((Collection<QueryItemType>)defaultHier.getQueryItem());
            for (EObject obj : defaultHier.getMemberKeys().getRefObj()) {
                items.remove(obj);
            }
            for (EObject obj : defaultHier.getParentItems().getRefObj()) {
                items.remove(obj);
            }
            if (items != null) {
                securableAttributes = new ArrayList<QueryItem>();
                for (QueryItemType item : items) {
                    securableAttributes.add(FmQueryItem.get(this.m_session, item));
                }
            }
        } else {
            securableAttributes = this.getAllQueryItems();
            List<QueryItem> levelKeys = this.getLevelKeys();
            Iterator<QueryItem> it = securableAttributes.iterator();
            block3: while (it.hasNext()) {
                attr = it.next();
                for (QueryItem levelKey : levelKeys) {
                    if (!attr.equals(levelKey)) continue;
                    it.remove();
                    continue block3;
                }
            }
        }
        Iterator<QueryItem> it = securableAttributes.iterator();
        while (it.hasNext()) {
            boolean hasCaptionRole = false;
            attr = it.next();
            for (Role someRole : attr.getRoles()) {
                if (!someRole.getDefaultRole().equals((Object)Role.EDefaultRoles.kRoleMemberCaption)) continue;
                hasCaptionRole = true;
                break;
            }
            if (!hasCaptionRole) continue;
            it.remove();
        }
        return securableAttributes;
    }

    @Override
    public void setName(String localeKey, String nameValue) {
        List<Cube> cubes = this.getReferencedInCubes();
        ArrayList<FmBaseObject> cubesReferenced = new ArrayList<FmBaseObject>();
        for (Cube cube : cubes) {
            if (cube.isAggregateCube()) continue;
            List<RelationalDimensionBase> dims = cube.getReferencedDimensions();
            for (RelationalDimensionBase dim : dims) {
                String dimName = dim.getName(localeKey);
                if (dim.getID().equals(this.getID()) || dimName == null || !dimName.equals(nameValue)) continue;
                cubesReferenced.add((FmBaseObject)((Object)cube));
            }
        }
        if (!cubesReferenced.isEmpty()) {
            String referencedCubesMsg = "\r\n" + ObjectHelper.renderObjects(this.m_session, cubesReferenced, 0, false);
            throw new FmMDException("BMT_MD_DIMENSION_CUBE_NAME_CONFLICT", nameValue, referencedCubesMsg);
        }
        super.setName(localeKey, nameValue);
    }

    private List<Cube> getReferencedInCubes() {
        ArrayList<Cube> cubes = new ArrayList<Cube>();
        List<Relationship> relationships = this.m_session.getProject().getRootNamespace().getAllRelationships();
        for (Relationship rel : relationships) {
            if (!rel.getLeftEnd().equals(this) && !rel.getRightEnd().equals(this) || !(rel.getParent() instanceof Cube)) continue;
            cubes.add((Cube)rel.getParent());
        }
        return cubes;
    }

    @Override
    public boolean isShareable() {
        return this.getRelationalDimensionType().isSetSharedDimension();
    }

    @Override
    public void setIsShareable(boolean isSharable) {
        if (isSharable) {
            this.getRelationalDimensionType().setSharedDimension(isSharable);
        } else {
            this.getRelationalDimensionType().unsetSharedDimension();
        }
    }

    @Override
    public boolean isPathBasedMun() {
        return this.getRelationalDimensionType().isSetUsePathBasedMUNs();
    }

    @Override
    public void setIsPathBasedMun(boolean isPathBasedMun) {
        if (isPathBasedMun) {
            this.getRelationalDimensionType().setUsePathBasedMUNs(isPathBasedMun);
        } else {
            this.getRelationalDimensionType().unsetUsePathBasedMUNs();
        }
    }

    @Override
    public String generateUUID(Cube cube) {
        StringBuilder dimXML = new StringBuilder(this.asXML());
        List<RelationalFilter> filters = this.getFilters();
        if (filters.size() > 0 && cube != null) {
            for (RelationalFilter filter : filters) {
                ArrayList<RelationalObject> context = new ArrayList<RelationalObject>();
                context.add(cube.getMeasureDimension());
                context.add(this);
                if (!filter.isInScope(context)) continue;
                dimXML.append(cube.getName());
            }
        }
        UUID uuid = null;
        try {
            uuid = UUID.nameUUIDFromBytes(dimXML.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return uuid.toString();
    }
}

