/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.EObjectSourceType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmExpression;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFilterFolder;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveListener;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.FilterApplication;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalFilter;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.genmodel.ApplyType;
import com.ibm.cognos.fmeng.genmodel.ExpressionType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.RelationalFilterType;
import com.ibm.cognos.fmeng.genmodel.RelationalObjectType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmRelationalFilter
extends FmModelObject
implements RelationalFilter {
    public static RelationalFilter createFilter(FMMDSession session, FmFilterFolder parent, String objectName) {
        if (objectName == null || objectName.length() == 0) {
            objectName = FmRelationalFilter.getDefaultName(session.getActiveLocale());
        }
        RelationalFilterType emfObj = GenmodelFactory.eINSTANCE.createRelationalFilterType();
        FmRelationalFilter filter = new FmRelationalFilter(session, emfObj);
        parent.addFilter(filter);
        String uniqueName = filter.makeUniqueName(objectName);
        filter.setName(uniqueName);
        ExpressionType expressionType = GenmodelFactory.eINSTANCE.createExpressionType();
        emfObj.setExpression(expressionType);
        return filter;
    }

    public static FmRelationalFilter get(FMMDSession session, Object emfobj) {
        return new FmRelationalFilter(session, (RelationalFilterType)emfobj);
    }

    public static String getDefaultName(Locale locale) {
        return FmMessage.render("BMT_MDN_OBJECT_NAME_FILTER", locale);
    }

    private FmRelationalFilter(FMMDSession session, RelationalFilterType emfObject) {
        super(session, emfObject);
    }

    @Override
    public FmObjectType getFmObjectType() {
        return FmObjectType.relationalFilter;
    }

    public FmExpression createDefaultExpression() {
        ExpressionType expressionType = GenmodelFactory.eINSTANCE.createExpressionType();
        this.getFilterType().setExpression(expressionType);
        return new FmExpression((FMMDSession)this.m_session, expressionType);
    }

    @Override
    public Expression setExpression(ExpressionBuilder expression) {
        FmExpression exp = FmExpression.create((FMMDSession)this.m_session, expression);
        this.getFilterType().setExpression(exp.getExpressionType());
        return exp;
    }

    @Override
    public Expression getExpression() {
        ExpressionType exp = this.getFilterType().getExpression();
        if (exp != null) {
            return FmExpression.get((FMMDSession)this.m_session, exp);
        }
        return null;
    }

    protected RelationalFilterType getFilterType() {
        return (RelationalFilterType)this.m_emfObject;
    }

    public EObjectSourceType determineSourceType(HashSet<FmBaseObject> visitedObjs) {
        if (visitedObjs == null) {
            visitedObjs = new HashSet();
        }
        visitedObjs.add(this);
        EObjectSourceType eSourceType = ((FmExpression)this.getExpression()).determineSourceType(visitedObjs);
        return eSourceType;
    }

    @Override
    public void getReferencedObjects(Set<BaseObject> objects) {
        FmExpression exp = (FmExpression)this.getExpression();
        if (exp != null) {
            exp.getReferencedObjects(objects, true);
        }
    }

    @Override
    public void prepareForObjectDeletion(RemoveInfo info, FmBaseObject object, RemoveListener listener) {
        FmExpression exp = (FmExpression)this.getExpression();
        if (exp != null && exp.breakReferencesTo(object)) {
            listener.invalidateObject(this);
        }
    }

    @Override
    public boolean getGenerateKeyFilter() {
        return this.getFilterType().isGenerateKeyFilter();
    }

    @Override
    public void setGenerateKeyFilter(boolean generateKeyFilter) {
        this.getFilterType().setGenerateKeyFilter(generateKeyFilter);
    }

    @Override
    public boolean isInScope(List<RelationalObject> relationalObjects) {
        Expression expr = this.getExpression();
        if (expr != null) {
            for (Object part : expr.getComponents()) {
                if (!(part instanceof QueryItemBase)) continue;
                QueryItemBase qi = (QueryItemBase)part;
                RelationalObject roPart = qi.getRelationalParent();
                if (roPart == null) {
                    return false;
                }
                boolean found = false;
                for (RelationalObject ro : relationalObjects) {
                    if (!ro.equals(roPart)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public RelationalObject getRelationalParent() {
        EObject obj = (EObject)this.m_emfObject;
        while (obj != null) {
            if (obj instanceof RelationalObjectType) {
                return (RelationalObject)FmModelFactory.getInstance().get(this.m_session, obj);
            }
            obj = obj.eContainer();
        }
        FmMDException.ASSERT(false, "Found a relational filter floating by itself...");
        return null;
    }

    @Override
    public FilterApplication.EFilterApplication getFilterApplication() {
        switch (this.getFilterType().getApply()) {
            case ALWAYS: {
                return FilterApplication.EFilterApplication.always;
            }
            case AS_NEEDED: {
                return FilterApplication.EFilterApplication.optional;
            }
            case DESIGN_ONLY: {
                return FilterApplication.EFilterApplication.designOnly;
            }
            case SECURITY: {
                return FilterApplication.EFilterApplication.security;
            }
        }
        FmMDException.ASSERT(false, "Bad filter definition apply value: " + this.getFilterType().getApply().toString());
        return null;
    }

    @Override
    public void setFilterApplication(FilterApplication.EFilterApplication apply) {
        switch (apply) {
            case always: {
                this.getFilterType().setApply(ApplyType.ALWAYS);
                break;
            }
            case optional: {
                this.getFilterType().setApply(ApplyType.AS_NEEDED);
                break;
            }
            case designOnly: {
                this.getFilterType().setApply(ApplyType.DESIGN_ONLY);
                break;
            }
            case security: {
                this.getFilterType().setApply(ApplyType.SECURITY);
                break;
            }
            default: {
                FmMDException.ASSERT(false, "Bad filter definition apply value: " + apply.toString());
            }
        }
    }
}

