/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.helpers.XExecuteCommandHelper;
import com.ibm.cognos.fmeng.fmmd.helpers.XQueryHelper;
import com.ibm.cognos.fmeng.fmmd.helpers.XValidateCommandHelper;
import com.ibm.cognos.fmeng.fmmd.impl.model.EObjectSourceType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FilterFolderParentInternal;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFilterFolder;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPhysicalDefinition;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTaskROLAPtoDMR;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveListener;
import com.ibm.cognos.fmeng.fmmd.impl.task.planner.XAdaptor;
import com.ibm.cognos.fmeng.fmmd.model.Association;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.FilterDefinition;
import com.ibm.cognos.fmeng.fmmd.model.FilterFolder;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.Join;
import com.ibm.cognos.fmeng.fmmd.model.Measure;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalFilter;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.Relationship;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipEnd;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.SQLObject;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.fmmd.model.TaskAnalyseObject;
import com.ibm.cognos.fmeng.fmmd.util.CmHelper;
import com.ibm.cognos.fmeng.fmmd.util.EmfRecurseHelper;
import com.ibm.cognos.fmeng.genmodel.FilterFolderType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.IntentType;
import com.ibm.cognos.fmeng.genmodel.PhysicalDefinitionType;
import com.ibm.cognos.fmeng.genmodel.RelationalObjectType;
import com.ibm.cognos.fmeng.metadata.MdCatalog;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdSchema;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.ProjectFactory;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FmRelationalObject
extends FmReportObject
implements RelationalObject,
FilterFolderParentInternal {
    FmRelationalObject(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    protected RelationalObjectType getRelationalObjectType() {
        return (RelationalObjectType)this.m_emfObject;
    }

    public FmPhysicalDefinition getPhysicalDefinition() {
        PhysicalDefinitionType physDef = this.getRelationalObjectType().getPhysicalDefinition();
        if (physDef != null) {
            return FmPhysicalDefinition.get(this.m_session, physDef);
        }
        return null;
    }

    @Override
    public int compareTo(RelationalObject o) {
        return this.getID().compareTo(o.getID());
    }

    protected void createPhysicalDefintion() {
        PhysicalDefinitionType physDef = GenmodelFactory.eINSTANCE.createPhysicalDefinitionType();
        this.getRelationalObjectType().setPhysicalDefinition(physDef);
    }

    @Override
    public void removeJoin(Join join) {
        this.getPhysicalDefinition().removeJoin(join);
    }

    @Override
    public void removeTable(Table tbl) {
        this.getPhysicalDefinition().removeTable(tbl);
    }

    @Override
    public void removeQueryItemMapping(QueryItemMapping mapping) {
        this.getPhysicalDefinition().removeQueryItemMapping(mapping);
    }

    @Override
    void prepareForObjectDeletion(RemoveInfo info, FmBaseObject object, RemoveListener listener) {
        super.prepareForObjectDeletion(info, object, listener);
        if (object instanceof QueryItemBase) {
            this.m_session.getTaskDimensionBuilder(this).removeQueryItemMapping((QueryItemBase)((Object)object));
        }
    }

    @Override
    public Table findTable(String moniker) {
        return this.getPhysicalDefinition().findTable(moniker);
    }

    @Override
    public Join findJoin(String moniker) {
        return this.getPhysicalDefinition().findJoin(moniker);
    }

    @Override
    public QueryItemMapping findQueryItemMapping(String moniker) {
        return this.getPhysicalDefinition().findMapping(moniker);
    }

    @Override
    public EObjectSourceType determineSourceType() {
        return EObjectSourceType.kRelational;
    }

    @Override
    public List<QueryItem> getAllQueryItems() {
        EmfRecurseHelper allStuff = new EmfRecurseHelper(this.m_session, this.m_emfObject);
        allStuff.addRecurseInto(65);
        allStuff.addRecurseInto(66);
        allStuff.addRecurseInto(130);
        allStuff.addRecurseInto(115);
        return allStuff.collect(119);
    }

    @Override
    public QueryItemBase findQueryItemBase(MdColumn mdColumn) {
        MdTable mdTable = mdColumn.getTable();
        MdSchema mdSchema = mdTable.getSchema();
        MdCatalog mdCatalog = mdSchema.getCatalog();
        DataSource dsOfInterest = null;
        for (DataSource ds : this.m_session.getProject().getDataSources()) {
            if (!ds.getSchemaName().equals(mdSchema.getName())) continue;
            if (mdCatalog == null) {
                if (!ds.getCatalogName().equals("")) continue;
                dsOfInterest = ds;
                break;
            }
            if (!ds.getCatalogName().equals(mdCatalog.getName())) continue;
            dsOfInterest = ds;
            break;
        }
        if (dsOfInterest == null) {
            return null;
        }
        FmPhysicalDefinition physDef = this.getPhysicalDefinition();
        Table tableOfInterest = physDef.findTable(dsOfInterest, mdTable.getName());
        if (tableOfInterest == null) {
            return null;
        }
        for (QueryItemMapping mapping : physDef.getQueryItemMappings(tableOfInterest)) {
            if (!mapping.getColumnName().equals(mdColumn.getName())) continue;
            return mapping.getQueryItem();
        }
        return null;
    }

    @Override
    public QueryItem findQueryItem(MdColumn mdColumn) {
        QueryItemBase obj = this.findQueryItemBase(mdColumn);
        if (obj instanceof QueryItem) {
            return (QueryItem)obj;
        }
        return null;
    }

    @Override
    public Measure findMeasure(MdColumn mdColumn) {
        QueryItemBase obj;
        if (this instanceof MeasureDimension && (obj = this.findQueryItemBase(mdColumn)) instanceof Measure) {
            return (Measure)obj;
        }
        return null;
    }

    @Override
    public Join createJoin(String name, Table left, Table right) {
        return this.getPhysicalDefinition().createJoin(name, left, right);
    }

    @Override
    public QueryItemMapping createQueryItemMapping(QueryItemBase queryItem, String columnName, Table table) {
        return this.getPhysicalDefinition().createQueryItemMapping(queryItem, columnName, table);
    }

    public QueryItemMapping createQueryItemMapping(QueryItemBase queryItem, String columnName, SQLObject sqlObj) {
        return this.getPhysicalDefinition().createQueryItemMapping(queryItem, columnName, sqlObj);
    }

    @Override
    public Table createTable(DataSource ds, String tableName) {
        return this.getPhysicalDefinition().createTable(ds, tableName);
    }

    @Override
    public List<QueryItemBase> findMappedQueryItems(String dataSourceName, String table, String columnName) {
        return this.getPhysicalDefinition().findMappedQueryItems(dataSourceName, table, columnName);
    }

    @Override
    public QueryItemMapping findMapping(QueryItemBase queryItem) {
        return this.getPhysicalDefinition().findMapping(queryItem);
    }

    @Override
    public Table findTable(QueryItem queryItem) {
        return this.getPhysicalDefinition().findTable(queryItem);
    }

    @Override
    public Table findOrCreateTable(MdTable mdTable) {
        DataSource ds = this.getProject().findOrCreateDataSource(mdTable);
        Table table = this.findTable(ds, mdTable.getName());
        if (table == null) {
            table = this.createTable(ds, mdTable.getName());
        }
        return table;
    }

    @Override
    public Table findTable(DataSource dataSource, String tableName) {
        return this.getPhysicalDefinition().findTable(dataSource, tableName);
    }

    @Override
    public List<Join> getJoins() {
        return this.getPhysicalDefinition().getJoins();
    }

    @Override
    public List<QueryItemMapping> getQueryItemMappings() {
        return this.getPhysicalDefinition().getQueryItemMappings();
    }

    @Override
    public List<QueryItemMapping> getQueryItemMappings(Table table) {
        return this.getPhysicalDefinition().getQueryItemMappings(table);
    }

    @Override
    public List<Table> getTables() {
        return this.getPhysicalDefinition().getTables();
    }

    public List<Relationship> getRelationships(RelationalObject other) {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        FmRelationalObject left = this;
        RelationalObject right = other;
        for (Relationship rel : this.getSession().getProject().getRootNamespace().getAllRelationships()) {
            if (rel.getLeftEnd().equals(left) && rel.getRightEnd().equals(right)) {
                relationships.add(rel);
                continue;
            }
            if (!rel.getLeftEnd().equals(right) || !rel.getRightEnd().equals(left)) continue;
            relationships.add(rel);
        }
        return relationships;
    }

    @Override
    public List<Relationship> getRelationships() {
        return this.getSession().getProject().getRootNamespace().getAllRelationships(this);
    }

    @Override
    public List<Relationship> getRelationships(RelationshipEnd other) {
        return this.getSession().getProject().getRootNamespace().getAllRelationships(this, other);
    }

    @Override
    public SQLObject createSQLObject(DataSource ds, String moniker, String sqlStatement) {
        return this.getPhysicalDefinition().createSQLObject(ds, moniker, sqlStatement);
    }

    @Override
    public SQLObject findSQLObject(String moniker) {
        return this.getPhysicalDefinition().findSQLObject(moniker);
    }

    @Override
    public List<SQLObject> getSQLObjects() {
        return this.getPhysicalDefinition().getSQLObjects();
    }

    @Override
    public void removeSQLObject(SQLObject object) {
        this.getPhysicalDefinition().removeSQLObject(object);
    }

    @Override
    public FilterDefinition createFilterDefinition(String name, ExpressionBuilder expression) {
        return this.getPhysicalDefinition().createFilterDefinition(name, expression);
    }

    @Override
    public List<FilterDefinition> getFilterDefinitions() {
        return this.getPhysicalDefinition().getFilterDefinitions();
    }

    @Override
    public void removeFilterDefinition(String displayName) {
        this.getPhysicalDefinition().removeFilterDefinition(displayName);
    }

    @Override
    public List<Table> getBottomTables() {
        return this.getPhysicalDefinition().getBottomTables();
    }

    @Override
    public List<Table> getCommonTables(RelationalObject right) {
        return this.getPhysicalDefinition().getCommonTables(right);
    }

    protected Element executeDataQuery(List<QueryItem> projectItems, int maxRows, boolean autosum) {
        CmHelper helper = CmHelper.get(this.m_session, this.m_session.getPassport());
        helper.validatePassport();
        HashMap<Object, String> idMap = new HashMap<Object, String>();
        QuerySubjectBase generatedQuerySubject = this.generateFmQuerySubjectTempSession(idMap, projectItems == null || projectItems.isEmpty());
        if (generatedQuerySubject == null) {
            return null;
        }
        XExecuteCommandHelper hlprExecuteCmd = new XExecuteCommandHelper(generatedQuerySubject.getSession());
        hlprExecuteCmd.addQueryFeedback(XExecuteCommandHelper.EQueryFeedback.nativeCommandText);
        hlprExecuteCmd.addQueryFeedback(XExecuteCommandHelper.EQueryFeedback.CognosCommandText);
        hlprExecuteCmd.addQueryFeedback(XExecuteCommandHelper.EQueryFeedback.columnList);
        XQueryHelper pHlprQuery = hlprExecuteCmd.addQuery("fmQuery");
        pHlprQuery.setAutoSummary(autosum);
        pHlprQuery.addHint(XQueryHelper.EQueryHint.measureRefiner, "disabled");
        HashSet<String> projectedSet = new HashSet<String>();
        if (projectItems != null && !projectItems.isEmpty()) {
            for (QueryItem qi : projectItems) {
                projectedSet.add(qi.getName());
            }
        }
        for (QueryItem obj : generatedQuerySubject.getAllQueryItems()) {
            if (obj.getDatatype() == FmDatatype.BLOB || obj.getDatatype() == FmDatatype.BLOBARRAY) continue;
            String qItemName = obj.getName();
            if (!projectedSet.isEmpty() && !projectedSet.contains(qItemName)) continue;
            String id = obj.getID();
            pHlprQuery.addDataItem(qItemName, id);
        }
        Element inElement = hlprExecuteCmd.make();
        if (maxRows <= 0) {
            XValidateCommandHelper hlprValidateCmd = new XValidateCommandHelper(inElement);
            inElement = hlprValidateCmd.make();
        }
        Element outElement = null;
        try {
            FMMDSession session = generatedQuerySubject.getSession();
            session.setProgressCallbackHandler(this.m_session.getProgressCallbackHandler());
            XAdaptor myAdaptor = XAdaptor.create(session, false, false);
            outElement = myAdaptor.doQsApiRequest(inElement, maxRows);
        }
        catch (Exception e) {
            generatedQuerySubject.getSession().destroy();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
        if (maxRows <= 0) {
            XValidateCommandHelper.checkReponse(outElement);
        }
        return outElement;
    }

    public QuerySubjectBase generateFmQuerySubjectTempSession(HashMap<Object, String> idMap, boolean matchQueryItemsWithColumnNames) {
        FMMDSession newSession = FMMDSession.createFMMDSession(this.getSession());
        newSession.create(ProjectFactory.createInMemoryProject());
        newSession.setPassport(this.getSession().getPassport());
        FmTaskROLAPtoDMR taskROLAPtoDMR = (FmTaskROLAPtoDMR)newSession.getTaskROLAPtoDMR();
        taskROLAPtoDMR.convertFromDimensionForROLAP(newSession, this, idMap);
        QuerySubjectBase qs = (QuerySubjectBase)newSession.findById(idMap.get(this.getInternal()));
        if (matchQueryItemsWithColumnNames) {
            List<QueryItem> qiList = qs.getAllQueryItems();
            for (QueryItem qi : qiList) {
                String externalName;
                List<ReportObject> objs = qi.getExpression().getRefObjs(false);
                if (objs.size() != 1 || (externalName = ((QueryItem)objs.get(0)).getExternalName()) == null || externalName.isEmpty()) continue;
                qi.setName(qi.getSession().getActiveLocale().toString(), externalName);
            }
        }
        return qs;
    }

    protected boolean sanityTest() {
        TaskAnalyseObject anal = this.getSession().getTaskAnalyseObject();
        ArrayList<FeedbackMessage> messages = new ArrayList<FeedbackMessage>();
        anal.analyseObject(this, TaskAnalyseObject.AnalysisContext.publish, messages, true);
        for (FeedbackMessage msg : messages) {
            if (msg.getSeverity() != FeedbackMessage.FeedbackSeverity.ERROR) continue;
            return false;
        }
        return true;
    }

    @Override
    public String generateSQL() {
        QueryItemMapping queryMapping;
        QueryItem queryItem;
        StringBuilder sql = new StringBuilder();
        sql.append("select \n");
        LinkedHashMap<String, String> tableMap = new LinkedHashMap<String, String>();
        List<QueryItem> queryItemList = this.getAllQueryItems();
        List<Table> tables = this.getTables();
        int i = 0;
        while (i < tables.size()) {
            String tableAlias = "T" + String.valueOf(i + 1);
            tableMap.put(tables.get(i).getName(), tableAlias);
            ++i;
        }
        HashSet<String> allColumnNames = new HashSet<String>();
        HashSet<String> dupColumnNames = new HashSet<String>();
        int qi = 0;
        while (qi < queryItemList.size()) {
            queryItem = queryItemList.get(qi);
            queryMapping = this.findMapping(queryItem);
            if (queryMapping != null) {
                String columnName = queryMapping.getColumnName();
                if (allColumnNames.contains(columnName)) {
                    dupColumnNames.add(columnName);
                } else {
                    allColumnNames.add(columnName);
                }
            }
            ++qi;
        }
        qi = 0;
        while (qi < queryItemList.size()) {
            queryItem = queryItemList.get(qi);
            queryMapping = this.findMapping(queryItem);
            if (queryMapping != null) {
                Table mappingTable = queryMapping.getTable();
                sql.append("\t");
                String tableAlias = (String)tableMap.get(mappingTable.getName());
                String columnName = queryMapping.getColumnName();
                sql.append(String.valueOf(tableAlias) + ".");
                sql.append("\"" + columnName + "\"");
                if (dupColumnNames.contains(columnName)) {
                    sql.append(" as \"" + mappingTable.getName() + "__" + columnName + "\"");
                } else {
                    sql.append(" as \"" + columnName + "\"");
                }
                if (qi + 1 < queryItemList.size()) {
                    sql.append(",");
                }
                sql.append("\n");
            }
            ++qi;
        }
        sql.append("from\n");
        int i2 = 0;
        while (i2 < tables.size()) {
            Table t = tables.get(i2);
            MdTable mt = t.getPhysicalTable(true);
            if (mt != null) {
                MdSchema schema = mt.getSchema();
                sql.append("\t");
                MdCatalog cat = schema.getCatalog();
                if (cat != null && cat.getName() != null && !"".equals(cat.getName())) {
                    sql.append("\"" + cat.getName() + "\"");
                    sql.append(".");
                }
                if (schema != null && schema.getName() != null && !"".equals(schema.getName())) {
                    sql.append("\"" + schema.getName() + "\"");
                    sql.append(".");
                }
            }
            sql.append("\"" + t.getName() + "\"");
            sql.append("  " + (String)tableMap.get(t.getName()));
            if (i2 + 1 < tables.size()) {
                sql.append(",");
            }
            sql.append("\n");
            ++i2;
        }
        List<Join> joins = this.getJoins();
        if (joins.size() > 0) {
            sql.append("where\n");
            int ji = 0;
            while (ji < joins.size()) {
                Join join = joins.get(ji);
                List<Association> asses = join.getAssociations();
                int ai = 0;
                while (ai < asses.size()) {
                    sql.append("\t(");
                    sql.append("\"" + (String)tableMap.get(join.getLeftTable().getName()) + "\"");
                    sql.append(".\"" + asses.get(ai).getLeftColumn() + "\"");
                    sql.append(" " + FmRelationalObject.getOperator(asses.get(ai).getOperator()) + " ");
                    sql.append("\"" + (String)tableMap.get(join.getRightTable().getName()) + "\"");
                    sql.append(".\"" + asses.get(ai).getRightColumn() + "\"");
                    sql.append(")");
                    if (ai + 1 < asses.size()) {
                        sql.append(" and\n");
                    }
                    ++ai;
                }
                if (ji + 1 < joins.size()) {
                    sql.append(" and\n");
                }
                ++ji;
            }
        }
        return sql.toString();
    }

    @Override
    public String generateV5SQL() {
        if (this.getAllQueryItems().size() == 0) {
            return "";
        }
        Element resultElement = this.doTestDataQuery(null, 0, true, false);
        if (resultElement == null) {
            return "";
        }
        DataSource ds = null;
        List<SQLObject> sqlObjs = this.getSQLObjects();
        if (sqlObjs.size() > 0) {
            ds = sqlObjs.get(0).getDataSource();
        } else {
            List<Table> tables = this.getTables();
            if (tables.size() > 0) {
                ds = tables.get(0).getDataSource();
            }
        }
        String sql = "";
        if (ds != null) {
            sql = this.getSql(resultElement, ds);
        }
        return sql;
    }

    private String getSql(Element results, DataSource ds) {
        String sql = "";
        Element sqlElement = (Element)DocumentHelper.createXPath((String)"//property[@name='CognosCommandText']").selectSingleNode((Object)results.getDocument());
        if (sqlElement != null) {
            sql = sqlElement.getText();
        }
        return sql;
    }

    public static String getOperator(Association.EOperator operator) {
        switch (operator) {
            case equals: {
                return "=";
            }
            case notEquals: {
                return "!=";
            }
            case lessThan: {
                return "<";
            }
            case greaterThan: {
                return ">";
            }
            case lessThanOrEquals: {
                return "<=";
            }
            case greaterThanOrEquals: {
                return ">=";
            }
        }
        return "";
    }

    private FmFilterFolder createOrGetFilterFolder() {
        FilterFolderType folder = this.getRelationalObjectType().getFilterFolder();
        if (folder == null) {
            String name = FmMessage.render("BMT_MDN_ROOT_FILTER_FOLDER", this.m_session.getActiveLocale());
            return FmFilterFolder.create(this.m_session, this, name);
        }
        return FmFilterFolder.get(this.m_session, folder);
    }

    @Override
    public RelationalFilter createFilter(String name) {
        FmFilterFolder filterFolder = this.createOrGetFilterFolder();
        return filterFolder.createFilter(name);
    }

    @Override
    public List<RelationalFilter> getAllFilters() {
        FilterFolderType folder = this.getRelationalObjectType().getFilterFolder();
        if (folder == null) {
            return new ArrayList<RelationalFilter>(0);
        }
        return this.createOrGetFilterFolder().getAllFilters();
    }

    @Override
    public void addFilterFolder(FmFilterFolder filterFolder) {
        this.getRelationalObjectType().setFilterFolder((FilterFolderType)filterFolder.getInternal());
    }

    public FilterFolder getFilterFolder() {
        FilterFolderType folder = this.getRelationalObjectType().getFilterFolder();
        if (folder == null) {
            return null;
        }
        return this.createOrGetFilterFolder();
    }

    @Override
    public List<RelationalFilter> getFilters() {
        FilterFolderType folder = this.getRelationalObjectType().getFilterFolder();
        if (folder == null) {
            return new ArrayList<RelationalFilter>(0);
        }
        return this.createOrGetFilterFolder().getFilters();
    }

    @Override
    public FmCube getCube() {
        Object cube = this.m_session.getGateway().getAncestorOfType(this.getInternal(), 28);
        if (cube != null) {
            return (FmCube)FmModelFactory.getInstance().get(this.m_session, cube);
        }
        return null;
    }

    public List<QueryItemMapping> getQueryItemMappings(List<QueryItemBase> items) {
        return this.getPhysicalDefinition().getQueryItemMappings(items);
    }

    public List<Join> getJoins(Table table) {
        return this.getPhysicalDefinition().getJoins(table);
    }

    @Override
    public void getReferencedObjects(Set<BaseObject> set) {
        List<Table> tables = this.getPhysicalDefinition().getTables();
        for (Table table : tables) {
            set.add(table.getDataSource());
        }
        super.getReferencedObjects(set);
    }

    @Override
    public RelationalObject.Intent getIntent() {
        switch (this.getRelationalObjectType().getIntent()) {
            case DYNAMIC_CUBES: {
                return RelationalObject.Intent.dynamicCubes;
            }
            case RELATIONAL: {
                return RelationalObject.Intent.relational;
            }
        }
        FmMDException.ASSERT(false, "Invalid target type: " + this.getRelationalObjectType().getIntent().toString());
        return null;
    }

    @Override
    public void setIntent(RelationalObject.Intent target) {
        switch (target) {
            case dynamicCubes: {
                this.getRelationalObjectType().setIntent(IntentType.DYNAMIC_CUBES);
                break;
            }
            case relational: {
                this.getRelationalObjectType().setIntent(IntentType.RELATIONAL);
            }
        }
    }

    @Override
    public void updateObject(DataSource ds) {
        this.getPhysicalDefinition().updateObject(ds);
    }
}

