/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmColumnReference;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmExpression;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevelReference;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationshipBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmScope;
import com.ibm.cognos.fmeng.fmmd.impl.model.RelationshipParentInternal;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveListener;
import com.ibm.cognos.fmeng.fmmd.impl.task.planner.XAdaptor;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Cardinality;
import com.ibm.cognos.fmeng.fmmd.model.ColumnReference;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.LevelReference;
import com.ibm.cognos.fmeng.fmmd.model.Measure;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.Relationship;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipEnd;
import com.ibm.cognos.fmeng.fmmd.model.Scope;
import com.ibm.cognos.fmeng.fmmd.model.Status;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.fmmd.util.FmJoinHelper;
import com.ibm.cognos.fmeng.fmmd.util.JoinBase;
import com.ibm.cognos.fmeng.genmodel.CardinalityType;
import com.ibm.cognos.fmeng.genmodel.ExpressionType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.JoinFilterTypeType;
import com.ibm.cognos.fmeng.genmodel.MeasureScopeType;
import com.ibm.cognos.fmeng.genmodel.QuerySubjectBaseType;
import com.ibm.cognos.fmeng.genmodel.RefobjViaShortcutType;
import com.ibm.cognos.fmeng.genmodel.RelationshipType;
import com.ibm.cognos.fmeng.genmodel.ScopeType;
import com.ibm.cognos.fmeng.genmodel.StatusType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.platform.impl.UnresolvedReference;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmRelationship
extends FmRelationshipBase
implements Status,
Relationship,
JoinBase<FmQuerySubjectBase, FmRelationship>,
Comparable<FmRelationship> {
    public static FmRelationship createRelationship(FMMDSession session, ExpressionBuilder expr, RelationshipEnd left, RelationshipEnd right) {
        return FmRelationship.createRelationship(session, null, null, expr, left, right);
    }

    public static FmRelationship createRelationship(FMMDSession session, RelationshipParentInternal suggestedParent, String relName, ExpressionBuilder expr, RelationshipEnd left, RelationshipEnd right) {
        if (relName == null) {
            relName = FmRelationship.getDefaultName(session, left, right);
        }
        if (!(suggestedParent instanceof FmCube || left == null && right == null)) {
            suggestedParent = FmRelationship.determineContainership((EMFSession)session, (FmBaseObject)((Object)left), (FmBaseObject)((Object)right));
        }
        RelationshipType emfObj = GenmodelFactory.eINSTANCE.createRelationshipType();
        FmRelationship rel = new FmRelationship(session, emfObj);
        suggestedParent.addRelationship(rel);
        String uniqueName = rel.makeUniqueName(relName);
        rel.getRelationshipType().setName(uniqueName);
        rel.init(left, right, expr);
        return rel;
    }

    public static FmRelationship get(FMMDSession session, Object emfobj) {
        return new FmRelationship(session, (RelationshipType)emfobj);
    }

    private FmRelationship(FMMDSession session, RelationshipType emfObject) {
        super(session, emfObject);
    }

    @Override
    public FmObjectType getFmObjectType() {
        return FmObjectType.relationship;
    }

    public RelationshipType getRelationshipType() {
        return (RelationshipType)this.m_emfObject;
    }

    @Override
    public Status.EStatus getStatus() {
        return Status.EStatus.valueOf(this.getRelationshipType().getStatus().toString());
    }

    @Override
    public void setStatus(Status.EStatus eStatus) {
        this.getRelationshipType().setStatus(StatusType.get(eStatus.toString()));
    }

    @Override
    public RelationshipEnd getLeftEnd() {
        EObject eobj = this.getRelationshipType().getLeft().getRefobj();
        if (!(eobj instanceof UnresolvedReference) && eobj != null) {
            return (RelationshipEnd)FmModelFactory.getInstance().get(this.m_session, eobj);
        }
        return null;
    }

    private void setLeftEnd(RelationshipEnd leftEnd, boolean updateContainership) {
        if (leftEnd != null) {
            this.getRelationshipType().getLeft().setRefobj((EObject)leftEnd.getInternal());
        } else {
            this.getRelationshipType().getLeft().setRefobj(this.m_session.getNullObject());
        }
        if (updateContainership) {
            this.updateContainership();
        }
    }

    @Override
    public void setLeftEnd(RelationshipEnd leftEnd) {
        this.setLeftEnd(leftEnd, true);
    }

    @Override
    public RelationshipEnd getRightEnd() {
        EObject eobj = this.getRelationshipType().getRight().getRefobj();
        if (!(eobj instanceof UnresolvedReference) && eobj != null) {
            return (RelationshipEnd)FmModelFactory.getInstance().get(this.m_session, eobj);
        }
        return null;
    }

    private void setRightEnd(RelationshipEnd rightEnd, boolean updateContainership) {
        if (rightEnd != null) {
            this.getRelationshipType().getRight().setRefobj((EObject)rightEnd.getInternal());
        } else {
            this.getRelationshipType().getRight().setRefobj(this.m_session.getNullObject());
        }
        if (updateContainership) {
            this.updateContainership();
        }
    }

    @Override
    public void setRightEnd(RelationshipEnd rightEnd) {
        this.setRightEnd(rightEnd, true);
    }

    @Override
    public Cardinality.ECardinality getLeftMincard() {
        return this.getCardinalityType(this.getRelationshipType().getLeft().getMincard());
    }

    @Override
    public void setLeftMincard(Cardinality.ECardinality leftMincard) {
        this.setMinCardinalityType(leftMincard, this.getRelationshipType().getLeft());
    }

    @Override
    public Cardinality.ECardinality getRightMincard() {
        return this.getCardinalityType(this.getRelationshipType().getRight().getMincard());
    }

    @Override
    public void setRightMincard(Cardinality.ECardinality rightMincard) {
        this.setMinCardinalityType(rightMincard, this.getRelationshipType().getRight());
    }

    @Override
    public Cardinality.ECardinality getLeftMaxcard() {
        return this.getCardinalityType(this.getRelationshipType().getLeft().getMaxcard());
    }

    @Override
    public void setLeftMaxcard(Cardinality.ECardinality leftMaxcard) {
        this.setMaxCardinalityType(leftMaxcard, this.getRelationshipType().getLeft());
    }

    @Override
    public Cardinality.ECardinality getRightMaxcard() {
        return this.getCardinalityType(this.getRelationshipType().getRight().getMaxcard());
    }

    @Override
    public void setRightMaxcard(Cardinality.ECardinality rightMaxcard) {
        this.setMaxCardinalityType(rightMaxcard, this.getRelationshipType().getRight());
    }

    @Override
    public Expression getExpression() {
        return new FmExpression((FMMDSession)this.m_session, this.getRelationshipType().getExpression());
    }

    @Override
    public Expression setExpression(ExpressionBuilder expression) {
        if (expression != null) {
            FmExpression fmExp = FmExpression.create((FMMDSession)this.m_session, expression);
            this.getRelationshipType().setExpression(fmExp.getExpressionType());
            return fmExp;
        }
        ExpressionType dummyExpressionType = GenmodelFactory.eINSTANCE.createExpressionType();
        this.getRelationshipType().setExpression(dummyExpressionType);
        return null;
    }

    private static String getDefaultName(FMMDSession session, RelationshipEnd left, RelationshipEnd right) {
        String relName = null;
        String localeKey = FmModelFactory.getInstance().getProject(session).getDefaultLocale();
        if (left == null || right == null) {
            return FmMessage.render("BMT_MDN_OBJECT_NAME_RELATIONSHIP", localeKey);
        }
        String leftName = ((FmReportObject)((Object)left)).getName(localeKey);
        String rightName = ((FmReportObject)((Object)right)).getName(localeKey);
        relName = leftName;
        relName = String.valueOf(relName) + " <--> ";
        relName = String.valueOf(relName) + rightName;
        return relName;
    }

    private void init(RelationshipEnd left, RelationshipEnd right, ExpressionBuilder expr) {
        this.getRelationshipType().setLeft(GenmodelFactory.eINSTANCE.createCardinalityType());
        this.getRelationshipType().setRight(GenmodelFactory.eINSTANCE.createCardinalityType());
        this.setLeftEnd(left, false);
        this.setRightEnd(right, false);
        if (this.getLeftEnd() instanceof MeasureDimension) {
            this.setLeftMincard(Cardinality.ECardinality.one);
            this.setLeftMaxcard(Cardinality.ECardinality.many);
            this.setRightMincard(Cardinality.ECardinality.one);
            this.setRightMaxcard(Cardinality.ECardinality.one);
        } else {
            this.setLeftMincard(Cardinality.ECardinality.one);
            this.setLeftMaxcard(Cardinality.ECardinality.one);
            this.setRightMincard(Cardinality.ECardinality.one);
            this.setRightMaxcard(Cardinality.ECardinality.many);
        }
        this.setExpression(expr);
    }

    public static String getDefaultName(Locale locale) {
        return FmMessage.render("BMT_MDN_OBJECT_NAME_RELATIONSHIP", locale);
    }

    @Override
    public void updateContainership() {
        RelationshipParentInternal newParent = this.determineContainership();
        if (newParent != null) {
            newParent.addRelationship(this);
        }
    }

    @Override
    public void prepareForObjectDeletion(RemoveInfo info, FmBaseObject object, RemoveListener listener) {
        CardinalityType right;
        boolean deleteThis = false;
        CardinalityType left = this.getRelationshipType().getLeft();
        if (left.getRefobj() != null && left.getRefobj().equals(object.getInternal())) {
            deleteThis = true;
        }
        if ((right = this.getRelationshipType().getRight()).getRefobj() != null && right.getRefobj().equals(object.getInternal())) {
            deleteThis = true;
        }
        ExpressionType x = this.getRelationshipType().getExpression();
        boolean invalidated = this.m_session.breakObjectReferences(object, (List<EObject>)x.getRefobj());
        EList<RefobjViaShortcutType> refViaShortcut = x.getRefobjViaShortcut();
        for (RefobjViaShortcutType rs : refViaShortcut) {
            boolean invalidRefObj = this.m_session.breakObjectReferences(object, (List<EObject>)rs.getRefobj());
            if (!invalidRefObj) continue;
            invalidated = true;
        }
        if (deleteThis) {
            this.getFmProject().prepareForObjectDeletion(info, this, listener);
            listener.impactedObjectForDeletion(this);
            this.m_session.getGateway().delete(this.getInternal());
            return;
        }
        if (invalidated) {
            listener.invalidateObject(this);
        } else {
            Scope scope2;
            if ((object instanceof FmLevelReference || object instanceof FmLevel) && (scope2 = this.getScopeIfitAlreadyExists(object)) != null) {
                this.removeScope(scope2);
            }
            if (object instanceof FmMeasure) {
                for (Scope scope2 : this.getScopes()) {
                    scope2.removeMeasureScope((Measure)((Object)object));
                }
            }
        }
    }

    @Override
    public void getReferencedObjects(Set<BaseObject> objects) {
        ExpressionType et;
        CardinalityType right;
        CardinalityType left = this.getRelationshipType().getLeft();
        if (left != null && left.getRefobj() != null) {
            objects.add(FmModelFactory.getInstance().get(this.m_session, left.getRefobj()));
        }
        if ((right = this.getRelationshipType().getRight()) != null && right.getRefobj() != null) {
            objects.add(FmModelFactory.getInstance().get(this.m_session, right.getRefobj()));
        }
        if ((et = this.getRelationshipType().getExpression()) != null) {
            FmExpression expr = FmExpression.get((FMMDSession)this.m_session, et);
            objects.addAll(expr.getRawRefObjs(true));
        }
    }

    public void doEvaluate() {
        boolean validateOnly = true;
        XAdaptor myAdaptor = XAdaptor.create(this.m_session, validateOnly, false);
        myAdaptor.planRelationship(this);
    }

    @Override
    public FmQuerySubjectBase getLeft() {
        TopLevelObject top;
        EObject eobj = this.getRelationshipType().getLeft().getRefobj();
        if (!(eobj instanceof UnresolvedReference) && eobj != null && (top = FmModelFactory.getInstance().get(this.m_session, eobj)) instanceof FmQuerySubjectBase) {
            return (FmQuerySubjectBase)top;
        }
        return null;
    }

    @Override
    public FmQuerySubjectBase getRight() {
        TopLevelObject top;
        EObject eobj = this.getRelationshipType().getRight().getRefobj();
        if (!(eobj instanceof UnresolvedReference) && eobj != null && (top = FmModelFactory.getInstance().get(this.m_session, eobj)) instanceof FmQuerySubjectBase) {
            return (FmQuerySubjectBase)top;
        }
        return null;
    }

    public static String xmlPrettyPrint(String xml) {
        try {
            String dummyRoot = "PrettyPrintDummyRoot";
            String dummyXml = "<" + dummyRoot + ">" + xml.trim() + "</" + dummyRoot + ">";
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setSuppressDeclaration(true);
            Document document = DocumentHelper.parseText((String)dummyXml);
            StringWriter sw = new StringWriter();
            XMLWriter writer = new XMLWriter((Writer)sw, format);
            for (Object e : document.selectNodes("/" + dummyRoot + "/node()")) {
                writer.write((Node)e);
            }
            return sw.toString().trim();
        }
        catch (DocumentException e) {
            throw new RuntimeException("Error pretty printing xml:\n" + xml, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error pretty printing xml:\n" + xml, e);
        }
    }

    @Override
    public String toString() {
        String foo = this.getName();
        foo = String.valueOf(foo) + "\n\t";
        foo = String.valueOf(foo) + (this.getLeftEnd() == null ? "null" : this.getLeftEnd().getName());
        foo = String.valueOf(foo) + " <---> ";
        foo = String.valueOf(foo) + (this.getRightEnd() == null ? "null" : this.getRightEnd().getName());
        foo = String.valueOf(foo) + "\nExpression:\n";
        foo = String.valueOf(foo) + FmRelationship.xmlPrettyPrint(this.getExpression().getExpressionText());
        foo = String.valueOf(foo) + "\nleftMin: " + this.getLeftMincard().toString() + ", leftMax: " + this.getLeftMaxcard().toString() + ", rightMin: " + this.getRightMincard().toString() + ", rightMax: " + this.getRightMaxcard().toString();
        return foo;
    }

    @Override
    public int compareTo(FmRelationship o) {
        int ret = this.getRelationshipType().getName().compareTo(o.getRelationshipType().getName());
        if (ret != 0) {
            return ret;
        }
        return this.getParentNamespace().getName().compareTo(o.getParentNamespace().getName());
    }

    @Override
    public FmQuerySubjectBase getEnd() {
        if (this.getStartPrivate().equals(this.getRelationshipType().getLeft().getRefobj())) {
            return this.getRight();
        }
        return this.getLeft();
    }

    private QuerySubjectBaseType getStartPrivate() {
        if (FmJoinHelper.isStart(this.getLeftMaxcard(), this.getRightMaxcard())) {
            return (QuerySubjectBaseType)this.getRelationshipType().getLeft().getRefobj();
        }
        if (FmJoinHelper.isStart(this.getRightMaxcard(), this.getLeftMaxcard())) {
            return (QuerySubjectBaseType)this.getRelationshipType().getRight().getRefobj();
        }
        return (QuerySubjectBaseType)this.getRelationshipType().getLeft().getRefobj();
    }

    @Override
    public FmQuerySubjectBase getStart() {
        if (this.getStartPrivate().equals(this.getRelationshipType().getLeft().getRefobj())) {
            return this.getLeft();
        }
        return this.getRight();
    }

    @Override
    public boolean equals(FmRelationship right) {
        return this.getID().equals(right.getID());
    }

    @Override
    public FmQuerySubjectBase getOtherSide(FmQuerySubjectBase table) {
        return new FmJoinHelper<FmQuerySubjectBase, FmRelationship>().getOtherSide(this, table);
    }

    @Override
    public FmRelationalObject getOtherSide(FmRelationalObject table) {
        if (!(this.getLeftEnd() instanceof FmRelationalObject) || !(this.getRightEnd() instanceof FmRelationalObject)) {
            return null;
        }
        if (this.getLeftEnd().equals(table)) {
            return (FmRelationalObject)this.getRightEnd();
        }
        if (this.getRightEnd().equals(table)) {
            return (FmRelationalObject)this.getLeftEnd();
        }
        return null;
    }

    @Override
    public boolean isSelfJoin(boolean considerImplementation) {
        if (considerImplementation) {
            if (this.getLeftEnd() instanceof FmRelationalObject && this.getRightEnd() instanceof FmRelationalObject) {
                FmRelationalObject leftRO = (FmRelationalObject)this.getLeftEnd();
                FmRelationalObject rightRO = (FmRelationalObject)this.getRightEnd();
                ArrayList<TableRef> tables = new ArrayList<TableRef>();
                List<Object> comps = this.getExpression().getComponents();
                boolean hasObjects = false;
                for (Object comp : comps) {
                    if (comp instanceof FmQueryItemBase) {
                        QueryItemMapping mapping;
                        hasObjects = true;
                        FmQueryItemBase qi = (FmQueryItemBase)comp;
                        RelationalObject ro = qi.getRelationalParent();
                        if (ro == null || (mapping = ro.findMapping(qi)) == null) continue;
                        tables.add(new TableRef(mapping.getTable()));
                        continue;
                    }
                    if (!(comp instanceof FmColumnReference)) continue;
                    hasObjects = true;
                    FmColumnReference columnRef = (FmColumnReference)comp;
                    tables.add(new TableRef(columnRef));
                }
                if (tables.size() == 1) {
                    return true;
                }
                if (tables.size() > 1) {
                    int i = 0;
                    while (i < tables.size() - 1) {
                        int j = i + 1;
                        while (j < tables.size()) {
                            if (!((TableRef)tables.get(i)).equals((TableRef)tables.get(j))) {
                                return false;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    return true;
                }
                if (!hasObjects && leftRO.getCommonTables(rightRO).size() > 0) {
                    return true;
                }
            } else {
                FmMDException.ASSERT(false, "isSelfJoin(boolean) not implemented for non-relational-objects.");
            }
            return false;
        }
        return this.isSelfJoin();
    }

    @Override
    public boolean getDimensionJoinsOnLowestLevel() {
        return this.getRelationshipType().isDimensionJoinsOnLowestLevel();
    }

    @Override
    public void setDimensionJoinsOnLowestLevel(boolean joinsOnLowestLevel) {
        this.getRelationshipType().setDimensionJoinsOnLowestLevel(joinsOnLowestLevel);
    }

    @Override
    public Scope createScope(RelationalHierarchy rHierar, Measure measure, Level level, boolean excluded) {
        Scope scope = null;
        this.removeMeasureScope(rHierar, measure);
        if (level.isAllLevel() && level.getParent().equals(rHierar)) {
            scope = this.findAndUpdateOrCreateScope(level, measure, excluded);
        }
        return scope;
    }

    @Override
    public Scope createScope(RelationalHierarchy rHierar, Measure measure, LevelReference level, boolean excluded) {
        Scope scope = null;
        this.removeMeasureScope(rHierar, measure);
        if (!level.getLevel().equals(rHierar.getLastLevelReference().getLevel())) {
            scope = this.findAndUpdateOrCreateScope(level, measure, excluded);
        }
        return scope;
    }

    private Scope findAndUpdateOrCreateScope(BaseObject level, Measure measure, boolean excluded) {
        Scope scope = this.getScopeIfitAlreadyExists(level);
        if (scope == null) {
            scope = FmScope.createScope(this.m_session, level, measure, excluded, this);
        } else {
            scope.createMeasureScope(measure, excluded);
            this.updateScope(scope);
        }
        return scope;
    }

    @Override
    public void removeScope(RelationalHierarchy rHierar, Measure measure, boolean excluded) {
        this.removeMeasureScope(rHierar, measure);
        Scope s = this.getScopeIfitAlreadyExists(rHierar);
        if (s == null) {
            s = FmScope.createScope(this.m_session, rHierar, measure, excluded, this);
        } else {
            s.createMeasureScope(measure, excluded);
            this.updateScope(s);
        }
    }

    @Override
    public void addScope(Scope scope) {
        EList<ScopeType> scopeTypes = this.getRelationshipType().getScope();
        scopeTypes.add(((FmScope)scope).getScope());
    }

    @Override
    public Scope getScopeIfitAlreadyExists(BaseObject levelOrHierarchy) {
        EList<ScopeType> scopes = this.getRelationshipType().getScope();
        for (ScopeType includedScope : scopes) {
            if (includedScope.getLevelRef() == null || !includedScope.getLevelRef().equals(levelOrHierarchy.getInternal())) continue;
            return FmScope.get(this.m_session, includedScope);
        }
        return null;
    }

    @Override
    public void removeScope(Scope scope) {
        EList<ScopeType> scopeTypes = this.getRelationshipType().getScope();
        scopeTypes.remove(((FmScope)scope).getScope());
    }

    @Override
    public void removeMeasureScope(RelationalHierarchy rHierar, Measure m) {
        EList<ScopeType> scopeTypes = this.getRelationshipType().getScope();
        int x = 0;
        while (x < scopeTypes.size()) {
            ScopeType st = (ScopeType)scopeTypes.get(x);
            EList<MeasureScopeType> measureScopes = st.getMeasureScope();
            int y = 0;
            while (y < measureScopes.size()) {
                MeasureScopeType mst = (MeasureScopeType)measureScopes.get(y);
                if (mst.getRefobj().equals(m.getInternal())) {
                    if (mst.isExcluded()) {
                        if (st.getLevelRef().equals(rHierar.getInternal())) {
                            scopeTypes.remove(x);
                            return;
                        }
                    } else {
                        TopLevelObject lRef;
                        TopLevelObject bo = this.m_session.get(st.getLevelRef());
                        Object parentInternal = null;
                        if (bo instanceof LevelReference) {
                            lRef = (LevelReference)this.m_session.get(st.getLevelRef());
                            parentInternal = lRef.getHierarchy().getInternal();
                        } else if (bo instanceof Level && (lRef = (Level)this.m_session.get(st.getLevelRef())).isAllLevel()) {
                            parentInternal = lRef.getParent().getInternal();
                        }
                        if (parentInternal != null && parentInternal.equals(rHierar.getInternal())) {
                            measureScopes.remove(y);
                            if (measureScopes.size() == 0) {
                                scopeTypes.remove(x);
                            }
                            return;
                        }
                    }
                }
                ++y;
            }
            ++x;
        }
    }

    @Override
    public void updateScope(Scope scope) {
        EList<ScopeType> scopeTypes = this.getRelationshipType().getScope();
        int i = 0;
        while (i < scopeTypes.size()) {
            ScopeType st = (ScopeType)scopeTypes.get(i);
            if (st.getLevelRef().equals(scope.getLevelOrHierarchy().getInternal())) {
                scopeTypes.set(i, ((FmScope)scope).getScope());
            }
            ++i;
        }
    }

    @Override
    public List<Scope> getScopes() {
        EList<ScopeType> scopeTypes = this.getRelationshipType().getScope();
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        for (ScopeType includedScope : scopeTypes) {
            scopes.add(FmScope.get(this.m_session, includedScope));
        }
        return scopes;
    }

    @Override
    public Relationship.JoinOptimization getJoinOptimization() {
        switch (this.getRelationshipType().getJoinFilterType()) {
            case IN: {
                return Relationship.JoinOptimization.in;
            }
            case BETWEEN: {
                return Relationship.JoinOptimization.between;
            }
            case TABLE: {
                return Relationship.JoinOptimization.table;
            }
        }
        return Relationship.JoinOptimization.none;
    }

    @Override
    public void setJoinOptimization(Relationship.JoinOptimization joinOptimization) {
        switch (joinOptimization) {
            case in: {
                this.getRelationshipType().setJoinFilterType(JoinFilterTypeType.IN);
                break;
            }
            case between: {
                this.getRelationshipType().setJoinFilterType(JoinFilterTypeType.BETWEEN);
                break;
            }
            case table: {
                this.getRelationshipType().setJoinFilterType(JoinFilterTypeType.TABLE);
                break;
            }
            default: {
                this.getRelationshipType().setJoinFilterType(JoinFilterTypeType.NONE);
            }
        }
    }

    private class TableRef {
        public String m_tableName;
        public EObject m_dataSource;

        public TableRef(Table table) {
            this.m_tableName = table.getTableName();
            this.m_dataSource = (EObject)table.getDataSource().getInternal();
        }

        public TableRef(ColumnReference column) {
            this.m_tableName = column.getTableName();
            this.m_dataSource = (EObject)column.getDataSource().getInternal();
        }

        public boolean equals(TableRef rightSide) {
            return this.m_tableName.equals(rightSide.m_tableName) && this.m_dataSource.equals(rightSide.m_dataSource);
        }
    }
}

