/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.RelationshipParentInternal;
import com.ibm.cognos.fmeng.fmmd.model.Cardinality;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipEnd;
import com.ibm.cognos.fmeng.fmmd.model.Scope;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.fmmd.util.FmJoinHelper;
import com.ibm.cognos.fmeng.genmodel.CardinalityEnum;
import com.ibm.cognos.fmeng.genmodel.CardinalityType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.utility.FmMDException;

public abstract class FmRelationshipBase
extends FmModelObject
implements RelationshipBase {
    FmRelationshipBase(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    public abstract RelationshipEnd getLeftEnd();

    public abstract RelationshipEnd getRightEnd();

    public void setLeftEnd(RelationshipEnd leftEnd) {
    }

    public void setRightEnd(RelationshipEnd rightEnd) {
    }

    public abstract Cardinality.ECardinality getLeftMincard();

    public abstract Cardinality.ECardinality getRightMincard();

    public abstract Cardinality.ECardinality getLeftMaxcard();

    public abstract Cardinality.ECardinality getRightMaxcard();

    public void setLeftMincard(Cardinality.ECardinality leftMincard) {
    }

    public void setRightMincard(Cardinality.ECardinality rightMincard) {
    }

    public void setLeftMaxcard(Cardinality.ECardinality leftMaxcard) {
    }

    public void setRightMaxcard(Cardinality.ECardinality rightMaxcard) {
    }

    public void addScope(Scope s) {
    }

    public boolean isSelfJoin() {
        return this.getLeftEnd().equals(this.getRightEnd());
    }

    public boolean containsBothEnds(RelationshipEnd firstEnd, RelationshipEnd secondEnd) {
        return this.getLeftEnd().equals(firstEnd) && this.getRightEnd().equals(secondEnd) || this.getLeftEnd().equals(secondEnd) && this.getRightEnd().equals(firstEnd);
    }

    protected RelationshipParentInternal determineContainership() {
        FmBaseObject leftEnd = (FmBaseObject)((Object)this.getLeftEnd());
        FmBaseObject rightEnd = (FmBaseObject)((Object)this.getRightEnd());
        return FmRelationshipBase.determineContainership(this.m_session, leftEnd, rightEnd);
    }

    protected static RelationshipParentInternal determineContainership(EMFSession session, FmBaseObject leftEnd, FmBaseObject rightEnd) {
        TopLevelObject ret = null;
        if (leftEnd != null && rightEnd != null) {
            Object obj = session.getGateway().getCommonAncestor(leftEnd.getInternal(), rightEnd.getInternal());
            FmMDException.ASSERT(obj != null, "Common ancestor expected.");
            ret = FmModelFactory.getInstance().get(session, obj);
        }
        return (RelationshipParentInternal)ret;
    }

    public abstract void updateContainership();

    protected Cardinality.ECardinality getCardinalityType(CardinalityEnum enumValue) {
        switch (enumValue) {
            case UNKNOWN: {
                return Cardinality.ECardinality.unknown;
            }
            case UNSUPPORTED: {
                return Cardinality.ECardinality.unsupported;
            }
            case ZERO: {
                return Cardinality.ECardinality.zero;
            }
            case ONE: {
                return Cardinality.ECardinality.one;
            }
            case MANY: {
                return Cardinality.ECardinality.many;
            }
        }
        return Cardinality.ECardinality.unknown;
    }

    protected void setMinCardinalityType(Cardinality.ECardinality card, CardinalityType cardType) {
        switch (card) {
            case unknown: {
                cardType.setMincard(CardinalityEnum.UNKNOWN);
                break;
            }
            case unsupported: {
                cardType.setMincard(CardinalityEnum.UNSUPPORTED);
                break;
            }
            case zero: {
                cardType.setMincard(CardinalityEnum.ZERO);
                break;
            }
            case one: {
                cardType.setMincard(CardinalityEnum.ONE);
                break;
            }
            case many: {
                cardType.setMincard(CardinalityEnum.MANY);
            }
        }
    }

    protected void setMaxCardinalityType(Cardinality.ECardinality card, CardinalityType cardType) {
        switch (card) {
            case unknown: {
                cardType.setMaxcard(CardinalityEnum.UNKNOWN);
                break;
            }
            case unsupported: {
                cardType.setMaxcard(CardinalityEnum.UNSUPPORTED);
                break;
            }
            case zero: {
                cardType.setMaxcard(CardinalityEnum.ZERO);
                break;
            }
            case one: {
                cardType.setMaxcard(CardinalityEnum.ONE);
                break;
            }
            case many: {
                cardType.setMaxcard(CardinalityEnum.MANY);
            }
        }
    }

    public void copyCardinality(Cardinality right) {
        FmJoinHelper.copyCardinality(this, right);
    }

    public boolean equals(Cardinality.ECardinality leftMinCard, Cardinality.ECardinality leftMaxCard, Cardinality.ECardinality rightMinCard, Cardinality.ECardinality rightMaxCard) {
        return leftMinCard.equals((Object)this.getLeftMincard()) && leftMaxCard.equals((Object)this.getLeftMaxcard()) && rightMinCard.equals((Object)this.getRightMincard()) && rightMaxCard.equals((Object)this.getRightMaxcard());
    }

    public RelationshipEnd getOtherEnd(RelationshipEnd end) {
        if (end != null) {
            if (end.equals(this.getLeftEnd())) {
                return this.getRightEnd();
            }
            if (end.equals(this.getRightEnd())) {
                return this.getLeftEnd();
            }
        }
        return null;
    }
}

