/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevelReference;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveListener;
import com.ibm.cognos.fmeng.fmmd.model.LevelReference;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.RelativeTimeMember;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.RelationalHierarchyType;
import com.ibm.cognos.fmeng.genmodel.RelativeTimeMemberType;
import com.ibm.cognos.fmeng.genmodel.RelativeTimeType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.math.BigInteger;
import java.util.List;
import java.util.Locale;
import org.eclipse.emf.ecore.EObject;

public class FmRelativeTimeMember
extends FmReportObject
implements RelativeTimeMember {
    public static RelativeTimeMember create(EMFSession mSession, FmRelationalHierarchy parent, String name, RelativeTimeMember.RelativeTimeMemberStyle style) {
        if (name == null || name.length() == 0) {
            name = FmRelativeTimeMember.getDefaultName(mSession.getActiveLocale());
        }
        RelativeTimeMemberType obj = GenmodelFactory.eINSTANCE.createRelativeTimeMemberType();
        FmRelativeTimeMember member = new FmRelativeTimeMember(mSession, obj);
        parent.addRelativeTimeMember(member);
        String uniqueName = member.makeUniqueName(name);
        member.setName(FmModelFactory.getInstance().getProject(mSession).getDefaultLocale(), uniqueName);
        member.setRelativeTimeMemberStyle(style);
        member.setDefaultProperties(style);
        return member;
    }

    public static RelativeTimeMember get(FMMDSession session, Object object) {
        return new FmRelativeTimeMember(session, object);
    }

    public static String getDefaultName(Locale locale) {
        return FmMessage.render("BMT_MDN_OBJECT_NAME_RELATIVE_TIME_MEMBER", locale);
    }

    private FmRelativeTimeMember(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    public FmObjectType getFmObjectType() {
        return FmObjectType.relativeTimeMember;
    }

    protected RelativeTimeMemberType getRelativeTimeMemberType() {
        return (RelativeTimeMemberType)this.m_emfObject;
    }

    public RelativeTimeMember.RelativeTimeMemberStyle getRelativeTimeMemberStyle() {
        switch (this.getRelativeTimeMemberType().getRelativeTimeMemberStyle()) {
            default: {
                return RelativeTimeMember.RelativeTimeMemberStyle.simple;
            }
            case PERIOD_TO_DATE: {
                return RelativeTimeMember.RelativeTimeMemberStyle.periodToDate;
            }
            case ROLLING_TOTAL: 
        }
        return RelativeTimeMember.RelativeTimeMemberStyle.rollingTotal;
    }

    public void setRelativeTimeMemberStyle(RelativeTimeMember.RelativeTimeMemberStyle style) {
        switch (style) {
            case simple: {
                this.getRelativeTimeMemberType().setRelativeTimeMemberStyle(RelativeTimeType.SIMPLE);
                break;
            }
            case periodToDate: {
                this.getRelativeTimeMemberType().setRelativeTimeMemberStyle(RelativeTimeType.PERIOD_TO_DATE);
                break;
            }
            case rollingTotal: {
                this.getRelativeTimeMemberType().setRelativeTimeMemberStyle(RelativeTimeType.ROLLING_TOTAL);
            }
        }
    }

    public LevelReference getContextPeriod() {
        return this.getRelativeTimeMemberType().getContextPeriod() != null ? FmLevelReference.get(this.m_session, this.getRelativeTimeMemberType().getContextPeriod()) : null;
    }

    private RelationalHierarchy getHierarchy() {
        EObject obj = (EObject)this.m_emfObject;
        while (obj != null) {
            if (obj instanceof RelationalHierarchyType) {
                return FmRelationalHierarchy.get(this.m_session, obj);
            }
            obj = obj.eContainer();
        }
        FmMDException.ASSERT(false, "Relative time member not attached to a hierarchy.");
        return null;
    }

    public BigInteger getContextPeriodOffset() {
        return this.getRelativeTimeMemberType().getContextPeriodOffset();
    }

    public BigInteger getNumberOfPeriods() {
        return this.getRelativeTimeMemberType().getNumberOfPeriods();
    }

    public LevelReference getTargetPeriod() {
        return this.getRelativeTimeMemberType().getTargetPeriod() != null ? FmLevelReference.get(this.m_session, this.getRelativeTimeMemberType().getTargetPeriod()) : null;
    }

    public BigInteger getTargetPeriodOffset() {
        return this.getRelativeTimeMemberType().getTargetPeriodOffset();
    }

    public LevelReference getToDatePeriod() {
        return this.getRelativeTimeMemberType().getToDatePeriod() != null ? FmLevelReference.get(this.m_session, this.getRelativeTimeMemberType().getToDatePeriod()) : null;
    }

    public void setContextPeriod(LevelReference ref) {
        EObject objRef = null;
        if (ref != null) {
            objRef = (EObject)ref.getInternal();
        }
        this.getRelativeTimeMemberType().setContextPeriod(objRef);
    }

    public void setContextPeriodOffset(BigInteger offset) {
        this.getRelativeTimeMemberType().setContextPeriodOffset(offset);
    }

    public void setNumberOfPeriods(BigInteger numberOfPeriods) {
        this.getRelativeTimeMemberType().setNumberOfPeriods(numberOfPeriods);
    }

    public void setTargetPeriod(LevelReference ref) {
        EObject objRef = null;
        if (ref != null) {
            objRef = (EObject)ref.getInternal();
        }
        this.getRelativeTimeMemberType().setTargetPeriod(objRef);
    }

    public void setTargetPeriodOffset(BigInteger offset) {
        this.getRelativeTimeMemberType().setTargetPeriodOffset(offset);
    }

    public void setToDatePeriod(LevelReference ref) {
        EObject objRef = null;
        if (ref != null) {
            objRef = (EObject)ref.getInternal();
        }
        this.getRelativeTimeMemberType().setToDatePeriod(objRef);
    }

    void prepareForObjectDeletion(RemoveInfo info, FmBaseObject object, RemoveListener listener) {
        if (object instanceof FmLevelReference) {
            Object lvlRef = ((FmLevelReference)object).getInternal();
            if (lvlRef.equals(this.getRelativeTimeMemberType().getContextPeriod())) {
                this.getRelativeTimeMemberType().setContextPeriod(null);
            }
            if (lvlRef.equals(this.getRelativeTimeMemberType().getTargetPeriod())) {
                this.getRelativeTimeMemberType().setTargetPeriod(null);
            }
            if (lvlRef.equals(this.getRelativeTimeMemberType().getToDatePeriod())) {
                this.getRelativeTimeMemberType().setToDatePeriod(null);
            }
        }
    }

    public boolean isLifeToDate() {
        if (this.getRelativeTimeMemberStyle() != RelativeTimeMember.RelativeTimeMemberStyle.periodToDate) {
            return false;
        }
        return this.getRelativeTimeMemberType().isLifeToDate();
    }

    public void setLifeToDate(boolean lifeToDate) {
        if (this.getRelativeTimeMemberStyle() != RelativeTimeMember.RelativeTimeMemberStyle.periodToDate) {
            throw new FmMDException("BMT_MD_LIFE_TO_DATE_NOT_APPLICABLE");
        }
        this.getRelativeTimeMemberType().setLifeToDate(lifeToDate);
        if (lifeToDate) {
            this.setToDatePeriod(null);
        }
    }

    private void setDefaultProperties(RelativeTimeMember.RelativeTimeMemberStyle style) {
        RelationalHierarchy hierarchy = this.getHierarchy();
        List<LevelReference> levels = hierarchy.getLevelReferences();
        if (levels.size() > 0) {
            this.setTargetPeriod(levels.get(levels.size() - 1));
        }
        if (levels.size() > 0) {
            this.setContextPeriod(levels.get(0));
        }
        this.getRelativeTimeMemberType().setContextPeriodOffset(BigInteger.valueOf(0L));
        this.getRelativeTimeMemberType().setTargetPeriodOffset(BigInteger.valueOf(0L));
        switch (style) {
            case simple: {
                break;
            }
            case periodToDate: {
                this.setLifeToDate(false);
                if (levels.size() <= 0) break;
                this.setToDatePeriod(levels.get(0));
                break;
            }
            case rollingTotal: {
                this.getRelativeTimeMemberType().setNumberOfPeriods(BigInteger.valueOf(0L));
            }
        }
    }
}

