/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLocalizedValue;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmProperty;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRole;
import com.ibm.cognos.fmeng.fmmd.impl.model.MoveListener;
import com.ibm.cognos.fmeng.fmmd.impl.model.NamingListener;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.LocalizedValue;
import com.ibm.cognos.fmeng.fmmd.model.Property;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.Role;
import com.ibm.cognos.fmeng.fmmd.model.Status;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.NameType;
import com.ibm.cognos.fmeng.genmodel.ProjectType;
import com.ibm.cognos.fmeng.genmodel.PropertyType;
import com.ibm.cognos.fmeng.genmodel.ReportObjectType;
import com.ibm.cognos.fmeng.genmodel.StatusType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FmReportObject
extends FmBaseObject
implements ReportObject {
    protected static final Pattern m_badCubeChars = Pattern.compile("[<>:\"/\\\\\\|\\?\\*\\&,']");
    protected static final String DESCENDANTS = "Descendants";
    protected static final String CHILDREN = "Children";

    FmReportObject(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    protected ReportObjectType getReportObjectType() {
        return (ReportObjectType)this.m_emfObject;
    }

    @Override
    public void setName(String localeKey, String nameValue) {
        String value = this.fixupName(nameValue);
        this.validateName(nameValue, true);
        this.validateNameUnique(value);
        this.setMultilingualValue((List<NameType>)this.getReportObjectType().getName(), localeKey, value);
    }

    public boolean validateName(String nameValue, boolean throwException) {
        return false;
    }

    @Override
    public void removeNameLocale(String localeKey) {
        this.removeLocale((List<NameType>)this.getReportObjectType().getName(), localeKey);
    }

    @Override
    public String getName() {
        EObject obj = (EObject)this.getInternal();
        while (obj != null) {
            if (obj instanceof ProjectType) {
                ProjectType proj = (ProjectType)obj;
                return this.getName(proj.getDefaultLocale());
            }
            obj = obj.eContainer();
        }
        return null;
    }

    @Override
    public String getGuid() {
        return this.getReportObjectType().getGuid();
    }

    @Override
    public void setGuid(String guid) {
        this.getReportObjectType().setGuid(guid);
    }

    @Override
    public String getName(String localeKey) {
        return this.getMultilingualValue((List<NameType>)this.getReportObjectType().getName(), localeKey);
    }

    @Override
    public void setDescription(String localeKey, String nameValue) {
        this.setMultilingualValue((List<NameType>)this.getReportObjectType().getDescription(), localeKey, nameValue);
    }

    @Override
    public String getDescription(String localeKey) {
        return this.getMultilingualValue((List<NameType>)this.getReportObjectType().getDescription(), localeKey);
    }

    @Override
    public void setScreenTip(String localeKey, String nameValue) {
        this.setMultilingualValue((List<NameType>)this.getReportObjectType().getScreenTip(), localeKey, nameValue);
    }

    @Override
    public String getScreenTip(String localeKey) {
        return this.getMultilingualValue((List<NameType>)this.getReportObjectType().getScreenTip(), localeKey);
    }

    public void setLastChanged(String value) {
        this.getReportObjectType().setLastChanged(value);
    }

    public String getLastChanged() {
        return this.getReportObjectType().getLastChanged();
    }

    @Override
    public void setLastChangedBy(String value) {
        this.getReportObjectType().setLastChangedBy(value);
    }

    @Override
    public String getLastChangedBy() {
        return this.getReportObjectType().getLastChangedBy();
    }

    @Override
    public String getComment() {
        return this.getReportObjectType().getComment();
    }

    @Override
    public void setComment(String propertyValue) {
        this.getReportObjectType().setComment(propertyValue);
    }

    @Override
    public void postCopyAdoption(FmBaseObject parentObject) {
        this.makeAllNamesUnique(BaseObject.PrefixName.kCopy, parentObject, null);
        if (this.getParent() == null) {
            parentObject.addChild(this.m_emfObject);
        }
    }

    public void copyDescriptionAndScreentip(FmReportObject ro) {
        EList<NameType> screenTips;
        EList<NameType> descriptions = ro.getReportObjectType().getDescription();
        if (descriptions != null) {
            for (NameType nt : descriptions) {
                this.setDescription(nt.getLocale(), nt.getValue());
            }
        }
        if ((screenTips = ro.getReportObjectType().getScreenTip()) != null) {
            for (NameType nt : screenTips) {
                this.setScreenTip(nt.getLocale(), nt.getValue());
            }
        }
    }

    public void copyCommonProperties(ReportObject srcObj, BaseObject destParent) {
        this.copyNames((FmReportObject)srcObj, BaseObject.PrefixName.kCopy, (FmBaseObject)destParent);
        this.copyDescriptionAndScreentip((FmReportObject)srcObj);
        this.setComment(srcObj.getComment());
    }

    public void copyNames(FmReportObject nameSource, BaseObject.PrefixName namingStrategy, FmBaseObject parentObject) {
        EList<NameType> names = nameSource.getReportObjectType().getName();
        EList<NameType> thisNames = this.getReportObjectType().getName();
        List<String> supportedLocales = parentObject.getProject().getSupportedLocales();
        for (NameType name : names) {
            if (!supportedLocales.contains(name.getLocale())) continue;
            String uniqueName = parentObject.makeChildUniqueName(name.getValue(), this.getFmObjectType(), namingStrategy, this);
            this.setMultilingualValue((List<NameType>)thisNames, name.getLocale(), uniqueName);
        }
    }

    public void copyNames(List<LocalizedValue> names, BaseObject.PrefixName namingStrategy, FmBaseObject parentObject) {
        EList<NameType> thisNames = this.getReportObjectType().getName();
        List<String> supportedLocales = parentObject.getProject().getSupportedLocales();
        for (LocalizedValue name : names) {
            if (!supportedLocales.contains(name.getLocale())) continue;
            String uniqueName = parentObject.makeChildUniqueName(name.getValue(), this.getFmObjectType(), namingStrategy, this);
            this.setMultilingualValue((List<NameType>)thisNames, name.getLocale(), uniqueName);
        }
    }

    @Override
    public void moveObject(FmBaseObject targetParent, MoveListener listener) {
        super.moveObject(targetParent, listener);
        this.makeAllNamesUnique(BaseObject.PrefixName.kStandard, targetParent, listener);
    }

    protected void makeAllNamesUnique(BaseObject.PrefixName namingStrategy, FmBaseObject parentObject, NamingListener listener) {
        EList<NameType> names = this.getReportObjectType().getName();
        for (NameType name : names) {
            String uniqueName = parentObject.makeChildUniqueName(name.getValue(), this.getFmObjectType(), namingStrategy, this);
            if (uniqueName.equals(name.getValue())) continue;
            if (listener != null) {
                listener.objectRenamed(this, name.getValue(), uniqueName, name.getLocale());
            }
            name.setValue(uniqueName);
        }
    }

    public List<String> getNameList() {
        EList<NameType> names = this.getReportObjectType().getName();
        ArrayList<String> nameList = new ArrayList<String>();
        int i = 0;
        while (i < names.size()) {
            nameList.add(((NameType)names.get(i)).getValue());
            ++i;
        }
        return nameList;
    }

    @Override
    public List<LocalizedValue> getNames() {
        ArrayList<LocalizedValue> names = new ArrayList<LocalizedValue>();
        for (NameType name : this.getReportObjectType().getName()) {
            names.add(new FmLocalizedValue(name.getLocale(), name.getValue()));
        }
        return names;
    }

    @Override
    public List<String> getSupportedLocales() {
        ArrayList<String> localLocales = new ArrayList<String>();
        for (NameType name : this.getReportObjectType().getName()) {
            localLocales.add(name.getLocale());
        }
        return localLocales;
    }

    protected String hasName(String name) {
        EList<NameType> names = this.getReportObjectType().getName();
        for (NameType nameType : names) {
            if (!nameType.getValue().equals(name)) continue;
            return nameType.getLocale();
        }
        return null;
    }

    protected String getMultilingualValue(List<NameType> names, String localeKey) {
        NameType name = this.getMultilingualNameType(names, localeKey);
        if (name != null) {
            return name.getValue();
        }
        return null;
    }

    protected void setMultilingualValue(List<NameType> names, String localeKey, String value) {
        this.getProject().addLocale(localeKey);
        NameType name = this.getMultilingualNameType(names, localeKey);
        String existingValue = null;
        if (name == null) {
            name = GenmodelFactory.eINSTANCE.createNameType();
            names.add(name);
            name.setLocale(localeKey);
            name.setValue(value);
        } else {
            existingValue = name.getValue();
            name.setValue(value);
        }
        ((EMFSession)this.getSession()).getCubeSynchronizer().synchNameChange(name, existingValue, value);
    }

    protected void removeLocale(List<NameType> names, String localeKey) {
        if (this.getProject().getDefaultLocale().equals(localeKey)) {
            return;
        }
        NameType nameOfInterest = null;
        for (NameType name : names) {
            if (!name.getLocale().equals(localeKey)) continue;
            nameOfInterest = name;
            break;
        }
        if (nameOfInterest != null) {
            ((EMFSession)this.getSession()).getCubeSynchronizer().synchNameChange(nameOfInterest, nameOfInterest.getValue(), null);
            this.m_session.getGateway().delete(nameOfInterest);
        }
    }

    private NameType getMultilingualNameType(List<NameType> names, String localeKey) {
        for (NameType name : names) {
            String inLocale;
            String objLocale = name.getLocale().replace("_", "-");
            if (!objLocale.equalsIgnoreCase(inLocale = localeKey.replace("_", "-"))) continue;
            return name;
        }
        return null;
    }

    @Override
    public Property createCustomProperty(String name) {
        PropertyType pType = GenmodelFactory.eINSTANCE.createPropertyType();
        EList<PropertyType> properties = this.getReportObjectType().getProperty();
        properties.add(pType);
        FmProperty prop = FmProperty.get(this.m_session, pType);
        prop.setName(name);
        return prop;
    }

    @Override
    public Property getCustomProperty(String name) {
        EList<PropertyType> properties = this.getReportObjectType().getProperty();
        for (PropertyType prop : properties) {
            PropertyType ret = this.getCustomProperty(name, prop);
            if (ret == null) continue;
            return FmProperty.get(this.m_session, prop);
        }
        return null;
    }

    private PropertyType getCustomProperty(String name, PropertyType prop) {
        if (name.equals(prop.getName())) {
            return prop;
        }
        EList<PropertyType> props = prop.getProperty();
        for (PropertyType childProp : props) {
            PropertyType ret = this.getCustomProperty(name, childProp);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public Status.EStatus getStatus() {
        switch (this.getReportObjectType().getStatus()) {
            case INVALID: 
            case CHILD_INVALID: 
            case CHILD_INVALID_THIS_WARNING: {
                return Status.EStatus.invalid;
            }
            case WARNING: 
            case CHILD_WARNING: {
                return Status.EStatus.warning;
            }
            case NEEDS_REEVALUATION: {
                return Status.EStatus.needsReevaluation;
            }
            case PERFORMANCE: {
                return Status.EStatus.performance;
            }
        }
        return Status.EStatus.valid;
    }

    @Override
    public void setStatus(Status.EStatus eStatus) {
        switch (eStatus) {
            case invalid: {
                this.getReportObjectType().setStatus(StatusType.INVALID);
                break;
            }
            case warning: {
                this.getReportObjectType().setStatus(StatusType.WARNING);
                break;
            }
            case valid: {
                this.getReportObjectType().setStatus(StatusType.VALID);
                break;
            }
            case needsReevaluation: {
                this.getReportObjectType().setStatus(StatusType.NEEDS_REEVALUATION);
                break;
            }
            case performance: {
                this.getReportObjectType().setStatus(StatusType.PERFORMANCE);
            }
        }
    }

    @Override
    public abstract FmObjectType getFmObjectType();

    public QueryItemBase getItemWithRole(String customRoleName, String locale, List<QueryItem> items) {
        for (QueryItem item : items) {
            FmQueryItem i = (FmQueryItem)item;
            List<Role> roles = i.getRoles();
            for (Role r : roles) {
                if (!((FmRole)r).matches(customRoleName, locale)) continue;
                return i;
            }
        }
        return null;
    }

    public QueryItemBase getItemWithRole(Role.EDefaultRoles role, List<QueryItem> items) {
        for (QueryItem item : items) {
            FmQueryItem i = (FmQueryItem)item;
            List<Role> roles = i.getRoles();
            for (Role r : roles) {
                if (!r.getDefaultRole().equals((Object)role)) continue;
                return i;
            }
        }
        return null;
    }
}

