/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmComplexProperty;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLocalizedValue;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.LocalizedValue;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.Role;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.NameType;
import com.ibm.cognos.fmeng.genmodel.RoleType;
import com.ibm.cognos.fmeng.genmodel.impl.QueryItemTypeImpl;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmRole
extends FmComplexProperty
implements Role {
    static String[] g_vRoleNames = new String[]{"_dimensionUniqueName", "_hierarchyUniqueName", "_levelLabel", "_levelNumber", "_levelUniqueName", "_memberCaption", "_memberDescription", "_memberUniqueName", "_parentUniqueName", "_businessKey", "_longName", "_shorName", "_rollupType", "_planningDefault", "_transactionId", "_key", "_value"};

    public static FmRole get(EMFSession session, Object rt) {
        FmMDException.ASSERT(rt != null && rt instanceof RoleType, "Expected role type");
        return new FmRole(session, rt);
    }

    private FmRole(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    public RoleType getRole() {
        return (RoleType)this.m_emfObject;
    }

    @Override
    public void setName(String roleValue, String localeKey) {
        ((FmQueryItemBase)this.getQueryItem()).verifyRoleName(roleValue);
        EList<NameType> vhRoleNames = this.getRole().getName();
        NameType roleName = null;
        for (NameType rName : vhRoleNames) {
            if (!localeKey.equals(rName.getLocale())) continue;
            roleName = rName;
            break;
        }
        if (roleName != null) {
            roleName.setValue(roleValue);
            roleName.setLocale(localeKey);
        } else {
            roleName = GenmodelFactory.eINSTANCE.createNameType();
            roleName.setValue(roleValue);
            roleName.setLocale(localeKey);
            vhRoleNames.add(roleName);
        }
    }

    @Override
    public QueryItemBase getQueryItem() {
        Object parent = this.m_session.getGateway().getParent(this.m_emfObject);
        while (parent != null && !(parent instanceof QueryItemTypeImpl)) {
            parent = this.m_session.getGateway().getParent(parent);
        }
        return (FmQueryItemBase)FmModelFactory.getInstance().get(this.m_session, parent);
    }

    static String getDefaultRoleName(Role.EDefaultRoles eRole) {
        switch (eRole) {
            case kRoleDimensionUniqueName: 
            case kRoleHierarchyUniqueName: 
            case kRoleLevelLabel: 
            case kRoleLevelNumber: 
            case kRoleLevelUniqueName: 
            case kRoleMemberCaption: 
            case kRoleMemberDescription: 
            case kRoleMemberUniqueName: 
            case kRoleParentUniqueName: 
            case kRoleBusinessKey: 
            case kRoleLongName: 
            case kRoleShortName: 
            case kRoleRollupType: 
            case kRolePlanningDefault: 
            case kRoleTransactionId: 
            case kRoleKey: 
            case kRoleValue: {
                return g_vRoleNames[eRole.ordinal()];
            }
        }
        return null;
    }

    public static boolean isDefaultRole(String defaultRoleName) {
        HashSet<String> set = new HashSet<String>(Arrays.asList(g_vRoleNames));
        return set.contains(defaultRoleName);
    }

    public static Role.EDefaultRoles getDefaultRoleIndex(String defaultRoleName) {
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(g_vRoleNames));
        int idx = names.indexOf(defaultRoleName);
        switch (idx) {
            case 0: {
                return Role.EDefaultRoles.kRoleDimensionUniqueName;
            }
            case 1: {
                return Role.EDefaultRoles.kRoleHierarchyUniqueName;
            }
            case 2: {
                return Role.EDefaultRoles.kRoleLevelLabel;
            }
            case 3: {
                return Role.EDefaultRoles.kRoleLevelNumber;
            }
            case 4: {
                return Role.EDefaultRoles.kRoleLevelUniqueName;
            }
            case 5: {
                return Role.EDefaultRoles.kRoleMemberCaption;
            }
            case 6: {
                return Role.EDefaultRoles.kRoleMemberDescription;
            }
            case 7: {
                return Role.EDefaultRoles.kRoleMemberUniqueName;
            }
            case 8: {
                return Role.EDefaultRoles.kRoleParentUniqueName;
            }
            case 9: {
                return Role.EDefaultRoles.kRoleBusinessKey;
            }
            case 10: {
                return Role.EDefaultRoles.kRoleLongName;
            }
            case 11: {
                return Role.EDefaultRoles.kRoleShortName;
            }
            case 12: {
                return Role.EDefaultRoles.kRoleRollupType;
            }
            case 13: {
                return Role.EDefaultRoles.kRolePlanningDefault;
            }
            case 14: {
                return Role.EDefaultRoles.kRoleTransactionId;
            }
            case 15: {
                return Role.EDefaultRoles.kRoleKey;
            }
            case 16: {
                return Role.EDefaultRoles.kRoleValue;
            }
        }
        Object[] msgParams = new Object[]{defaultRoleName};
        throw new FmMDException("BMT_MD_ERROR_ROLE_PREDEFINED_NAME", msgParams);
    }

    @Override
    public String getName() {
        EList<NameType> names = this.getRole().getName();
        for (NameType name : names) {
            String nameValue = name.getValue();
            if (!FmRole.isDefaultRole(nameValue)) continue;
            return nameValue;
        }
        String defaultLocale = this.getSession().getProject().getDefaultLocale();
        return this.getName(defaultLocale);
    }

    @Override
    public String getName(String localeKey) {
        for (NameType nameType : this.getRole().getName()) {
            if (FmRole.isDefaultRole(nameType.getValue())) {
                return nameType.getValue();
            }
            if (nameType.getLocale() == null || "".equals(nameType.getLocale()) || !nameType.getLocale().equals(localeKey)) continue;
            return nameType.getValue();
        }
        return null;
    }

    @Override
    public Role.EDefaultRoles getDefaultRole() {
        String roleOfInterest = ((NameType)this.getRole().getName().get(0)).getValue();
        Role.EDefaultRoles[] eDefaultRolesArray = Role.EDefaultRoles.values();
        int n = eDefaultRolesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Role.EDefaultRoles role = eDefaultRolesArray[n2];
            if (roleOfInterest.equals(FmRole.getDefaultRoleName(role))) {
                return role;
            }
            ++n2;
        }
        return Role.EDefaultRoles.kRoleUnknown;
    }

    public boolean matches(String customRoleName, String locale) {
        EList<NameType> names = this.getRole().getName();
        for (NameType name : names) {
            if (!name.getValue().equals(customRoleName) || !name.getLocale().equals(locale)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(String customRoleName) {
        EList<NameType> names = this.getRole().getName();
        for (NameType name : names) {
            if (!name.getValue().equals(customRoleName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getIntrinsic() {
        return this.getRole().isIntrinsic();
    }

    @Override
    public void setIntrinsic(boolean intrinsic) {
        this.getRole().setIntrinsic(intrinsic);
    }

    @Override
    public List<LocalizedValue> getNames() {
        ArrayList<LocalizedValue> names = new ArrayList<LocalizedValue>();
        for (NameType name : this.getRole().getName()) {
            names.add(new FmLocalizedValue(name.getLocale(), name.getValue()));
        }
        return names;
    }
}

