/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmDataSource;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPhysicalDefinition;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPseudoModelObject;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.SQLObject;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.SqlObjectType;
import com.ibm.cognos.fmeng.platform.FMMDSession;

public class FmSQLObject
extends FmPseudoModelObject
implements SQLObject {
    FmSQLObject(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    public static FmSQLObject createSQLObject(FMMDSession session, FmPhysicalDefinition fmPhysicalDefinition, FmDataSource ds, String name, String sqlStatement) {
        String id = fmPhysicalDefinition.makeObjectNameUnique(name, 164);
        SqlObjectType sqlType = GenmodelFactory.eINSTANCE.createSqlObjectType();
        sqlType.setName(id);
        sqlType.setSqlStatement(sqlStatement);
        FmSQLObject sqlObject = new FmSQLObject(session, sqlType);
        sqlObject.setDataSource(ds);
        fmPhysicalDefinition.addSQLObject(sqlObject);
        return sqlObject;
    }

    public static FmSQLObject get(FMMDSession session, Object emfobj) {
        return new FmSQLObject(session, (SqlObjectType)emfobj);
    }

    public SqlObjectType getSqlObjectType() {
        return (SqlObjectType)this.m_emfObject;
    }

    private void setDataSource(FmDataSource ds) {
        this.getSqlObjectType().setDataSourceRef(ds.getAsDataSourceType());
    }

    public FmDataSource getDataSource() {
        return FmDataSource.get(this.m_session, this.getSqlObjectType().getDataSourceRef());
    }

    public String toString() {
        return "SQL Object: " + this.getName() + "\n\tSQL Statement: " + this.getSQLStatement();
    }

    public int compareTo(FmSQLObject right) {
        return this.getName().compareTo(right.getName());
    }

    public RelationalObject getRelationalParent() {
        BaseObject parent = this.getParent();
        while (parent != null && !(parent instanceof RelationalObject)) {
            parent = parent.getParent();
        }
        return (RelationalObject)parent;
    }

    public String getSQLStatement() {
        return this.getSqlObjectType().getSqlStatement();
    }

    public void setSQLStatement(String sqlStatement) {
        this.getSqlObjectType().setSqlStatement(sqlStatement);
    }
}

