/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.EObjectSourceType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmNamespace;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationshipBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmScope;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSection;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmShortcut;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveListener;
import com.ibm.cognos.fmeng.fmmd.impl.task.FmScopeRelationshipTransform;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Cardinality;
import com.ibm.cognos.fmeng.fmmd.model.Dimension;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.Hierarchy;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.Measure;
import com.ibm.cognos.fmeng.fmmd.model.Namespace;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipEnd;
import com.ibm.cognos.fmeng.fmmd.model.Scope;
import com.ibm.cognos.fmeng.fmmd.model.ScopeRelationship;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.fmmd.util.EmfHelper;
import com.ibm.cognos.fmeng.fmmd.util.ObjectReferenceHelper;
import com.ibm.cognos.fmeng.genmodel.CardinalityType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.MeasureScopeType;
import com.ibm.cognos.fmeng.genmodel.NamespaceType;
import com.ibm.cognos.fmeng.genmodel.ScopeRelationshipType;
import com.ibm.cognos.fmeng.genmodel.ScopeType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmScopeRelationship
extends FmRelationshipBase
implements ScopeRelationship {
    public static FmScopeRelationship createObject(FMMDSession session, RelationshipEnd left, RelationshipEnd right) {
        String relName = FmScopeRelationship.getDefaultName(session, left, right);
        Namespace parent = FmModelFactory.getInstance().getProject(session).getRootNamespace();
        ScopeRelationshipType emfObj = GenmodelFactory.eINSTANCE.createScopeRelationshipType();
        FmScopeRelationship rel = new FmScopeRelationship(session, emfObj);
        ((FmNamespace)parent).addScopeRelationship(rel);
        String uniqueName = rel.makeUniqueName(relName);
        rel.getScopeRelationshipType().setName(uniqueName);
        rel.init(left, right);
        return rel;
    }

    public static FmScopeRelationship createScopeRelationship(FMMDSession session, FmSection suggestedParent, RelationshipEnd left, RelationshipEnd right) {
        String relName = FmScopeRelationship.getDefaultName(session, left, right);
        ScopeRelationshipType emfObj = GenmodelFactory.eINSTANCE.createScopeRelationshipType();
        FmScopeRelationship rel = new FmScopeRelationship(session, emfObj);
        suggestedParent.addScopeRelationship(rel);
        String uniqueName = rel.makeUniqueName(relName);
        rel.getScopeRelationshipType().setName(uniqueName);
        rel.init(left, right);
        return rel;
    }

    public static FmScopeRelationship get(FMMDSession session, Object emfobj) {
        return new FmScopeRelationship(session, (ScopeRelationshipType)emfobj);
    }

    private FmScopeRelationship(FMMDSession session, ScopeRelationshipType emfObject) {
        super(session, emfObject);
    }

    @Override
    public FmObjectType getFmObjectType() {
        return FmObjectType.scopeRelationship;
    }

    protected ScopeRelationshipType getScopeRelationshipType() {
        return (ScopeRelationshipType)this.m_emfObject;
    }

    @Override
    public RelationshipEnd getLeftEnd() {
        EObject eobj = this.getScopeRelationshipType().getLeft().getRefobj();
        return (RelationshipEnd)FmModelFactory.getInstance().get(this.m_session, eobj);
    }

    @Override
    public void setLeftEnd(RelationshipEnd leftEnd) {
        this.getScopeRelationshipType().getLeft().setRefobj((EObject)leftEnd.getInternal());
    }

    @Override
    public RelationshipEnd getRightEnd() {
        EObject eobj = this.getScopeRelationshipType().getRight().getRefobj();
        return (RelationshipEnd)FmModelFactory.getInstance().get(this.m_session, eobj);
    }

    @Override
    public void setRightEnd(RelationshipEnd rightEnd) {
        this.getScopeRelationshipType().getRight().setRefobj((EObject)rightEnd.getInternal());
    }

    @Override
    public Cardinality.ECardinality getLeftMincard() {
        return this.getCardinalityType(this.getScopeRelationshipType().getLeft().getMincard());
    }

    @Override
    public void setLeftMincard(Cardinality.ECardinality leftMincard) {
        this.setMinCardinalityType(leftMincard, this.getScopeRelationshipType().getLeft());
    }

    @Override
    public Cardinality.ECardinality getRightMincard() {
        return this.getCardinalityType(this.getScopeRelationshipType().getRight().getMincard());
    }

    @Override
    public void setRightMincard(Cardinality.ECardinality rightMincard) {
        this.setMinCardinalityType(rightMincard, this.getScopeRelationshipType().getRight());
    }

    @Override
    public Cardinality.ECardinality getLeftMaxcard() {
        return this.getCardinalityType(this.getScopeRelationshipType().getLeft().getMaxcard());
    }

    @Override
    public void setLeftMaxcard(Cardinality.ECardinality leftMaxcard) {
        this.setMaxCardinalityType(leftMaxcard, this.getScopeRelationshipType().getLeft());
    }

    @Override
    public Cardinality.ECardinality getRightMaxcard() {
        return this.getCardinalityType(this.getScopeRelationshipType().getRight().getMaxcard());
    }

    @Override
    public void setRightMaxcard(Cardinality.ECardinality rightMaxcard) {
        this.setMaxCardinalityType(rightMaxcard, this.getScopeRelationshipType().getRight());
    }

    @Override
    public List<Scope> getScopes() {
        EList<ScopeType> scopes = this.getScopeRelationshipType().getScope();
        ArrayList<Scope> res = new ArrayList<Scope>(scopes.size());
        for (ScopeType sc : scopes) {
            res.add(FmScope.get(this.m_session, sc));
        }
        return res;
    }

    private List<FmLevel> getScopeLevelRefs() {
        ArrayList<FmLevel> levelRefs = new ArrayList<FmLevel>();
        EList<ScopeType> scopes = this.getScopeRelationshipType().getScope();
        for (ScopeType scope : scopes) {
            EObject eobj = scope.getLevelRef();
            levelRefs.add(FmLevel.get(this.m_session, eobj));
        }
        return levelRefs;
    }

    private List<MeasureScopeType> getAllScopedMeasureScopes() {
        ArrayList<MeasureScopeType> returnedObjects = new ArrayList<MeasureScopeType>();
        EList<ScopeType> scopes = this.getScopeRelationshipType().getScope();
        for (ScopeType scope : scopes) {
            EList<MeasureScopeType> measureScopes = scope.getMeasureScope();
            returnedObjects.addAll((Collection<MeasureScopeType>)measureScopes);
        }
        return returnedObjects;
    }

    private static String getDefaultName(FMMDSession session, RelationshipEnd left, RelationshipEnd right) {
        String relName = null;
        String localeKey = FmModelFactory.getInstance().getProject(session).getDefaultLocale();
        if (left == null || right == null) {
            return FmMessage.render("BMT_MDN_OBJECT_NAME_RELATIONSHIP", localeKey);
        }
        String leftName = ((FmReportObject)((Object)left)).getName(localeKey);
        String rightName = ((FmReportObject)((Object)right)).getName(localeKey);
        relName = leftName;
        relName = String.valueOf(relName) + " <=> ";
        relName = String.valueOf(relName) + rightName;
        return relName;
    }

    private void init(RelationshipEnd left, RelationshipEnd right) {
        this.getScopeRelationshipType().setLeft(GenmodelFactory.eINSTANCE.createCardinalityType());
        this.getScopeRelationshipType().setRight(GenmodelFactory.eINSTANCE.createCardinalityType());
        this.setLeftEnd(left);
        this.setRightEnd(right);
        this.setLeftMincard(Cardinality.ECardinality.one);
        this.setLeftMaxcard(Cardinality.ECardinality.one);
        this.setRightMincard(Cardinality.ECardinality.one);
        this.setRightMaxcard(Cardinality.ECardinality.many);
    }

    public static void findScopingCandidates(FMMDSession session, RelationshipEnd dimension, List<RelationshipEnd> vMeasureDims, List<RelationshipEnd> vRegularDims) {
        boolean bIsSourceMeasure;
        Dimension sourceDim = FmScopeRelationshipTransform.getDimensionFor(dimension);
        if (((FmDimension)sourceDim).determineSourceType(null) == EObjectSourceType.kMultidimensional) {
            return;
        }
        boolean bl = bIsSourceMeasure = ((FmDimension)sourceDim).getDimensionStyle() == DimensionBase.DimensionStyle.measure;
        if (bIsSourceMeasure) {
            vMeasureDims.add(dimension);
        } else {
            vRegularDims.add(dimension);
        }
        BaseObject parent = sourceDim.getParent();
        while (!(parent instanceof FmNamespace)) {
            parent = parent.getParent();
        }
        HashSet<Integer> recurseInto = new HashSet<Integer>();
        HashMap<Integer, List<Object>> collect = new HashMap<Integer, List<Object>>();
        recurseInto.add(148);
        ArrayList dimensions = new ArrayList();
        collect.put(42, dimensions);
        EmfHelper.collect(((FmBaseObject)parent).getInternal(), recurseInto, collect);
        for (Object iter : dimensions) {
            boolean bIsMeasure;
            FmDimension objDim;
            if (iter.equals(dimension.getInternal()) || (objDim = (FmDimension)FmModelFactory.getInstance().get(session, iter)).determineSourceType(null) == EObjectSourceType.kMultidimensional) continue;
            boolean bl2 = bIsMeasure = objDim.getDimensionStyle() == DimensionBase.DimensionStyle.measure;
            if (bIsSourceMeasure && !bIsMeasure) {
                vRegularDims.add(objDim);
                continue;
            }
            if (bIsSourceMeasure || !bIsMeasure) continue;
            vMeasureDims.add(objDim);
        }
    }

    public static List<FmScopeRelationship> transformScopes(FMMDSession session, RelationshipEnd measureDim, List<RelationshipEnd> vRegularDims) {
        ArrayList<FmScopeRelationship> vScopeRels = new ArrayList<FmScopeRelationship>();
        Dimension measDim = FmScopeRelationshipTransform.getDimensionFor(measureDim);
        List<Measure> vMeasures = measDim.getAllMeasures();
        int idx = 0;
        while (idx < vRegularDims.size()) {
            Dimension regDim = FmScopeRelationshipTransform.getDimensionFor(vRegularDims.get(idx));
            List<Hierarchy> vHierarchies = regDim.getAllHierarchies();
            ArrayList<FmLevel> vScopingLevels = new ArrayList<FmLevel>();
            for (Hierarchy hier : vHierarchies) {
                FmLevel scopeLevel = FmScopeRelationship.locateScopingLevel(session, hier, vMeasures);
                vScopingLevels.add(scopeLevel);
            }
            FmScopeRelationship newScopeRel = FmScopeRelationship.setScoping(session, measureDim, vMeasures, vRegularDims.get(idx), vHierarchies, vScopingLevels);
            if (newScopeRel != null) {
                vScopeRels.add(newScopeRel);
            }
            ++idx;
        }
        return vScopeRels;
    }

    private static FmLevel locateScopingLevel(FMMDSession session, Hierarchy hierarchy, List<?> measures) {
        return ((FmHierarchy)hierarchy).getLeafLevel();
    }

    private static FmScopeRelationship setScoping(FMMDSession session, RelationshipEnd measureDim, List<Measure> vMeasures, RelationshipEnd regularDim, List<Hierarchy> vHierarchies, List<FmLevel> vScopeLevels) {
        FmScopeRelationship scopeRel = null;
        boolean bCreate = false;
        int idx = 0;
        while (!bCreate && idx < vHierarchies.size()) {
            bCreate = vScopeLevels.get(idx) != null;
            ++idx;
        }
        if (!bCreate) {
            return scopeRel;
        }
        scopeRel = FmScopeRelationship.createObject(session, regularDim, measureDim);
        int hIdx = 0;
        while (hIdx < vHierarchies.size()) {
            boolean bExclude = vScopeLevels.get(hIdx) == null;
            boolean bIsLeafLevel = false;
            if (!bExclude) {
                FmHierarchy objHierarchy = (FmHierarchy)vHierarchies.get(hIdx);
                boolean bl = bIsLeafLevel = objHierarchy.getLeafLevel() == vScopeLevels.get(hIdx);
            }
            if (!bExclude && bIsLeafLevel) {
                return scopeRel;
            }
            if (!bExclude) {
                scopeRel.addMeasuresToScope(vScopeLevels.get(hIdx), vMeasures, bExclude);
            } else {
                scopeRel.addMeasuresToScope(vHierarchies.get(hIdx), vMeasures, bExclude);
            }
            ++hIdx;
        }
        return scopeRel;
    }

    public void adjustScope(Measure measure, Level level, boolean bExclude) {
        FmHierarchy hierarchy = (FmHierarchy)level.getParent();
        FmMDException.ASSERT(hierarchy != null, "scoping level must belong to a valid hierarchy");
        boolean bIsLeafLevel = hierarchy.getLeafLevel().getInternal().equals(level.getInternal());
        ScopeType infoMeasureScope = FmScopeRelationship.getScopingInfoFor(this, measure, hierarchy);
        if (!bExclude) {
            if (infoMeasureScope.getLevelRef() == null) {
                if (!bIsLeafLevel) {
                    this.addMeasureToScope(level, measure, bExclude);
                }
            } else {
                if (((MeasureScopeType)infoMeasureScope.getMeasureScope()).isExcluded() || !level.getInternal().equals(infoMeasureScope.getLevelRef())) {
                    this.removeMeasureFromScope(infoMeasureScope, measure);
                }
                if (!bIsLeafLevel) {
                    this.addMeasureToScope(level, measure, bExclude);
                }
            }
        } else {
            if (infoMeasureScope.getLevelRef() == null) {
                this.addMeasureToScope(level, measure, bExclude);
            } else if (((MeasureScopeType)infoMeasureScope.getMeasureScope()).isExcluded()) {
                if (!hierarchy.equals(infoMeasureScope.getLevelRef())) {
                    this.addMeasureToScope(hierarchy, measure, bExclude);
                }
            } else {
                this.removeMeasureFromScope(infoMeasureScope, measure);
                this.addMeasureToScope(level, measure, bExclude);
            }
            this.removeScopeRelationIfNoScopedMeasureLeft();
        }
    }

    private boolean removeScopeRelationIfNoScopedMeasureLeft() {
        TopLevelObject leftDim = FmModelFactory.getInstance().get(this.m_session, this.getScopeRelationshipType().getLeft().getRefobj());
        TopLevelObject rightDim = FmModelFactory.getInstance().get(this.m_session, this.getScopeRelationshipType().getRight().getRefobj());
        List<Measure> vMeasures = null;
        if (rightDim instanceof FmShortcut) {
            FmDimension measureDim = (FmDimension)((FmShortcut)rightDim).getRefobj();
            vMeasures = measureDim.getAllMeasures();
        } else if (rightDim instanceof FmDimension) {
            vMeasures = ((FmDimension)rightDim).getAllMeasures();
        }
        List<Hierarchy> vHierarchies = null;
        if (leftDim instanceof FmShortcut) {
            FmDimension regularDim = (FmDimension)((FmShortcut)leftDim).getRefobj();
            vHierarchies = regularDim.getAllHierarchies();
        } else if (leftDim instanceof FmDimension) {
            vHierarchies = ((FmDimension)leftDim).getAllHierarchies();
        }
        boolean bAllExcluded = true;
        Iterator<Hierarchy> hierIter = vHierarchies.iterator();
        while (hierIter.hasNext() && bAllExcluded) {
            Hierarchy hierarchy = hierIter.next();
            Iterator<Measure> measureIter = vMeasures.iterator();
            while (measureIter.hasNext() && bAllExcluded) {
                Measure measure = measureIter.next();
                ScopeType scope = FmScopeRelationship.getScopingInfoFor(this, measure, hierarchy);
                EList<MeasureScopeType> measureScopes = scope.getMeasureScope();
                if (measureScopes == null || measureScopes.size() <= 0) continue;
                bAllExcluded = ((MeasureScopeType)measureScopes.get(0)).isExcluded();
            }
        }
        if (bAllExcluded) {
            FmNamespace modelObj = (FmNamespace)this.getProject().getRootNamespace();
            NamespaceType ns = (NamespaceType)modelObj.getInternal();
            ns.getScopeRelationship().remove(this.m_emfObject);
        }
        return bAllExcluded;
    }

    private void removeMeasureFromScope(ScopeType scope, Measure measure) {
        EList<MeasureScopeType> measureScopes = scope.getMeasureScope();
        for (MeasureScopeType measureScope : measureScopes) {
            EObject aMeasure = measureScope.getRefobj();
            if (!aMeasure.equals(measure)) continue;
            scope.getMeasureScope().remove((Object)aMeasure);
            break;
        }
        if (scope.getMeasureScope().size() == 0) {
            this.getScopeRelationshipType().getScope().remove((Object)scope);
        }
    }

    private void addMeasureToScope(BaseObject levelOrHierarchy, Measure measure, boolean bExclude) {
        ScopeType scope = this.locateScopeFor(levelOrHierarchy);
        if (scope == null) {
            scope = GenmodelFactory.eINSTANCE.createScopeType();
            scope.setLevelRef((EObject)levelOrHierarchy.getInternal());
            this.getScopeRelationshipType().getScope().add((Object)scope);
        }
        MeasureScopeType newMeasureScope = GenmodelFactory.eINSTANCE.createMeasureScopeType();
        newMeasureScope.setExcluded(bExclude);
        newMeasureScope.setRefobj(((FmMeasure)measure).getMeasureType());
        scope.getMeasureScope().add((Object)newMeasureScope);
    }

    private void addMeasuresToScope(BaseObject levelOrHierarchy, List<Measure> measures, boolean bExclude) {
        ScopeType scope = this.locateScopeFor(levelOrHierarchy);
        if (scope == null) {
            scope = GenmodelFactory.eINSTANCE.createScopeType();
            scope.setLevelRef((EObject)levelOrHierarchy.getInternal());
            this.getScopeRelationshipType().getScope().add((Object)scope);
        }
        MeasureScopeType newMeasureScope = GenmodelFactory.eINSTANCE.createMeasureScopeType();
        newMeasureScope.setExcluded(bExclude);
        for (Measure measure : measures) {
            newMeasureScope.setRefobj(((FmMeasure)measure).getMeasureType());
        }
        scope.getMeasureScope().add((Object)newMeasureScope);
    }

    private ScopeType locateScopeFor(BaseObject levelOrHierarchy) {
        EList<ScopeType> scopes = this.getScopeRelationshipType().getScope();
        for (ScopeType scope : scopes) {
            EObject eobj = scope.getLevelRef();
            if (!levelOrHierarchy.getInternal().equals(eobj)) continue;
            return scope;
        }
        return null;
    }

    public static String getDefaultName(Locale locale) {
        return FmMessage.render("BMT_MDN_OBJECT_NAME_RELATIONSHIP", locale);
    }

    private static FmBaseObject getScopeRelationship(FMMDSession session, FmDimension measureDim, FmDimension regularDim) {
        List<Object> rels = ObjectReferenceHelper.getRelationshipsFor(session.getProject(), measureDim, true);
        for (Object eobj : rels) {
            FmMDException.ASSERT(eobj instanceof ScopeRelationshipType, "Must be scope relationship.");
            FmScopeRelationship fmRel = (FmScopeRelationship)FmModelFactory.getInstance().get(session, eobj);
            RelationshipEnd leftEnd = fmRel.getLeftEnd();
            if (!leftEnd.equals(regularDim)) continue;
            return fmRel;
        }
        return null;
    }

    private static ScopeType getScopingInfoFor(FmScopeRelationship scopeRel, Measure measure, Hierarchy hierarchy) {
        ScopeType scopeType = GenmodelFactory.eINSTANCE.createScopeType();
        EList<MeasureScopeType> measureScopeList = scopeType.getMeasureScope();
        List<Level> hierarchyLevels = hierarchy.getLevels();
        List<FmLevel> scopeLevelRefs = scopeRel.getScopeLevelRefs();
        block0: for (FmLevel level : scopeLevelRefs) {
            if (!hierarchyLevels.contains(level)) continue;
            List<MeasureScopeType> measureScopes = scopeRel.getAllScopedMeasureScopes();
            for (MeasureScopeType measureScope : measureScopes) {
                EObject aMeasure = measureScope.getRefobj();
                if (!aMeasure.equals(measure.getInternal())) continue;
                MeasureScopeType newMeasureScope = GenmodelFactory.eINSTANCE.createMeasureScopeType();
                newMeasureScope.setExcluded(measureScope.isExcluded());
                newMeasureScope.setRefobj(aMeasure);
                measureScopeList.add(newMeasureScope);
                continue block0;
            }
        }
        return scopeType;
    }

    @Override
    public void updateContainership() {
        FmSection newParent = (FmSection)this.determineContainership();
        if (newParent != null) {
            newParent.addScopeRelationship(this);
        }
    }

    @Override
    public void prepareForObjectDeletion(RemoveInfo info, FmBaseObject object, RemoveListener listener) {
        CardinalityType right;
        boolean deleteThis = false;
        CardinalityType left = this.getScopeRelationshipType().getLeft();
        if (left != null && left.getRefobj() == object.getInternal()) {
            left.setRefobj(null);
            deleteThis = true;
        }
        if ((right = this.getScopeRelationshipType().getRight()) != null && right.getRefobj() == object.getInternal()) {
            right.setRefobj(null);
            deleteThis = true;
        }
        EList<ScopeType> types = this.getScopeRelationshipType().getScope();
        Iterator scopeTypeIt = types.iterator();
        while (scopeTypeIt.hasNext()) {
            ScopeType sc = (ScopeType)scopeTypeIt.next();
            if (sc.getLevelRef() == object.getInternal()) {
                sc.setLevelRef(this.m_session.createBrokenReference(object));
                listener.invalidateScopeLevelReference(this);
            }
            EList<MeasureScopeType> scopes = sc.getMeasureScope();
            Iterator it = scopes.iterator();
            while (it.hasNext()) {
                MeasureScopeType ro = (MeasureScopeType)it.next();
                if (ro.getRefobj() != object.getInternal()) continue;
                it.remove();
            }
            if (scopes.size() != 0) continue;
            scopeTypeIt.remove();
        }
        if (deleteThis) {
            this.getFmProject().prepareForObjectDeletion(info, this, listener);
            listener.impactedObjectForDeletion(this);
            this.m_session.getGateway().delete(this.getInternal());
        }
    }

    @Override
    public void getReferencedObjects(Set<BaseObject> objects) {
        CardinalityType right;
        CardinalityType left = this.getScopeRelationshipType().getLeft();
        if (left != null && left.getRefobj() != null) {
            objects.add(FmModelFactory.getInstance().get(this.m_session, left.getRefobj()));
        }
        if ((right = this.getScopeRelationshipType().getRight()) != null && right.getRefobj() != null) {
            objects.add(FmModelFactory.getInstance().get(this.m_session, right.getRefobj()));
        }
        EList<ScopeType> types = this.getScopeRelationshipType().getScope();
        for (ScopeType sc : types) {
            EObject lr = sc.getLevelRef();
            if (lr != null) {
                objects.add(FmModelFactory.getInstance().get(this.m_session, lr));
            }
            EList<MeasureScopeType> scopes = sc.getMeasureScope();
            for (MeasureScopeType ro : scopes) {
                if (ro.getRefobj() == null) continue;
                objects.add(FmModelFactory.getInstance().get(this.m_session, lr));
            }
        }
    }

    public void addScopes(List<Scope> scopes) {
        EList<ScopeType> incomingScopeType = this.getScopeRelationshipType().getScope();
        for (Scope s : scopes) {
            incomingScopeType.add(((FmScope)s).getScope());
        }
    }

    @Override
    public void addScope(Scope scope) {
        EList<ScopeType> scopeTypes = this.getScopeRelationshipType().getScope();
        scopeTypes.add(((FmScope)scope).getScope());
    }

    @Override
    public Scope createScopeForRelationship(Level newLevel, Measure measure, boolean excluded) {
        return FmScope.createScope(this.m_session, newLevel, measure, excluded, this);
    }

    @Override
    public Scope createScopeForRelationship(BaseObject bo) {
        return FmScope.createScope(this.m_session, bo, this);
    }
}

