/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmComplexProperty;
import com.ibm.cognos.fmeng.genmodel.DisplayPathType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.SecurityObjectType;
import com.ibm.cognos.fmeng.genmodel.SecurityType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;

public class FmSecurityObject
extends FmComplexProperty {
    private String m_cmSearchPath = "";
    private short m_type = 0;
    private String m_displayPath = "";
    private SecurityObjectType m_emfObj;
    public static final short ACCOUNT = 0;
    public static final short ROLE = 1;
    public static final short GROUP = 2;

    public static FmSecurityObject get(FMMDSession session, Object object) {
        FmSecurityObject fmSecObj = null;
        if (object != null) {
            FmMDException.ASSERT(object instanceof SecurityObjectType, null);
            SecurityObjectType secObj = (SecurityObjectType)object;
            short type = 0;
            if (secObj.getType() == SecurityType.ACCOUNT) {
                type = 0;
            } else if (secObj.getType() == SecurityType.GROUP) {
                type = 2;
            } else if (secObj.getType() == SecurityType.ROLE) {
                type = 1;
            }
            fmSecObj = new FmSecurityObject(session, object, secObj.getCmSearchPath(), type, secObj.getDisplayPath().getValue());
        }
        return fmSecObj;
    }

    public static FmSecurityObject createTransient(FMMDSession session, String searchPath, short type, String displayPath) {
        return new FmSecurityObject(session, null, searchPath, type, displayPath);
    }

    public static FmSecurityObject createPersistent(FMMDSession session, String searchPath, short type, String displayPath) {
        SecurityObjectType emfObj = GenmodelFactory.eINSTANCE.createSecurityObjectType();
        emfObj.setCmSearchPath(searchPath);
        switch (type) {
            case 2: {
                emfObj.setType(SecurityType.GROUP);
                break;
            }
            case 1: {
                emfObj.setType(SecurityType.ROLE);
                break;
            }
            case 0: {
                emfObj.setType(SecurityType.ACCOUNT);
            }
        }
        DisplayPathType displayPathObj = GenmodelFactory.eINSTANCE.createDisplayPathType();
        displayPathObj.setValue(displayPath);
        emfObj.setDisplayPath(displayPathObj);
        return new FmSecurityObject(session, emfObj, searchPath, type, displayPath);
    }

    private FmSecurityObject(FMMDSession session, Object obj, String searchPath, short type, String displayPath) {
        super(session, obj);
        if (obj != null) {
            FmMDException.ASSERT(obj instanceof SecurityObjectType, null);
        }
        this.m_emfObj = (SecurityObjectType)obj;
        this.m_cmSearchPath = searchPath;
        this.m_type = type;
        this.m_displayPath = displayPath;
    }

    SecurityObjectType getSecurityObjectType() {
        return this.m_emfObj;
    }

    public String getCMSearchPath() {
        return this.m_cmSearchPath;
    }

    public void setCMSearchPath(String searchPath) {
        this.m_emfObj.setCmSearchPath(searchPath);
    }

    public static FmSecurityObject getEveryoneRole() {
        return null;
    }

    String getDisplayPath() {
        return this.m_displayPath;
    }

    public String getDisplayPathDynamic() {
        DisplayPathType displayPathObj = this.m_emfObj.getDisplayPath();
        return displayPathObj.getValue();
    }

    public void setDisplayPath(String displayPath) {
        DisplayPathType displayPathObj = this.m_emfObj.getDisplayPath();
        displayPathObj.setValue(displayPath);
    }

    public short getType() {
        return this.m_type;
    }

    public boolean isTransient() {
        return this.m_emfObj == null;
    }
}

