/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmEMDObjectNaming;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFunctionSet;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPackage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQosOverride;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSecurityObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSecurityViews;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveListener;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.genmodel.AccessType;
import com.ibm.cognos.fmeng.genmodel.DecisionRoleType;
import com.ibm.cognos.fmeng.genmodel.FunctionSetType;
import com.ibm.cognos.fmeng.genmodel.FunctionSetsType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.IncludeRuleType;
import com.ibm.cognos.fmeng.genmodel.QosOverrideType;
import com.ibm.cognos.fmeng.genmodel.QosOverridesType;
import com.ibm.cognos.fmeng.genmodel.SecurityDefinitionSetType;
import com.ibm.cognos.fmeng.genmodel.SecurityObjectType;
import com.ibm.cognos.fmeng.genmodel.SecurityViewType;
import com.ibm.cognos.fmeng.genmodel.ViewDefinitionType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmSecurityView
extends FmModelObject {
    private FmSecurityView(FMMDSession session, SecurityViewType emfObject) {
        super(session, emfObject);
    }

    public static FmSecurityView get(FMMDSession session, Object emfobj) {
        return new FmSecurityView(session, (SecurityViewType)emfobj);
    }

    public static FmSecurityView createObject(FMMDSession session, FmSecurityViews parent, String objectName, FmEMDObjectNaming makeUniqueRule) {
        if (objectName == null || objectName.length() == 0) {
            objectName = FmSecurityView.getDefaultName(session.getActiveLocale());
        }
        SecurityViewType emfObj = GenmodelFactory.eINSTANCE.createSecurityViewType();
        AccessType eAccessType = GenmodelFactory.eINSTANCE.createAccessType();
        emfObj.setAccess(eAccessType);
        QosOverridesType eQOSOverrides = GenmodelFactory.eINSTANCE.createQosOverridesType();
        emfObj.setQosOverrides(eQOSOverrides);
        FmSecurityView view = new FmSecurityView(session, emfObj);
        parent.addSecurityView(view);
        String uniqueName = view.makeUniqueName(objectName);
        view.setName(uniqueName);
        return view;
    }

    @Override
    public FmObjectType getFmObjectType() {
        return FmObjectType.securityView;
    }

    SecurityViewType getSecurityViewType() {
        return (SecurityViewType)this.m_emfObject;
    }

    public List<FmSecurityObject> getSecurityObjects() {
        DecisionRoleType dRole;
        ArrayList<FmSecurityObject> securityObjs = null;
        AccessType at = this.getSecurityViewType().getAccess();
        EList<SecurityObjectType> securityObjectEobjs = null;
        if (at != null && (dRole = at.getDecisionRole()) != null) {
            securityObjectEobjs = dRole.getSecurityObject();
        }
        if (securityObjectEobjs != null) {
            securityObjs = new ArrayList(securityObjectEobjs.size());
            for (SecurityObjectType st : securityObjectEobjs) {
                FmSecurityObject secObj = FmSecurityObject.get(this.m_session, st);
                securityObjs.add(secObj);
            }
        } else {
            securityObjs = new ArrayList<FmSecurityObject>(0);
        }
        return securityObjs;
    }

    public FmPackage getPackage() {
        List<FmPackage> packages = this.getFmProject().getPackagesFolder().getPackageCollection();
        for (FmPackage var : packages) {
            if (!this.equals(var.getSecurityView())) continue;
            return var;
        }
        return null;
    }

    public String getDefaultName() {
        return FmSecurityView.getDefaultName(this.getFmProject().getDefaultLocale1());
    }

    public static String getDefaultName(Locale locale) {
        return FmMessage.render("BMT_MDN_OBJECT_NAME_SECURITYVIEW", locale);
    }

    public void setDefinition(List<ReportObject> includeObjs, List<ReportObject> excludeObjs, List<ReportObject> hideObjs, List<FmSecurityView> includeViews) {
        ViewDefinitionType emfViewDef = this.getSecurityViewType().getDefinition();
        if (emfViewDef == null) {
            emfViewDef = GenmodelFactory.eINSTANCE.createViewDefinitionType();
            ((SecurityViewType)this.m_emfObject).setDefinition(emfViewDef);
        }
        EList<SecurityDefinitionSetType> sets = emfViewDef.getSet();
        sets.clear();
        if (includeObjs != null && includeObjs.size() > 0 || includeViews != null && includeViews.size() > 0) {
            sets.add(this.createSecurityDefinitionSet(IncludeRuleType.INCLUDE, includeObjs, includeViews));
        }
        if (excludeObjs != null && excludeObjs.size() > 0) {
            sets.add(this.createSecurityDefinitionSet(IncludeRuleType.EXCLUDE, excludeObjs, null));
        }
        if (hideObjs != null && hideObjs.size() > 0) {
            sets.add(this.createSecurityDefinitionSet(IncludeRuleType.HIDE, hideObjs, null));
        }
    }

    private SecurityDefinitionSetType getDefinitionSet(IncludeRuleType rule) {
        EList<SecurityDefinitionSetType> sets;
        ViewDefinitionType emfViewDef = ((SecurityViewType)this.m_emfObject).getDefinition();
        if (emfViewDef != null && (sets = emfViewDef.getSet()) != null) {
            int i = 0;
            while (i < sets.size()) {
                SecurityDefinitionSetType set = (SecurityDefinitionSetType)sets.get(i);
                if (set.getIncludeRule() == rule) {
                    return set;
                }
                ++i;
            }
        }
        return null;
    }

    private SecurityDefinitionSetType createSecurityDefinitionSet(IncludeRuleType rule, List<ReportObject> objList, List<FmSecurityView> viewList) {
        TopLevelObject fmObj;
        int i;
        SecurityDefinitionSetType setDef = GenmodelFactory.eINSTANCE.createSecurityDefinitionSetType();
        setDef.setIncludeRule(rule);
        if (objList != null) {
            EList<EObject> objRefs = setDef.getRefobj();
            i = 0;
            while (i < objList.size()) {
                fmObj = objList.get(i);
                objRefs.add((EObject)fmObj.getInternal());
                ++i;
            }
        }
        if (viewList != null) {
            EList<EObject> viewRefs = setDef.getViewref();
            i = 0;
            while (i < viewList.size()) {
                fmObj = viewList.get(i);
                viewRefs.add((EObject)((FmBaseObject)((Object)fmObj)).getInternal());
                ++i;
            }
        }
        return setDef;
    }

    public void setSecurity(List<FmSecurityObject> securityObjects) {
        DecisionRoleType decisionRole;
        SecurityViewType view = this.getSecurityViewType();
        AccessType accessType = view.getAccess();
        if (accessType == null) {
            accessType = GenmodelFactory.eINSTANCE.createAccessType();
            view.setAccess(accessType);
        }
        if ((decisionRole = accessType.getDecisionRole()) == null) {
            decisionRole = GenmodelFactory.eINSTANCE.createDecisionRoleType();
            accessType.setDecisionRole(decisionRole);
        }
        EList<SecurityObjectType> secList = decisionRole.getSecurityObject();
        secList.clear();
        int i = 0;
        while (i < securityObjects.size()) {
            FmSecurityObject fmSecObj = securityObjects.get(i);
            FmMDException.ASSERT(!fmSecObj.isTransient(), "Expected a persistent version of the SecurityObject");
            secList.add(fmSecObj.getSecurityObjectType());
            ++i;
        }
    }

    public void getAllReferencedViews(List<FmSecurityView> views) {
        views.add(this);
        SecurityDefinitionSetType set = this.getDefinitionSet(IncludeRuleType.INCLUDE);
        if (set != null) {
            EList<EObject> list = set.getViewref();
            int i = 0;
            while (i < list.size()) {
                FmSecurityView nextView = FmSecurityView.get(this.m_session, list.get(i));
                views.add(nextView);
                nextView.getAllReferencedViews(views);
                ++i;
            }
        }
    }

    private List<Object> getConsolidatedSet(IncludeRuleType setType) {
        ArrayList<Object> consolidatedSet = new ArrayList<Object>();
        ArrayList<FmSecurityView> views = new ArrayList<FmSecurityView>();
        this.getAllReferencedViews(views);
        int i = 0;
        while (i < views.size()) {
            FmSecurityView curView = (FmSecurityView)views.get(i);
            SecurityDefinitionSetType set = curView.getDefinitionSet(setType);
            if (set != null) {
                EList<EObject> objList = set.getRefobj();
                consolidatedSet.addAll((Collection<Object>)objList);
            }
            ++i;
        }
        if (views.size() > 1) {
            this.removeRedundancies(consolidatedSet);
        }
        return consolidatedSet;
    }

    public List<BaseObject> getIncludeSet() {
        List<Object> includeSet = this.getConsolidatedIncludeSet();
        ArrayList<BaseObject> objs = new ArrayList<BaseObject>(includeSet.size());
        for (Object obj : includeSet) {
            objs.add(FmModelFactory.getInstance().get(this.m_session, obj));
        }
        return objs;
    }

    public List<Object> getConsolidatedIncludeSet() {
        return this.getConsolidatedSet(IncludeRuleType.INCLUDE);
    }

    public List<Object> getConsolidatedExcludeSet() {
        return this.getConsolidatedSet(IncludeRuleType.EXCLUDE);
    }

    public List<Object> getConsolidatedHiddenSet() {
        return this.getConsolidatedSet(IncludeRuleType.HIDE);
    }

    private void removeRedundancies(List<Object> consolidatedSet) {
        if (consolidatedSet.size() > 1) {
            Object root = ((FmBaseObject)((Object)this.getProject().getRootNamespace())).getInternal();
            HashSet<Object> toRemoveSet = new HashSet<Object>();
            for (Object o : consolidatedSet) {
                List<Object> ancestors = this.m_session.getGateway().getAncestorList(o, root);
                for (Object currAnc : ancestors) {
                    if (!consolidatedSet.contains(currAnc)) continue;
                    toRemoveSet.add(o);
                }
            }
            if (toRemoveSet.size() > 0) {
                consolidatedSet.removeAll(toRemoveSet);
            }
        }
    }

    public boolean isObjectIncluded(FmBaseObject obj) {
        return true;
    }

    public boolean isRoleBasedView() {
        SecurityViewType view = this.getSecurityViewType();
        return view.isIsRoleBased();
    }

    public List<FmFunctionSet> getFunctionSets() {
        FunctionSetsType fs = this.getSecurityViewType().getFunctionSets();
        EList<FunctionSetType> functionSets = fs.getFunctionSet();
        ArrayList<FmFunctionSet> res = new ArrayList<FmFunctionSet>(functionSets.size());
        for (FunctionSetType fst : functionSets) {
            res.add(FmFunctionSet.get(this.m_session, fst));
        }
        return res;
    }

    public void removeFunctionSetContainingFunctionId(String value) {
        FunctionSetsType fs = this.getSecurityViewType().getFunctionSets();
        EList<FunctionSetType> functionSets = fs.getFunctionSet();
        Iterator it = functionSets.iterator();
        while (it.hasNext()) {
            FunctionSetType fst = (FunctionSetType)it.next();
            if (!value.equals(fst.getFunctionSetID())) continue;
            it.remove();
        }
    }

    public boolean addFunctionSet(String propValue) {
        FunctionSetsType fs = this.getSecurityViewType().getFunctionSets();
        if (fs == null) {
            fs = GenmodelFactory.eINSTANCE.createFunctionSetsType();
            this.getSecurityViewType().setFunctionSets(fs);
        }
        EList<FunctionSetType> functionSets = fs.getFunctionSet();
        for (FunctionSetType fst : functionSets) {
            if (!propValue.equals(fst.getFunctionSetID())) continue;
            return false;
        }
        FunctionSetType setDef = GenmodelFactory.eINSTANCE.createFunctionSetType();
        setDef.setFunctionSetID(propValue);
        functionSets.add(setDef);
        return true;
    }

    public List<FmQosOverride> getQosOverrides() {
        QosOverridesType fs = this.getSecurityViewType().getQosOverrides();
        EList<QosOverrideType> overRides = fs.getQosOverride();
        ArrayList<FmQosOverride> res = new ArrayList<FmQosOverride>(overRides.size());
        for (QosOverrideType fst : overRides) {
            res.add(FmQosOverride.get(this.m_session, fst));
        }
        return res;
    }

    public void removeQosOverride(FmQosOverride qosOver) {
        QosOverridesType fs = this.getSecurityViewType().getQosOverrides();
        EList<QosOverrideType> overRides = fs.getQosOverride();
        overRides.remove(qosOver.getInternal());
    }

    public void removeQosOverrideWithFunctionId(String value) {
        QosOverridesType fs = this.getSecurityViewType().getQosOverrides();
        EList<QosOverrideType> overRides = fs.getQosOverride();
        Iterator it = overRides.iterator();
        while (it.hasNext()) {
            QosOverrideType qot = (QosOverrideType)it.next();
            if (!value.equals(qot.getFunctionId())) continue;
            it.remove();
        }
    }

    public FmQosOverride addFunctionSetOverride(String propValue) {
        QosOverridesType QosO = this.getSecurityViewType().getQosOverrides();
        if (QosO == null) {
            QosO = GenmodelFactory.eINSTANCE.createQosOverridesType();
            this.getSecurityViewType().setQosOverrides(QosO);
        }
        return FmQosOverride.addFunctionSetOverride(propValue, QosO, this.m_session);
    }

    public FmQosOverride getFunctionSetOverride(String propValue) {
        QosOverridesType QosO = this.getSecurityViewType().getQosOverrides();
        if (QosO == null) {
            return null;
        }
        EList<QosOverrideType> functionSetsOverrides = QosO.getQosOverride();
        for (QosOverrideType ovr : functionSetsOverrides) {
            if (!propValue.equals(ovr.getFunctionId())) continue;
            return FmQosOverride.get(this.m_session, ovr);
        }
        return null;
    }

    @Override
    void prepareForObjectDeletion(RemoveInfo info, FmBaseObject object, RemoveListener listener) {
        FmPackage pkg;
        if (object instanceof FmPackage && this.equals((pkg = (FmPackage)object).getSecurityView())) {
            info.markAsDeletion(this);
            this.remove(info, listener);
        }
        EList<SecurityDefinitionSetType> sets = this.getSecurityViewType().getDefinition().getSet();
        for (SecurityDefinitionSetType set : sets) {
            EList<EObject> refs = set.getRefobj();
            refs.remove(object.getInternal());
            EList<EObject> views = set.getViewref();
            boolean removedRef = views.remove(object.getInternal());
            if (!removedRef) continue;
            listener.securityViewRefRemoved(this);
        }
    }

    public List<FmPackage> getReferencingPackages() {
        ArrayList<FmPackage> res = new ArrayList<FmPackage>();
        List<FmPackage> allPackages = this.getFmProject().getPackagesFolder().getPackageCollection();
        for (FmPackage pkg : allPackages) {
            if (!pkg.getSecurityView().equals(this)) continue;
            res.add(pkg);
        }
        return res;
    }

    public void setIsRoleBased(boolean isRoleBased) {
        this.getSecurityViewType().setIsRoleBased(isRoleBased);
    }

    public void setIsViewBased(boolean isViewBased) {
        this.getSecurityViewType().setIsViewBased(true);
    }
}

