/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPackage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalFilter;
import com.ibm.cognos.fmeng.fmmd.model.FilterApplication;
import com.ibm.cognos.fmeng.fmmd.model.Permission;
import com.ibm.cognos.fmeng.fmmd.model.RelationalFilter;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.SecurityViewDefinition;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.PermissionType;
import com.ibm.cognos.fmeng.genmodel.SecuredObjectType;
import com.ibm.cognos.fmeng.genmodel.SecurityViewDefinitionType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmSecurityViewDefinition
extends FmModelObject
implements SecurityViewDefinition {
    public static FmSecurityViewDefinition createSecurityViewDefinition(FMMDSession session, FmPackage kPackage, String name) {
        SecurityViewDefinitionType securityViewType = GenmodelFactory.eINSTANCE.createSecurityViewDefinitionType();
        securityViewType.setDataSecurity(GenmodelFactory.eINSTANCE.createDataSecurityType());
        securityViewType.setObjectSecurity(GenmodelFactory.eINSTANCE.createObjectSecurityType());
        FmSecurityViewDefinition securityView = new FmSecurityViewDefinition(session, securityViewType);
        kPackage.addSecurityViewDefinition(securityView);
        name = securityView.generateUniqueName(name, securityViewType);
        securityView.setName(name);
        return securityView;
    }

    public static FmSecurityViewDefinition get(FMMDSession session, Object emfObject) {
        return new FmSecurityViewDefinition(session, emfObject);
    }

    public static String getDefaultName(Locale locale) {
        return FmMessage.render("BMT_MDN_OBJECT_NAME_SECURITYVIEW", locale);
    }

    FmSecurityViewDefinition(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    private SecurityViewDefinitionType getSecurityViewDefinitionType() {
        return (SecurityViewDefinitionType)this.m_emfObject;
    }

    @Override
    public FmObjectType getFmObjectType() {
        return FmObjectType.securityViewDefinition;
    }

    @Override
    public void setObjectSecurity(TopLevelObject object, Permission permission) {
        SecuredObjectType securedObject = null;
        for (SecuredObjectType obj : this.getSecurityViewDefinitionType().getObjectSecurity().getSecuredObject()) {
            if (!obj.getRefobj().equals(object.getInternal())) continue;
            securedObject = obj;
            break;
        }
        if (securedObject == null) {
            securedObject = GenmodelFactory.eINSTANCE.createSecuredObjectType();
            securedObject.setRefobj((EObject)object.getInternal());
            this.getSecurityViewDefinitionType().getObjectSecurity().getSecuredObject().add((Object)securedObject);
        }
        switch (permission) {
            case grant: {
                securedObject.setPermission(PermissionType.GRANT);
                break;
            }
            case deny: {
                securedObject.setPermission(PermissionType.DENY);
            }
        }
    }

    @Override
    public void removeSecuredObject(TopLevelObject object) {
        Iterator it = this.getSecurityViewDefinitionType().getObjectSecurity().getSecuredObject().iterator();
        while (it.hasNext()) {
            SecuredObjectType obj = (SecuredObjectType)it.next();
            if (!obj.getRefobj().equals(object.getInternal())) continue;
            it.remove();
            break;
        }
    }

    @Override
    public List<SecurityViewDefinition.SecuredObject> getSecuredObjects() {
        ArrayList<SecurityViewDefinition.SecuredObject> securedObjects = new ArrayList<SecurityViewDefinition.SecuredObject>();
        for (SecuredObjectType obj : this.getSecurityViewDefinitionType().getObjectSecurity().getSecuredObject()) {
            TopLevelObject tlo = FmModelFactory.getInstance().get(this.m_session, obj.getRefobj());
            if (!(tlo instanceof ReportObject)) continue;
            SecurityViewDefinition.SecuredObject securedObject = new SecurityViewDefinition.SecuredObject();
            securedObject.m_object = (ReportObject)tlo;
            switch (obj.getPermission()) {
                case GRANT: {
                    securedObject.m_permission = Permission.grant;
                    break;
                }
                case DENY: {
                    securedObject.m_permission = Permission.deny;
                }
            }
            securedObjects.add(securedObject);
        }
        return securedObjects;
    }

    @Override
    public void addSecurityFilter(RelationalFilter filter) {
        if (!filter.getFilterApplication().equals((Object)FilterApplication.EFilterApplication.security)) {
            throw new FmMDException("BMT_MD_INVALID_FILTER_FOR_SECURITY_VIEW_DEFINITION");
        }
        for (Object obj : this.getSecurityViewDefinitionType().getDataSecurity().getRefobj()) {
            if (!obj.equals(filter.getInternal())) continue;
            return;
        }
        this.getSecurityViewDefinitionType().getDataSecurity().getRefobj().add((Object)((EObject)filter.getInternal()));
    }

    @Override
    public void removeSecurityFilter(RelationalFilter filter) {
        this.getSecurityViewDefinitionType().getDataSecurity().getRefobj().remove(filter.getInternal());
    }

    @Override
    public List<RelationalFilter> getSecurityFilters() {
        ArrayList<RelationalFilter> filters = new ArrayList<RelationalFilter>();
        for (Object obj : this.getSecurityViewDefinitionType().getDataSecurity().getRefobj()) {
            filters.add(FmRelationalFilter.get(this.m_session, obj));
        }
        return filters;
    }

    @Override
    public List<RelationalFilter> getCandidateSecurityFilters() {
        FmPackage kPackage = (FmPackage)this.getParent();
        FmMDException.ASSERT(kPackage != null, "Security view definition is not owned by a package.");
        ArrayList<RelationalFilter> filters = new ArrayList<RelationalFilter>();
        for (RelationalObject obj : kPackage.getAllRelationalObjects()) {
            for (RelationalFilter filter : obj.getAllFilters()) {
                if (!filter.getFilterApplication().equals((Object)FilterApplication.EFilterApplication.security)) continue;
                filters.add(filter);
            }
        }
        Iterator it = filters.iterator();
        while (it.hasNext()) {
            RelationalFilter filter = (RelationalFilter)it.next();
            for (RelationalFilter secFilter : this.getSecurityFilters()) {
                if (!filter.equals(secFilter)) continue;
                it.remove();
            }
        }
        return filters;
    }
}

