/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmComplexProperty;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSortItem;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.SortItem;
import com.ibm.cognos.fmeng.fmmd.model.SortItemParent;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.OrderByType;
import com.ibm.cognos.fmeng.genmodel.SortItemType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmSortItems
extends FmComplexProperty {
    FmSortItems(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    public static FmSortItems get(EMFSession session, OrderByType emfObject) {
        return new FmSortItems(session, emfObject);
    }

    public FmSortItem addDefaultMemberSortItem(QueryItem qi) {
        SortItemType sot2;
        OrderByType obt = this.getOrderByType();
        for (SortItemType sot2 : obt.getSortItem()) {
            EObject refObj = sot2.getRefobj();
            if (refObj == null || !sot2.getRefobj().equals(qi.getInternal())) continue;
            return FmSortItem.get(this.m_session, sot2);
        }
        sot2 = GenmodelFactory.eINSTANCE.createSortItemType();
        obt.getSortItem().add((Object)sot2);
        FmSortItem sortItem = FmSortItem.get(this.m_session, sot2);
        return sortItem;
    }

    public List<SortItem> getMemberSortItems() {
        ArrayList<SortItem> res = new ArrayList<SortItem>();
        for (SortItemType sot : this.getOrderByType().getSortItem()) {
            res.add(FmSortItem.get(this.m_session, sot));
        }
        return res;
    }

    public SortItem addMemberSortItem(SortItemParent parent, QueryItem qi, SortItem.ESortItem value) {
        return this.addMemberSortItem(parent, qi, value, SortItem.ENullPlacement.nullsUnspecified);
    }

    public SortItem addMemberSortItem(SortItemParent parent, QueryItem qi, SortItem.ESortItem value, SortItem.ENullPlacement nullPlacement) {
        boolean bFound = false;
        for (QueryItem item : parent.getAllQueryItems()) {
            if (!item.equals(qi)) continue;
            bFound = true;
            break;
        }
        if (!bFound) {
            if (parent instanceof Level) {
                throw new FmMDException("BMT_MD_INVALID_ITEM_FOR_SORTING_LEVEL");
            }
            throw new FmMDException("BMT_MD_INVALID_ITEM_FOR_SORTING_HIERARCHY");
        }
        FmSortItem sortItem = this.addDefaultMemberSortItem(qi);
        sortItem.setQueryItem(qi);
        sortItem.setSort(value);
        sortItem.setNullPlacement(nullPlacement);
        return sortItem;
    }

    private OrderByType getOrderByType() {
        return (OrderByType)this.m_emfObject;
    }

    public FmSortItem addDefaultMemberSortItem() {
        OrderByType obt = this.getOrderByType();
        SortItemType sot = GenmodelFactory.eINSTANCE.createSortItemType();
        obt.getSortItem().add((Object)sot);
        return FmSortItem.get(this.m_session, sot);
    }

    public void removeFromMemberSort(FmQueryItem item) {
        OrderByType obt = this.getOrderByType();
        if (obt != null) {
            EList<SortItemType> sorts = obt.getSortItem();
            Iterator it = sorts.iterator();
            while (it.hasNext()) {
                SortItemType st = (SortItemType)it.next();
                if (st.getRefobj() != item.getInternal()) continue;
                it.remove();
            }
        }
    }

    public void reorderBefore(SortItem itemToReorder, SortItem before) {
        this.m_session.getGateway().reorderBefore(this.getInternal(), ((FmSortItem)itemToReorder).getInternal(), ((FmSortItem)before).getInternal());
    }

    public void reorderBefore(QueryItem itemToReorder, QueryItem before) {
        SortItem siItemToReorder = this.findMemberSortItem(itemToReorder);
        SortItem siBefore = this.findMemberSortItem(before);
        this.reorderBefore(siItemToReorder, siBefore);
    }

    public SortItem findMemberSortItem(QueryItem itemToFind) {
        if (itemToFind == null) {
            return null;
        }
        for (SortItemType sit : this.getOrderByType().getSortItem()) {
            if (!sit.getRefobj().equals(itemToFind.getInternal())) continue;
            return FmSortItem.get(this.m_session, sit);
        }
        return null;
    }
}

