/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmMemberUniqueName;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSourceObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualMember;
import com.ibm.cognos.fmeng.fmmd.model.MemberUniqueName;
import com.ibm.cognos.fmeng.fmmd.model.MemberUniqueNameBuilder;
import com.ibm.cognos.fmeng.fmmd.model.SourceMember;
import com.ibm.cognos.fmeng.fmmd.model.SourceObject;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.MunType;
import com.ibm.cognos.fmeng.genmodel.SourceMemberType;
import com.ibm.cognos.fmeng.genmodel.SourceObjectType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import org.eclipse.emf.ecore.EObject;

public class FmSourceMember
extends FmModelObject
implements SourceMember {
    public static SourceMember createSourceMember(FMMDSession session, FmVirtualMember fmVirtualMember, SourceObject srcHierarchy, MemberUniqueNameBuilder munBuilder) {
        SourceMemberType emfObj = GenmodelFactory.eINSTANCE.createSourceMemberType();
        FmSourceMember srcMember = new FmSourceMember(session, emfObj);
        srcMember.setParentMember(munBuilder);
        srcMember.setSourceParent(srcHierarchy);
        fmVirtualMember.addSourceMember(srcMember);
        srcMember.setName(srcMember.getMemberUniqueName().getMemberCaption());
        return srcMember;
    }

    public static FmSourceMember get(FMMDSession session, Object object) {
        return new FmSourceMember(session, object);
    }

    private FmSourceMember(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    private SourceMemberType getSourceMemberType() {
        return (SourceMemberType)this.m_emfObject;
    }

    public FmObjectType getFmObjectType() {
        return FmObjectType.sourceMember;
    }

    public MemberUniqueName getMemberUniqueName() {
        MunType mun = this.getSourceMemberType().getSourceMemberUniqueName();
        if (mun == null) {
            return null;
        }
        return FmMemberUniqueName.get(this.m_session, mun);
    }

    public SourceObject getSourceParent() {
        SourceObjectType src = (SourceObjectType)this.getSourceMemberType().getSourceParent();
        if (src == null) {
            return null;
        }
        return FmSourceObject.get(this.m_session, src);
    }

    public void setSourceParent(SourceObject srcHierarchy) {
        this.getSourceMemberType().setSourceParent((EObject)srcHierarchy.getInternal());
    }

    public MemberUniqueName setParentMember(MemberUniqueNameBuilder munBuilder) {
        FmMemberUniqueName newMun = FmMemberUniqueName.create(this.m_session, munBuilder);
        this.getSourceMemberType().setSourceMemberUniqueName(newMun.getMemberUniqueNameType());
        return newMun;
    }

    public boolean getHidden() {
        return this.getSourceMemberType().isHidden();
    }

    public void setHidden(boolean hidden) {
        this.getSourceMemberType().setHidden(hidden);
    }

    public String getSourceMemberUniqueName() {
        String cubeName = this.getSourceParent().getCubeSource().getSourceName();
        String uniqueName = "[" + cubeName + "]." + this.getMemberUniqueName().getV5MemberUniqueName(null, false);
        return uniqueName;
    }

    public void setName(String value) {
        this.getSourceMemberType().setName(value);
    }

    public String getID() {
        return "";
    }

    public SourceObject getCubeSource() {
        SourceObjectType src = (SourceObjectType)this.getSourceMemberType().getSourceParent();
        while (src != null) {
            if (src.getSourceParent() == null) {
                return FmSourceObject.get(this.m_session, src);
            }
            src = (SourceObjectType)src.getSourceParent();
        }
        FmMDException.ASSERT(false, "No source cube found.");
        return null;
    }
}

