/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationship;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveListener;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.CubeBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipEnd;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.SourceObject;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.SourceObjectType;
import com.ibm.cognos.fmeng.metadata.MdCube;
import com.ibm.cognos.fmeng.metadata.MdOLAPBase;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import org.eclipse.emf.ecore.EObject;

public class FmSourceObject
extends FmModelObject
implements SourceObject {
    public static SourceObject createCubeSource(FMMDSession session, FmVirtualObject virtualObj, CubeBase cube) {
        FmSourceObject source = FmSourceObject.createSourceInternal(session, virtualObj, null, cube.getName());
        source.getSourceObjectType().setModelSource((EObject)cube.getInternal());
        return source;
    }

    public static SourceObject createCubeSource(FMMDSession session, FmVirtualObject virtualObj, MdCube cube) {
        FmSourceObject source = FmSourceObject.createSourceInternal(session, virtualObj, null, cube.getName());
        source.getSourceObjectType().setSourceName(cube.getName());
        source.getSourceObjectType().setSourcePath(cube.getCMPath());
        return source;
    }

    public static FmSourceObject createSourceObject(FMMDSession session, FmVirtualObject parent, FmSourceObject parentSource, ReportObject sourceObject) {
        FmSourceObject source = FmSourceObject.createSourceInternal(session, parent, parentSource, sourceObject.getName());
        source.getSourceObjectType().setModelSource((EObject)sourceObject.getInternal());
        return source;
    }

    public static FmSourceObject createSourceObject(FMMDSession session, FmVirtualObject parent, FmSourceObject parentSource, MdOLAPBase sourceObject) {
        FmSourceObject source = FmSourceObject.createSourceInternal(session, parent, parentSource, sourceObject.getName());
        source.getSourceObjectType().setSourceName(sourceObject.getName());
        return source;
    }

    public static FmSourceObject get(FMMDSession session, Object emfObj) {
        return new FmSourceObject(session, emfObj);
    }

    private static FmSourceObject createSourceInternal(FMMDSession session, FmVirtualObject virtualObj, FmSourceObject parent, String name) {
        SourceObjectType source = GenmodelFactory.eINSTANCE.createSourceObjectType();
        if (parent != null) {
            source.setSourceParent((EObject)parent.getInternal());
        }
        FmSourceObject fmSource = new FmSourceObject(session, source);
        virtualObj.addSourceObject(fmSource);
        String uniqueName = fmSource.makeUniqueName(name);
        source.setName(uniqueName);
        return fmSource;
    }

    private FmSourceObject(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    private SourceObjectType getSourceObjectType() {
        return (SourceObjectType)this.m_emfObject;
    }

    public String getSourceName() {
        EObject modelSource = this.getSourceObjectType().getModelSource();
        if (modelSource != null) {
            return ((FmReportObject)FmObjectType.get(this.getSession(), modelSource)).getName();
        }
        return this.getSourceObjectType().getSourceName();
    }

    public SourceObject getSourceParent() {
        EObject sourceParent = this.getSourceObjectType().getSourceParent();
        if (sourceParent != null) {
            return FmSourceObject.get(this.getSession(), sourceParent);
        }
        return null;
    }

    public String getSourcePath() {
        EObject sourceParent = this.getSourceObjectType().getSourceParent();
        if (sourceParent == null) {
            EObject modelSource = this.getSourceObjectType().getModelSource();
            if (modelSource != null) {
                return "CAMID(\\\":\\\")/rolapDataSource[@name=\"" + ((FmReportObject)FmObjectType.get(this.m_session, modelSource)).getName() + "\"]";
            }
            return this.getSourceObjectType().getSourcePath();
        }
        return null;
    }

    public TopLevelObject getModelSource() {
        EObject modelSource = this.getSourceObjectType().getModelSource();
        if (modelSource != null) {
            return FmObjectType.get(this.getSession(), modelSource);
        }
        return null;
    }

    public FmObjectType getFmObjectType() {
        return FmObjectType.sourceObject;
    }

    public boolean isModelSource() {
        SourceObjectType src = this.getSourceObjectType();
        while (src != null) {
            if (src.getSourceParent() == null) {
                return src.getModelSource() != null;
            }
            src = (SourceObjectType)src.getSourceParent();
        }
        FmMDException.ASSERT(false, "Should never get here.");
        return false;
    }

    public void setHidden(boolean hidden) {
        EObject sourceParent = this.getSourceObjectType().getSourceParent();
        FmMDException.ASSERT(sourceParent != null, "You can't set sources for cubes to hidden");
        this.getSourceObjectType().setHidden(hidden);
    }

    public boolean getHidden() {
        EObject sourceParent = this.getSourceObjectType().getSourceParent();
        if (sourceParent == null) {
            return false;
        }
        return this.getSourceObjectType().isHidden();
    }

    public void prepareForObjectDeletion(RemoveInfo info, FmBaseObject object, RemoveListener listener) {
        if (object instanceof FmRelationship) {
            FmRelationship deletedRelationship = (FmRelationship)object;
            RelationshipEnd leftEnd = deletedRelationship.getLeftEnd();
            RelationshipEnd rightEnd = deletedRelationship.getRightEnd();
            FmRelationalDimension deletedDimension = null;
            if (leftEnd instanceof FmRelationalDimension) {
                deletedDimension = (FmRelationalDimension)leftEnd;
            } else if (rightEnd instanceof FmRelationalDimension) {
                deletedDimension = (FmRelationalDimension)rightEnd;
            }
            if (deletedDimension != null) {
                TopLevelObject mySourceObject;
                TopLevelObject myOriginatingCube;
                CubeBase deletedFromCube = deletedRelationship.getAncestorCubeOrVirtual();
                SourceObject myCubeSource = this.getCubeSource();
                if (deletedFromCube != null && myCubeSource != null && deletedFromCube.equals(myOriginatingCube = myCubeSource.getModelSource()) && deletedDimension.equals(mySourceObject = this.getModelSource())) {
                    this.getSession().delete(this);
                }
            }
        } else if (object instanceof FmSourceObject) {
            FmSourceObject srcParent = (FmSourceObject)object;
            if (srcParent.equals(this.getSourceParent())) {
                this.getSession().delete(this);
            }
        } else {
            TopLevelObject src = this.getModelSource();
            if (object.equals(src)) {
                this.getSession().delete(this);
            }
        }
    }

    public boolean compareSource(SourceObject right) {
        FmSourceObject rightObj = (FmSourceObject)right;
        if (this.getSourceObjectType().getModelSource() != null && rightObj.getSourceObjectType().getModelSource() != null) {
            return this.getSourceObjectType().getModelSource().equals(rightObj.getSourceObjectType().getModelSource());
        }
        if (this.getSourceObjectType().getModelSource() == null && rightObj.getSourceObjectType().getModelSource() != null) {
            return false;
        }
        if (this.getSourceObjectType().getModelSource() != null && rightObj.getSourceObjectType().getModelSource() == null) {
            return false;
        }
        String leftSourceName = this.getSourceObjectType().getSourceName();
        String rightSourceName = rightObj.getSourceObjectType().getSourceName();
        if (leftSourceName == null && rightSourceName == null) {
            return true;
        }
        if (leftSourceName == null && rightSourceName != null) {
            return false;
        }
        if (leftSourceName != null && rightSourceName == null) {
            return false;
        }
        return this.getSourceObjectType().getSourceName().equals(rightObj.getSourceObjectType().getSourceName());
    }

    public SourceObject getCubeSource() {
        SourceObjectType src = this.getSourceObjectType();
        while (src != null) {
            if (src.getSourceParent() == null) {
                return FmSourceObject.get(this.m_session, src);
            }
            src = (SourceObjectType)src.getSourceParent();
        }
        FmMDException.ASSERT(false, "No source cube found.");
        return null;
    }

    public MdOLAPBase getMetadataSource() {
        if (!this.isModelSource()) {
            return this.getSession().findMetadataObject(this);
        }
        return null;
    }

    public void resetModelSource() {
        this.getSourceObjectType().setModelSource(null);
    }

    public boolean repair() {
        if (this.isModelSource() && this.getSourceObjectType().getModelSource() == null && this.getSourceObjectType().getSourceName() != null) {
            FmSourceObject srcParent = (FmSourceObject)this.getSourceParent();
            if (srcParent.getModelSource() != null) {
                TopLevelObject baseObj = srcParent.getModelSource();
                for (BaseObject childObj : baseObj.getChildObjects()) {
                    if (!childObj.getName().equals(this.getSourceObjectType().getSourceName()) || !(childObj instanceof FmReportObject)) continue;
                    this.getSourceObjectType().setModelSource((EObject)childObj.getInternal());
                    return true;
                }
                return false;
            }
            return false;
        }
        return true;
    }
}

