/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmComplexProperty;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmProcParameter;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.FmRegularAggregate;
import com.ibm.cognos.fmeng.fmmd.model.StoredProcedure;
import com.ibm.cognos.fmeng.genmodel.DataSourceType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.RoutineProcParameterType;
import com.ibm.cognos.fmeng.genmodel.RoutineProcParametersType;
import com.ibm.cognos.fmeng.genmodel.StoredProcedureType;
import com.ibm.cognos.fmeng.genmodel.routineType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmStoredProcedure
extends FmComplexProperty
implements StoredProcedure {
    static FmStoredProcedure get(EMFSession session, Object sp) {
        FmStoredProcedure storedProc = null;
        if (sp != null) {
            FmMDException.ASSERT(sp instanceof StoredProcedureType, null);
            storedProc = new FmStoredProcedure(session, sp);
        }
        return storedProc;
    }

    FmStoredProcedure(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    protected void init(DataSource dataSource, String canonicalName, EProcType type) {
        this.setDataSource(dataSource);
        this.setCanonicalName(canonicalName);
        this.setType(type);
        RoutineProcParametersType params = GenmodelFactory.eINSTANCE.createRoutineProcParametersType();
        this.getStoredProcedureType().setProcParameters(params);
    }

    private StoredProcedureType getStoredProcedureType() {
        return (StoredProcedureType)this.m_emfObject;
    }

    public List<FmProcParameter> getProcParameters() {
        RoutineProcParametersType params = this.getStoredProcedureType().getProcParameters();
        EList<RoutineProcParameterType> procParams = params.getProcParameter();
        ArrayList<FmProcParameter> res = new ArrayList<FmProcParameter>(procParams.size());
        for (RoutineProcParameterType procParam : procParams) {
            res.add(FmProcParameter.get(this.m_session, procParam));
        }
        return res;
    }

    @Override
    public void addProcParameter(FmRegularAggregate agg, FmDatatype datatype, StoredProcedure.EParamMode mode, boolean nullable, String name, int precision, int scale, long size) {
        RoutineProcParametersType params = this.getStoredProcedureType().getProcParameters();
        EList<RoutineProcParameterType> procParams = params.getProcParameter();
        RoutineProcParameterType procParam = GenmodelFactory.eINSTANCE.createRoutineProcParameterType();
        FmProcParameter param = FmProcParameter.get(this.m_session, procParam);
        param.setAggregationRule(agg);
        param.setDatatype(datatype);
        param.setMode(mode);
        param.setNullable(nullable);
        param.setParameterName(name);
        param.setPrecision(precision);
        param.setScale(scale);
        param.setSize(size);
        procParams.add((RoutineProcParameterType)param.getInternal());
    }

    public void removeProcParameter(FmProcParameter fmProcParameter) {
        RoutineProcParametersType params = this.getStoredProcedureType().getProcParameters();
        EList<RoutineProcParameterType> procParams = params.getProcParameter();
        procParams.remove(fmProcParameter.getInternal());
    }

    public void moveProcParameter(FmProcParameter prop, FmProcParameter beforeProp) {
        EList<RoutineProcParameterType> definitions = this.getStoredProcedureType().getProcParameters().getProcParameter();
        definitions.remove(prop.getInternal());
        if (beforeProp != null) {
            int index = definitions.indexOf(beforeProp.getInternal());
            definitions.add(index, prop.getProcParameter());
        } else {
            definitions.add(prop.getProcParameter());
        }
    }

    public void setDataSource(DataSource dataSource) {
        DataSourceType ds = (DataSourceType)dataSource.getInternal();
        this.getStoredProcedureType().setDataSourceRef(ds);
    }

    public void setCanonicalName(String canonicalName) {
        this.getStoredProcedureType().setCanonicalName(canonicalName);
    }

    public void setType(EProcType type) {
        this.getStoredProcedureType().setType(routineType.get(type.toString()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EProcType {
        unknown,
        procedure,
        other;

    }
}

