/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FilterDefinitionParentInternal;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDataSource;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFilterDefinition;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmJoin;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPhysicalDefinition;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPseudoModelObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTableDeterminant;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.FilterDefinition;
import com.ibm.cognos.fmeng.fmmd.model.Join;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.RelationalQuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.fmmd.model.TableDeterminant;
import com.ibm.cognos.fmeng.fmmd.util.Joinable;
import com.ibm.cognos.fmeng.genmodel.FilterDefinitionType;
import com.ibm.cognos.fmeng.genmodel.FiltersType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.JoinType;
import com.ibm.cognos.fmeng.genmodel.PhysicalDefinitionType;
import com.ibm.cognos.fmeng.genmodel.RelationalObjectType;
import com.ibm.cognos.fmeng.genmodel.TableDeterminantType;
import com.ibm.cognos.fmeng.genmodel.TableType;
import com.ibm.cognos.fmeng.metadata.MdCatalog;
import com.ibm.cognos.fmeng.metadata.MdSchema;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmTable
extends FmPseudoModelObject
implements Table,
Joinable<FmTable, FmJoin>,
Comparable<FmTable>,
FilterDefinitionParentInternal {
    FmTable(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    public static FmTable createTable(FMMDSession session, FmPhysicalDefinition fmPhysicalDefinition, FmDataSource ds, String name) {
        String id = fmPhysicalDefinition.makeObjectNameUnique(name, 169);
        TableType tableType = GenmodelFactory.eINSTANCE.createTableType();
        tableType.setTableName(name);
        tableType.setName(id);
        FmTable table = new FmTable(session, tableType);
        table.setDataSource(ds);
        fmPhysicalDefinition.addTable(table);
        return table;
    }

    public static FmTable get(FMMDSession session, Object emfobj) {
        return new FmTable(session, (TableType)emfobj);
    }

    public TableType getTableType() {
        return (TableType)this.m_emfObject;
    }

    @Override
    public void setName(String name) {
        FmMDException.ASSERT(false, "Unable to rename tables");
    }

    @Override
    public String getTableName() {
        return this.getTableType().getTableName();
    }

    private void setDataSource(FmDataSource ds) {
        this.getTableType().setDataSourceRef(ds.getAsDataSourceType());
    }

    @Override
    public FmDataSource getDataSource() {
        if (this.getTableType().getDataSourceRef() != null) {
            return FmDataSource.get(this.m_session, this.getTableType().getDataSourceRef());
        }
        return null;
    }

    public String toString() {
        return "Table: " + this.getTableName() + ", data source: " + this.getDataSource().getName();
    }

    @Override
    public List<FmJoin> getJoins() {
        String id = this.getName();
        ArrayList<FmJoin> joins = new ArrayList<FmJoin>();
        PhysicalDefinitionType parentObject = (PhysicalDefinitionType)this.getTableType().eContainer();
        for (JoinType someJoin : parentObject.getJoin()) {
            if (!someJoin.getLeftPhysicalObjectRef().equals(id) && !someJoin.getRightPhysicalObjectRef().equals(id)) continue;
            joins.add(FmJoin.get(this.m_session, someJoin));
        }
        return joins;
    }

    @Override
    public List<Join> getLeftToRightJoins(Table right) {
        String leftId = this.getName();
        String rightId = right.getName();
        ArrayList<Join> joins = new ArrayList<Join>();
        PhysicalDefinitionType parentObject = (PhysicalDefinitionType)this.getTableType().eContainer();
        for (JoinType someJoin : parentObject.getJoin()) {
            if (!someJoin.getLeftPhysicalObjectRef().equals(leftId) || !someJoin.getRightPhysicalObjectRef().equals(rightId)) continue;
            joins.add(FmJoin.get(this.m_session, someJoin));
        }
        return joins;
    }

    public List<Join> getJoins(Table right) {
        String leftId = this.getName();
        String rightId = right.getName();
        ArrayList<Join> joins = new ArrayList<Join>();
        PhysicalDefinitionType parentObject = (PhysicalDefinitionType)this.getTableType().eContainer();
        for (JoinType someJoin : parentObject.getJoin()) {
            if (someJoin.getLeftPhysicalObjectRef().equals(leftId) && someJoin.getRightPhysicalObjectRef().equals(rightId)) {
                joins.add(FmJoin.get(this.m_session, someJoin));
                continue;
            }
            if (!someJoin.getLeftPhysicalObjectRef().equals(rightId) || !someJoin.getRightPhysicalObjectRef().equals(leftId)) continue;
            joins.add(FmJoin.get(this.m_session, someJoin));
        }
        return joins;
    }

    @Override
    public int compareTo(FmTable right) {
        return this.getName().compareTo(right.getName());
    }

    @Override
    public boolean hasJoin(Table otherTable) {
        PhysicalDefinitionType parentObject = (PhysicalDefinitionType)this.getTableType().eContainer();
        for (JoinType someJoin : parentObject.getJoin()) {
            if (someJoin.getLeftPhysicalObjectRef().equals(this.getName()) && someJoin.getRightPhysicalObjectRef().equals(otherTable.getName())) {
                return true;
            }
            if (!someJoin.getLeftPhysicalObjectRef().equals(otherTable.getName()) || !someJoin.getRightPhysicalObjectRef().equals(this.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<QueryItemMapping> getQueryItemMappings() {
        FmPhysicalDefinition parent = FmPhysicalDefinition.get(this.m_session, this.getTableType().eContainer());
        return parent.getQueryItemMappings(this);
    }

    @Override
    public RelationalObject getRelationalParent() {
        EObject obj = (EObject)this.m_emfObject;
        while (obj != null) {
            if (obj instanceof RelationalObjectType) {
                return (RelationalObject)FmModelFactory.getInstance().get(this.m_session, obj);
            }
            obj = obj.eContainer();
        }
        return null;
    }

    @Override
    public MdTable getPhysicalTable(boolean allowException) {
        return this.getSession().findPhysicalTable(this.getDataSource(), this.getTableName(), allowException);
    }

    @Override
    public boolean equals(MdTable right) {
        if (right == null) {
            return false;
        }
        if (!this.getName().equals(right.getName())) {
            return false;
        }
        FmDataSource ds = this.getDataSource();
        MdSchema schema = right.getSchema();
        if (!ds.getSchemaName().equals(schema.getName())) {
            return false;
        }
        MdCatalog catalog = schema.getCatalog();
        return catalog == null || ds.getCatalogName().equals(catalog.getName());
    }

    @Override
    public FilterDefinition createFilterDefinition(String name, ExpressionBuilder expression) {
        return FmFilterDefinition.create(this.m_session, this, name, expression);
    }

    private FiltersType getFilters() {
        FiltersType filtersType = this.getTableType().getFilters();
        if (filtersType == null) {
            filtersType = GenmodelFactory.eINSTANCE.createFiltersType();
            this.getTableType().setFilters(filtersType);
        }
        return filtersType;
    }

    @Override
    public List<FilterDefinition> getFilterDefinitions() {
        ArrayList<FilterDefinition> filters = new ArrayList<FilterDefinition>();
        FiltersType filtersType = this.getFilters();
        for (FilterDefinitionType filterType : filtersType.getFilterDefinition()) {
            filters.add(FmFilterDefinition.get(this.m_session, filterType));
        }
        return filters;
    }

    @Override
    public void removeFilterDefinition(String displayName) {
        for (FilterDefinitionType filter : this.getFilters().getFilterDefinition()) {
            if (!filter.getDisplayName().equals(displayName)) continue;
            this.m_session.getGateway().delete(filter);
            break;
        }
    }

    @Override
    public void addFilterDefinition(FmFilterDefinition filter) {
        this.getFilters().getFilterDefinition().add((Object)filter.getFilterDefinitionType());
    }

    @Override
    public boolean isQueryItemInFilterScope(FmQueryItemBase qi) {
        for (QueryItemMapping mapping : this.getQueryItemMappings()) {
            if (!qi.equals(mapping.getQueryItem())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String makeObjectNameUnique(String name, int type) {
        boolean bUnique = false;
        String tempName = name;
        int i = 0;
        int size = -1;
        switch (type) {
            case 46: {
                size = this.getFilters().getFilterDefinition().size();
                break;
            }
            case 168: {
                size = this.getTableDeterminants().size();
                break;
            }
            default: {
                FmMDException.ASSERT(false, "Unknown child object type for FmTable.");
                break;
            }
        }
        while (!bUnique) {
            bUnique = true;
            String objName = null;
            int j = 0;
            while (j < size) {
                switch (type) {
                    case 46: {
                        objName = ((FilterDefinitionType)this.getFilters().getFilterDefinition().get(j)).getDisplayName();
                        break;
                    }
                    case 168: {
                        objName = this.getTableDeterminants().get(j).getName();
                    }
                }
                if (objName.equals(tempName)) {
                    bUnique = false;
                    break;
                }
                ++j;
            }
            if (bUnique) continue;
            tempName = String.valueOf(name) + Integer.toString(++i);
        }
        return tempName;
    }

    @Override
    public boolean isEquivalent(Table right) {
        if (!this.getDataSource().equals(right.getDataSource())) {
            return false;
        }
        return this.getName().equals(right.getName());
    }

    @Override
    public TableDeterminant createTableDeterminant(String name) {
        if (!(this.getRelationalParent() instanceof RelationalQuerySubject)) {
            throw new FmMDException("BMT_MD_DETERMINANTS_ON_QUERY_SUBJECTS_ONLY");
        }
        return FmTableDeterminant.createTableDeterminant(this.m_session, this, name);
    }

    public void addDeterminant(FmTableDeterminant det) {
        this.getTableType().getTableDeterminant().add((Object)((TableDeterminantType)det.getInternal()));
    }

    protected TableDeterminantType findDeterminant(String name) {
        for (TableDeterminantType det : this.getTableType().getTableDeterminant()) {
            if (!det.getName().equals(name)) continue;
            return det;
        }
        return null;
    }

    @Override
    public void removeTableDeterminant(String name) {
        if (!(this.getRelationalParent() instanceof RelationalQuerySubject)) {
            throw new FmMDException("BMT_MD_DETERMINANTS_ON_QUERY_SUBJECTS_ONLY");
        }
        TableDeterminantType det = this.findDeterminant(name);
        if (det != null) {
            this.m_session.getGateway().delete(det);
        }
    }

    @Override
    public TableDeterminant findTableDeterminant(String name) {
        if (!(this.getRelationalParent() instanceof RelationalQuerySubject)) {
            return null;
        }
        TableDeterminantType det = this.findDeterminant(name);
        if (det != null) {
            return FmTableDeterminant.get(this.m_session, det);
        }
        return null;
    }

    @Override
    public List<TableDeterminant> getTableDeterminants() {
        ArrayList<TableDeterminant> dets = new ArrayList<TableDeterminant>();
        for (TableDeterminantType det : this.getTableType().getTableDeterminant()) {
            dets.add(FmTableDeterminant.get(this.m_session, det));
        }
        return dets;
    }
}

