/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmPseudoModelObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalQuerySubject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTable;
import com.ibm.cognos.fmeng.fmmd.model.Determinant;
import com.ibm.cognos.fmeng.fmmd.model.RelationalQuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.TableDeterminant;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.RelationalQuerySubjectType;
import com.ibm.cognos.fmeng.genmodel.TableDeterminantType;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmTableDeterminant
extends FmPseudoModelObject
implements TableDeterminant {
    public static FmTableDeterminant createTableDeterminant(FMMDSession session, FmTable table, String name) {
        if (name == null || name.length() == 0) {
            name = FmTableDeterminant.getDefaultName(session.getActiveLocale());
        }
        String id = table.makeObjectNameUnique(name, 168);
        TableDeterminantType type = GenmodelFactory.eINSTANCE.createTableDeterminantType();
        type.setName(id);
        FmTableDeterminant det = FmTableDeterminant.get(session, type);
        table.addDeterminant(det);
        return det;
    }

    private static String getDefaultName(Locale activeLocale) {
        return FmMessage.render("BMT_MDN_OBJECT_NAME_DETERMINANT", activeLocale);
    }

    public static FmTableDeterminant get(FMMDSession session, Object obj) {
        return new FmTableDeterminant(session, obj);
    }

    FmTableDeterminant(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    private TableDeterminantType getTableDeterminantType() {
        return (TableDeterminantType)this.m_emfObject;
    }

    private FmTable getTable() {
        return FmTable.get(this.m_session, this.getTableDeterminantType().eContainer());
    }

    @Override
    public String getName() {
        return this.getTableDeterminantType().getName();
    }

    @Override
    public void setName(String name) {
        FmTable table = FmTable.get(this.m_session, this.getTableDeterminantType().eContainer());
        String id = table.makeObjectNameUnique(name, 168);
        this.getTableDeterminantType().setName(id);
    }

    @Override
    public boolean isCanGroup() {
        return this.getTableDeterminantType().isCanGroup();
    }

    @Override
    public void setCanGroup(boolean canGroup) {
        this.getTableDeterminantType().setCanGroup(canGroup);
    }

    @Override
    public boolean isIdentifiesRow() {
        return this.getTableDeterminantType().isIdentifiesRow();
    }

    @Override
    public void setIdentifiesRow(boolean identifiesRow) {
        if (identifiesRow) {
            if (!this.getTableDeterminantType().isIdentifiesRow()) {
                this.getTableDeterminantType().setIdentifiesRow(identifiesRow);
                this.fillAttributes();
            }
        } else {
            this.getTableDeterminantType().setIdentifiesRow(identifiesRow);
        }
    }

    private void fillAttributes() {
        FmTable table;
        MdTable mdTable;
        if (this.getTableDeterminantType().isIdentifiesRow() && (mdTable = (table = this.getTable()).getPhysicalTable(false)) != null) {
            List<MdColumn> cols = mdTable.getColumns();
            ArrayList<MdColumn> attributeCols = new ArrayList<MdColumn>();
            boolean addAsAttribute = true;
            Iterator<MdColumn> it = cols.iterator();
            while (it.hasNext()) {
                addAsAttribute = true;
                MdColumn col = it.next();
                for (String key : this.getKeys()) {
                    if (!col.getName().equals(key)) continue;
                    addAsAttribute = false;
                    break;
                }
                if (!addAsAttribute) continue;
                attributeCols.add(col);
            }
            this.getTableDeterminantType().getAttributes().clear();
            for (MdColumn col : attributeCols) {
                this.getTableDeterminantType().getAttributes().add((Object)col.getName());
            }
        }
    }

    @Override
    public List<String> getKeys() {
        return this.getTableDeterminantType().getKey();
    }

    @Override
    public List<String> getAttributes() {
        return this.getTableDeterminantType().getAttributes();
    }

    @Override
    public void addKeys(List<String> keys) {
        MdTable table = this.getTable().getPhysicalTable(false);
        for (String key : keys) {
            MdColumn col = table.findColumn(key);
            if (col == null) continue;
            this.addKey(col);
        }
    }

    private void checkColumn(MdColumn column) {
        MdTable thisTable;
        FmMDException.ASSERT(column != null, "Bad column");
        MdTable keyTable = column.getTable();
        FmTable table = this.getTable();
        if (table != null && !(thisTable = table.getPhysicalTable(false)).equals(keyTable)) {
            RelationalQuerySubject ro = null;
            TableDeterminantType obj = this.getTableDeterminantType();
            while (obj != null) {
                if (obj instanceof RelationalQuerySubjectType) {
                    ro = FmRelationalQuerySubject.get(this.m_session, obj);
                    break;
                }
                obj = obj.eContainer();
            }
            FmMDException.ASSERT(ro != null, "Unexpected location for a determinant.");
            throw new FmMDException("BMT_MD_INVALID_TABLE_FOR_DETERMINANT", ro.getName());
        }
    }

    @Override
    public void addKey(MdColumn key) {
        this.checkColumn(key);
        String name = key.getName();
        if (!this.getTableDeterminantType().getKey().contains((Object)name)) {
            this.getTableDeterminantType().getKey().add((Object)name);
        }
        if (this.getTableDeterminantType().getAttributes().contains((Object)name)) {
            this.getTableDeterminantType().getAttributes().remove((Object)name);
        }
    }

    @Override
    public void removeKeys(List<String> keys) {
        for (String name : keys) {
            if (!this.getTableDeterminantType().getKey().contains((Object)name)) continue;
            this.getTableDeterminantType().getKey().remove((Object)name);
        }
        this.fillAttributes();
    }

    @Override
    public void addAttributes(List<String> attributes) {
        MdTable table = this.getTable().getPhysicalTable(false);
        for (String attr : attributes) {
            MdColumn col = table.findColumn(attr);
            if (col == null) continue;
            this.addAttribute(col);
        }
    }

    @Override
    public void addAttribute(MdColumn attr) {
        this.checkColumn(attr);
        String name = attr.getName();
        if (!this.getTableDeterminantType().getAttributes().contains((Object)name)) {
            this.getTableDeterminantType().getAttributes().add((Object)name);
        }
        if (this.getTableDeterminantType().getKey().contains((Object)name)) {
            this.getTableDeterminantType().getKey().remove((Object)name);
        }
    }

    @Override
    public void removeAttributes(List<String> attributes) {
        for (String name : attributes) {
            if (!this.getTableDeterminantType().getAttributes().contains((Object)name)) continue;
            this.getTableDeterminantType().getAttributes().remove((Object)name);
        }
    }

    @Override
    public boolean compare(Determinant determinant) {
        if (determinant.isIdentifiesRow() != this.isIdentifiesRow()) {
            return false;
        }
        return determinant.isCanGroup() == this.isCanGroup();
    }
}

