/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevelReference;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasureDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPhysicalDefinition;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimensionBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTable;
import com.ibm.cognos.fmeng.fmmd.impl.task.FmCopyManager;
import com.ibm.cognos.fmeng.fmmd.model.AggregateCube;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.BuilderFactory;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.LevelReference;
import com.ibm.cognos.fmeng.fmmd.model.Measure;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.Relationship;
import com.ibm.cognos.fmeng.fmmd.model.Role;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.fmmd.model.TaskAggregateCube;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.metadata.MdCatalog;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdForeignKey;
import com.ibm.cognos.fmeng.metadata.MdSchema;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmTaskAggregateCube
implements TaskAggregateCube {
    private static FmTaskAggregateCube m_Instance = null;
    static boolean mbOptionSortRank = true;
    static float mfMeasureFuzzyThreashold = 0.3f;
    static float mfLevelKeyFuzzyThreashold = 0.3f;
    static boolean m_dumpFuzzyMatching = false;

    private FmTaskAggregateCube() {
    }

    public static TaskAggregateCube getInstance() {
        if (m_Instance == null) {
            m_Instance = new FmTaskAggregateCube();
        }
        return m_Instance;
    }

    @Override
    public Cube createAggregateCube(Cube parentCube, MdTable aggregateTable) {
        FmMDException.ASSERT(parentCube != null, "No detail cube was specified");
        FmMDException.ASSERT(aggregateTable != null, "No aggregate table was specified");
        if (FmTaskAggregateCube.isDenormalizedAggregateCandidate(aggregateTable)) {
            Cube aggrCube = parentCube.createAggregateCube(aggregateTable.getName());
            this.addDegenerateAggregateDimensionInternal(parentCube, aggrCube, aggregateTable, true);
            return aggrCube;
        }
        List<RelationalDimensionBase> aggDimList = this.findMatchingDimension(parentCube, aggregateTable);
        if (aggDimList.isEmpty()) {
            throw new FmMDException("BMT_MD_AGGR_TABLE_NO_MATCHING_DIM", aggregateTable.getName());
        }
        Cube aggrCube = parentCube.createAggregateCube(aggregateTable.getName());
        this.addAggregateDimensionInternal(parentCube, aggrCube, aggregateTable, true);
        return aggrCube;
    }

    @Override
    public Cube createDefaultAggregateCube(Cube parentCube, Map<RelationalDimension, List<LevelReference>> dimensionsToInclude, List<Measure> measuresToInclude) {
        return this.createDefaultAggregateCubeInternal(parentCube, dimensionsToInclude, measuresToInclude);
    }

    @Override
    public Cube createDefaultAggregateCube(Cube parentCube) {
        return this.createDefaultAggregateCubeInternal(parentCube, null, null);
    }

    @Override
    public AggregateCube createAggregate(Cube parentCube, String name, List<RelationalDimension> dimensions, List<Measure> measures, AggregateCube.AggregateCubeStyle style) {
        FmMDException.ASSERT(parentCube != null, "No detail cube was specified");
        return parentCube.createAggregateCube(name, style, dimensions, measures);
    }

    protected Cube createDefaultAggregateCubeInternal(Cube parentCube, Map<RelationalDimension, List<LevelReference>> dimensionsToInclude, List<Measure> measuresToInclude) {
        QueryItemBase queryItemBase;
        FmMDException.ASSERT(parentCube != null, "No detail cube was specified");
        FmCube aggCube = (FmCube)parentCube.createAggregateCube(parentCube.getName());
        aggCube.copyNames((FmReportObject)((Object)parentCube), BaseObject.PrefixName.kStandard, (FmBaseObject)((Object)parentCube));
        ArrayList<TopLevelObject> toCopy = new ArrayList<TopLevelObject>();
        toCopy.add(parentCube.getMeasureDimension());
        List<Relationship> rels = null;
        Set<RelationalDimension> dims = null;
        if (dimensionsToInclude != null) {
            dims = dimensionsToInclude.keySet();
            rels = new ArrayList<Relationship>();
            block0: for (RelationalDimension dim : dims) {
                for (Relationship relationship : parentCube.getRelationships()) {
                    if (!relationship.getLeftEnd().equals(dim) && !relationship.getRightEnd().equals(dim)) continue;
                    rels.add(relationship);
                    continue block0;
                }
            }
        } else {
            rels = parentCube.getRelationships();
        }
        toCopy.addAll(rels);
        FmCopyManager.copy(parentCube.getSession(), (BaseObject)aggCube, toCopy);
        List<Relationship> aggRels = aggCube.getRelationships();
        for (Relationship rel : aggRels) {
            ExpressionBuilder builder = BuilderFactory.createExpressionBuilder();
            rel.setExpression(builder);
        }
        MeasureDimension newMDim = aggCube.getMeasureDimension();
        if (newMDim.getAllQueryItems().size() > 0 && (queryItemBase = newMDim.getItemWithRole(Role.EDefaultRoles.kRoleTransactionId)) != null) {
            aggCube.getSession().delete(queryItemBase);
        }
        List<QueryItemMapping> list = newMDim.getQueryItemMappings();
        for (QueryItemMapping mapping : list) {
            newMDim.removeQueryItemMapping(mapping);
        }
        List<Table> tables = newMDim.getTables();
        for (Table tbl : tables) {
            newMDim.removeTable(tbl);
        }
        aggCube.getSession().delete(newMDim.getCalculatedMeasures());
        aggCube.getSession().delete(newMDim.getAllFilters());
        if (dims != null) {
            for (RelationalDimension dim : dims) {
                List<LevelReference> refs = dimensionsToInclude.get(dim);
                if (refs == null) continue;
                aggCube.createRollupDimension(dim, refs);
            }
        }
        ArrayList<Measure> toDelete = new ArrayList<Measure>();
        if (measuresToInclude != null) {
            for (Measure measure : newMDim.getAllMeasures()) {
                boolean deleteMeasure = true;
                for (Measure measureToInclude : measuresToInclude) {
                    if (!measureToInclude.getName().equals(measure.getName())) continue;
                    deleteMeasure = false;
                    break;
                }
                if (!deleteMeasure) continue;
                toDelete.add(measure);
            }
        }
        aggCube.getSession().delete(toDelete);
        return aggCube;
    }

    @Override
    public RelationalDimensionBase addAggregateDimension(Cube aggregateCube, MdTable aggregateTable) {
        FmMDException.ASSERT(aggregateCube != null, "No aggregate cube was specified");
        FmMDException.ASSERT(aggregateTable != null, "No aggregate table was specified");
        Cube parentCube = aggregateCube.getDetailCube();
        return this.addAggregateDimensionInternal(parentCube, aggregateCube, aggregateTable, false);
    }

    private RelationalDimensionBase addAggregateDimensionInternal(Cube parentCube, Cube aggregateCube, MdTable aggregateTable, boolean createRelationships) {
        List<RelationalDimensionBase> aggDimList = this.findMatchingDimension(parentCube, aggregateTable);
        if (aggDimList.isEmpty()) {
            return null;
        }
        RelationalDimensionBase oldMeasureDim = null;
        for (RelationalDimensionBase d : aggDimList) {
            if (!(d instanceof MeasureDimension)) continue;
            oldMeasureDim = d;
            break;
        }
        if (oldMeasureDim == null) {
            return null;
        }
        MeasureDimension aggrMeasureDim = this.copyMeasureDimension(aggregateCube, oldMeasureDim, aggregateTable);
        List<MdForeignKey> fkeys = null;
        boolean findPrimaryKey = true;
        if (aggrMeasureDim instanceof MeasureDimension) {
            fkeys = aggregateTable.getForeignKeys();
            findPrimaryKey = true;
        } else {
            fkeys = aggregateTable.getReferringForeignKeys();
            findPrimaryKey = false;
        }
        if (createRelationships) {
            for (MdForeignKey fkey : fkeys) {
                if (fkey.getPrimaryTable() == null) continue;
                List<RelationalDimensionBase> related = this.findRelatedDimension(parentCube, fkey, findPrimaryKey);
                if (!related.isEmpty()) {
                    for (RelationalDimensionBase relatedDim : related) {
                        if (findPrimaryKey) {
                            this.createRelationship(aggregateCube, fkey, (RelationalDimension)relatedDim, aggrMeasureDim);
                            continue;
                        }
                        this.createRelationship(aggregateCube, fkey, (RelationalDimension)relatedDim, (MeasureDimension)((Object)related));
                    }
                    continue;
                }
                MdTable aggrDimTable = fkey.getPrimaryTable();
                if (aggrDimTable == null) continue;
                List<RelationalDimensionBase> aggrDims = this.findMatchingDimension(parentCube, aggrDimTable);
                for (RelationalDimensionBase aggrDim : aggrDims) {
                    RelationalDimension newAggrDim = this.copyRegularDimension(aggregateCube, (RelationalDimension)aggrDim, aggrDimTable, new FindColumnByName(aggrDimTable.getColumns()));
                    this.createRelationship(aggregateCube, fkey, newAggrDim, aggrMeasureDim);
                }
            }
        } else {
            for (MdForeignKey fkey : fkeys) {
                List<RelationalDimensionBase> related = this.findRelatedDimension(aggregateCube, fkey, findPrimaryKey);
                if (related.isEmpty()) {
                    related = this.findRelatedDimension(parentCube, fkey, findPrimaryKey);
                }
                if (related.isEmpty()) continue;
                for (RelationalDimensionBase relatedDim : related) {
                    if (findPrimaryKey) {
                        this.createRelationship(aggregateCube, fkey, (RelationalDimension)relatedDim, aggrMeasureDim);
                        continue;
                    }
                    this.createRelationship(aggregateCube, fkey, (RelationalDimension)((Object)aggrMeasureDim), (MeasureDimension)relatedDim);
                }
            }
        }
        return aggrMeasureDim;
    }

    private RelationalDimensionBase addDegenerateAggregateDimensionInternal(Cube parentCube, Cube aggregateCube, MdTable aggregateTable, boolean createRelationships) {
        List<RelationalDimensionBase> related;
        MeasureDimension aggrMeasureDim = this.copyDegenerateMeasureDimension(parentCube, aggregateCube, aggregateTable);
        List<MdForeignKey> fkeys = null;
        boolean findPrimaryKey = true;
        fkeys = aggregateTable.getForeignKeys();
        if (createRelationships) {
            for (MdForeignKey fkey : fkeys) {
                if (fkey.getPrimaryTable() == null) continue;
                related = this.findRelatedDimension(parentCube, fkey, findPrimaryKey);
                if (!related.isEmpty()) {
                    for (RelationalDimensionBase relatedDim : related) {
                        this.createRelationship(aggregateCube, fkey, (RelationalDimension)relatedDim, aggrMeasureDim);
                    }
                    continue;
                }
                MdTable aggrDimTable = fkey.getPrimaryTable();
                if (aggrDimTable == null) continue;
                List<RelationalDimensionBase> aggrDims = this.findMatchingDimension(parentCube, aggrDimTable);
                for (RelationalDimensionBase aggrDim : aggrDims) {
                    RelationalDimension newAggrDim = this.copyRegularDimension(aggregateCube, (RelationalDimension)aggrDim, aggrDimTable, new FindColumnByName(aggrDimTable.getColumns()));
                    this.createRelationship(aggregateCube, fkey, newAggrDim, aggrMeasureDim);
                }
            }
        } else {
            for (MdForeignKey fkey : fkeys) {
                related = this.findRelatedDimension(aggregateCube, fkey, findPrimaryKey);
                if (related.isEmpty()) {
                    related = this.findRelatedDimension(parentCube, fkey, findPrimaryKey);
                }
                if (related.isEmpty()) continue;
                for (RelationalDimensionBase relatedDim : related) {
                    if (findPrimaryKey) {
                        this.createRelationship(aggregateCube, fkey, (RelationalDimension)relatedDim, aggrMeasureDim);
                        continue;
                    }
                    this.createRelationship(aggregateCube, fkey, (RelationalDimension)((Object)aggrMeasureDim), (MeasureDimension)relatedDim);
                }
            }
        }
        Map<MdColumn, Set<QueryItem>> aggrLevelKeyMap = this.findMatchingAggrKeys(parentCube, aggregateTable);
        Map<QueryItem, MdColumn> reverseAggrLevelKeyMap = FmTaskAggregateCube.reverseMap(aggrLevelKeyMap);
        Set<RelationalDimension> degenerateDims = this.createDegenerateDimensions(parentCube, aggregateCube, reverseAggrLevelKeyMap);
        this.createDegenerateRelationships(parentCube, aggregateCube, degenerateDims);
        return aggrMeasureDim;
    }

    private void createDegenerateRelationships(Cube parentCube, Cube aggregateCube, Set<RelationalDimension> listDim) {
        MeasureDimension mDim = aggregateCube.getMeasureDimension();
        for (RelationalDimension rDim : listDim) {
            ExpressionBuilder expression = BuilderFactory.createExpressionBuilder();
            aggregateCube.createRelationship(String.valueOf(rDim.getName()) + "<-->" + mDim.getName(), expression, rDim, mDim);
        }
    }

    public static <T, E> Map<E, T> reverseMap(Map<T, Set<E>> map) {
        HashMap<E, T> result = new HashMap<E, T>();
        for (Map.Entry<T, Set<E>> entry : map.entrySet()) {
            for (E e : entry.getValue()) {
                result.put(e, entry.getKey());
            }
        }
        return result;
    }

    private Set<RelationalDimension> createDegenerateDimensions(Cube parentCube, Cube aggrCube, Map<QueryItem, MdColumn> aggrLevelKeyMap) {
        HashSet<RelationalDimension> listDim = new HashSet<RelationalDimension>();
        if (aggrLevelKeyMap.size() > 0) {
            MdTable aggregateTable = aggrLevelKeyMap.values().iterator().next().getTable();
            HashSet<RelationalDimension> setOldDims = new HashSet<RelationalDimension>();
            for (QueryItem qi : aggrLevelKeyMap.keySet()) {
                RelationalDimension oldDim = (RelationalDimension)qi.getRelationalParent();
                if (oldDim == null) continue;
                setOldDims.add(oldDim);
            }
            for (RelationalDimension oldDim : setOldDims) {
                RelationalDimension rdim = this.copyRegularDimension(aggrCube, oldDim, aggregateTable, new FindColumnByLookup(aggrLevelKeyMap));
                listDim.add(rdim);
            }
        }
        return listDim;
    }

    private MeasureDimension copyDegenerateMeasureDimension(Cube parentCube, Cube aggrCube, MdTable aggregateTable) {
        MeasureDimension measureDim = parentCube.getMeasureDimension();
        FmMeasureDimension newDim = (FmMeasureDimension)aggrCube.createMeasureDimension(measureDim.getName());
        newDim.copyCommonProperties(measureDim, aggrCube);
        FmPhysicalDefinition newPhysDef = newDim.getPhysicalDefinition();
        DataSource ds = newDim.getProject().findOrCreateDataSource(aggregateTable);
        FmTable newAggrTable = newPhysDef.createTable(ds, aggregateTable.getName());
        Map<MdColumn, Measure> aggrMeasureMap = this.findMatchingAggrMeasures(parentCube.getMeasureDimension(), aggregateTable);
        if (aggrMeasureMap.size() == 0) {
            throw new FmMDException("BMT_MD_AGGR_TABLE_NO_MATCHING_DIM", aggregateTable.getName());
        }
        for (Map.Entry<MdColumn, Measure> e : aggrMeasureMap.entrySet()) {
            MdColumn aggrColumn = e.getKey();
            Measure measure = e.getValue();
            FmMeasure newQueryItem = newDim.createMeasureFromColumn(measure.getName(), aggrColumn);
            newDim.createQueryItemMapping((QueryItemBase)newQueryItem, aggrColumn.getName(), newAggrTable);
        }
        return newDim;
    }

    private void createRelationship(Cube aggregateCube, MdForeignKey fkey, RelationalDimension left, MeasureDimension right) {
        ExpressionBuilder builder = BuilderFactory.createExpressionBuilder();
        int i = 0;
        while (i < fkey.getColumns().size()) {
            if (i > 1) {
                builder.addExpressionPart("&&", null);
            }
            MdColumn leftCol = fkey.getPrimaryTable().getPrimaryKey().getColumns().get(i);
            MdColumn rightCol = fkey.getColumns().get(i);
            builder.addExpressionPart(leftCol, left, null);
            builder.addExpressionPart("=", null);
            builder.addExpressionPart(rightCol, right, null);
            ++i;
        }
        aggregateCube.createRelationship(fkey.getName(), builder, left, right);
    }

    private List<RelationalDimensionBase> findRelatedDimension(Cube parentCube, MdForeignKey fkey, boolean findPrimaryKey) {
        ArrayList<RelationalDimensionBase> relatedDimensions = new ArrayList<RelationalDimensionBase>();
        MdTable table = findPrimaryKey ? fkey.getPrimaryTable() : fkey.getTable();
        MdSchema schema = table.getSchema();
        MdCatalog catalog = schema.getCatalog();
        for (RelationalDimensionBase dim : parentCube.getReferencedDimensions()) {
            FmPhysicalDefinition physDef = ((FmRelationalDimensionBase)dim).getPhysicalDefinition();
            for (Table someTable : physDef.getTables()) {
                if (!someTable.getName().equals(table.getName())) continue;
                DataSource ds = someTable.getDataSource();
                if (catalog == null) {
                    if (!ds.getSchemaName().equals(schema.getName())) continue;
                    relatedDimensions.add(dim);
                    continue;
                }
                if (!ds.getSchemaName().equals(schema.getName()) || !ds.getCatalogName().equals(catalog.getName())) continue;
                relatedDimensions.add(dim);
            }
        }
        return relatedDimensions;
    }

    private RelationalDimension copyRegularDimension(Cube aggrCube, RelationalDimension oldDim, MdTable aggregateTable, FindColumn aggrColumnFinder) {
        FmRelationalDimension newDim = (FmRelationalDimension)aggrCube.createRegularDimension(oldDim.getName());
        HashMap<Object, Object> levelMap = new HashMap<Object, Object>();
        newDim.copyCommonProperties(oldDim, aggrCube);
        FmPhysicalDefinition oldPhysDef = ((FmRelationalDimensionBase)((Object)oldDim)).getPhysicalDefinition();
        FmPhysicalDefinition newPhysDef = newDim.getPhysicalDefinition();
        DataSource ds = newDim.getProject().findOrCreateDataSource(aggregateTable);
        FmTable fmAggrTable = newPhysDef.createTable(ds, aggregateTable.getName());
        for (Table table : oldPhysDef.getTables()) {
            List<QueryItemMapping> mappings = oldPhysDef.getQueryItemMappings(table);
            Iterator iterator = mappings.iterator();
            while (iterator.hasNext()) {
                Level oldLevel;
                QueryItemMapping mapping = (QueryItemMapping)iterator.next();
                FmQueryItemBase oldQueryItem = (FmQueryItemBase)mapping.getQueryItem();
                Object newQueryItem = null;
                MdColumn aggrColumn = aggrColumnFinder.findColumn(mapping);
                if (aggrColumn == null || (oldLevel = oldQueryItem.getLevel()) == null || !oldLevel.isLevelKey((QueryItem)((Object)oldQueryItem))) continue;
                Level newParentLevel = null;
                for (Level someLevel : newDim.getAllLevels()) {
                    if (!someLevel.getName().equals(oldLevel.getName())) continue;
                    newParentLevel = someLevel;
                    break;
                }
                if (newParentLevel == null) {
                    newParentLevel = newDim.createLevel(oldLevel.getName());
                    levelMap.put(oldLevel.getInternal(), newParentLevel.getInternal());
                }
                newQueryItem = newParentLevel.createQueryItemFromColumn(oldQueryItem.getName(), aggrColumn);
                newParentLevel.addLevelKey((QueryItem)newQueryItem);
                newDim.createQueryItemMapping((QueryItemBase)newQueryItem, aggrColumn.getName(), fmAggrTable);
            }
        }
        List<Level> baseLevelList = oldDim.getAllLevels();
        for (Level baseLevel : baseLevelList) {
            FmLevel newAggLevel;
            if (baseLevel.isAllLevel() || levelMap.get(baseLevel.getInternal()) == null || (newAggLevel = FmLevel.get(oldDim.getSession(), levelMap.get(baseLevel.getInternal()))) == null || baseLevel.getLevelKeys().size() == newAggLevel.getLevelKeys().size()) continue;
            List<QueryItem> baseLevelKeys = baseLevel.getLevelKeys();
            for (QueryItem baseLevelKey : baseLevelKeys) {
                QueryItem qiToAdd;
                FmLevel aggLevelKeyLevel;
                if (baseLevelKey.getLevel().getInternal().equals(baseLevel.getInternal()) || (aggLevelKeyLevel = FmLevel.get(oldDim.getSession(), levelMap.get(baseLevelKey.getLevel().getInternal()))) == null || (qiToAdd = (QueryItem)aggLevelKeyLevel.getQueryItemByName(baseLevelKey.getName())) == null) continue;
                newAggLevel.addLevelKey(qiToAdd);
            }
        }
        if (oldDim instanceof RelationalDimension) {
            FmRelationalDimension newHierDim = newDim;
            for (RelationalHierarchy oldHier : oldDim.getAllHierarchies()) {
                FmRelationalHierarchy newHier = newHierDim.createHierarchy(oldHier.getName());
                newHier.copyCommonProperties(oldHier, newHierDim);
                boolean bFirstLevel = true;
                for (LevelReference oldLevelRef : oldHier.getLevelReferences()) {
                    FmLevel newLevel;
                    EObject levelRefObj = ((FmLevelReference)oldLevelRef).getLevelReference();
                    if (levelMap.get(levelRefObj) == null) continue;
                    if (bFirstLevel) {
                        bFirstLevel = false;
                        Level oldAllLevel = oldHier.getAllLevel();
                        if (oldAllLevel != null) {
                            Level newAllLevel = newDim.createLevelFromLevel(oldAllLevel);
                            newHier.addLevel(newAllLevel);
                        }
                    }
                    FmMDException.ASSERT((newLevel = FmLevel.get(newHier.getSession(), levelMap.get(levelRefObj))).getInternal() != null, "Bad level mapping: " + oldLevelRef.getLevel().getID());
                    newHier.addLevel(newLevel);
                }
                if (newHier.getLevelReferences().size() != 0) continue;
                aggrCube.getSession().delete(newHier);
            }
        }
        return newDim;
    }

    private MeasureDimension copyMeasureDimension(Cube aggrCube, RelationalDimensionBase oldDim, MdTable aggregateTable) {
        FmMeasureDimension newDim = (FmMeasureDimension)aggrCube.createMeasureDimension(oldDim.getName());
        newDim.copyCommonProperties(oldDim, aggrCube);
        FmPhysicalDefinition oldPhysDef = ((FmRelationalDimensionBase)oldDim).getPhysicalDefinition();
        FmPhysicalDefinition newPhysDef = newDim.getPhysicalDefinition();
        List<MdColumn> aggregateColumns = aggregateTable.getColumns();
        DataSource ds = newDim.getProject().findOrCreateDataSource(aggregateTable);
        FmTable newAggrTable = newPhysDef.createTable(ds, aggregateTable.getName());
        for (Table table : oldPhysDef.getTables()) {
            FmMeasureDimension parentForNewColumns = null;
            List<QueryItemMapping> mappings = oldPhysDef.getQueryItemMappings(table);
            for (QueryItemMapping mapping : mappings) {
                FmQueryItemBase oldQueryItem = (FmQueryItemBase)mapping.getQueryItem();
                MdColumn aggrColumn = this.findMatchingColumnByName(aggregateColumns, mapping.getColumnName());
                if (aggrColumn == null) continue;
                QueryItemBase newQueryItem = null;
                if (oldQueryItem instanceof Measure) {
                    newQueryItem = newDim.createMeasureFromColumn(oldQueryItem.getName(), aggrColumn);
                    parentForNewColumns = newDim;
                } else if (oldQueryItem instanceof FmQueryItem) {
                    newQueryItem = newDim.createQueryItemFromColumn(oldQueryItem.getName(), aggrColumn);
                    parentForNewColumns = newDim;
                }
                newDim.createQueryItemMapping(newQueryItem, aggrColumn.getName(), newAggrTable);
            }
            FmMDException.ASSERT(parentForNewColumns != null, "We weren't able to find any columns in the aggregate table that match columns from the old table.");
        }
        return newDim;
    }

    private MdColumn findMatchingColumnByName(Collection<MdColumn> columns, String name) {
        for (MdColumn column : columns) {
            if (!column.getName().equals(name)) continue;
            return column;
        }
        return null;
    }

    private List<RelationalDimensionBase> findMatchingDimension(Cube parentCube, MdTable aggregateTable) {
        ArrayList<RelationalDimensionBase> matchingDimensions = new ArrayList<RelationalDimensionBase>();
        Table table = null;
        for (RelationalDimensionBase dim : parentCube.getReferencedDimensions()) {
            FmPhysicalDefinition physDef = ((FmRelationalDimensionBase)dim).getPhysicalDefinition();
            List<Table> tables = physDef.getTables();
            if (tables.size() != 1) continue;
            table = tables.get(0);
            HashSet<String> dimensionColumnSet = new HashSet<String>();
            MdTable physicalDimTable = table.getPhysicalTable(true);
            List<MdColumn> physicalDimColumn = physicalDimTable.getColumns();
            for (MdColumn col : physicalDimColumn) {
                dimensionColumnSet.add(col.getName());
            }
            boolean match = true;
            List<MdColumn> aggrColumns = aggregateTable.getColumns();
            for (MdColumn aggCol : aggrColumns) {
                if (dimensionColumnSet.contains(aggCol.getName()) || aggCol.isKey()) continue;
                match = false;
                break;
            }
            if (!match) continue;
            matchingDimensions.add(dim);
        }
        return matchingDimensions;
    }

    private HashMap<MdColumn, List<QueryItemBase>> findMatchingPhysMD(List<MdColumn> listAggrColumn, List<? extends QueryItemBase> listQueryItems) {
        LinkedHashMap<MdColumn, List<QueryItemBase>> results = new LinkedHashMap<MdColumn, List<QueryItemBase>>();
        for (MdColumn aggrColumn : listAggrColumn) {
            ArrayList<QueryItemBase> physMatches = new ArrayList<QueryItemBase>();
            results.put(aggrColumn, physMatches);
            for (QueryItemBase queryItemBase : listQueryItems) {
                MdColumn listKeyColumn = this.getQueryItemColumn(queryItemBase);
                if (!this.isMatchingPhysicalMetadata(aggrColumn, listKeyColumn)) continue;
                physMatches.add(queryItemBase);
            }
        }
        return results;
    }

    private HashMap<QueryItemBase, List<MdColumn>> findMatchingPhysMD2(List<? extends QueryItemBase> listQueryItems, List<MdColumn> listAggrColumn) {
        LinkedHashMap<QueryItemBase, List<MdColumn>> results = new LinkedHashMap<QueryItemBase, List<MdColumn>>();
        for (QueryItemBase queryItemBase : listQueryItems) {
            MdColumn listKeyColumn = this.getQueryItemColumn(queryItemBase);
            if (listKeyColumn == null) continue;
            ArrayList<MdColumn> physMatches = new ArrayList<MdColumn>();
            results.put(queryItemBase, physMatches);
            for (MdColumn aggrColumn : listAggrColumn) {
                if (!this.isMatchingPhysicalMetadata(aggrColumn, listKeyColumn)) continue;
                physMatches.add(aggrColumn);
            }
        }
        return results;
    }

    private Map<MdColumn, Measure> findMatchingAggrMeasures(MeasureDimension measureDim, MdTable aggregateTable) {
        if (m_dumpFuzzyMatching) {
            System.out.printf("\n---------------------- MEASURE MATCHES: START\n\n", new Object[0]);
        }
        LinkedHashMap<MdColumn, Measure> results = new LinkedHashMap<MdColumn, Measure>();
        HashMap<MdColumn, List<QueryItemBase>> columnCandidates = this.findMatchingPhysMD(FmTaskAggregateCube.getAggrFactCandidates(aggregateTable), measureDim.getAllMeasures());
        LinkedHashMap<Measure, MdColumn> winningMeasure = new LinkedHashMap<Measure, MdColumn>();
        HashMap<Measure, Float> winningMeasureRanking = new HashMap<Measure, Float>();
        for (Map.Entry entry : columnCandidates.entrySet()) {
            Map.Entry<String, Float> rankWinner;
            MdColumn aggrColumn = (MdColumn)entry.getKey();
            List listMeasures = (List)entry.getValue();
            ArrayList<MdColumn> listMeasureColumns = this.getQueryItemColumns(listMeasures);
            Map<String, MdColumn> listMeasureColumnNames = this.listColumnNames(listMeasureColumns);
            HashMap<String, Float> rank = this.rankFuzzyMatches(aggrColumn.getName(), listMeasureColumnNames.keySet(), mbOptionSortRank);
            if (m_dumpFuzzyMatching) {
                String sMatchList = rank.toString().replaceAll(String.valueOf(aggrColumn.getName()) + "[|][|]", "");
                if (sMatchList.equals("{}")) {
                    sMatchList = "{ NO MATCHING PHYSICAL METADATA:  IMPLIES POTENTIAL LVLKEY CANDIDATE }";
                }
                System.out.printf("Aggr Fact '%s' matches:\n\t\t%s\n", aggrColumn.getName(), sMatchList);
            }
            if ((rankWinner = this.getRankWinner(rank)) == null) continue;
            String rankKey = rankWinner.getKey();
            Float rankValue = rankWinner.getValue();
            if (!(rankValue.floatValue() > mfMeasureFuzzyThreashold)) continue;
            String winnerQiColumnName = rankKey.replaceAll(String.valueOf(aggrColumn.getName()) + "[|][|]", "");
            int nCount = 0;
            for (String qiColName : listMeasureColumnNames.keySet()) {
                if (qiColName.equals(winnerQiColumnName)) {
                    Float fMeasureFilter;
                    Measure qiWinner = (Measure)listMeasures.get(nCount);
                    if (m_dumpFuzzyMatching) {
                        System.out.printf("\t\tMeasure Winner:  '%s'\n", qiWinner.getName());
                    }
                    if ((fMeasureFilter = (Float)winningMeasureRanking.get(qiWinner)) == null || rankValue.floatValue() > fMeasureFilter.floatValue()) {
                        winningMeasure.put(qiWinner, aggrColumn);
                        winningMeasureRanking.put(qiWinner, rankValue);
                    }
                }
                ++nCount;
            }
        }
        int iWin = 0;
        if (m_dumpFuzzyMatching) {
            System.out.printf("\nFinal Winners:\n==============\n", new Object[0]);
        }
        for (Map.Entry e : winningMeasure.entrySet()) {
            if (m_dumpFuzzyMatching) {
                System.out.printf("%2d: '%s'-->'%s'\n", ++iWin, ((MdColumn)e.getValue()).getName(), ((Measure)e.getKey()).getName());
            }
            results.put((MdColumn)e.getValue(), (Measure)e.getKey());
        }
        if (m_dumpFuzzyMatching) {
            System.out.printf("\n---------------------- MEASURE MATCHES: FINISHED\n", new Object[0]);
        }
        return results;
    }

    private List<QueryItem> listLevelKeys(Cube parentCube) {
        ArrayList<QueryItem> listLevelKeys = new ArrayList<QueryItem>();
        for (RelationalDimensionBase dim : parentCube.getReferencedDimensions()) {
            if (!(dim instanceof RelationalDimension)) continue;
            RelationalDimension rdim = (RelationalDimension)dim;
            for (RelationalHierarchy rhier : rdim.getAllHierarchies()) {
                for (LevelReference lvlRef : rhier.getLevelReferences()) {
                    for (QueryItem qiLevelKey : lvlRef.getLevel().getLevelKeys()) {
                        listLevelKeys.add(qiLevelKey);
                    }
                }
            }
        }
        return listLevelKeys;
    }

    private Map<MdColumn, Set<QueryItem>> findMatchingAggrKeys(Cube parentCube, MdTable aggregateTable) {
        HashMap<MdColumn, Set<QueryItem>> winningResults = new HashMap<MdColumn, Set<QueryItem>>();
        List<QueryItem> allLevelKeys = this.listLevelKeys(parentCube);
        Map<RelationalHierarchy, List<Level>> mapHierarchyLevels = this.getHierarchyLevels(parentCube);
        HashMap<MdColumn, List<QueryItemBase>> measureCandidates = this.findMatchingPhysMD(FmTaskAggregateCube.getAggrFactCandidates(aggregateTable), parentCube.getMeasureDimension().getAllMeasures());
        List<MdColumn> aggrKeyCandidates = FmTaskAggregateCube.getAggrKeyCandidates(aggregateTable);
        for (Map.Entry e : measureCandidates.entrySet()) {
            if (((List)e.getValue()).size() != 0) continue;
            aggrKeyCandidates.add((MdColumn)e.getKey());
        }
        HashMap<QueryItemBase, List<MdColumn>> lvlKeyCandidates = this.findMatchingPhysMD2(allLevelKeys, this.filterForeignKeys(aggrKeyCandidates));
        if (m_dumpFuzzyMatching) {
            System.out.printf("\n---------------------- LEVEL KEY MATCHES: START\n\n", new Object[0]);
        }
        int nthLevelMatch = 0;
        boolean bUnmatchedLvlKeyCandidates = true;
        while (bUnmatchedLvlKeyCandidates) {
            Float maxAvgRank = Float.valueOf(0.0f);
            RelationalHierarchy winningHierarchy = null;
            HashMap<MdColumn, QueryItem> winningLvl = new HashMap<MdColumn, QueryItem>();
            if (m_dumpFuzzyMatching) {
                System.out.printf("Matching Level %2d\n=================\n", ++nthLevelMatch);
            }
            for (Map.Entry<RelationalHierarchy, Level> topLevel : this.getTopLevels(mapHierarchyLevels).entrySet()) {
                HashMap<MdColumn, QueryItem> currentLvlResults = new HashMap<MdColumn, QueryItem>();
                RelationalHierarchy h = topLevel.getKey();
                Level lvl = topLevel.getValue();
                List<QueryItem> listLevelKeys = lvl.getLevelKeys();
                if (listLevelKeys.size() <= 0) continue;
                Float rankAvg = Float.valueOf(0.0f);
                boolean bMatchingPhysicalMetadata = false;
                int nNonUniqueLevelKeys = 0;
                for (QueryItem qiLevelKey : listLevelKeys) {
                    MdColumn aggrColumn;
                    MdColumn columnLvlKey = this.getQueryItemColumn(qiLevelKey);
                    if (listLevelKeys.size() > 0 && (aggrColumn = this.getNonUniqueKeyColumn(winningResults, qiLevelKey)) != null) {
                        ++nNonUniqueLevelKeys;
                        currentLvlResults.put(aggrColumn, qiLevelKey);
                        if (m_dumpFuzzyMatching) {
                            System.out.printf("Level Key ID: %s\nKey Column Name '%s' matches:\n\t\tNon-unique level key identified.\n", qiLevelKey.getID(), columnLvlKey == null ? "null" : columnLvlKey.getName());
                        }
                        if (!m_dumpFuzzyMatching) continue;
                        System.out.printf("\t\tAggregate winner:  '%s'\n", aggrColumn.getName());
                        continue;
                    }
                    List listAggrColumn = (List)lvlKeyCandidates.get(qiLevelKey);
                    boolean bl = bMatchingPhysicalMetadata = listAggrColumn != null && listAggrColumn.size() > 0;
                    if (!bMatchingPhysicalMetadata) {
                        if (m_dumpFuzzyMatching) {
                            System.out.printf("Level Key ID: %s\nKey Column Name '%s' matches:\n\t\t%s\n", qiLevelKey.getID(), columnLvlKey == null ? "null" : columnLvlKey.getName(), "NO MATCHING PHYSICAL METADATA...SKIPPING ANY REMAINING LEVEL KEYS");
                        }
                        currentLvlResults = null;
                        break;
                    }
                    Map<String, MdColumn> mapAggrColumnNames = this.listColumnNames(listAggrColumn);
                    HashMap<String, Float> rank = this.rankFuzzyMatches(columnLvlKey.getName(), mapAggrColumnNames.keySet(), mbOptionSortRank);
                    if (m_dumpFuzzyMatching) {
                        System.out.printf("Level Key ID: %s\nKey Column Name '%s' matches:\n\t\t%s\n", qiLevelKey.getID(), columnLvlKey.getName(), rank.toString().replaceAll(String.valueOf(columnLvlKey.getName()) + "[|][|]", ""));
                    }
                    Map.Entry<String, Float> winningRank = this.getRankWinner(rank);
                    String rankAggrColumnName = winningRank.getKey().replaceAll(String.valueOf(columnLvlKey.getName()) + "[|][|]", "");
                    if (m_dumpFuzzyMatching) {
                        System.out.printf("\t\tAggregate winner:  '%s'\n", rankAggrColumnName);
                    }
                    currentLvlResults.put(mapAggrColumnNames.get(rankAggrColumnName), qiLevelKey);
                    rankAvg = Float.valueOf(rankAvg.floatValue() + winningRank.getValue().floatValue());
                }
                if (currentLvlResults == null) continue;
                rankAvg = Float.valueOf(rankAvg.floatValue() / (float)(listLevelKeys.size() - nNonUniqueLevelKeys));
                if (!(maxAvgRank.floatValue() < rankAvg.floatValue())) continue;
                maxAvgRank = rankAvg;
                winningHierarchy = h;
                winningLvl = currentLvlResults;
            }
            if (winningHierarchy != null) {
                if (maxAvgRank.floatValue() > mfLevelKeyFuzzyThreashold) {
                    Level removedWinningLevel = this.filterWinningLevel(mapHierarchyLevels, winningHierarchy);
                    if (m_dumpFuzzyMatching) {
                        System.out.printf("\n\tLevel winner[%3.2f]:  '%s'\n\n", maxAvgRank, removedWinningLevel.getID());
                    }
                    for (Map.Entry lvlEntry : winningLvl.entrySet()) {
                        MdColumn aggrKey = (MdColumn)lvlEntry.getKey();
                        QueryItem lvlKey = (QueryItem)lvlEntry.getValue();
                        HashSet<QueryItem> levelKeys = (HashSet<QueryItem>)winningResults.get(aggrKey);
                        if (levelKeys == null) {
                            levelKeys = new HashSet<QueryItem>();
                        }
                        levelKeys.add(lvlKey);
                        winningResults.put(aggrKey, levelKeys);
                    }
                    this.filterCandidateWinners(lvlKeyCandidates, winningLvl);
                    continue;
                }
                bUnmatchedLvlKeyCandidates = false;
                if (!m_dumpFuzzyMatching) break;
                System.out.printf("\n\tLevel winner:  None...ranking too low.\n\n\tSearch complete.\n", new Object[0]);
                break;
            }
            bUnmatchedLvlKeyCandidates = false;
            if (!m_dumpFuzzyMatching) break;
            System.out.printf("\n\tLevel winner:  None.\n\n\tSearch complete.\n", new Object[0]);
            break;
        }
        if (m_dumpFuzzyMatching) {
            System.out.printf("\nFinal Winners:\n==============\n", new Object[0]);
            int iWin = 0;
            for (Map.Entry e : winningResults.entrySet()) {
                for (QueryItem q : (Set)e.getValue()) {
                    System.out.printf("%2d: %-40s --> %s\n", ++iWin, "'" + ((MdColumn)e.getKey()).getName() + "'", q.getID());
                }
            }
            System.out.printf("\n---------------------- LEVEL KEY MATCHES: FINISHED\n", new Object[0]);
        }
        return winningResults;
    }

    private MdColumn getNonUniqueKeyColumn(Map<MdColumn, Set<QueryItem>> winningResults, QueryItem lvlKey) {
        MdColumn colLvlKey = this.getQueryItemColumn(lvlKey);
        Map<QueryItem, MdColumn> reverseAggrLevelKeyMap = FmTaskAggregateCube.reverseMap(winningResults);
        for (Map.Entry<QueryItem, MdColumn> entry : reverseAggrLevelKeyMap.entrySet()) {
            QueryItem parentLvlKey = entry.getKey();
            MdColumn colParentLvlKey = this.getQueryItemColumn(parentLvlKey);
            if (colParentLvlKey != colLvlKey) continue;
            return reverseAggrLevelKeyMap.get(parentLvlKey);
        }
        return null;
    }

    private Level filterWinningLevel(Map<RelationalHierarchy, List<Level>> mapHierarchyLevels, RelationalHierarchy winningHierarchy) {
        Level removedWinningLevel = mapHierarchyLevels.get(winningHierarchy).remove(0);
        String removedLevelID = removedWinningLevel.getID();
        for (Map.Entry<RelationalHierarchy, List<Level>> e : mapHierarchyLevels.entrySet()) {
            String sLevelID;
            if (e.getValue().size() <= 0 || !(sLevelID = e.getValue().get(0).getID()).equals(removedLevelID)) continue;
            e.getValue().remove(0);
        }
        return removedWinningLevel;
    }

    private void filterCandidateWinners(Map<QueryItemBase, List<MdColumn>> lvlKeyCandidates, Map<MdColumn, QueryItem> winningLvl) {
        for (Map.Entry<MdColumn, QueryItem> e : winningLvl.entrySet()) {
            MdColumn aggrColumn = e.getKey();
            QueryItem qiLvlKey = e.getValue();
            lvlKeyCandidates.remove(qiLvlKey);
            for (List<MdColumn> listAggrCol : lvlKeyCandidates.values()) {
                listAggrCol.remove(aggrColumn);
            }
        }
    }

    private Map<RelationalHierarchy, Level> getTopLevels(Map<RelationalHierarchy, List<Level>> mapHierarchyLevels) {
        HashMap<RelationalHierarchy, Level> topLevels = new HashMap<RelationalHierarchy, Level>();
        for (Map.Entry<RelationalHierarchy, List<Level>> e : mapHierarchyLevels.entrySet()) {
            List<Level> listLevels = e.getValue();
            if (listLevels.size() <= 0) continue;
            topLevels.put(e.getKey(), listLevels.get(0));
        }
        return topLevels;
    }

    private Map<RelationalHierarchy, List<Level>> getHierarchyLevels(Cube parentCube) {
        HashMap<RelationalHierarchy, List<Level>> results = new HashMap<RelationalHierarchy, List<Level>>();
        for (RelationalDimensionBase dim : parentCube.getReferencedDimensions()) {
            if (!(dim instanceof RelationalDimension)) continue;
            RelationalDimension rdim = (RelationalDimension)dim;
            for (RelationalHierarchy rhier : rdim.getAllHierarchies()) {
                ArrayList<Level> listLevels = new ArrayList<Level>();
                results.put(rhier, listLevels);
                for (LevelReference lvlRef : rhier.getLevelReferences()) {
                    Level lvl = lvlRef.getLevel();
                    if (lvl.isAllLevel()) continue;
                    listLevels.add(lvl);
                }
            }
        }
        return results;
    }

    private List<MdColumn> filterForeignKeys(List<MdColumn> aggrKeys) {
        HashSet<MdColumn> listRemove = new HashSet<MdColumn>();
        for (MdColumn aggrKey : aggrKeys) {
            if (!aggrKey.getTable().getForeignKeys().contains(aggrKey)) continue;
            listRemove.add(aggrKey);
        }
        aggrKeys.removeAll(listRemove);
        return aggrKeys;
    }

    Map.Entry<String, Float> getRankWinner(HashMap<String, Float> rank) {
        Map.Entry<String, Float> maxEntry = null;
        for (Map.Entry<String, Float> entry : rank.entrySet()) {
            if (maxEntry != null && entry.getValue().compareTo(maxEntry.getValue()) <= 0) continue;
            maxEntry = entry;
        }
        return maxEntry;
    }

    private ArrayList<MdColumn> getQueryItemColumns(Collection<? extends QueryItemBase> listQueryItems) {
        ArrayList<MdColumn> results = new ArrayList<MdColumn>();
        for (QueryItemBase queryItemBase : listQueryItems) {
            results.add(this.getQueryItemColumn(queryItemBase));
        }
        return results;
    }

    private MdColumn getQueryItemColumn(QueryItemBase qi) {
        String idQueryItem = qi.getID();
        RelationalDimensionBase parent = (RelationalDimensionBase)qi.getRelationalParent();
        for (QueryItemMapping qim : parent.getQueryItemMappings()) {
            MdTable phyTable;
            if (!qim.getQueryItem().getID().equals(idQueryItem) || (phyTable = qim.getTable().getPhysicalTable(true)) == null) continue;
            return phyTable.findColumn(qim.getColumnName());
        }
        return null;
    }

    private Map<String, MdColumn> listColumnNames(Collection<MdColumn> listColumns) {
        LinkedHashMap<String, MdColumn> names = new LinkedHashMap<String, MdColumn>();
        for (MdColumn column : listColumns) {
            names.put(column.getName(), column);
        }
        return names;
    }

    private static float fuzzyLevenshtein(String s1, String s2) {
        int len2;
        int len1 = s1.length();
        int maxLen = len1 > (len2 = s2.length()) ? len1 : len2;
        int nDistance = StringUtils.getLevenshteinDistance((String)s1.toUpperCase(), (String)s2.toUpperCase());
        Float fFuzzy = Float.valueOf(1.0f - (float)nDistance * 1.0f / (float)maxLen);
        return fFuzzy.floatValue();
    }

    private HashMap<String, Float> rankFuzzyMatches(String lookup, Set<String> dictionnary, boolean bSort) {
        LinkedHashMap<String, Float> rankValues = new LinkedHashMap<String, Float>();
        for (String term : dictionnary) {
            Float f = Float.valueOf(FmTaskAggregateCube.fuzzyLevenshtein(lookup, term));
            rankValues.put(String.valueOf(lookup) + "||" + term, f);
        }
        return bSort ? FmTaskAggregateCube.sortMapValues(rankValues) : rankValues;
    }

    private static <E, F extends Comparable<? super F>> HashMap<E, F> sortMapValues(HashMap<E, F> aMap) {
        if (aMap == null) {
            return null;
        }
        LinkedHashMap sortedMap = new LinkedHashMap();
        ArrayList<E> aMapKeys = new ArrayList<E>(aMap.keySet());
        ArrayList<F> aMapValues = new ArrayList<F>(aMap.values());
        ArrayList<F> aSortedValues = new ArrayList<F>(aMap.values());
        Collections.sort(aSortedValues);
        for (Comparable aSortedValue : aSortedValues) {
            int nIndex = aMapValues.indexOf(aSortedValue);
            sortedMap.put(aMapKeys.get(nIndex), aSortedValue);
            FmMDException.ASSERT(aMap.get(aMapKeys.get(nIndex)) == aMapValues.get(nIndex), "Map key set and value set are not stored in the same order");
            aMapValues.remove(nIndex);
            aMapKeys.remove(nIndex);
        }
        return sortedMap;
    }

    private boolean isMatchingPhysicalMetadata(MdColumn columnA, MdColumn columnB) {
        if (columnA == null || columnB == null) {
            return false;
        }
        return columnA.getDatatype() == columnB.getDatatype() && columnA.getSize() == columnB.getSize() && columnA.getPrecision() == columnB.getPrecision() && columnA.getScale() == columnB.getScale();
    }

    public static List<MdColumn> getAggrFactCandidates(MdTable aggrTable) {
        ArrayList<MdColumn> factColumns = new ArrayList<MdColumn>();
        for (MdColumn mdColumn : aggrTable.getColumns()) {
            if (!FmTaskAggregateCube.isFactCandidate(mdColumn)) continue;
            factColumns.add(mdColumn);
        }
        return factColumns;
    }

    public static List<MdColumn> getAggrKeyCandidates(MdTable aggrTable) {
        LinkedList<MdColumn> listColumns = new LinkedList<MdColumn>(aggrTable.getColumns());
        List<MdColumn> listAggrFacts = FmTaskAggregateCube.getAggrFactCandidates(aggrTable);
        List<MdForeignKey> listFKeys = aggrTable.getForeignKeys();
        ArrayList<MdColumn> listFKeyColumns = new ArrayList<MdColumn>();
        for (MdForeignKey fkey : listFKeys) {
            listFKeyColumns.addAll(fkey.getColumns());
        }
        listColumns.removeAll(listAggrFacts);
        listColumns.removeAll(listFKeyColumns);
        return listColumns;
    }

    private static boolean isFactCandidate(MdColumn col) {
        return !col.isKey() && FmDatatype.isNumeric(col.getDatatype()) != false;
    }

    private static boolean isDenormalizedAggregateCandidate(MdTable aggrTable) {
        boolean bHasFactCandiates = FmTaskAggregateCube.getAggrFactCandidates(aggrTable).size() > 0;
        return bHasFactCandiates;
    }

    static interface FindColumn {
        public MdColumn findColumn(QueryItemMapping var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FindColumnByLookup
    implements FindColumn {
        Map<QueryItem, MdColumn> mMap;

        FindColumnByLookup(Map<QueryItem, MdColumn> map) {
            this.mMap = map;
        }

        @Override
        public MdColumn findColumn(QueryItemMapping mapping) {
            return this.mMap.get(mapping.getQueryItem());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FindColumnByName
    implements FindColumn {
        List<MdColumn> mAggregateColumns;

        FindColumnByName(List<MdColumn> aggregateColumns) {
            this.mAggregateColumns = aggregateColumns;
        }

        @Override
        public MdColumn findColumn(QueryItemMapping mapping) {
            return FmTaskAggregateCube.this.findMatchingColumnByName(this.mAggregateColumns, mapping.getColumnName());
        }
    }
}

