/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.LevelReference;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.Relationship;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.TaskAggregateCube2;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.List;

public class FmTaskAggregateCube2
implements TaskAggregateCube2 {
    private static FmTaskAggregateCube2 m_Instance = null;

    private FmTaskAggregateCube2() {
    }

    public static TaskAggregateCube2 getInstance() {
        if (m_Instance == null) {
            m_Instance = new FmTaskAggregateCube2();
        }
        return m_Instance;
    }

    public void removeRollupHierarchy(Cube aggCube, RelationalDimension dim, RelationalHierarchy removeHierarchy, RelationalDimension rollupDim) {
        RelationalHierarchy rollupHier = this.getRollupHierarchyForSource(rollupDim, removeHierarchy);
        rollupHier.getSession().delete(rollupHier);
        if (rollupDim.getAllHierarchies().size() == 0) {
            this.unrollDimension(rollupDim, dim, aggCube);
        }
    }

    public void unrollDimension(RelationalDimension rollupDim, RelationalDimension sourceDim, Cube aggCube) {
        if (rollupDim != null) {
            rollupDim.getSession().delete(rollupDim);
            aggCube.createRelationship("Relationship", null, sourceDim, aggCube.getMeasureDimension());
        }
    }

    public RelationalDimension createRollupDimension(Cube aggCube, RelationalDimension dim, LevelReference rollupRef) {
        RelationalDimension rollupDim = this.createRollupDimension(dim, aggCube);
        this.setAsAggregationLevel(rollupRef, rollupDim);
        return rollupDim;
    }

    private RelationalDimension createRollupDimension(RelationalDimension sourceDim, Cube aggCube) {
        RelationalDimension rollupDim = aggCube.createRegularDimension(sourceDim.getName());
        this.copyNames(sourceDim, rollupDim);
        Relationship rel = aggCube.getRelationshipTo(sourceDim);
        rel.getSession().delete(rel);
        aggCube.createRelationship("Relationship", null, rollupDim, aggCube.getMeasureDimension());
        return rollupDim;
    }

    private void copyNames(ReportObject sourceObj, ReportObject rollupObj) {
        ((FmReportObject)rollupObj).copyNames((FmReportObject)sourceObj, BaseObject.PrefixName.kStandard, (FmBaseObject)rollupObj.getParent());
        FmMDException.ASSERT(sourceObj.getName().equals(rollupObj.getName()), "Rollup object names were unique-ified for some reason.");
    }

    public RelationalDimension rollupParentChildDimension(RelationalDimension parentChild, Cube aggCube) {
        RelationalDimension dim = this.createRollupDimension(parentChild, aggCube);
        List hiers = parentChild.getAllHierarchies();
        FmMDException.ASSERT(hiers.size() == 1, "Should only be 1 hierarchy");
        RelationalHierarchy hier = (RelationalHierarchy)hiers.get(0);
        FmMDException.ASSERT(hier.getParentChild(), "Must be a parent-child hierarchy");
        QueryItem child = hier.getChildItem();
        if (child == null) {
            throw new FmMDException("BMT_MD_NO_CHILD_KEY_TO_REMAP");
        }
        RelationalHierarchy rollupHier = dim.createParentChildHierarchy(hier.getName());
        QueryItem cKey = hier.getChildItem();
        if (cKey != null) {
            rollupHier.setChildItem(rollupHier.createQueryItem(cKey.getName(), null));
        }
        return dim;
    }

    public RelationalHierarchy getRollupHierarchyForSource(RelationalDimension rollupDim, RelationalHierarchy sourceHierarchy) {
        List hiers = rollupDim.getAllHierarchies();
        int i = 0;
        while (i < hiers.size()) {
            RelationalHierarchy hier = (RelationalHierarchy)hiers.get(i);
            if (hier.getName().equals(sourceHierarchy.getName())) {
                return hier;
            }
            ++i;
        }
        return null;
    }

    public void setAsAggregationLevel(LevelReference sourceLevelReference, RelationalDimension rollupDimension) {
        LevelReference ref2;
        RelationalHierarchy sourceHierarchy = (RelationalHierarchy)sourceLevelReference.getParent();
        RelationalHierarchy rollupHier = this.getRollupHierarchyForSource(rollupDimension, sourceHierarchy);
        if (rollupHier == null) {
            rollupHier = (RelationalHierarchy)rollupDimension.createHierarchy(sourceHierarchy.getName());
            this.copyNames(sourceHierarchy, rollupHier);
        }
        List<LevelReference> refs = rollupHier.getLevelReferences();
        boolean hasLevelReference = false;
        int i = 0;
        while (i < refs.size()) {
            ref2 = refs.get(i);
            if (ref2.getLevel().getName().equals(sourceLevelReference.getLevel().getName())) {
                hasLevelReference = true;
                break;
            }
            ++i;
        }
        if (hasLevelReference) {
            i = refs.size() - 1;
            while (i >= 0) {
                ref2 = refs.get(i);
                if (!ref2.getLevel().getName().equals(sourceLevelReference.getLevel().getName())) {
                    ref2.getSession().delete(ref2);
                    --i;
                    continue;
                }
                break;
            }
        } else {
            List<LevelReference> levelRefs = sourceHierarchy.getLevelReferences();
            for (LevelReference ref2 : levelRefs) {
                LevelReference rollupRef = this.getRollupLevelRef(rollupHier, ref2);
                if (rollupRef == null) {
                    Level lvl = this.getRollupLevel(rollupDimension, ref2.getLevel());
                    if (lvl == null) {
                        lvl = this.createRollupLevelFrom(rollupDimension, ref2.getLevel());
                    }
                    rollupRef = rollupHier.addLevel(lvl);
                }
                if (!rollupRef.getLevel().getName().equals(sourceLevelReference.getLevel().getName())) {
                    continue;
                }
                break;
            }
        }
    }

    private LevelReference getRollupLevelRef(RelationalHierarchy rollupHier, LevelReference sourceLevel) {
        List<LevelReference> lvls = rollupHier.getLevelReferences();
        for (LevelReference lvl : lvls) {
            if (!lvl.getLevel().getName().equals(sourceLevel.getLevel().getName())) continue;
            return lvl;
        }
        return null;
    }

    private Level getRollupLevel(RelationalDimension rollupDim, Level sourceLevel) {
        List<Level> lvls = rollupDim.getAllLevels();
        for (Level lvl : lvls) {
            if (!lvl.getName().equals(sourceLevel.getName())) continue;
            return lvl;
        }
        return null;
    }

    private Level createRollupLevelFrom(RelationalDimension rollupDim, Level sourceLevel) {
        Level lvl = rollupDim.createLevel(sourceLevel.getName());
        this.copyNames(sourceLevel, lvl);
        List<QueryItem> keys = sourceLevel.getLevelKeys();
        for (QueryItem key : keys) {
            QueryItem rollupKey = null;
            if (key.getParent().equals(sourceLevel)) {
                rollupKey = lvl.createQueryItem(key.getName(), null);
            } else {
                Level rollupLevel = this.getRollupLevel(rollupDim, (Level)key.getParent());
                if (rollupLevel == null) {
                    rollupLevel = this.createRollupLevelFrom(rollupDim, key.getLevel());
                }
                List<QueryItem> qis = rollupLevel.getLevelKeys();
                for (QueryItem qi : qis) {
                    if (!qi.getName().equals(key.getName())) continue;
                    rollupKey = qi;
                    break;
                }
                if (rollupKey == null) {
                    boolean isLevelKey = false;
                    for (QueryItem qi : key.getLevel().getLevelKeys()) {
                        if (!qi.equals(key)) continue;
                        isLevelKey = true;
                        break;
                    }
                    FmMDException.ASSERT(!isLevelKey, String.valueOf(key.getName()) + " is a level key, when we though it wasn't.");
                    rollupKey = rollupLevel.createQueryItem(key.getName(), null);
                }
            }
            FmMDException.ASSERT(rollupKey != null, "Null rollup level key for level key " + key.getName());
            lvl.addLevelKey(rollupKey);
        }
        return lvl;
    }
}

