/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmAssociation;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmColumnReference;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasureDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTaskDimensionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.Association;
import com.ibm.cognos.fmeng.fmmd.model.BuilderFactory;
import com.ibm.cognos.fmeng.fmmd.model.Cardinality;
import com.ibm.cognos.fmeng.fmmd.model.ColumnReference;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.LevelReference;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.Project;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.RelationalQuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.Relationship;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipParent;
import com.ibm.cognos.fmeng.fmmd.model.Section;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.fmmd.model.TaskCubeBuilder;
import com.ibm.cognos.fmeng.fmmd.model.TaskDimensionBuilder;
import com.ibm.cognos.fmeng.fmmd.util.FmRoute;
import com.ibm.cognos.fmeng.fmmd.util.FmRoutes;
import com.ibm.cognos.fmeng.fmmd.util.FmRoutesCache;
import com.ibm.cognos.fmeng.metadata.MdBase;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdJoin;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmTaskCubeBuilder
implements TaskCubeBuilder {
    private FmRoutesCache<MdTable, MdJoin> m_MdCache = null;
    FMMDSession m_Session;

    public static TaskCubeBuilder getInstance(FMMDSession session) {
        return new FmTaskCubeBuilder(session);
    }

    private FmTaskCubeBuilder(FMMDSession session) {
        this.m_Session = session;
        this.m_MdCache = new FmRoutesCache(session.m_RoutesGovernor.get(), true);
    }

    @Override
    public Cube createCube(Section parent, String cubeName, MdTable factTable) {
        FMMDSession session = parent.getSession();
        Cube newCube = parent.createCube(cubeName);
        MeasureDimension measDim = newCube.createMeasureDimension(FmMeasureDimension.getDefaultName(session.getActiveLocale()));
        if (factTable != null) {
            FmTaskDimensionBuilder measBuilder = (FmTaskDimensionBuilder)session.getTaskDimensionBuilder(measDim);
            measBuilder.createMeasuresFromTable(measDim, factTable);
        }
        return newCube;
    }

    @Override
    public List<Relationship> addDimension(Cube cube, RelationalDimension dimension) {
        ArrayList<RelationalDimension> dimensions = new ArrayList<RelationalDimension>();
        dimensions.add(dimension);
        return this.addDimensions(cube, dimensions);
    }

    @Override
    public List<Relationship> addDimensions(Cube cube, List<RelationalDimension> dimensions) {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        MeasureDimension measDim = cube.getMeasureDimension();
        if (measDim == null) {
            throw new FmMDException("BMT_MD_NO_MEASURE_DIMENSIONS_FOUND", cube.getName());
        }
        List<Table> measTables = measDim.getTables();
        Table measTable = null;
        MdTable measMdTable = null;
        if (measTables.size() > 0) {
            measTable = measDim.getTables().get(0);
            measMdTable = measTable.getPhysicalTable(true);
        }
        for (RelationalDimension dimension : dimensions) {
            boolean relationshipExists = false;
            List<Table> dimTables = dimension.getBottomTables();
            for (Relationship rel : cube.getRelationships()) {
                if (!rel.getLeftEnd().equals(dimension) && !rel.getRightEnd().equals(dimension)) continue;
                relationshipExists = true;
                break;
            }
            if (relationshipExists) continue;
            this.joinDimension(cube, dimension, dimTables, measDim, measTable, measMdTable, relationships);
        }
        for (Relationship newRelationship : relationships) {
            newRelationship.setLeftMincard(Cardinality.ECardinality.one);
            newRelationship.setLeftMaxcard(Cardinality.ECardinality.one);
            newRelationship.setRightMincard(Cardinality.ECardinality.one);
            newRelationship.setRightMaxcard(Cardinality.ECardinality.many);
        }
        return relationships;
    }

    @Override
    public void inferRelationExpressions(Cube cube) {
        for (Relationship rel : cube.getRelationships()) {
            Expression expr = rel.getExpression();
            if (expr != null && expr.getComponents().size() != 0) continue;
            RelationalDimension dim = null;
            MeasureDimension measDim = cube.getMeasureDimension();
            dim = rel.getLeftEnd().equals(measDim) ? (RelationalDimension)rel.getRightEnd() : (RelationalDimension)rel.getLeftEnd();
            List<ExpressionBuilder> expressions = this.inferExpression(dim, measDim, cube);
            if (expressions.size() <= 0) continue;
            rel.setExpression(expressions.get(0));
        }
    }

    private void joinDimension(Cube cube, RelationalDimension dimension, List<Table> dimTables, MeasureDimension measDim, Table measTable, MdTable measMdTable, List<Relationship> relationships) {
        String relSeparator = FmMessage.render("BMT_MDV_RELATIONSHIP_NAME_SEPARATOR", cube.getSession().getActiveLocale());
        List<ExpressionBuilder> expressions = this.inferExpression(dimension, dimTables, measDim, measTable, measMdTable, cube);
        if (expressions.size() > 0) {
            for (ExpressionBuilder expr : expressions) {
                Relationship newRelationship = cube.createRelationship(String.valueOf(dimension.getName()) + relSeparator + measDim.getName(), expr, dimension, measDim);
                relationships.add(newRelationship);
            }
            return;
        }
        ExpressionBuilder builder = BuilderFactory.createExpressionBuilder();
        Relationship newRelationship = cube.createRelationship(String.valueOf(dimension.getName()) + relSeparator + measDim.getName(), builder, dimension, measDim);
        relationships.add(newRelationship);
    }

    private List<ExpressionBuilder> inferExpression(RelationalObject dimension, RelationalObject measDim, RelationshipParent cube) {
        List<Table> dimTables = dimension.getTables();
        List<Table> measTables = measDim.getTables();
        Table measTable = null;
        MdTable measMdTable = null;
        if (measTables != null && measTables.size() > 0) {
            measTable = measTables.get(0);
            measMdTable = measTable.getPhysicalTable(true);
        }
        return this.inferExpression(dimension, dimTables, measDim, measTable, measMdTable, cube);
    }

    private List<ExpressionBuilder> inferExpression(RelationalObject dimension, List<Table> dimTables, RelationalObject measDim, Table measTable, MdTable measMdTable, RelationshipParent cube) {
        ArrayList<ExpressionBuilder> expressions = new ArrayList<ExpressionBuilder>();
        Project project = dimension.getSession().getProject();
        if (dimTables.size() > 0 && measTable != null) {
            MdTable dimMdTable;
            Object dimMdTable2;
            Table dimTable3;
            for (Table dimTable2 : dimTables) {
                if (!dimTable2.isEquivalent(measTable)) continue;
                ExpressionBuilder builder = BuilderFactory.createExpressionBuilder();
                expressions.add(builder);
                return expressions;
            }
            FmRoutes<MdTable, MdJoin> routes = new FmRoutes<MdTable, MdJoin>(this.m_Session.m_RoutesGovernor.get());
            List<Table> bottomTables = dimension.getBottomTables();
            for (Table dimTable3 : bottomTables) {
                dimMdTable2 = dimTable3.getPhysicalTable(true);
                routes.addAll(this.m_MdCache.compute(measMdTable, (MdTable)dimMdTable2, false));
            }
            if (routes.size() == 0) {
                for (Table dimTable3 : dimTables) {
                    dimMdTable2 = dimTable3.getPhysicalTable(true);
                    routes.addAll(this.m_MdCache.compute(measMdTable, (MdTable)dimMdTable2, false));
                }
            }
            routes.trimNonShortest();
            if (routes.size() > 0) {
                int i;
                FmRoutes usedRoutes = new FmRoutes(this.m_Session.m_RoutesGovernor.get());
                block3: for (Relationship rel : cube.getAllRelationships()) {
                    List<Object> components = rel.getExpression().getComponents();
                    i = 0;
                    while (i + 2 < components.size()) {
                        Object obj = components.get(i);
                        Object obj2 = components.get(i + 2);
                        if (!(obj instanceof FmColumnReference) || !(obj2 instanceof FmColumnReference)) continue block3;
                        for (FmRoute route : routes.getAllRoutes()) {
                            int k = 0;
                            while (k < route.getJoinCount()) {
                                MdJoin join = (MdJoin)route.getJoin(k);
                                String leftTable = ((MdTable)join.getLeft()).getName();
                                DataSource leftDs = project.findOrCreateDataSource((MdBase)join.getLeft());
                                DataSource rightDs = project.findOrCreateDataSource((MdBase)join.getRight());
                                String rightTable = ((MdTable)join.getRight()).getName();
                                if (((FmColumnReference)obj).getDataSource().equals(leftDs) && ((FmColumnReference)obj2).getDataSource().equals(rightDs) && ((FmColumnReference)obj).getTableName().equals(leftTable) && ((FmColumnReference)obj2).getTableName().equals(rightTable)) {
                                    for (Association assoc : join.getAssociations()) {
                                        if (!assoc.getLeftColumn().equals(((FmColumnReference)obj).getColumnName()) || !assoc.getRightColumn().equals(((FmColumnReference)obj2).getColumnName()) || usedRoutes.contains(route)) continue;
                                        usedRoutes.addRoute(route);
                                    }
                                }
                                ++k;
                            }
                        }
                        i += 4;
                    }
                }
                FmRoute route = null;
                int i2 = 0;
                while (i2 < routes.size()) {
                    if (!usedRoutes.contains(routes.getRoute(i2))) {
                        route = routes.getRoute(i2);
                        break;
                    }
                    ++i2;
                }
                if (route == null) {
                    route = routes.getAllRoutes().get(0);
                }
                ExpressionBuilder builder = BuilderFactory.createExpressionBuilder();
                TaskDimensionBuilder dimBuilder = FmTaskDimensionBuilder.getInstance(dimension);
                i = 0;
                while (i < route.getJoinCount()) {
                    MdJoin join = (MdJoin)route.getJoin(i);
                    String leftTable = ((MdTable)join.getLeft()).getName();
                    DataSource leftDs = project.findOrCreateDataSource((MdBase)join.getLeft());
                    DataSource rightDs = project.findOrCreateDataSource((MdBase)join.getRight());
                    String rightTable = ((MdTable)join.getRight()).getName();
                    if (i == 0) {
                        RelationalObject rightRO = null;
                        rightRO = measDim.findTable(rightDs, ((MdTable)join.getRight()).getName()) != null ? measDim : dimension;
                        for (Association assoc : join.getAssociations()) {
                            if (builder.getParts().size() != 0) {
                                builder.addExpressionPart("AND", null);
                            }
                            this.addColumnToExpression(builder, leftDs, leftTable, assoc.getLeftColumn(), dimension);
                            builder.addExpressionPart(FmAssociation.getOperatorAsString(assoc.getOperator()), null);
                            this.addColumnToExpression(builder, rightDs, rightTable, assoc.getRightColumn(), rightRO);
                        }
                    } else {
                        dimBuilder.addTableToRelationalObject(leftDs, (MdTable)join.getLeft());
                        dimBuilder.addTableToRelationalObject(rightDs, (MdTable)join.getRight());
                    }
                    ++i;
                }
                expressions.add(builder);
                return expressions;
            }
            if (bottomTables.size() == 1 && (dimMdTable = (dimTable3 = bottomTables.get(0)).getPhysicalTable(true)) != null && measMdTable != null) {
                ExpressionBuilder builder = BuilderFactory.createExpressionBuilder();
                List<MdColumn> measColumns = measMdTable.getColumns();
                ArrayList<MdColumn> dimColumns = new ArrayList<MdColumn>();
                for (MdColumn column : dimMdTable.getColumns()) {
                    if (!column.isPrimaryKey()) continue;
                    dimColumns.add(column);
                }
                this.inferExpressionFromColumnNames(dimension, measDim, measMdTable, project, dimMdTable, builder, dimColumns, measColumns);
                if (builder.getParts().size() != 0) {
                    expressions.add(builder);
                    return expressions;
                }
                dimColumns = new ArrayList();
                for (MdColumn column : dimMdTable.getColumns()) {
                    if (column.isKey()) continue;
                    dimColumns.add(column);
                }
                this.inferExpressionFromColumnNames(dimension, measDim, measMdTable, project, dimMdTable, builder, dimColumns, measColumns);
                if (builder.getParts().size() != 0) {
                    expressions.add(builder);
                    return expressions;
                }
            }
        }
        return expressions;
    }

    private void addColumnToExpression(ExpressionBuilder builder, DataSource ds, String tableName, String columnName, RelationalObject ro) {
        if (ro instanceof RelationalQuerySubject) {
            RelationalQuerySubject rqs = (RelationalQuerySubject)ro;
            QueryItemBase qi = null;
            List<QueryItemBase> qis = rqs.findMappedQueryItems(ds.getName(), tableName, columnName);
            if (qis.size() > 0) {
                qi = qis.get(0);
            } else {
                MdTable table = ro.getSession().findPhysicalTable(ds, tableName, false);
                MdColumn col = null;
                if (table != null) {
                    col = table.findColumn(columnName);
                }
                if (col != null) {
                    TaskDimensionBuilder task = ro.getSession().getTaskDimensionBuilder(rqs);
                    qi = task.createQueryItemFromColumn(rqs, col);
                } else {
                    qi = rqs.createQueryItem(columnName, null);
                }
            }
            FmMDException.ASSERT(qi != null, "Couldn't find or create a query item for " + ds.getName() + "." + tableName + "." + columnName);
            builder.addExpressionPart(qi, null, null);
        } else {
            builder.addExpressionPart(ds, columnName, tableName, ro, null);
        }
    }

    private void inferExpressionFromColumnNames(RelationalObject dimension, RelationalObject measDim, MdTable measMdTable, Project project, MdTable dimMdTable, ExpressionBuilder builder, List<MdColumn> dimColumns, List<MdColumn> measColumns) {
        DataSource leftDs = null;
        DataSource rightDs = null;
        for (MdColumn leftColumn : dimColumns) {
            for (MdColumn rightColumn : measColumns) {
                if (!leftColumn.getName().equals(rightColumn.getName())) continue;
                if (builder.getParts().size() != 0) {
                    builder.addExpressionPart("AND", null);
                }
                if (leftDs == null) {
                    leftDs = project.findOrCreateDataSource(leftColumn);
                }
                if (rightDs == null) {
                    rightDs = project.findOrCreateDataSource(rightColumn);
                }
                this.addColumnToExpression(builder, leftDs, dimMdTable.getName(), leftColumn.getName(), dimension);
                builder.addExpressionPart("=", null);
                this.addColumnToExpression(builder, rightDs, measMdTable.getName(), rightColumn.getName(), measDim);
            }
        }
    }

    @Override
    public Relationship createRelationship(Section parent, RelationalObject leftRQS, RelationalObject rightRQS) {
        List<ExpressionBuilder> exprs = this.inferExpression(leftRQS, rightRQS, parent);
        ExpressionBuilder builder = BuilderFactory.createExpressionBuilder();
        if (exprs.size() > 0) {
            builder = exprs.get(0);
        }
        Relationship relationship = parent.createRelationship(builder, leftRQS, rightRQS);
        if (leftRQS instanceof RelationalDimension) {
            relationship.setLeftMincard(Cardinality.ECardinality.one);
            relationship.setLeftMaxcard(Cardinality.ECardinality.one);
            relationship.setRightMincard(Cardinality.ECardinality.one);
            relationship.setRightMaxcard(Cardinality.ECardinality.many);
        } else if (rightRQS instanceof RelationalDimension) {
            relationship.setLeftMincard(Cardinality.ECardinality.one);
            relationship.setLeftMaxcard(Cardinality.ECardinality.many);
            relationship.setRightMincard(Cardinality.ECardinality.one);
            relationship.setRightMaxcard(Cardinality.ECardinality.one);
        }
        this.inferJoinsAtLowestLevel(relationship);
        return relationship;
    }

    private void inferJoinsAtLowestLevel(Relationship relationship) {
        RelationalDimension dim = null;
        Expression expr = relationship.getExpression();
        if (relationship.getLeftEnd() instanceof RelationalDimension) {
            dim = (RelationalDimension)relationship.getLeftEnd();
        } else if (relationship.getRightEnd() instanceof RelationalDimension) {
            dim = (RelationalDimension)relationship.getRightEnd();
        }
        if (dim != null && expr != null) {
            for (RelationalHierarchy hier : dim.getAllHierarchies()) {
                LevelReference lowestLevelRef = hier.getLastLevelReference();
                for (LevelReference levelRef : hier.getLevelReferences()) {
                    Level level = levelRef.getLevel();
                    for (QueryItem levelKey : level.getLevelKeys()) {
                        QueryItemMapping mapping = dim.findMapping(levelKey);
                        if (mapping == null) continue;
                        for (Object obj : expr.getComponents()) {
                            ColumnReference columnRef;
                            if (!(obj instanceof ColumnReference) || !(columnRef = (ColumnReference)obj).equals(mapping)) continue;
                            if (levelRef.equals(lowestLevelRef)) {
                                relationship.setDimensionJoinsOnLowestLevel(true);
                            } else {
                                relationship.setDimensionJoinsOnLowestLevel(false);
                            }
                            return;
                        }
                    }
                }
            }
        }
    }
}

