/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.CubeBuilder;
import com.ibm.cognos.fmeng.fmmd.model.Dimension;
import com.ibm.cognos.fmeng.fmmd.model.Namespace;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.model.Section;
import com.ibm.cognos.fmeng.fmmd.model.TaskDMRtoROLAP;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FmTaskDMRtoROLAP
implements TaskDMRtoROLAP {
    private FmTaskDMRtoROLAP() {
    }

    public static FmTaskDMRtoROLAP getInstance() {
        return new FmTaskDMRtoROLAP();
    }

    @Override
    public List<FmMessage> convertToCube(Section parentSection, List<Dimension> dimensions, String name) {
        if (parentSection == null) {
            throw new FmMDException("BMT_MD_NO_CONTAINER_SECTION_SPECIFIED");
        }
        if (dimensions.size() == 0) {
            throw new FmMDException("BMT_MD_NO_NAMESPACE_DIMENSIONS_SPECIFIED");
        }
        FMMDSession oldSession = dimensions.get(0).getSession();
        FMMDSession newSession = parentSection.getSession();
        FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.FM_IMPORT, newSession, "Start import " + Integer.toString(dimensions.size()) + " dimensions.");
        FmEngApplicationLog.getApplicationLog().dumpMemoryUsage(newSession);
        CubeBuilder cubeBuilder = new CubeBuilder(oldSession, newSession);
        List<FmMessage> msgs = cubeBuilder.convertToCube(parentSection, dimensions, name);
        cubeBuilder = null;
        FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.FM_IMPORT, newSession, "End import " + Integer.toString(dimensions.size()) + " dimensions.");
        FmEngApplicationLog.getApplicationLog().dumpMemoryUsage(newSession);
        return msgs;
    }

    @Override
    public List<FmMessage> convertToCube(Section parentSection, Section dmrNamespace) {
        if (parentSection == null) {
            throw new FmMDException("BMT_MD_NO_CONTAINER_SECTION_SPECIFIED");
        }
        if (dmrNamespace == null) {
            throw new FmMDException("BMT_MD_NO_NAMESPACE_DIMENSIONS_SPECIFIED");
        }
        FMMDSession oldSession = dmrNamespace.getSession();
        FMMDSession newSession = parentSection.getSession();
        CubeBuilder cubeBuilder = new CubeBuilder(oldSession, newSession);
        return cubeBuilder.convertToCube(parentSection, dmrNamespace);
    }

    @Override
    public List<FmMessage> convertToRelational(Section targetSection, Namespace srcNamespace) {
        if (targetSection == null) {
            throw new FmMDException("BMT_MD_NO_CONTAINER_SECTION_SPECIFIED");
        }
        if (srcNamespace == null) {
            throw new FmMDException("BMT_MD_NO_NAMESPACE_DIMENSIONS_SPECIFIED");
        }
        FMMDSession oldSession = srcNamespace.getSession();
        FMMDSession newSession = targetSection.getSession();
        CubeBuilder cubeBuilder = new CubeBuilder(oldSession, newSession);
        List<FmMessage> msgs = cubeBuilder.convertToRelational(targetSection, srcNamespace);
        cubeBuilder = null;
        return msgs;
    }

    @Override
    public List<FmMessage> convertTo(Section targetSection, TopLevelObject srcObject, FmObjectType targetType) {
        List<FmMessage> messages = null;
        if (targetSection == null) {
            throw new FmMDException("BMT_MD_NO_CONTAINER_SECTION_SPECIFIED");
        }
        if (srcObject == null) {
            throw new FmMDException("BMT_MD_NO_NAMESPACE_DIMENSIONS_SPECIFIED");
        }
        FMMDSession oldSession = srcObject.getSession();
        FMMDSession newSession = targetSection.getSession();
        FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.FM_IMPORT, newSession, "Start import " + srcObject.getName() + " to " + targetType.toString());
        FmEngApplicationLog.getApplicationLog().dumpMemoryUsage(newSession);
        CubeBuilder cubeBuilder = new CubeBuilder(oldSession, newSession);
        block0 : switch (srcObject.getFmObjectType()) {
            case namespace: {
                switch (targetType) {
                    case cube: {
                        messages = cubeBuilder.convertToCube(targetSection, (Namespace)srcObject);
                        break block0;
                    }
                    case relationalQuerySubject: {
                        messages = cubeBuilder.convertToRelational(targetSection, (Namespace)srcObject);
                        break block0;
                    }
                }
                FmMDException.ASSERT(false, "Unexpected target type: " + targetType.toString() + " for object " + srcObject.getName());
                break;
            }
            case dimension: {
                switch (targetType) {
                    case cube: 
                    case measureDimension: {
                        ArrayList<Dimension> dims = new ArrayList<Dimension>(1);
                        dims.add((Dimension)srcObject);
                        messages = cubeBuilder.convertToCube(targetSection, dims, srcObject.getName());
                        break block0;
                    }
                    case relationalDimension: {
                        ArrayList<QuerySubjectBase> dims = new ArrayList<QuerySubjectBase>(1);
                        dims.add((Dimension)srcObject);
                        messages = cubeBuilder.convertToDimension(targetSection, dims);
                        break block0;
                    }
                }
                FmMDException.ASSERT(false, "Unexpected target type: " + targetType.toString() + " for object " + srcObject.getName());
                break;
            }
            case querySubject: {
                switch (targetType) {
                    case measureDimension: {
                        messages = cubeBuilder.convertToMeasureDimensionToCube(targetSection, (QuerySubjectBase)srcObject);
                        break block0;
                    }
                    case relationalDimension: {
                        ArrayList<QuerySubjectBase> qses = new ArrayList<QuerySubjectBase>(1);
                        qses.add((QuerySubjectBase)srcObject);
                        messages = cubeBuilder.convertToDimension(targetSection, qses);
                        break block0;
                    }
                    case relationalQuerySubject: {
                        ArrayList<QuerySubject> qses = new ArrayList<QuerySubject>(1);
                        qses.add((QuerySubject)srcObject);
                        messages = cubeBuilder.convertToRelational(targetSection, qses);
                        break block0;
                    }
                }
                FmMDException.ASSERT(false, "Unexpected target type: " + targetType.toString() + " for object " + srcObject.getName());
                break;
            }
            default: {
                FmMDException.ASSERT(false, "Unsupported source type: " + srcObject.getName());
            }
        }
        cubeBuilder = null;
        FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.FM_IMPORT, newSession, "End import " + srcObject.getName() + " to " + targetType.toString());
        FmEngApplicationLog.getApplicationLog().dumpMemoryUsage(newSession);
        return messages;
    }
}

