/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmJoin;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPhysicalDefinition;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTable;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTaskCubeBuilder;
import com.ibm.cognos.fmeng.fmmd.model.Association;
import com.ibm.cognos.fmeng.fmmd.model.Cardinality;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.FmUsage;
import com.ibm.cognos.fmeng.fmmd.model.Join;
import com.ibm.cognos.fmeng.fmmd.model.Measure;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemParent;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.RelationalQuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.fmmd.model.TaskCubeBuilder;
import com.ibm.cognos.fmeng.fmmd.model.TaskDimensionBuilder;
import com.ibm.cognos.fmeng.fmmd.util.FmJoinHelper;
import com.ibm.cognos.fmeng.fmmd.util.FmRoute;
import com.ibm.cognos.fmeng.fmmd.util.FmRoutes;
import com.ibm.cognos.fmeng.fmmd.util.FmRoutesCache;
import com.ibm.cognos.fmeng.fmmd.util.StringHelper;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdDatabase;
import com.ibm.cognos.fmeng.metadata.MdJoin;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmTaskDimensionBuilder
implements TaskDimensionBuilder {
    private RelationalObject m_Dimension = null;
    private FmPhysicalDefinition m_PhysDef = null;
    private HashMap<MdTable, Table> m_Tables = null;
    private FmRoutesCache<MdTable, MdJoin> m_MdCache = null;
    private DataSource m_Source;
    private Table m_NewTable;
    private FmJoinHelper<MdTable, MdJoin> m_JoinHelper = null;

    private FmTaskDimensionBuilder(RelationalObject dimension) {
        this.m_Dimension = dimension;
        this.m_PhysDef = ((FmRelationalObject)dimension).getPhysicalDefinition();
        this.m_MdCache = new FmRoutesCache(dimension.getSession().m_RoutesGovernor.get(), true);
        this.m_JoinHelper = new FmJoinHelper();
    }

    public static TaskDimensionBuilder getInstance(RelationalObject relationalObj) {
        return new FmTaskDimensionBuilder(relationalObj);
    }

    @Override
    public QueryItem createQueryItemFromColumn(QueryItemParent parent, MdColumn column) {
        String name = StringHelper.prettyPrint(column.getName());
        if (this.m_Dimension instanceof RelationalDimension && name != null) {
            String originalName = name;
            boolean isUnique = false;
            List<QueryItem> allItems = ((RelationalDimension)this.m_Dimension).getAllQueryItems();
            int iCount = 1;
            block0: while (!isUnique) {
                isUnique = true;
                for (QueryItem item : allItems) {
                    if (!name.equals(item.getName())) continue;
                    isUnique = false;
                    name = String.valueOf(originalName) + Integer.toString(iCount++);
                    continue block0;
                }
            }
        }
        QueryItem qi = parent.createQueryItemFromColumn(name, column);
        this.addQueryItemMapping(qi, column);
        return qi;
    }

    @Override
    public List<QueryItem> createQueryItemsFromColumns(QueryItemParent parent, List<MdColumn> columns, boolean throwOnUnsupportedDatatype) {
        ArrayList<QueryItem> queryItems = new ArrayList<QueryItem>();
        for (MdColumn column : columns) {
            if (FmDatatype.isUnsupportedByROLAP(column.getDatatype()).booleanValue() && !(parent instanceof RelationalQuerySubject)) {
                if (!throwOnUnsupportedDatatype) continue;
                throw new FmMDException("BMT_MD_UNSUPPORTED_DATATYPE_COLUMN", column.getDatatype().toString(), column.getName());
            }
            queryItems.add(this.createQueryItemFromColumn(parent, column));
        }
        return queryItems;
    }

    @Override
    public List<QueryItem> createQueryItemsFromColumns(QueryItemParent parent, List<MdColumn> columns) {
        return this.createQueryItemsFromColumns(parent, columns, false);
    }

    @Override
    public Measure createMeasureFromColumn(MeasureDimension measureDim, MdColumn column) {
        if (!((MeasureDimension)this.m_Dimension).canUseTable(column.getTable())) {
            List<Table> tables = this.m_Dimension.getTables();
            throw new FmMDException("BMT_MD_ONE_TABLE_ONLY_FOR_MEASURE_DIMENSIONS", this.m_Dimension.getName(), tables.get(0).getName());
        }
        boolean hasTable = measureDim.getTables().size() > 0;
        Measure qi = measureDim.createMeasureFromColumn(StringHelper.prettyPrint(column.getName()), column);
        this.addQueryItemMapping(qi, column);
        qi.setUsage(FmUsage.fact);
        if (!hasTable && measureDim.getParent() instanceof Cube) {
            TaskCubeBuilder builder = FmTaskCubeBuilder.getInstance(this.m_Dimension.getSession());
            builder.inferRelationExpressions((Cube)measureDim.getParent());
        }
        return qi;
    }

    @Override
    public List<Measure> createMeasuresFromColumns(MeasureDimension measureDim, List<MdColumn> columns) {
        ArrayList<Measure> measures = new ArrayList<Measure>();
        for (MdColumn column : columns) {
            if (column == null) continue;
            measures.add(this.createMeasureFromColumn(measureDim, column));
        }
        return measures;
    }

    @Override
    public List<Measure> createMeasuresFromTable(MeasureDimension measureDim, MdTable table) {
        ArrayList<Measure> measures = new ArrayList<Measure>();
        for (MdColumn column : table.getColumns()) {
            if (column == null || column.isKey() || !FmDatatype.isNumeric(column.getDatatype()).booleanValue()) continue;
            measures.add(this.createMeasureFromColumn(measureDim, column));
        }
        return measures;
    }

    @Override
    public QueryItemMapping addQueryItemMapping(QueryItemBase item, MdColumn column) {
        if (!this.m_Dimension.isAncestor(item)) {
            return null;
        }
        if (column == null) {
            return null;
        }
        QueryItemMapping mapping = null;
        MdTable mdTable = column.getTable();
        mapping = this.m_PhysDef.findMapping(item);
        if (mapping != null) {
            this.m_PhysDef.removeQueryItemMapping(mapping);
        }
        DataSource source = item.getSession().getProject().findOrCreateDataSource(column);
        this.Initialize(source, column.getDatabase());
        Table table = this.findOrCreateTable(source, mdTable);
        mapping = this.m_PhysDef.createQueryItemMapping(item, column.getName(), table);
        item.copyColumnProperties(column);
        if (this.m_Dimension instanceof RelationalDimension && item.getUsage().equals((Object)FmUsage.fact)) {
            item.setUsage(FmUsage.attribute);
        }
        return mapping;
    }

    @Override
    public Table addTableToRelationalObject(MdTable tbl) {
        DataSource ds = this.m_Dimension.getSession().getProject().findOrCreateDataSource(tbl);
        this.Initialize(ds, tbl.getDatabase());
        Table table = this.findOrCreateTable(ds, tbl);
        return table;
    }

    @Override
    public Table addTableToRelationalObject(DataSource source, MdTable mdTable) {
        this.Initialize(source, mdTable.getDatabase());
        Table table = this.findOrCreateTable(source, mdTable);
        return table;
    }

    @Override
    public void removeQueryItem(QueryItemBase item) {
        QueryItemMapping mapping = this.m_PhysDef.findMapping(item);
        if (mapping != null) {
            this.m_PhysDef.removeQueryItemMapping(mapping);
        }
        this.m_PhysDef.getSession().delete(item);
    }

    @Override
    public void removeQueryItemMapping(QueryItemBase item) {
        FmMDException.ASSERT(this.m_PhysDef != null, "No physical definition for dimension builder.");
        QueryItemMapping mapping = this.m_PhysDef.findMapping(item);
        if (mapping == null) {
            return;
        }
        this.m_PhysDef.removeQueryItemMapping(mapping);
    }

    private void Initialize(DataSource source, MdDatabase metadataSource) {
        this.m_Source = source;
        this.m_NewTable = null;
        this.m_Tables = new HashMap();
        for (Table someTable : this.m_PhysDef.getTables()) {
            if (someTable.getPhysicalTable(true) == null) continue;
            this.m_Tables.put(someTable.getPhysicalTable(true), someTable);
        }
    }

    private Table findOrCreateTable(DataSource source, MdTable mdTable) {
        if (this.m_Dimension instanceof MeasureDimension && !((MeasureDimension)this.m_Dimension).canUseTable(mdTable)) {
            List<Table> tables = this.m_Dimension.getTables();
            throw new FmMDException("BMT_MD_ONE_TABLE_ONLY_FOR_MEASURE_DIMENSIONS", this.m_Dimension.getName(), tables.get(0).getName());
        }
        FmRoutes<MdTable, MdJoin> routes1 = null;
        FmRoutes<MdTable, MdJoin> routes2 = null;
        FmRoutes<MdTable, MdJoin> allRoutes = new FmRoutes<MdTable, MdJoin>(this.m_Dimension.getSession().m_RoutesGovernor.get(), 2, false);
        Table newTable = null;
        HashSet<Table> newTables = new HashSet<Table>();
        newTable = this.m_PhysDef.findTable(source, mdTable.getName());
        if (newTable == null) {
            for (MdTable oldTable : this.m_Tables.keySet()) {
                routes1 = this.m_MdCache.compute(oldTable, mdTable, false);
                routes2 = this.m_MdCache.compute(mdTable, oldTable, false);
                allRoutes.addAll(routes1);
                allRoutes.addAll(routes2);
            }
            if (allRoutes.size() > 0) {
                newTable = this.elevate(allRoutes, mdTable, newTables);
            } else {
                for (Table someTable : this.m_Dimension.getTables()) {
                    MdTable dimMdTable = someTable.getPhysicalTable(true);
                    if (dimMdTable == null) continue;
                    for (MdColumn leftColumn : mdTable.getColumns()) {
                        for (MdColumn rightColumn : dimMdTable.getColumns()) {
                            if (!leftColumn.getName().equals(rightColumn.getName())) continue;
                            newTable = this.createTableInternal(source, mdTable);
                            FmJoin newJoin = this.m_PhysDef.createJoin(String.valueOf(someTable.getName()) + "-->" + newTable.getName(), someTable, newTable);
                            newJoin.setLeftMincard(Cardinality.ECardinality.one);
                            newJoin.setLeftMaxcard(Cardinality.ECardinality.one);
                            newJoin.setRightMincard(Cardinality.ECardinality.one);
                            newJoin.setRightMaxcard(Cardinality.ECardinality.many);
                            newJoin.createAssociation(leftColumn.getName(), rightColumn.getName(), Association.EOperator.equals);
                            return newTable;
                        }
                    }
                }
            }
        }
        if (newTable == null) {
            newTable = this.createTableInternal(source, mdTable);
        }
        return newTable;
    }

    private Table createTableInternal(DataSource source, MdTable mdTable) {
        FmTable newTable = this.m_PhysDef.createTable(source, mdTable.getName());
        ((EMFSession)this.m_PhysDef.getSession()).addDatabase(mdTable.getDatabase());
        this.m_Tables.put(mdTable, newTable);
        return newTable;
    }

    public Table elevate(FmRoutes<MdTable, MdJoin> routes, MdTable dbTable, HashSet<Table> newTables) {
        if (routes == null) {
            return null;
        }
        if (routes.size() == 0) {
            return null;
        }
        for (FmRoute<MdTable, MdJoin> route : routes.getAllRoutes()) {
            this.elevateNextTable(0, route, dbTable, newTables);
        }
        return this.m_NewTable;
    }

    private Table elevateNextTable(int iCurNode, FmRoute<MdTable, MdJoin> route, MdTable dbTable, HashSet<Table> newTables) {
        Table nextWBTable = null;
        Table curWBTable = null;
        if (iCurNode >= route.getNodeCount()) {
            return null;
        }
        MdTable curTable = route.getNode(iCurNode);
        if (this.m_Tables.containsKey(curTable)) {
            curWBTable = this.m_Tables.get(curTable);
        }
        if (curWBTable == null) {
            curWBTable = this.createTableInternal(this.m_Source, curTable);
            newTables.add(curWBTable);
        }
        if (this.getTable(curWBTable).equals(dbTable)) {
            this.m_NewTable = curWBTable;
        }
        if ((nextWBTable = this.elevateNextTable(iCurNode + 1, route, dbTable, newTables)) == null) {
            return curWBTable;
        }
        if (!curWBTable.hasJoin(nextWBTable) && (newTables.contains(curWBTable) || newTables.contains(nextWBTable))) {
            List<MdJoin> pmJoins = this.m_JoinHelper.getJoins(this.getTable(nextWBTable), this.getTable(curWBTable));
            for (MdJoin pmJoin : pmJoins) {
                this.createJoin(pmJoin, nextWBTable, curWBTable);
                for (MdJoin backJoin : this.m_JoinHelper.getJoins(this.getTable(curWBTable), this.getTable(nextWBTable))) {
                    this.createJoin(backJoin, curWBTable, nextWBTable);
                }
            }
        }
        if (!this.m_Tables.containsKey(this.getTable(nextWBTable))) {
            this.m_Tables.put(this.getTable(nextWBTable), nextWBTable);
        }
        if (iCurNode == 0 && !this.m_Tables.containsKey(this.getTable(curWBTable))) {
            this.m_Tables.put(this.getTable(curWBTable), curWBTable);
        }
        return curWBTable;
    }

    private Join createJoin(MdJoin physJoin, Table startTable, Table endTable) {
        FmJoin newJoin = this.m_PhysDef.createJoin(physJoin.getName(), startTable, endTable);
        for (Association key : physJoin.getAssociations()) {
            newJoin.createAssociation(key.getLeftColumn(), key.getRightColumn(), key.getOperator());
        }
        return newJoin;
    }

    private MdTable getTable(Table table) {
        for (MdTable mdTable : this.m_Tables.keySet()) {
            if (!table.equals(this.m_Tables.get(mdTable))) continue;
            return mdTable;
        }
        return null;
    }
}

