/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.ibm.cognos.fmeng.fmmd.impl.model.AccessRuleParentInternal;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLocaleMapping;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasureDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMemberUniqueName;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelBuilderDC;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMultilingualAttribute;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRefobjViaShortcut;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmShortcut;
import com.ibm.cognos.fmeng.fmmd.impl.task.OneToOneModelSerializer;
import com.ibm.cognos.fmeng.fmmd.model.AccessRule;
import com.ibm.cognos.fmeng.fmmd.model.AccessView;
import com.ibm.cognos.fmeng.fmmd.model.AggregateCube;
import com.ibm.cognos.fmeng.fmmd.model.AggregateDimension;
import com.ibm.cognos.fmeng.fmmd.model.AggregateHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.AggregateLevel;
import com.ibm.cognos.fmeng.fmmd.model.AggregateMeasure;
import com.ibm.cognos.fmeng.fmmd.model.AggregateRule;
import com.ibm.cognos.fmeng.fmmd.model.AttributeReference;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.CalculatedMember;
import com.ibm.cognos.fmeng.fmmd.model.ColumnReference;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.CubeBase;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionHandler;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.FmRegularAggregate;
import com.ibm.cognos.fmeng.fmmd.model.HierarchyBase;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.LevelBase;
import com.ibm.cognos.fmeng.fmmd.model.LevelReference;
import com.ibm.cognos.fmeng.fmmd.model.LocalizedValue;
import com.ibm.cognos.fmeng.fmmd.model.Measure;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.MeasureFolder;
import com.ibm.cognos.fmeng.fmmd.model.MemberUniqueName;
import com.ibm.cognos.fmeng.fmmd.model.NamedSet;
import com.ibm.cognos.fmeng.fmmd.model.NamedSetFolder;
import com.ibm.cognos.fmeng.fmmd.model.NamedSetParent;
import com.ibm.cognos.fmeng.fmmd.model.Namespace;
import com.ibm.cognos.fmeng.fmmd.model.PackageBase;
import com.ibm.cognos.fmeng.fmmd.model.Project;
import com.ibm.cognos.fmeng.fmmd.model.Property;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.model.ReferenceViaShortcut;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.Relationship;
import com.ibm.cognos.fmeng.fmmd.model.RelativeTimeMember;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.Role;
import com.ibm.cognos.fmeng.fmmd.model.Shortcut;
import com.ibm.cognos.fmeng.fmmd.model.SortItem;
import com.ibm.cognos.fmeng.fmmd.model.SourceMember;
import com.ibm.cognos.fmeng.fmmd.model.SourceObject;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.fmmd.model.TaskAnalyseObject;
import com.ibm.cognos.fmeng.fmmd.model.TaskExportToCognosROLAP;
import com.ibm.cognos.fmeng.fmmd.model.VirtualCube;
import com.ibm.cognos.fmeng.fmmd.model.VirtualDimension;
import com.ibm.cognos.fmeng.fmmd.model.VirtualDimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.VirtualHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.VirtualLevel;
import com.ibm.cognos.fmeng.fmmd.model.VirtualMeasure;
import com.ibm.cognos.fmeng.fmmd.model.VirtualMeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.VirtualMeasureFolder;
import com.ibm.cognos.fmeng.fmmd.model.VirtualMember;
import com.ibm.cognos.fmeng.fmmd.model.VirtualObject;
import com.ibm.cognos.fmeng.fmmd.util.CmHelper;
import com.ibm.cognos.fmeng.fmmd.util.StringHelper;
import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.platform.EventCallbackHandler;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.ProjectFactory;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.utility.EMFCustomModelSerializer;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmTaskExportToCognosROLAP
implements TaskExportToCognosROLAP {
    private static final String TAG_ATTR_category = "category";
    private static final String TAG_ATTR_comments = "comments";
    private static final String TAG_ATTR_modifier = "modifier";
    private static final String TAG_ATTR_name = "name";
    private static final String TAG_ATTR_refObject = "refObject";
    private static final String TAG_ATTR_type = "type";
    private static final String TAG_ATTR_uuid = "uuid";
    private static final String TAG_ATTR_locale = "locale";
    private static final String TAG_ATTR_visible = "visible";
    private static final String TAG_ATTR_format = "format";
    private static final String TAG_ATTR_funcDep = "funcDep";
    private static final String TAG_ATTR_mergeOperator = "mergeOperator";
    private static final String TAG_ATTR_localizationMethod = "localizationMethod";
    private static final String TAG_ATTR_hasRelativeTimeMembers = "hasRelativeTimeMembers";
    private static final String TAG_ATTR_defaultLocale = "defaultLocale";
    private static final String TAG_ATTR_securityType = "securityType";
    private static final String TAG_ATTR_contextPeriodOffset = "contextPeriodOffset";
    private static final String TAG_ATTR_targetPeriodOffset = "targetPeriodOffset";
    private static final String TAG_ATTR_numberOfPeriods = "numberOfPeriods";
    private static final String TAG_ATTR_lifeToDate = "isLifeTodate";
    private static final String TAG_ATTR_leverageSharedMemberCache = "leverageSharedMemberCache";
    private static final String TAG_ELE_mdSchema = "olap:mdSchema";
    private static final String TAG_ELE_name = "olap:name";
    private static final String TAG_ELE_attribute = "olap:attribute";
    private static final String TAG_ELE_level = "olap:level";
    private static final String TAG_ELE_levelKeyRef = "olap:levelKeyRef";
    private static final String TAG_ELE_allLevelName = "olap:allLevelName";
    private static final String TAG_ELE_allMemberCaption = "olap:allMemberCaption";
    private static final String TAG_ELE_virtualDimension = "olap:virtualDimension";
    private static final String TAG_ELE_virtualHierarchy = "olap:virtualHierarchy";
    private static final String TAG_ELE_measureFolder = "olap:measureFolder";
    private static final String TAG_ELE_virtualHierarchyFolder = "olap:virtualHierarchyFolder";
    private static final String TAG_ELE_sourceDimRef = "olap:sourceDimensionRef";
    private static final String TAG_ELE_sourceHierRef = "olap:sourceHierarchyRef";
    private static final String TAG_ELE_defaultHierRef = "olap:defaultHierarchyRef";
    private static final String TAG_ELE_defaultMemRef = "olap:defaultMemberRef";
    private static final String TAG_ELE_virtualMem = "olap:virtualMember";
    private static final String TAG_ELE_sourceMemRef = "olap:sourceMemberRef";
    private static final String TAG_ELE_caption = "olap:caption";
    private static final String TAG_ELE_defaultAttributeRef = "olap:defaultAttributeRef";
    private static final String TAG_ELE_businessKeyAttributeRef = "olap:businessKeyAttributeRef";
    private static final String TAG_ELE_relativeTimeMemberType = "olap:relativeTimeMemberType";
    private static final String TAG_ELE_currentPeriodExpression = "olap:currentPeriodExpression";
    private static final String TAG_ELE_securityRules = "olap:securityRules";
    private static final String TAG_ELE_factTransactionId = "olap:factTransactionId";
    private static final String TAG_ELE_namedSets = "olap:namedSets";
    private static final String TAG_ELE_namedSet = "olap:namedSet";
    private static final String TAG_ELE_virtualNamedSets = "olap:virtualNamedSets";
    private static final String TAG_ELE_virtualNamedSet = "olap:virtualNamedSet";
    private static final String TAG_ELE_displayPath = "olap:displayPath";
    private static final String TAG_ELE_queryItem = "olap:queryItem";
    private static final String gCS_MODEL_PARENT_LEVEL_DEFAULT_NAME = "Parent_Level";
    private static final String gCS_MODEL_MEMBER_LEVEL_DEFAULT_NAME = "Member_Level";
    private static final String gMEMBER_QUERY_PACKAGE_NAME = "__MemberQueryPkg";
    private static final String TAG_ELE_simpleRelativeTime = "olap:customSimpleRelativeTimeMember";
    private static final String TAG_ELE_periodToDateRelativeTime = "olap:customPTDRelativeTimeMember";
    private static final String TAG_ELE_RollingTotalRelativeTime = "olap:customRollingTotalRelativeTimeMember";
    private static final String TAG_ELE_contextPeriod = "olap:contextPeriod";
    private static final String TAG_ELE_targetPeriod = "olap:targetPeriod";
    private static final String TAG_ELE_toDatePeriod = "olap:todatePeriod";
    private FMMDSession m_dmrSession = null;
    private FMMDSession m_srcSession = null;
    private HashMap<Object, String> m_idMap = null;
    private FmModelBuilderDC m_ModelBuilderDC = null;
    private Map<Object, Map<Object, String>> m_AttributeAccessRules = null;

    private FmTaskExportToCognosROLAP(FMMDSession session) {
        this.m_srcSession = session;
    }

    private void initDMRSession() {
        this.m_dmrSession = FMMDSession.createFMMDSession(this.m_srcSession);
        this.m_dmrSession.create(ProjectFactory.createInMemoryProject());
        FmTaskExportToCognosROLAP.prepareFMSessionForROLAP(this.m_dmrSession, this.m_srcSession.getDefaultLocale());
        this.m_ModelBuilderDC = new FmModelBuilderDC();
        this.m_idMap = new HashMap();
        this.m_AttributeAccessRules = new HashMap<Object, Map<Object, String>>();
    }

    public static FmTaskExportToCognosROLAP getInstance(FMMDSession session) {
        return new FmTaskExportToCognosROLAP(session);
    }

    @Override
    public List<String> exportToCognosROLAP(PackageBase kPackage) {
        FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_srcSession, "Start create data source for dynamic cubes in package:" + kPackage.getName());
        List<CubeBase> cubes = kPackage.getAllCubes();
        ArrayList<String> outPaths = new ArrayList<String>(cubes.size());
        for (CubeBase someCube : cubes) {
            outPaths.add(this.exportCubeToCognosROLAPInternal(someCube));
        }
        FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_srcSession, "End create data source for dynamic cubes in package:" + kPackage.getName() + ":\n\t" + ((Object)outPaths).toString());
        return outPaths;
    }

    @Override
    public void checkPackageSanity(PackageBase kPackage, List<FeedbackMessage> messages, boolean isPublish) {
        FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_srcSession, "Start pre-publish sanity check.");
        if (this.sanityCheck(kPackage, TaskAnalyseObject.AnalysisContext.publish, true, messages)) {
            EventCallbackHandler callback = this.m_srcSession.getEventCallbackHandler();
            FmMessage msg = null;
            msg = kPackage.isStupidSpecialCaseCubeHandling() ? (isPublish ? new FmMessage("BMT_UIP_PUBLISH_WITH_WARNINGS_CONFIRMATION", kPackage.getName()) : new FmMessage("BMT_UIP_DEPLOY_CUBE_WITH_WARNINGS_CONFIRMATION", kPackage.getAllCubes().get(0).getName())) : new FmMessage("BMT_UIP_PUBLISH_PACKAGE_WITH_WARNINGS_CONFIRMATION", kPackage.getName());
            if (callback != null && !callback.doBooleanPrompt(msg)) {
                throw new FmMDException("BMT_MD_CANCELED");
            }
        }
        FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_srcSession, "End pre-publish sanity check.");
    }

    @Override
    public void associateAccountWithRolapDataSource(String cubePath, boolean isVirtual) {
        FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_srcSession, "Start associate current user account with cube: " + cubePath);
        CmHelper cmHelper = CmHelper.get(this.m_srcSession, this.m_srcSession.getPassport());
        cmHelper.associateAccountWithRolapDataSource(cubePath, isVirtual);
        FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_srcSession, "End associate current user account with cube: " + cubePath);
    }

    @Override
    public HashMap<CubeBase, String> exportToCognosROLAP(String directory, boolean includeROLAPModelAsProperty, List<FeedbackMessage> messages) throws IOException {
        Namespace ns = this.m_srcSession.getProject().getRootNamespace();
        HashMap<CubeBase, String> cubes = new HashMap<CubeBase, String>();
        List<CubeBase> allCubes = ns.getAllCubes();
        for (CubeBase someCube : allCubes) {
            this.sanityCheck(someCube, TaskAnalyseObject.AnalysisContext.publish, false, messages);
        }
        for (CubeBase someCube : allCubes) {
            String cleanedCubeName = StringHelper.cleanupFileName(someCube.getName());
            String cubeDirectory = String.valueOf(directory) + File.separator + cleanedCubeName;
            cubes.put(someCube, cubeDirectory);
            this.exportCubeToCognosROLAPInternal(someCube, cubeDirectory, cleanedCubeName, includeROLAPModelAsProperty);
        }
        return cubes;
    }

    @Override
    public void exportToCognosROLAP(PackageBase cubePkg, String directory, boolean includeROLAPModelAsProperty, List<FeedbackMessage> messages) throws IOException {
        for (CubeBase cube : cubePkg.getAllCubes()) {
            String cleanedCubeName = StringHelper.cleanupFileName(cube.getName());
            String cubeDirectory = String.valueOf(directory) + File.separator + cleanedCubeName;
            this.exportCubeToCognosROLAPInternal(cube, cubeDirectory, cleanedCubeName, includeROLAPModelAsProperty);
        }
    }

    @Override
    public Map<Object, Object> exportToCognosROLAP(DimensionBase objDim, String cmPkgContainerPath) {
        return this.exportToCognosROLAP(objDim, cmPkgContainerPath, null, true);
    }

    @Override
    public Map<Object, Object> exportToCognosROLAP(DimensionBase dim, String cmPkgContainerPath, List<FeedbackMessage> messages, boolean connected) {
        String outModelPath;
        HashMap<Object, Object> outValues = new HashMap<Object, Object>(2);
        FmMDException.ASSERT(dim != null, "Expecting a valid dimension object to be published.");
        FmMDException.ASSERT(cmPkgContainerPath != null && cmPkgContainerPath.length() > 0, "Expecting a valid package container path.");
        this.sanityCheck(dim, TaskAnalyseObject.AnalysisContext.memberbrowse, messages, connected);
        Element elmOLAPRoot = this.setupROLAPModelHeading();
        this.initDMRSession();
        if (dim instanceof RelationalDimension) {
            RelationalDimension objDim = (RelationalDimension)dim;
            this.m_ModelBuilderDC.convertFromDimensionForROLAP(this.m_dmrSession, objDim, this.m_idMap);
            FmMDException.ASSERT(this.m_idMap.size() > 0, "Failed to generate ROLAP model. The underlying model conversion did not result in any object mapping.");
            this.exportDimension(elmOLAPRoot, objDim);
        } else if (dim instanceof VirtualDimension) {
            VirtualDimension vDim = (VirtualDimension)dim;
            ArrayList<VirtualDimensionBase> vDims = new ArrayList<VirtualDimensionBase>(1);
            vDims.add(vDim);
            this.exportCube(elmOLAPRoot, (VirtualCube)vDim.getParent(), vDims);
        }
        if (cmPkgContainerPath.equals("Don't publish mofo!")) {
            outModelPath = "Didn't publish.";
            outValues.put("gzippedSerializedModel", this.serializeModel(this.m_dmrSession));
        } else {
            CmHelper cmHelper = CmHelper.get(this.m_srcSession, this.m_srcSession.getPassport());
            outModelPath = cmHelper.simplePublishModel(cmPkgContainerPath, gMEMBER_QUERY_PACKAGE_NAME, Long.toString(System.currentTimeMillis()), this.m_dmrSession.getProject().getDynamicQueryMode(), this.serializeModel(this.m_dmrSession));
        }
        this.m_dmrSession.destroy();
        outValues.put("modelSearchPath", outModelPath);
        outValues.put("rolapSpec", elmOLAPRoot);
        return outValues;
    }

    @Override
    public void registerCubeWithDefaultQueryService(String cubeName, boolean isVirtualCube) {
        FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_srcSession, "Start register cube with query service: " + cubeName);
        CmHelper cmHelper = CmHelper.get(this.m_srcSession, this.m_srcSession.getPassport());
        cmHelper.addCubeToQueryService(cubeName, isVirtualCube);
        FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_srcSession, "End register cube with query service: " + cubeName);
    }

    @Override
    public String startCubeOnServer(String cubeName) {
        FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_srcSession, "Start send command to start the cube: " + cubeName);
        CmHelper cmHelper = CmHelper.get(this.m_srcSession, this.m_srcSession.getPassport());
        String ret = cmHelper.startCube(cubeName);
        FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_srcSession, "End send command to start the cube: " + cubeName + ": " + ret);
        return ret;
    }

    private void exportCubeToCognosROLAPInternal(CubeBase objCube, String directory, String cleanedCubeName, boolean includeROLAPModelAsProperty) throws IOException {
        File fDir = new File(directory);
        fDir.mkdirs();
        if (includeROLAPModelAsProperty) {
            this.exportCubeAsSingleModel(objCube);
            ByteArrayOutputStream out = this.serializeModel(this.m_dmrSession);
            this.dumpSerializedModelToFile(out, String.valueOf(directory) + File.separator + "model.xml");
            this.m_dmrSession.destroy();
        } else {
            Element elmOLAPRoot = this.setupROLAPModelHeading();
            if (objCube.getCubeStyle().equals((Object)CubeBase.CubeStyle.virtual)) {
                this.exportCube(elmOLAPRoot, (VirtualCube)objCube);
            } else {
                this.initDMRSession();
                this.m_ModelBuilderDC.convertFromCubeForROLAP(this.m_dmrSession.getProject().getRootNamespace(), (Cube)objCube, this.m_idMap);
                FmMDException.ASSERT(this.m_idMap.size() > 0, "Failed to generate ROLAP model. The underlying model conversion did not result in any object mapping.");
                this.exportCube(elmOLAPRoot, (Cube)objCube);
                this.m_dmrSession.saveAs(ProjectFactory.createFileProject(directory));
                this.m_dmrSession.destroy();
            }
            this.writeDocToFile(elmOLAPRoot, String.valueOf(directory) + File.separator + cleanedCubeName + ".xml");
        }
    }

    private boolean sanityCheck(CubeBase cube, TaskAnalyseObject.AnalysisContext context, boolean connected, List<FeedbackMessage> messages) {
        if (cube.getCubeStyle().equals((Object)CubeBase.CubeStyle.aggregate)) {
            throw new FmMDException("BMT_MD_CANNOT_DEPLOY_AGGREGATE_CUBE", cube.getID());
        }
        TaskAnalyseObject anal = cube.getSession().getTaskAnalyseObject();
        if (messages == null) {
            messages = new ArrayList<FeedbackMessage>();
        }
        anal.analyseObject(cube, context, messages, connected);
        boolean containsWarning = false;
        for (FeedbackMessage msg : messages) {
            if (msg.getSeverity() == FeedbackMessage.FeedbackSeverity.ERROR) {
                throw new FmMDException("BMT_MD_MODEL_ERRORS_CUBE", cube.getName());
            }
            if (msg.getSeverity() != FeedbackMessage.FeedbackSeverity.WARNING) continue;
            containsWarning |= true;
        }
        return containsWarning;
    }

    private void sanityCheck(DimensionBase dim, TaskAnalyseObject.AnalysisContext context, List<FeedbackMessage> messages, boolean connected) {
        TaskAnalyseObject anal = dim.getSession().getTaskAnalyseObject();
        if (messages == null) {
            messages = new ArrayList<FeedbackMessage>();
        }
        anal.analyseObject(dim, context, messages, connected);
        for (FeedbackMessage msg : messages) {
            if (msg.getSeverity() != FeedbackMessage.FeedbackSeverity.ERROR) continue;
            throw new FmMDException("BMT_MD_MODEL_ERRORS_DIMENSION", dim.getName());
        }
    }

    private boolean sanityCheck(PackageBase kPackage, TaskAnalyseObject.AnalysisContext context, boolean connected, List<FeedbackMessage> messages) {
        TaskAnalyseObject anal = kPackage.getSession().getTaskAnalyseObject();
        boolean containsWarning = false;
        if (messages == null) {
            messages = new ArrayList<FeedbackMessage>();
        }
        anal.analyseObject(kPackage, context, messages, connected);
        for (FeedbackMessage msg : messages) {
            if (msg.getSeverity() == FeedbackMessage.FeedbackSeverity.ERROR) {
                if (kPackage.isStupidSpecialCaseCubeHandling()) {
                    throw new FmMDException("BMT_MD_MODEL_ERRORS_CUBE", kPackage.getAllCubes().get(0).getName());
                }
                throw new FmMDException("BMT_MD_MODEL_ERRORS_PACKAGE", kPackage.getName());
            }
            if (msg.getSeverity() != FeedbackMessage.FeedbackSeverity.WARNING) continue;
            containsWarning |= true;
        }
        return containsWarning;
    }

    private String exportCubeToCognosROLAPInternal(CubeBase objCube) {
        this.exportCubeAsSingleModel(objCube);
        FmMDException.ASSERT(objCube instanceof FmReportObject, "Bad object being published.");
        ByteArrayOutputStream modelStream = this.serializeModel(this.m_dmrSession);
        CmHelper cmHelper = CmHelper.get(this.m_srcSession, this.m_srcSession.getPassport());
        FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_srcSession, "Finding Dynamic Cubes data source in CM: " + objCube.getName());
        boolean bCubeExists = false;
        String rolapCubePath = null;
        BaseClass foundDs = cmHelper.findRolapDataSource("/directory/namespace[@name=\"Cognos\"]", ((FmReportObject)((Object)objCube)).getNameList());
        if (foundDs != null) {
            rolapCubePath = foundDs.getSearchPath().getValue();
            bCubeExists = true;
            if (cmHelper.checkIfCMObjectHasMultiLocaleRenameIssues(foundDs, ((FmReportObject)((Object)objCube)).getNames())) {
                FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_srcSession, "Dynamic Cubes data source found in CM with same names in some but not all locales: " + objCube.getName());
                EventCallbackHandler callback = this.m_srcSession.getEventCallbackHandler();
                if (callback != null && !callback.doBooleanPrompt(new FmMessage("BMT_UIP_FAILED_TO_DEPLOY_CUBE_NAME_COLLISION_IN_MULTIPLE_LOCALE", objCube.getName()))) {
                    throw new FmMDException("BMT_MD_CANCELED");
                }
            } else {
                FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_srcSession, "Dynamic Cubes data source found in CM: " + objCube.getName());
                EventCallbackHandler callback = this.m_srcSession.getEventCallbackHandler();
                if (callback != null && !callback.doBooleanPrompt(new FmMessage("BMT_UIP_REPLUBLISH_CONFIRMATION", objCube.getName()))) {
                    throw new FmMDException("BMT_MD_CANCELED");
                }
            }
        } else {
            FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_srcSession, "Dynamic Cubes data source not found in CM: " + objCube.getName());
        }
        FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_srcSession, "Start create Dynamic Cubes data source in CM: " + objCube.getName());
        rolapCubePath = cmHelper.createUpdateRolapDataSource(bCubeExists ? rolapCubePath : "/directory/namespace[@name=\"Cognos\"]", objCube, bCubeExists, modelStream);
        FmEngApplicationLog.getApplicationLog().logDebug(FmEngApplicationLog.LOGGERS.PUBLISH, this.m_srcSession, "End create Dynamic Cubes data source in CM: " + objCube.getName());
        this.m_dmrSession.destroy();
        return rolapCubePath;
    }

    private void exportCubeAsSingleModel(CubeBase objCube) {
        Element elmOLAPRoot = this.setupROLAPModelHeading();
        this.initDMRSession();
        if (objCube instanceof Cube) {
            this.m_ModelBuilderDC.convertFromCubeForROLAP(this.m_dmrSession.getProject().getRootNamespace(), (Cube)objCube, this.m_idMap);
            FmMDException.ASSERT(this.m_idMap.size() > 0, "Failed to generate ROLAP model. The underlying model conversion did not result in any object mapping.");
            this.exportCube(elmOLAPRoot, (Cube)objCube);
        } else {
            this.exportCube(elmOLAPRoot, (VirtualCube)objCube);
        }
        String elmString = elmOLAPRoot.asXML();
        Property objRolap = this.m_dmrSession.getProject().getRootNamespace().createCustomProperty("ROLAPSource");
        objRolap.setValue(elmString);
    }

    private void dumpSerializedModelToFile(ByteArrayOutputStream oStream, String filename) {
        try {
            int nRead;
            byte[] bytes = oStream.toByteArray();
            GZIPInputStream unzip = new GZIPInputStream(new ByteArrayInputStream(bytes));
            ByteArrayOutputStream uncompressOStream = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = unzip.read(data, 0, data.length)) != -1) {
                uncompressOStream.write(data, 0, nRead);
            }
            uncompressOStream.flush();
            File tempModelFile = new File(filename);
            FileOutputStream tempOutputStream = new FileOutputStream(tempModelFile);
            uncompressOStream.writeTo(tempOutputStream);
            tempOutputStream.close();
        }
        catch (IOException e) {
            System.out.print(e.toString());
        }
    }

    private ByteArrayOutputStream serializeModel(FMMDSession aSession) {
        ByteArrayOutputStream modelStream = new ByteArrayOutputStream(1000000);
        try {
            GZIPOutputStream gzipstream = new GZIPOutputStream(modelStream);
            OneToOneModelSerializer mySer = new OneToOneModelSerializer(aSession);
            EMFCustomModelSerializer s = new EMFCustomModelSerializer(gzipstream, (XMLResource)((EMFSession)aSession).getResource(), mySer);
            s.serialize((EObject)aSession.getProject().getInternal(), true);
            gzipstream.flush();
            gzipstream.finish();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return modelStream;
    }

    private Element setupROLAPModelHeading() {
        Document csDoc = DocumentHelper.createDocument();
        Element elmRoot = csDoc.addElement("olap:metadata");
        elmRoot.addNamespace("olap", "http://www.ibm.com/olap");
        elmRoot.addNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        elmRoot.addAttribute("xsi:schemaLocation", "http://www.ibm.com/olap RolapCubeModel.xsd");
        elmRoot.addAttribute("version", "1.0.1");
        return elmRoot;
    }

    public void writeDocToFile(Element elmRoot, String modelPath) throws IOException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setNewLineAfterDeclaration(false);
        XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(new File(modelPath)), format);
        Document doc = elmRoot.getDocument();
        writer.write(doc);
        writer.close();
    }

    private void addLevelKeys(Element elmLevel, Level objLevel, boolean bGenNameRefOrQItem) {
        for (QueryItem objQItem : objLevel.getLevelKeys()) {
            if (bGenNameRefOrQItem) {
                this.genNameReference(elmLevel, TAG_ELE_levelKeyRef, objQItem.getName());
                continue;
            }
            Element elmAggrLevelKeyRef = elmLevel.addElement("olap:aggregateLevelKeyRef").addAttribute(TAG_ATTR_name, objQItem.getName());
            this.genRefObj(elmAggrLevelKeyRef, objQItem, null);
        }
    }

    private void exportCube(Element elmRoot, Cube someCube) {
        Element elmMDSchema = elmRoot.addElement(TAG_ELE_mdSchema).addAttribute(TAG_ATTR_name, someCube.getName());
        elmMDSchema.addAttribute(TAG_ATTR_defaultLocale, someCube.getProject().getDefaultLocale());
        Element elmCommonCubeModel = this.createCubeModelElement(elmMDSchema, "Common");
        Element elmCubeModel = this.createCubeModelElement(elmMDSchema, someCube.getName());
        Element elmCube = this.setupPrivateCubeModel(elmCubeModel, someCube);
        this.setupCommonCubeModel(elmCommonCubeModel, elmCube, someCube);
        this.setupAggregateCubes(elmCommonCubeModel, elmCube, someCube);
        this.exportAggregateCube(elmCommonCubeModel, elmCube, someCube);
        this.exportSecurityViews(someCube, elmCube);
        this.exportNamedSets(someCube, elmCube);
        FmTaskExportToCognosROLAP.removeNonDefaultLocales(this.m_dmrSession);
    }

    private void exportCube(Element elmRoot, VirtualCube someCube) {
        Element elmMDSchema = elmRoot.addElement(TAG_ELE_mdSchema).addAttribute(TAG_ATTR_name, someCube.getName());
        elmMDSchema.addAttribute(TAG_ATTR_defaultLocale, someCube.getProject().getDefaultLocale());
        Element elmVirtualCubes = elmMDSchema.addElement("olap:virtualCubes");
        this.exportCube(elmVirtualCubes, someCube, someCube.getDimensions());
    }

    private void exportCube(Element elmParent, VirtualCube someCube, List<VirtualDimensionBase> dims) {
        Element elmVirtualCube = this.exportFmObject(elmParent, "olap:virtualCube", someCube);
        this.exportMergeOperator(elmVirtualCube, someCube.getMergeOperator());
        elmVirtualCube.addAttribute(TAG_ATTR_type, "Virtual");
        elmVirtualCube.addAttribute("mergeStyle", "explicit");
        this.exportSources(elmVirtualCube, someCube, "olap:sourceCubeRef");
        for (VirtualDimensionBase dim : dims) {
            if (dim instanceof VirtualDimension) {
                this.exportVirtualDimension(elmVirtualCube, (VirtualDimension)dim);
                continue;
            }
            this.exportVirtualMeasureDimension(elmVirtualCube, (VirtualMeasureDimension)dim, someCube);
        }
        this.exportNamedSets(someCube, elmVirtualCube);
    }

    private void exportVirtualMeasureDimension(Element elmVirtualCube, VirtualMeasureDimension dim, VirtualCube someCube) {
        Element elmVirtualMeasDim = this.exportFmObject(elmVirtualCube, TAG_ELE_virtualDimension, dim);
        this.exportSources(elmVirtualMeasDim, dim, TAG_ELE_sourceDimRef);
        this.genNameReference(elmVirtualMeasDim, TAG_ELE_defaultHierRef, dim.getName());
        Element elmVirtualMeasHier = this.exportFmObject(elmVirtualMeasDim, TAG_ELE_virtualHierarchy, dim);
        this.exportSources(elmVirtualMeasHier, dim, TAG_ELE_sourceHierRef);
        this.genNameReference(elmVirtualMeasHier, TAG_ELE_defaultMemRef, dim.getDefaultMeasure().getName());
        this.exportVirtualMeasureDimensionDescendants(dim, someCube, elmVirtualMeasHier);
    }

    private void exportVirtualMeasureFolder(VirtualMeasureFolder objMsrFld, VirtualCube cube, Element elmVirtualMeasHier) {
        if (objMsrFld.hasDescendantMeasuresOrCalculatedMeasures()) {
            Element elmMsrFld = elmVirtualMeasHier.addElement(TAG_ELE_virtualHierarchyFolder);
            elmMsrFld.addAttribute(TAG_ATTR_name, objMsrFld.getName());
            this.addMultilingualCaptionElements(elmMsrFld, TAG_ELE_name, objMsrFld);
            this.exportVirtualMeasureDimensionDescendants(objMsrFld, cube, elmMsrFld);
        }
    }

    private void exportVirtualMeasureDimensionDescendants(BaseObject parent, VirtualCube someCube, Element elmVirtualMeasHier) {
        List<BaseObject> allMeasureDimChildren = parent.getChildObjects();
        block6: for (BaseObject child : allMeasureDimChildren) {
            switch (child.getFmObjectType()) {
                case virtualMeasure: {
                    VirtualMeasure measure = (VirtualMeasure)child;
                    Element elmMeasure = this.genNameReference(elmVirtualMeasHier, TAG_ELE_virtualMem, measure.getName());
                    this.exportMergeOperator(elmMeasure, measure.getMergeOperator());
                    if (measure.getPrecedence() != null) {
                        elmMeasure.addAttribute("precedence", measure.getPrecedence().toString());
                    }
                    elmMeasure.addAttribute(TAG_ATTR_visible, measure.getHidden() ? "false" : "true");
                    this.exportSources(elmMeasure, measure, TAG_ELE_sourceMemRef);
                    this.addMultilingualCaptionElements(elmMeasure, TAG_ELE_caption, measure);
                    if (measure.getFormat() == null || "".equals(measure.getFormat())) continue block6;
                    elmMeasure.addAttribute(TAG_ATTR_format, measure.getFormat());
                    break;
                }
                case calculatedMember: {
                    CalculatedMember calcMem = (CalculatedMember)child;
                    if (calcMem.getExpression() == null) continue block6;
                    Element elmCalcMsr = elmVirtualMeasHier.addElement("olap:virtualCalculatedMember");
                    elmCalcMsr.addAttribute(TAG_ATTR_name, calcMem.getName());
                    MemberUniqueName munParent = calcMem.getParentMember();
                    if (munParent != null) {
                        elmCalcMsr.addElement("olap:parent").addAttribute(TAG_ATTR_name, munParent.getV5MemberUniqueName(someCube, false));
                    }
                    elmCalcMsr.addElement("olap:V5Expression").addAttribute("template", calcMem.getV5Expression(someCube));
                    elmCalcMsr.addElement("olap:solveOrder").addAttribute("value", Integer.toString(calcMem.getSolveOrder()));
                    this.addMultilingualCaptionElements(elmCalcMsr, TAG_ELE_caption, calcMem);
                    if (!calcMem.isCalculatedMeasure()) continue block6;
                    elmCalcMsr.addAttribute(TAG_ATTR_visible, calcMem.getHidden() ? "false" : "true");
                    if (calcMem.getFormat() != null && !"".equals(calcMem.getFormat())) {
                        elmCalcMsr.addAttribute(TAG_ATTR_format, calcMem.getFormat());
                    }
                    elmCalcMsr.addElement("olap:aggregation").addAttribute("function", this.getAggregationFunctionForCalculatedMeasures(calcMem.getRegularAggregate()));
                    break;
                }
                case virtualMeasureFolder: {
                    VirtualMeasureFolder objMsrFld = (VirtualMeasureFolder)child;
                    this.exportVirtualMeasureFolder(objMsrFld, someCube, elmVirtualMeasHier);
                    break;
                }
                case measureFolder: 
                case sourceObject: 
                case sourceObjects: {
                    break;
                }
                default: {
                    FmMDException.ASSERT(false, "Unexpected child of a measure dimension: " + child.toString());
                }
            }
        }
    }

    private void exportVirtualDimension(Element elmVirtualCube, VirtualDimension dim) {
        Element elmVirtualDim = this.exportFmObject(elmVirtualCube, TAG_ELE_virtualDimension, dim);
        elmVirtualDim.addAttribute(TAG_ATTR_type, dim.getDimensionStyle() == DimensionBase.DimensionStyle.time ? "time" : "regular");
        if (dim.leverageSharedMemberCache()) {
            elmVirtualDim.addAttribute(TAG_ATTR_leverageSharedMemberCache, "true");
        } else {
            elmVirtualDim.addAttribute(TAG_ATTR_leverageSharedMemberCache, "false");
        }
        this.exportSources(elmVirtualDim, dim, TAG_ELE_sourceDimRef);
        this.genNameReference(elmVirtualDim, TAG_ELE_defaultHierRef, dim.getDefaultHierarchy().getName());
        for (VirtualHierarchy hier : dim.getHierarchies()) {
            this.exportVirtualHierarchy(elmVirtualDim, dim, hier);
        }
    }

    private void exportVirtualHierarchy(Element elmVirtualDim, VirtualDimension dim, VirtualHierarchy hier) {
        Element elmVirtualHier = this.exportFmObject(elmVirtualDim, TAG_ELE_virtualHierarchy, hier);
        if (dim.getDimensionStyle() == DimensionBase.DimensionStyle.time) {
            elmVirtualHier.addAttribute(TAG_ATTR_hasRelativeTimeMembers, hier.getHasRelativeTimeMembers() ? "true" : "false");
        }
        this.exportSources(elmVirtualHier, hier, TAG_ELE_sourceHierRef);
        this.exportHierarchyDefaultMUN((CubeBase)dim.getParent(), hier, elmVirtualHier);
        for (VirtualLevel level : hier.getLevels()) {
            this.exportVirtualLevel(elmVirtualHier, level);
        }
        for (VirtualMember member : hier.getVirtualMembers()) {
            Element elmMember = this.genNameReference(elmVirtualHier, TAG_ELE_virtualMem, member.getName());
            this.exportMergeOperator(elmMember, member.getMergeOperator());
            if (member.getPrecedence() != null) {
                elmMember.addAttribute("precedence", member.getPrecedence().toString());
            }
            elmMember.addAttribute(TAG_ATTR_visible, member.getHidden() ? "false" : "true");
            for (SourceMember srcMember : member.getSourceMembers()) {
                Element elmSource = elmMember.addElement(TAG_ELE_sourceMemRef);
                elmSource.addAttribute(TAG_ATTR_name, srcMember.getSourceMemberUniqueName());
                elmSource.addAttribute("hidden", srcMember.getHidden() ? "true" : "false");
            }
            this.addMultilingualCaptionElements(elmMember, TAG_ELE_caption, member);
        }
        this.exportVirtualCalculatedMembers(elmVirtualHier, hier.getCalculatedMembers());
    }

    private void exportVirtualCalculatedMembers(Element elmParent, List<CalculatedMember> calcMems) {
        for (CalculatedMember calcMem : calcMems) {
            if (calcMem.getExpression() == null) continue;
            Element elmCalcMsr = elmParent.addElement("olap:virtualCalculatedMember");
            elmCalcMsr.addAttribute(TAG_ATTR_name, calcMem.getName());
            MemberUniqueName munParent = calcMem.getParentMember();
            if (munParent != null) {
                elmCalcMsr.addElement("olap:parent").addAttribute(TAG_ATTR_name, munParent.getV5MemberUniqueName(null, false));
            }
            elmCalcMsr.addElement("olap:V5Expression").addAttribute("template", calcMem.getV5Expression(null));
            elmCalcMsr.addElement("olap:solveOrder").addAttribute("value", Integer.toString(calcMem.getSolveOrder()));
            this.addMultilingualCaptionElements(elmCalcMsr, TAG_ELE_caption, calcMem);
            if (!calcMem.isCalculatedMeasure()) continue;
            elmCalcMsr.addAttribute(TAG_ATTR_visible, calcMem.getHidden() ? "false" : "true");
            if (calcMem.getFormat() != null && !"".equals(calcMem.getFormat())) {
                elmCalcMsr.addAttribute(TAG_ATTR_format, calcMem.getFormat());
            }
            elmCalcMsr.addElement("olap:aggregation").addAttribute("function", this.getAggregationFunctionForCalculatedMeasures(calcMem.getRegularAggregate()));
        }
    }

    private void exportVirtualLevel(Element elmVirtualHier, VirtualLevel level) {
        Element elmVirtualLevel = this.exportFmObject(elmVirtualHier, "olap:virtualLevel", level);
        this.exportSources(elmVirtualLevel, level, "olap:sourceLevelRef");
        if (level.isTimeLevel()) {
            elmVirtualLevel.addElement(TAG_ELE_relativeTimeMemberType).addText("allRelativeTimeMembers");
        }
    }

    private void exportMergeOperator(Element elmObject, VirtualObject.MergeOperator mergeOperator) {
        switch (mergeOperator) {
            case subtract: {
                elmObject.addAttribute(TAG_ATTR_mergeOperator, "-");
                break;
            }
            case divide: {
                elmObject.addAttribute(TAG_ATTR_mergeOperator, "/");
                break;
            }
            case multiply: {
                elmObject.addAttribute(TAG_ATTR_mergeOperator, "*");
                break;
            }
            case maximum: {
                elmObject.addAttribute(TAG_ATTR_mergeOperator, "MAX");
                break;
            }
            case minimum: {
                elmObject.addAttribute(TAG_ATTR_mergeOperator, "MIN");
                break;
            }
            case none: {
                elmObject.addAttribute(TAG_ATTR_mergeOperator, "NOP");
                break;
            }
            default: {
                elmObject.addAttribute(TAG_ATTR_mergeOperator, "+");
            }
        }
    }

    private void exportSources(Element parentElement, VirtualObject virtualObject, String sourceName) {
        List<SourceObject> sources = virtualObject.getSourceObjects();
        for (SourceObject source : sources) {
            Element elmSource = parentElement.addElement(sourceName);
            if (virtualObject instanceof VirtualCube) {
                elmSource.addAttribute(TAG_ATTR_name, source.getSourceName());
                String path = source.getSourcePath();
                if (path == null) continue;
                elmSource.addAttribute("path", path);
                continue;
            }
            String id = "";
            SourceObject src = source;
            while (src != null) {
                if (!"".equals(id)) {
                    id = "." + id;
                }
                id = "[" + src.getSourceName() + "]" + id;
                src = src.getSourceParent();
            }
            elmSource.addAttribute(TAG_ATTR_name, id);
        }
    }

    private void exportDimension(Element elmRoot, RelationalDimension dimension) {
        Element elmMDSchema = elmRoot.addElement(TAG_ELE_mdSchema).addAttribute(TAG_ATTR_name, dimension.getName());
        elmMDSchema.addAttribute(TAG_ATTR_defaultLocale, dimension.getProject().getDefaultLocale());
        Element elmCommonCubeModel = this.createCubeModelElement(elmMDSchema, "Common");
        this.exportRegularDim(null, elmCommonCubeModel, (FmRelationalDimension)dimension, null);
    }

    private Element setupPrivateCubeModel(Element elmCubeModel, Cube someCube) {
        FmMeasureDimension objMsrDim = (FmMeasureDimension)someCube.getMeasureDimension();
        FmMDException.ASSERT(objMsrDim != null, "There is no measure dimension in the cube: " + someCube.getName());
        this.exportMeasureDim(someCube, elmCubeModel, objMsrDim);
        Element elmCube = this.exportFmObject(elmCubeModel, "olap:cube", someCube);
        elmCube.addAttribute("cubingServicesCompatibility", ((FmCube)someCube).getCubingServicesCompatibility() ? "true" : "false");
        elmCube.addAttribute("removeNonExistentTuples", someCube.isRemoveNonExistentTuples() ? "true" : "false");
        Element elmCubeFacts = this.exportFmObject(elmCube, "olap:cubeFacts", objMsrDim);
        List<BaseObject> allMeasureDimChildren = objMsrDim.getChildObjects();
        for (BaseObject child : allMeasureDimChildren) {
            switch (child.getFmObjectType()) {
                case measure: {
                    Measure objMsr = (Measure)child;
                    this.genNameReference(elmCubeFacts, "olap:measureRef", objMsr.getName());
                    break;
                }
                case calculatedMember: {
                    CalculatedMember objCalcMsr = (CalculatedMember)child;
                    this.genNameReference(elmCubeFacts, "olap:calculatedMeasureRef", objCalcMsr.getName());
                    break;
                }
                case measureFolder: {
                    MeasureFolder objMsrFld = (MeasureFolder)child;
                    this.exportMeasureFolder(elmCubeFacts, objMsrFld);
                    break;
                }
                case accessRules: 
                case filterFolder: 
                case queryItem: {
                    break;
                }
                default: {
                    FmMDException.ASSERT(false, "Invalid measure dimension child: " + child.getID());
                }
            }
        }
        this.exportFactTransactionId(elmCube, objMsrDim);
        this.setDefaultMeasure(objMsrDim, elmCubeFacts);
        return elmCube;
    }

    private void exportFactTransactionId(Element elmCube, FmMeasureDimension objMsrDim) {
        QueryItemBase qi = objMsrDim.findTransactionIdQueryItem();
        if (qi != null) {
            Element factTransId = elmCube.addElement(TAG_ELE_factTransactionId);
            Element qiElement = factTransId.addElement(TAG_ELE_queryItem);
            String idDMRObj = this.m_idMap.get(qi.getInternal());
            FmMDException.ASSERT(idDMRObj != null, "Failed to generate ROLAP model. Unable to locate the object corresponding to \"" + qi.getID() + "\" in the underlying model.");
            qiElement.addAttribute(TAG_ATTR_refObject, idDMRObj);
        }
    }

    private void setDefaultMeasure(FmMeasureDimension objMsrDim, Element elmCubeFacts) {
        ReportObject objDefMsr = objMsrDim.getDefaultMeasure();
        if (objDefMsr != null) {
            this.genNameReference(elmCubeFacts, "olap:defaultMeasureRef", objDefMsr.getName());
        }
    }

    private void setupCommonCubeModel(Element elmCommonCubeModel, Element elmCube, Cube someCube) {
        MeasureDimension objMsrDim = someCube.getMeasureDimension();
        for (RelationalDimensionBase objDim : someCube.getReferencedDimensions()) {
            if (objDim.getDimensionStyle() == DimensionBase.DimensionStyle.measure) continue;
            FmRelationalDimension objRegDim = (FmRelationalDimension)objDim;
            this.exportRegularDim(someCube, elmCommonCubeModel, objRegDim, objMsrDim);
            Element elmCubeDimRef = this.genNameReference(elmCube, "olap:cubeDimensionRef", objRegDim.getName());
            elmCubeDimRef.addAttribute(TAG_ATTR_category, "public");
            for (RelationalHierarchy objHier : objRegDim.getAllHierarchies()) {
                this.genNameReference(elmCubeDimRef, "olap:hierarchyRef", objHier.getName());
            }
            if (objRegDim.getDefaultHierarchy() != null) {
                this.genNameReference(elmCubeDimRef, TAG_ELE_defaultHierRef, objRegDim.getDefaultHierarchy().getName());
                continue;
            }
            FmMDException.ASSERT(objRegDim.getAllHierarchies().size() == 0, "Dimension has hierarchies?");
            this.genNameReference(elmCubeDimRef, TAG_ELE_defaultHierRef, objRegDim.getName());
        }
    }

    private void exportAggregateCube(Element elmCommonCubeModel, Element elmCube, Cube objParentCube) {
        for (AggregateCube aggCube : objParentCube.getAggregateCubes2()) {
            Element elmAggrCube = this.genNameReference(elmCube, "olap:aggregateCube", aggCube.getName());
            switch (aggCube.getAggregateCubeStyle()) {
                case inMemory: {
                    elmAggrCube.addAttribute(TAG_ATTR_type, "memory");
                    break;
                }
                case inDatabase: {
                    elmAggrCube.addAttribute(TAG_ATTR_type, "database");
                }
            }
            for (AggregateDimension aggDim : aggCube.getAggregateDimensions()) {
                this.ensureDetailedDimensionExists(elmCommonCubeModel, (FmRelationalDimension)aggDim.getDimension());
                Element elmAggDim = this.genNameReference(elmAggrCube, "olap:aggregateDimensionRef", aggDim.getName());
                elmAggDim.addAttribute(TAG_ATTR_category, "public");
                for (AggregateHierarchy aggHier : aggDim.getAggregateHierarchies()) {
                    Element elmAggHry = this.genNameReference(elmAggDim, "olap:aggregateHierarchyRef", aggHier.getName());
                    for (AggregateLevel aggLevel : aggHier.getLevels()) {
                        this.genNameReference(elmAggHry, "olap:aggregateLevelRef", aggLevel.getName());
                    }
                }
            }
            for (AggregateMeasure aggMeasure : aggCube.getAggregateMeasures()) {
                this.genNameReference(elmAggrCube, "olap:aggregateMeasureRef", aggMeasure.getName());
            }
        }
    }

    private void setupAggregateCubes(Element elmCommonCubeModel, Element elmCube, Cube objParentCube) {
        for (Cube objCube : objParentCube.getAggregateCubes()) {
            Element elmAggrCube = this.genNameReference(elmCube, "olap:aggregateCube", objCube.getName());
            elmAggrCube.addAttribute("ordinal", objCube.getAggregateOrdinal().toString());
            Map<Object, List<String>> mapSlicers = this.processAggrCubeSlicers(objCube);
            for (RelationalDimensionBase objDim : objCube.getReferencedDimensions()) {
                if (objDim.getDimensionStyle() == DimensionBase.DimensionStyle.measure) continue;
                FmRelationalDimension objRelDim = (FmRelationalDimension)objDim;
                this.ensureDetailedDimensionExists(elmCommonCubeModel, objRelDim);
                FmRelationalDimension detailDim = this.getDetailedDimension(objParentCube, objRelDim);
                Element elmAggDim = this.genNameReference(elmAggrCube, "olap:aggregateDimensionRef", objRelDim.getName());
                elmAggDim.addAttribute(TAG_ATTR_category, "public");
                for (RelationalHierarchy objHry : objRelDim.getAllHierarchies()) {
                    Element elmAggHry = this.genNameReference(elmAggDim, "olap:aggregateHierarchyRef", objHry.getName());
                    RelationalHierarchy detailHier = this.getDetailedHierarchy(detailDim, objRelDim, objHry);
                    if (objHry.getParentChild()) {
                        Element elmChildAggLevel = this.genNameReference(elmAggHry, "olap:aggregateLevelRef", gCS_MODEL_MEMBER_LEVEL_DEFAULT_NAME);
                        QueryItem childQueryItem = objHry.getChildItem();
                        Element elmChildAggrLevelKeyRef = elmChildAggLevel.addElement("olap:aggregateLevelKeyRef").addAttribute(TAG_ATTR_name, childQueryItem.getName());
                        this.genRefObj(elmChildAggrLevelKeyRef, childQueryItem, null);
                    } else {
                        for (LevelReference objLevelRef : objHry.getLevelReferences()) {
                            FmMDException.ASSERT(objLevelRef.getLevel() != null, "Bad level ref in hierarchy: " + objHry);
                            if (objLevelRef.getLevel().isAllLevel()) continue;
                            Element elmAggLevel = this.genNameReference(elmAggHry, "olap:aggregateLevelRef", objLevelRef.getLevel().getName());
                            this.addLevelKeys(elmAggLevel, objLevelRef.getLevel(), false);
                        }
                    }
                    List<String> vSlicerValues = mapSlicers.get(detailHier.getInternal());
                    if (vSlicerValues == null) continue;
                    Element elmAggSlice = this.genNameReference(elmAggHry, "olap:aggregateSlice", objHry.getName());
                    for (String slicerValue : vSlicerValues) {
                        this.genNameReference(elmAggSlice, "olap:aggregateMember", slicerValue);
                    }
                }
            }
            if (objCube.getMeasureDimension() == null) continue;
            for (Measure objMsr : objCube.getMeasureDimension().getAllMeasures()) {
                Element elmAggMsr = this.genNameReference(elmAggrCube, "olap:aggregateMeasureRef", objMsr.getName());
                this.genRefObj(elmAggMsr, objMsr, null);
            }
        }
    }

    private RelationalHierarchy getDetailedHierarchy(FmRelationalDimension detailDim, FmRelationalDimension aggrDim, RelationalHierarchy aggrHier) {
        if (detailDim.equals(aggrDim)) {
            return aggrHier;
        }
        for (RelationalHierarchy hier : detailDim.getAllHierarchies()) {
            if (!hier.getName().equals(aggrHier.getName())) continue;
            return hier;
        }
        FmMDException.ASSERT(false, "Couldn't find the detail dimension for " + aggrHier.getName());
        return null;
    }

    private FmRelationalDimension getDetailedDimension(Cube parentCube, FmRelationalDimension aggrDim) {
        if (aggrDim.isRollupDimension()) {
            for (RelationalDimensionBase dim : parentCube.getReferencedDimensions()) {
                if (!dim.getName().equals(aggrDim.getName())) continue;
                return (FmRelationalDimension)dim;
            }
        } else {
            return aggrDim;
        }
        FmMDException.ASSERT(false, "Couldn't find the detail dimension for " + aggrDim.getName());
        return null;
    }

    private Map<Object, List<String>> processAggrCubeSlicers(Cube objCube) {
        List<MemberUniqueName> vSlicers = objCube.getSlices();
        HashMap<Object, List<String>> outMap = new HashMap<Object, List<String>>(vSlicers.size());
        for (MemberUniqueName objMun : vSlicers) {
            List<BaseObject> vRefObjs = objMun.getRawRefObjs();
            FmMDException.ASSERT(((FmMemberUniqueName)objMun).isValid(), "Invalid MUN in aggregate slicer.");
            Object slicerKey = null;
            if (vRefObjs.get(0) instanceof RelationalHierarchy) {
                slicerKey = vRefObjs.get(0).getInternal();
            } else if (vRefObjs.get(0) instanceof LevelReference) {
                slicerKey = vRefObjs.get(0).getParent().getInternal();
            } else {
                FmMDException.ASSERT(false, "Expecting either a hierarchy or level reference as the first reference in a slicer MUN");
            }
            ArrayList<String> vSlicerValues = (ArrayList<String>)outMap.get(slicerKey);
            if (vSlicerValues == null) {
                vSlicerValues = new ArrayList<String>(3);
                outMap.put(slicerKey, vSlicerValues);
            }
            vSlicerValues.add(objMun.getV5MemberUniqueName(objCube, false));
        }
        return outMap;
    }

    private void ensureDetailedDimensionExists(Element elmCommonCubeModel, FmRelationalDimension objRelDim) {
        Node elmDim = elmCommonCubeModel.selectSingleNode("./olap:dimension[@name='" + objRelDim.getName() + "']");
        if (elmDim == null) {
            throw new FmMDException("BMT_MD_CS_EXPORT_MISSING_DETAILED_DIM", objRelDim.getName());
        }
    }

    private void exportRegularDim(Cube someCube, Element elmCubeModel, FmRelationalDimension objRegDim, MeasureDimension objMsrDim) {
        List<AccessRule> rules;
        boolean isByColumnMultiDimension;
        List<String> locales = objRegDim.getProject().getSupportedLocales();
        List<RelationalHierarchy> allHierarchies = objRegDim.getAllHierarchies();
        boolean isParentChild = objRegDim.getParentChild();
        Element elmDim = this.exportFmObject(elmCubeModel, "olap:dimension", objRegDim);
        elmDim.addAttribute(TAG_ATTR_type, objRegDim.getDimensionStyle() == DimensionBase.DimensionStyle.time ? "time" : "regular");
        boolean bl = isByColumnMultiDimension = objRegDim.getMultilingualSupport() == RelationalDimension.MultilingualSupport.byColumn;
        if (isByColumnMultiDimension) {
            elmDim.addAttribute(TAG_ATTR_localizationMethod, "byColumn");
        }
        if (objRegDim.isShareable()) {
            String uuid = objRegDim.generateUUID(someCube);
            elmDim.addAttribute(TAG_ATTR_uuid, uuid);
        }
        ConvergentLevelInfo convLevelInfo = new ConvergentLevelInfo();
        if (objMsrDim != null && !isParentChild) {
            List<Relationship> dimFactRels = objRegDim.getRelationships(objMsrDim);
            FmMDException.ASSERT(dimFactRels.size() == 1, "Expecting a single fact relationship for dimension: " + objRegDim.getID());
            List<Table> commonTables = objRegDim.getCommonTables(objMsrDim);
            if (commonTables.size() > 0) {
                Level outLevel = objRegDim.getDefaultHierarchy().getBottomLevel();
                FmMDException.ASSERT(outLevel != null, "Expecting a valid default leaf level for dimension: " + objRegDim.getID());
                convLevelInfo = new ConvergentLevelInfo();
                convLevelInfo.m_LevelName = outLevel.getName();
            } else {
                convLevelInfo = this.determineConvergenceLevel(objRegDim, objMsrDim, dimFactRels.get(0));
            }
        }
        for (QueryItem objQItem : objRegDim.getAllQueryItems()) {
            Element elmAttr = this.exportFmObject(elmDim, TAG_ELE_attribute, objQItem);
            if (isByColumnMultiDimension && objQItem.isMultilingual()) {
                FmMultilingualAttribute multiAttr = null;
                if (isParentChild) {
                    List<RelationalHierarchy> hierarchies = objRegDim.getAllHierarchies();
                    FmMDException.ASSERT(hierarchies.size() == 1, "Can only be one hierarchy in a parent-child dimension");
                    FmRelationalHierarchy hierarchy = (FmRelationalHierarchy)hierarchies.get(0);
                    multiAttr = hierarchy.getMultilingualAttributeMap().findAttribute((FmQueryItem)objQItem);
                } else {
                    FmLevel qiLevel = (FmLevel)objQItem.getLevel();
                    multiAttr = qiLevel.getMultilingualAttributeMap().findAttribute((FmQueryItem)objQItem);
                }
                if (multiAttr == null) continue;
                List<FmLocaleMapping> mappings = multiAttr.getLocaleMappingList();
                String defaultLocale = objQItem.getSession().getProject().getDefaultLocale();
                List<String> supportedLocales = objQItem.getSession().getProject().getSupportedLocales();
                this.genRefObj(elmAttr, objQItem, defaultLocale);
                Iterator iterator = mappings.iterator();
                while (iterator.hasNext()) {
                    FmLocaleMapping mapping = (FmLocaleMapping)iterator.next();
                    QueryItem qiMulti = mapping.getQueryItem();
                    if (qiMulti == null || mapping.getlocale().equals(defaultLocale)) continue;
                    for (String suppLocale : supportedLocales) {
                        if (!mapping.getlocale().equals(suppLocale)) continue;
                        this.genRefObj(elmAttr, mapping.getQueryItem(), mapping.getlocale());
                    }
                }
                continue;
            }
            this.genRefObj(elmAttr, objQItem, null);
        }
        if (convLevelInfo.m_Inject) {
            for (ConvergentAttributeInfo attrInfo : convLevelInfo.m_AttributeList) {
                Element elmChild = elmDim.addElement(TAG_ELE_attribute);
                elmChild.addAttribute(TAG_ATTR_name, attrInfo.m_AttributeName);
                for (String locale : locales) {
                    Element elmNameChild = elmChild.addElement(TAG_ELE_name);
                    elmNameChild.addAttribute(TAG_ATTR_locale, locale);
                    elmNameChild.addText(attrInfo.m_AttributeName);
                }
                elmChild.addElement(TAG_ELE_queryItem).addAttribute(TAG_ATTR_refObject, attrInfo.m_QueryItemRef);
            }
        }
        if (isParentChild) {
            String sMemberLevelName = this.exportParentChildHierarchy(someCube, elmDim, allHierarchies.get(0));
            this.genNameReference(elmDim, "olap:defaultConvergenceLevel", sMemberLevelName);
        } else {
            List<Level> allLevels = objRegDim.getAllLevels();
            this.exportLevelBasedHierarchies(someCube, elmDim, allLevels, allHierarchies, convLevelInfo);
            if (objMsrDim != null) {
                this.genNameReference(elmDim, "olap:defaultConvergenceLevel", convLevelInfo.m_LevelName);
            }
        }
        if (someCube != null && (rules = someCube.getAccessRules()).size() > 0) {
            Element elmSecurityRules = null;
            for (AccessRule rule : someCube.getAccessRules()) {
                RelationalDimension dim;
                AccessRule.RestrictObjectType objectType;
                if (rule.isEmpty() || !(objectType = rule.getRestrictObjectType()).equals((Object)AccessRule.RestrictObjectType.dimension) || !(dim = rule.getDimension()).equals(objRegDim)) continue;
                if (elmSecurityRules == null) {
                    elmSecurityRules = elmDim.addElement(TAG_ELE_securityRules);
                }
                this.exportSecurityRule(someCube, elmSecurityRules, rule.getName(), null, rule);
            }
        }
    }

    private ColumnReference extractSideInfo(Object object) {
        if (object instanceof ColumnReference) {
            ColumnReference cRef = (ColumnReference)object;
            return cRef;
        }
        FmMDException.ASSERT(false, "Unexpected query item in relationship");
        return null;
    }

    private ConvergentLevelInfo determineConvergenceLevel(RelationalDimension objRegDim, MeasureDimension objMeasDim, Relationship relDimFact) {
        ConvergentLevelInfo info = new ConvergentLevelInfo();
        List<Object> expParts = relDimFact.getExpression().getComponents();
        ArrayList<ColumnReference> convergentRefs = new ArrayList<ColumnReference>();
        int iStart = 0;
        while (iStart < expParts.size() && expParts.get(iStart) instanceof String) {
            ++iStart;
        }
        int i = iStart;
        while (i + 2 < expParts.size()) {
            FmMDException.ASSERT(expParts.get(i + 1) instanceof String, "Non-standard relationship expression.");
            if (expParts.size() > i + 3) {
                FmMDException.ASSERT(expParts.get(i + 3) instanceof String, "Non-standard relationship expression.");
            }
            ColumnReference leftSide = this.extractSideInfo(expParts.get(i));
            ColumnReference rightSide = this.extractSideInfo(expParts.get(i + 2));
            if (leftSide.getRelationalObject().equals(objMeasDim)) {
                convergentRefs.add(rightSide);
            } else if (rightSide.getRelationalObject().equals(objMeasDim)) {
                convergentRefs.add(leftSide);
            }
            i += 4;
        }
        FmMDException.ASSERT(convergentRefs.size() > 0, "Bad relationship expression; no join to the measure dimension. Validation should have caught this.");
        i = 0;
        while (i < convergentRefs.size()) {
            int j = i + 1;
            while (j < convergentRefs.size()) {
                ColumnReference iRef = (ColumnReference)convergentRefs.get(i);
                ColumnReference jRef = (ColumnReference)convergentRefs.get(j);
                FmMDException.ASSERT(iRef.getTableName().equals(jRef.getTableName()) && iRef.getDataSource().equals(jRef.getDataSource()), "Bad relationship expression; multiple joins to measure dimsion. Validation should have caught this.");
                ++j;
            }
            ++i;
        }
        HashSet<Object> examinedLevels = new HashSet<Object>();
        ColumnReference convergentRef = (ColumnReference)convergentRefs.get(0);
        ArrayList<Level> candidateLevels = new ArrayList<Level>();
        for (RelationalHierarchy hier : objRegDim.getAllHierarchies()) {
            Level level = hier.getBottomLevel();
            for (Object hier2 : objRegDim.getAllHierarchies()) {
                if (hier.equals(hier2) || !hier2.references(level) || hier2.getBottomLevel().equals(level)) continue;
                examinedLevels.add(level);
                break;
            }
            if (examinedLevels.contains(level.getInternal())) continue;
            if (this.matchConvergentLevelCandidate(convergentRef, level)) {
                candidateLevels.add(level);
            }
            examinedLevels.add(level.getInternal());
        }
        if (candidateLevels.size() > 0) {
            for (Level candidateLevel : candidateLevels) {
                for (ColumnReference ref : convergentRefs) {
                    if (!this.matchConvergentLevelCandidate(ref, candidateLevel)) continue;
                    info.m_LevelName = candidateLevel.getName();
                    return info;
                }
            }
        }
        for (Level level : objRegDim.getAllLevels()) {
            if (level.isAllLevel() || examinedLevels.contains(level.getInternal()) || !this.isReferencedInHierarchies(objRegDim, level) || !this.matchConvergentLevelCandidate(convergentRef, level)) continue;
            info.m_LevelName = level.getName();
            return info;
        }
        String businessQuerySubjectId = this.m_idMap.get(objRegDim.getInternal());
        FmMDException.ASSERT(businessQuerySubjectId != null, "Bad mapping for dimension " + objRegDim.getName());
        QuerySubject businessQuerySubject = (QuerySubject)this.m_dmrSession.findById(businessQuerySubjectId);
        FmMDException.ASSERT(businessQuerySubject != null, "Bad query subject id: " + businessQuerySubjectId);
        Namespace physicalNS = (Namespace)this.m_dmrSession.findById("[" + convergentRef.getDataSource().getSchemaName() + "]");
        QuerySubject qsOfInterest = null;
        for (QuerySubject qs : physicalNS.getQuerySubjects()) {
            if (!qs.getName().equals(convergentRef.getTableName())) continue;
            qsOfInterest = qs;
            break;
        }
        FmMDException.ASSERT(qsOfInterest != null, "Didn't find a db query subject for " + convergentRef.getTableName());
        info.m_Inject = true;
        info.m_LevelName = String.valueOf(convergentRef.getTableName()) + "_convergent_level";
        info.m_AttributeList = new ArrayList<ConvergentAttributeInfo>();
        for (ColumnReference cRef : convergentRefs) {
            QueryItem qiOfInterest = null;
            for (QueryItem qi : qsOfInterest.getAllQueryItems()) {
                if (!qi.getExternalName().equals(cRef.getColumnName())) continue;
                qiOfInterest = qi;
                break;
            }
            FmMDException.ASSERT(qiOfInterest != null, "Didn't find a db query item for " + cRef.getColumnName());
            QueryItem convergentQI = businessQuerySubject.findQueryItemReferencing(qiOfInterest);
            if (convergentQI == null) {
                Shortcut scOfInterest = null;
                HashSet<Object> shortcuts = new HashSet<Object>();
                QuerySubjectBase qsParent = qiOfInterest.getQueryParent();
                for (QueryItem queryItem : businessQuerySubject.getAllQueryItems()) {
                    for (Object comp : queryItem.getExpression().getComponents()) {
                        if (!(comp instanceof ReferenceViaShortcut)) continue;
                        FmRefobjViaShortcut ref = (FmRefobjViaShortcut)comp;
                        Shortcut sc = ref.getShortcut();
                        QueryItemBase qiRef = ref.getRefobj();
                        shortcuts.add(sc.getInternal());
                        if (!qiRef.getQueryParent().equals(qsParent)) continue;
                        scOfInterest = sc;
                        break;
                    }
                    if (scOfInterest != null) break;
                }
                if (scOfInterest == null) {
                    for (QueryItem queryItem : shortcuts) {
                        FmShortcut sc = FmShortcut.get(this.m_dmrSession, queryItem);
                        List<Relationship> rels = sc.getParentNamespace().getAllRelationships();
                        for (Relationship rel : rels) {
                            Shortcut testSc;
                            if (rel.getLeftEnd().equals(sc) && rel.getRightEnd() instanceof Shortcut) {
                                testSc = (Shortcut)rel.getRightEnd();
                                if (!testSc.getRefobj().equals(qsParent)) continue;
                                scOfInterest = testSc;
                                break;
                            }
                            if (!rel.getRightEnd().equals(sc) || !(rel.getLeftEnd() instanceof Shortcut) || !(testSc = (Shortcut)rel.getLeftEnd()).getRefobj().equals(qsParent)) continue;
                            scOfInterest = testSc;
                            break;
                        }
                        if (scOfInterest != null) break;
                    }
                }
                convergentQI = businessQuerySubject.createQueryItemFromQueryItem(cRef.getColumnName(), qiOfInterest, scOfInterest);
                convergentQI.setComment("The query item was injected to be used as a convergent item for the level " + info.m_LevelName + " in the dimension " + objRegDim.getName());
            }
            ConvergentAttributeInfo attrInfo = new ConvergentAttributeInfo();
            attrInfo.m_AttributeName = String.valueOf(convergentRef.getColumnName()) + "_convergent_item";
            attrInfo.m_QueryItemRef = convergentQI.getID();
            info.m_AttributeList.add(attrInfo);
        }
        return info;
    }

    private boolean isReferencedInHierarchies(RelationalDimension objRegDim, Level level) {
        List hierarchies = objRegDim.getAllHierarchies();
        for (RelationalHierarchy h : hierarchies) {
            if (!h.references(level)) continue;
            return true;
        }
        return false;
    }

    private boolean matchConvergentLevelCandidate(ColumnReference ref, Level level) {
        for (QueryItem item : level.getAllQueryItems()) {
            Table table;
            QueryItemMapping mapping = ref.getRelationalObject().findMapping(item);
            if (mapping == null || !(table = mapping.getTable()).getName().equals(ref.getTableName()) || !table.getDataSource().equals(ref.getDataSource()) || !mapping.getColumnName().equals(ref.getColumnName())) continue;
            return true;
        }
        return false;
    }

    private String exportParentChildHierarchy(Cube cube, Element elmDim, RelationalHierarchy objHrchy) {
        String sParentLevelName = this.exportParentLevel(elmDim, objHrchy);
        String sMemberLevelName = this.exportMemberLevel(elmDim, objHrchy);
        Element elmHier = this.exportFmObject(elmDim, "olap:hierarchy", objHrchy);
        elmHier.addAttribute(TAG_ATTR_type, this.convertHierarchyType(objHrchy));
        elmHier.addAttribute("deployment", "recursive");
        String rootMem = objHrchy.getRootMember();
        if (rootMem != null && rootMem.length() > 0) {
            elmHier.addAttribute("hasAllLevel", "yes");
            elmHier.addAttribute("allMemberName", rootMem);
        }
        this.addShowMembersAttributes(objHrchy, elmHier);
        this.genNameReference(elmHier, "olap:levelRef", sParentLevelName);
        this.genNameReference(elmHier, "olap:levelRef", sMemberLevelName);
        this.exportCalculatedMembers(cube, objHrchy, elmHier);
        this.exportHierarchyDefaultMUN(cube, objHrchy, elmHier);
        this.exportAllMemberCaption(objHrchy, elmHier);
        this.exportHierarchySecurityRules(cube, (FmRelationalHierarchy)objHrchy, elmHier);
        return sMemberLevelName;
    }

    private void addShowMembersAttributes(RelationalHierarchy objHrchy, Element elmHier) {
        elmHier.addAttribute("showMembers", objHrchy.getShowDataMembers() ? "yes" : "no");
        if (!objHrchy.getParentChild() || objHrchy.getShowDataMembers()) {
            elmHier.addAttribute("fillerDataMemberCaptionType", objHrchy.getCaptionForMembers() == RelationalHierarchy.CaptionForMembers.parent ? "parent" : "blank");
        }
        elmHier.addAttribute("showRelativeTimePriorPeriodMembers", objHrchy.getShowRelativeTimePriorPeriodMembers() ? "yes" : "no");
        elmHier.addAttribute("showRelativeTimeNextPeriodMembers", objHrchy.getShowRelativeTimeNextPeriodMembers() ? "yes" : "no");
        elmHier.addAttribute("showRelativeTimeSubtreeMembers", objHrchy.getShowRelativeTimeSubtreeMembers() ? "yes" : "no");
    }

    private String exportParentLevel(Element elmDim, RelationalHierarchy objHrchy) {
        String sName = gCS_MODEL_PARENT_LEVEL_DEFAULT_NAME;
        Property objProp = objHrchy.getCustomProperty("parentCSLevelName");
        if (objProp != null) {
            sName = objProp.getValue();
        }
        Element elmLevel = elmDim.addElement(TAG_ELE_level);
        elmLevel.addAttribute(TAG_ATTR_name, sName);
        elmLevel.addAttribute(TAG_ATTR_funcDep, "no");
        elmLevel.addAttribute(TAG_ATTR_type, "regular");
        String sKey = objHrchy.getParentItem().getName();
        this.genNameReference(elmLevel, TAG_ELE_levelKeyRef, sKey);
        this.genNameReference(elmLevel, TAG_ELE_defaultAttributeRef, sKey);
        return sName;
    }

    private String exportMemberLevel(Element elmDim, RelationalHierarchy objHrchy) {
        String sName = gCS_MODEL_MEMBER_LEVEL_DEFAULT_NAME;
        Property objProp = objHrchy.getCustomProperty("memberCSLevelName");
        if (objProp != null) {
            sName = objProp.getValue();
        }
        Element elmLevel = elmDim.addElement(TAG_ELE_level);
        elmLevel.addAttribute(TAG_ATTR_name, sName);
        elmLevel.addAttribute(TAG_ATTR_funcDep, "no");
        elmLevel.addAttribute(TAG_ATTR_type, "regular");
        QueryItem objParentItem = objHrchy.getParentItem();
        QueryItem objChildItem = objHrchy.getChildItem();
        this.genNameReference(elmLevel, TAG_ELE_levelKeyRef, objChildItem.getName());
        this.genNameReference(elmLevel, TAG_ELE_defaultAttributeRef, objChildItem.getName());
        List<SortItem> sortItems = objHrchy.getMemberSortItems();
        QueryItemBase objMemDesc = objHrchy.getItemWithRole(Role.EDefaultRoles.kRoleMemberDescription);
        QueryItemBase objMemCaption = objHrchy.getItemWithRole(Role.EDefaultRoles.kRoleMemberCaption);
        for (QueryItem item : objHrchy.getAllQueryItems()) {
            if (item.equals(objMemDesc) || item.equals(objMemCaption) || item.getHidden() || item.equals(objParentItem) || item.equals(objChildItem)) continue;
            this.genNameReference(elmLevel, "olap:relatedAttributeRef", item.getName());
        }
        for (SortItem objSortItem : sortItems) {
            this.genLevelSortItem(elmLevel, objSortItem);
        }
        if (objMemCaption != null) {
            this.genNameReference(elmLevel, "olap:captionAttributeRef", objMemCaption.getName());
        }
        if (objMemDesc != null) {
            this.genNameReference(elmLevel, "olap:descriptionAttributeRef", objMemDesc.getName());
        }
        this.genNameReference(elmLevel, TAG_ELE_businessKeyAttributeRef, objChildItem.getName());
        return sName;
    }

    private void exportLevelBasedHierarchies(Cube cube, Element elmDim, List<Level> allLevels, List<RelationalHierarchy> allHierarchies, ConvergentLevelInfo convLevelInfo) {
        for (Level objLevel : allLevels) {
            if (objLevel.isAllLevel() || !this.levelIsUsed(objLevel, allHierarchies)) continue;
            this.exportLevel(objLevel, elmDim);
        }
        if (convLevelInfo.m_Inject) {
            Element elmLevel = elmDim.addElement(TAG_ELE_level);
            elmLevel.addAttribute(TAG_ATTR_funcDep, "no");
            elmLevel.addAttribute(TAG_ATTR_type, "regular");
            elmLevel.addAttribute(TAG_ATTR_name, convLevelInfo.m_LevelName);
            List<String> locales = cube.getProject().getSupportedLocales();
            for (String locale : locales) {
                Element elmNameChild = elmLevel.addElement(TAG_ELE_name);
                elmNameChild.addAttribute(TAG_ATTR_locale, locale);
                elmNameChild.addText(convLevelInfo.m_LevelName);
            }
            for (ConvergentAttributeInfo attrInfo : convLevelInfo.m_AttributeList) {
                Element elmChild = elmLevel.addElement(TAG_ELE_levelKeyRef);
                elmChild.addAttribute(TAG_ATTR_name, attrInfo.m_AttributeName);
            }
        }
        for (RelationalHierarchy objHrchy : allHierarchies) {
            Level allLevel;
            Element elmHier = this.exportFmObject(elmDim, "olap:hierarchy", objHrchy);
            elmHier.addAttribute(TAG_ATTR_type, this.convertHierarchyType(objHrchy));
            elmHier.addAttribute("deployment", "standard");
            if (objHrchy.getAllLevel() != null) {
                elmHier.addAttribute("hasAllLevel", "yes");
                elmHier.addAttribute("allMemberName", objHrchy.getRootMember());
            }
            this.addShowMembersAttributes(objHrchy, elmHier);
            for (LevelReference levelRef : objHrchy.getLevelReferences()) {
                this.genNameReference(elmHier, "olap:levelRef", levelRef.getLevel().getName());
            }
            this.exportCalculatedMembers(cube, objHrchy, elmHier);
            if (objHrchy.getDimension().getDimensionStyle() == DimensionBase.DimensionStyle.time) {
                elmHier.addAttribute(TAG_ATTR_hasRelativeTimeMembers, objHrchy.getHasRelativeTimeMembers() ? "true" : "false");
                this.exportRelativeTimeMembers(objHrchy, elmHier);
            }
            this.exportHierarchyDefaultMUN(cube, objHrchy, elmHier);
            this.exportAllMemberCaption(objHrchy, elmHier);
            if (!objHrchy.isMultiRoot() && (allLevel = objHrchy.getAllLevel()) != null) {
                this.addMultilingualCaptionElements(elmHier, TAG_ELE_allLevelName, allLevel);
            }
            this.exportHierarchySecurityRules(cube, (FmRelationalHierarchy)objHrchy, elmHier);
        }
    }

    private void exportAllMemberCaption(RelationalHierarchy objHrchy, Element elmHier) {
        if (!objHrchy.isMultiRoot()) {
            List<String> locales = objHrchy.getProject().getSupportedLocales();
            for (String locale : locales) {
                String rootCaption = objHrchy.getRootCaption(locale);
                if (rootCaption == null) continue;
                Element elmNameChild = elmHier.addElement(TAG_ELE_allMemberCaption);
                elmNameChild.addAttribute(TAG_ATTR_locale, locale);
                elmNameChild.addText(rootCaption);
            }
        }
    }

    private boolean levelIsUsed(Level objLevel, List<RelationalHierarchy> allHierarchies) {
        for (RelationalHierarchy hier : allHierarchies) {
            if (!hier.getLevelIsUsed(objLevel)) continue;
            return true;
        }
        return false;
    }

    private void exportCalculatedMembers(Cube cube, RelationalHierarchy objHrchy, Element elmHrchy) {
        List<CalculatedMember> vCalcMmems = objHrchy.getCalculatedMembers();
        for (CalculatedMember objCalcMem : vCalcMmems) {
            if (objCalcMem.getExpression() == null) continue;
            Element elmCalcMsr = elmHrchy.addElement("olap:calculatedMember");
            elmCalcMsr.addAttribute(TAG_ATTR_name, objCalcMem.getName());
            MemberUniqueName munParent = objCalcMem.getParentMember();
            if (munParent != null) {
                elmCalcMsr.addElement("olap:parent").addAttribute(TAG_ATTR_name, munParent.getV5MemberUniqueName(cube, false));
            }
            elmCalcMsr.addElement("olap:V5Expression").addAttribute("template", objCalcMem.getV5Expression(cube));
            elmCalcMsr.addElement("olap:solveOrder").addAttribute("value", Integer.toString(objCalcMem.getSolveOrder()));
            this.addMultilingualCaptionElements(elmCalcMsr, TAG_ELE_caption, objCalcMem);
        }
    }

    private void exportHierarchyDefaultMUN(CubeBase cube, HierarchyBase objHrchy, Element elmHier) {
        String defaultMUN;
        MemberUniqueName mun = objHrchy.getDefaultMemberUniqueName();
        if (mun != null && (defaultMUN = mun.getV5MemberUniqueName(cube, false)) != null && !"".equals(defaultMUN)) {
            elmHier.addElement(TAG_ELE_defaultMemRef).addAttribute(TAG_ATTR_name, defaultMUN);
        }
    }

    private String convertHierarchyType(RelationalHierarchy objHrchy) {
        String outType = "balanced";
        return outType;
    }

    private void exportRelativeTimeMembers(RelationalHierarchy hierarchy, Element elmHier) {
        Element rtElement = null;
        for (RelativeTimeMember rtMember : hierarchy.getRelativeTimeMembers()) {
            if (rtMember.getRelativeTimeMemberStyle() == RelativeTimeMember.RelativeTimeMemberStyle.simple) {
                rtElement = elmHier.addElement(TAG_ELE_simpleRelativeTime);
                rtElement.addAttribute(TAG_ATTR_name, rtMember.getName());
                this.addMultilingualCaptionElements(rtElement, TAG_ELE_caption, rtMember);
                if (rtMember.getTargetPeriod() != null) {
                    this.genNameReference(rtElement, TAG_ELE_targetPeriod, rtMember.getTargetPeriod().getLevel().getName());
                    if (rtMember.getTargetPeriodOffset() != null) {
                        rtElement.addAttribute(TAG_ATTR_targetPeriodOffset, String.valueOf(rtMember.getTargetPeriodOffset()));
                    }
                }
                if (rtMember.getContextPeriod() == null) continue;
                this.genNameReference(rtElement, TAG_ELE_contextPeriod, rtMember.getContextPeriod().getLevel().getName());
                if (rtMember.getContextPeriodOffset() == null) continue;
                rtElement.addAttribute(TAG_ATTR_contextPeriodOffset, String.valueOf(rtMember.getContextPeriodOffset()));
                continue;
            }
            if (rtMember.getRelativeTimeMemberStyle() == RelativeTimeMember.RelativeTimeMemberStyle.periodToDate) {
                rtElement = elmHier.addElement(TAG_ELE_periodToDateRelativeTime);
                rtElement.addAttribute(TAG_ATTR_name, rtMember.getName());
                rtElement.addAttribute(TAG_ATTR_lifeToDate, String.valueOf(rtMember.isLifeToDate()));
                this.addMultilingualCaptionElements(rtElement, TAG_ELE_caption, rtMember);
                if (rtMember.getToDatePeriod() != null) {
                    this.genNameReference(rtElement, TAG_ELE_toDatePeriod, rtMember.getToDatePeriod().getLevel().getName());
                }
                FmMDException.ASSERT(rtMember.getTargetPeriod() != null, "No target period specified for: " + rtMember.toString());
                this.genNameReference(rtElement, TAG_ELE_targetPeriod, rtMember.getTargetPeriod().getLevel().getName());
                rtElement.addAttribute(TAG_ATTR_targetPeriodOffset, String.valueOf(rtMember.getTargetPeriodOffset()));
                if (rtMember.getContextPeriod() == null) continue;
                this.genNameReference(rtElement, TAG_ELE_contextPeriod, rtMember.getContextPeriod().getLevel().getName());
                if (rtMember.getContextPeriodOffset() == null) continue;
                rtElement.addAttribute(TAG_ATTR_contextPeriodOffset, String.valueOf(rtMember.getContextPeriodOffset()));
                continue;
            }
            if (rtMember.getRelativeTimeMemberStyle() != RelativeTimeMember.RelativeTimeMemberStyle.rollingTotal) continue;
            rtElement = elmHier.addElement(TAG_ELE_RollingTotalRelativeTime);
            rtElement.addAttribute(TAG_ATTR_name, rtMember.getName());
            this.addMultilingualCaptionElements(rtElement, TAG_ELE_caption, rtMember);
            if (rtMember.getTargetPeriod() != null) {
                this.genNameReference(rtElement, TAG_ELE_targetPeriod, rtMember.getTargetPeriod().getLevel().getName());
                if (rtMember.getTargetPeriodOffset() != null) {
                    rtElement.addAttribute(TAG_ATTR_targetPeriodOffset, String.valueOf(rtMember.getTargetPeriodOffset()));
                }
            }
            if (rtMember.getContextPeriod() != null) {
                this.genNameReference(rtElement, TAG_ELE_contextPeriod, rtMember.getContextPeriod().getLevel().getName());
                if (rtMember.getContextPeriodOffset() != null) {
                    rtElement.addAttribute(TAG_ATTR_contextPeriodOffset, String.valueOf(rtMember.getContextPeriodOffset()));
                }
            }
            if (rtMember.getNumberOfPeriods() == null) continue;
            rtElement.addAttribute(TAG_ATTR_numberOfPeriods, String.valueOf(rtMember.getNumberOfPeriods()));
        }
    }

    private void exportLevel(Level objLevel, Element elmDim) {
        List<QueryItem> allItems = objLevel.getAllQueryItems();
        Element elmLevel = this.exportFmObject(elmDim, TAG_ELE_level, objLevel);
        elmLevel.addAttribute(TAG_ATTR_funcDep, "no");
        this.addLevelKeys(elmLevel, objLevel, true);
        elmLevel.addAttribute(TAG_ATTR_type, objLevel.getLevelStyle().toString());
        List<QueryItem> levelKeys = objLevel.getLevelKeys();
        QueryItemBase objBuisKey = levelKeys.get(0);
        if (objBuisKey != null) {
            this.genNameReference(elmLevel, TAG_ELE_defaultAttributeRef, objBuisKey.getName());
        }
        List<SortItem> sortItems = objLevel.getMemberSortItems();
        QueryItemBase objMemDesc = objLevel.getItemWithRole(Role.EDefaultRoles.kRoleMemberDescription);
        QueryItemBase objMemCaption = objLevel.getItemWithRole(Role.EDefaultRoles.kRoleMemberCaption);
        for (QueryItem item : allItems) {
            if (this.isKeyOrSortItem(item, levelKeys, sortItems) || item.equals(objMemDesc) || item.equals(objMemCaption) || item.equals(objBuisKey) || item.getHidden()) continue;
            this.genNameReference(elmLevel, "olap:relatedAttributeRef", item.getName());
        }
        for (SortItem objSortItem : sortItems) {
            this.genLevelSortItem(elmLevel, objSortItem);
        }
        if (objMemCaption != null) {
            this.genNameReference(elmLevel, "olap:captionAttributeRef", objMemCaption.getName());
        }
        if (objMemDesc != null) {
            this.genNameReference(elmLevel, "olap:descriptionAttributeRef", objMemDesc.getName());
        }
        this.genNameReference(elmLevel, TAG_ELE_businessKeyAttributeRef, objBuisKey.getName());
        if (objLevel.isTimeLevel()) {
            elmLevel.addElement(TAG_ELE_relativeTimeMemberType).addText("allRelativeTimeMembers");
            this.exportCurrentPeriodExpression(objLevel, elmLevel);
        }
    }

    private void exportCurrentPeriodExpression(LevelBase objLevel, Element elmLevel) {
        Expression expr = objLevel.getCurrentPeriodExpression();
        if (expr != null) {
            CurrentPeriodExpressionHandler exprHandler = new CurrentPeriodExpressionHandler();
            expr.evaluateComponents(exprHandler);
            elmLevel.addElement(TAG_ELE_currentPeriodExpression).addText(exprHandler.getExpression());
        }
    }

    private boolean isKeyOrSortItem(QueryItem objQItem, List<QueryItem> levelKeys, List<SortItem> sortItems) {
        if (levelKeys.contains(objQItem)) {
            return true;
        }
        for (SortItem sortItem : sortItems) {
            if (!objQItem.equals(sortItem.getQueryItem())) continue;
            return true;
        }
        return false;
    }

    private void genLevelSortItem(Element elmLevel, SortItem objSortItem) {
        if (objSortItem.getQueryItem() == null) {
            return;
        }
        Element elmSort = this.genNameReference(elmLevel, "olap:orderAttributeRef", objSortItem.getQueryItem().getName());
        elmSort.addAttribute("order", objSortItem.getSort() == SortItem.ESortItem.ascending ? "asc" : "desc");
    }

    private void genRefObj(Element elmParent, QueryItemBase objItem, String locale) {
        String idDMRObj = this.m_idMap.get(((FmQueryItemBase)objItem).getInternal());
        FmMDException.ASSERT(idDMRObj != null, "Failed to generate ROLAP model. Unable to locate the object corresponding to \"" + objItem.getID() + "\" in the underlying model.");
        Element queryItemElement = elmParent.addElement(TAG_ELE_queryItem);
        queryItemElement.addAttribute(TAG_ATTR_refObject, idDMRObj);
        if (locale != null) {
            queryItemElement.addAttribute(TAG_ATTR_locale, locale);
        }
    }

    private void exportMeasureFolder(Element elmCubeFacts, MeasureFolder objMsrFld) {
        if (objMsrFld.hasDescendantMeasuresOrCalculatedMeasures()) {
            Element elmMsrFld = elmCubeFacts.addElement(TAG_ELE_measureFolder);
            elmMsrFld.addAttribute(TAG_ATTR_name, objMsrFld.getName());
            this.addMultilingualCaptionElements(elmMsrFld, TAG_ELE_name, objMsrFld);
            List<BaseObject> allMeasureFolderChildren = objMsrFld.getChildObjects();
            for (BaseObject child : allMeasureFolderChildren) {
                switch (child.getFmObjectType()) {
                    case measure: {
                        Measure objMsr = (Measure)child;
                        this.genNameReference(elmMsrFld, "olap:measureRef", objMsr.getName());
                        break;
                    }
                    case calculatedMember: {
                        CalculatedMember objCalcMsr = (CalculatedMember)child;
                        this.genNameReference(elmMsrFld, "olap:calculatedMeasureRef", objCalcMsr.getName());
                        break;
                    }
                    case measureFolder: {
                        MeasureFolder objMeasureFolder = (MeasureFolder)child;
                        this.exportMeasureFolder(elmMsrFld, objMeasureFolder);
                        break;
                    }
                    default: {
                        FmMDException.ASSERT(false, "Invalid measure folder child: " + child.getID());
                    }
                }
            }
        }
    }

    private void exportMeasureDimensionChildren(Cube parentCube, Element elmFacts, BaseObject fmObject) {
        List<BaseObject> allMeasureDimChildren = fmObject.getChildObjects();
        block6: for (BaseObject child : allMeasureDimChildren) {
            switch (child.getFmObjectType()) {
                case measure: {
                    Measure objMsr = (Measure)child;
                    Element elmMeasure = this.exportFmObject(elmFacts, "olap:measure", objMsr);
                    this.genRefObj(elmMeasure, objMsr, null);
                    elmMeasure.addAttribute(TAG_ATTR_visible, objMsr.getHidden() ? "false" : "true");
                    if (objMsr.getFormat() != null && !"".equals(objMsr.getFormat())) {
                        elmMeasure.addAttribute(TAG_ATTR_format, objMsr.getFormat());
                    }
                    List<AggregateRule> aggrRules = objMsr.getAggregateRules();
                    for (AggregateRule ar : aggrRules) {
                        Element elmAggr = elmMeasure.addElement("olap:aggregation").addAttribute("function", this.getSemiAggregate(ar));
                        for (DimensionBase dim : ar.getDimensionRefs()) {
                            Element elmDimRef = this.genNameReference(elmAggr, "olap:dimensionRef", dim.getName());
                            elmDimRef.addAttribute(TAG_ATTR_category, "public");
                        }
                    }
                    continue block6;
                }
                case calculatedMember: {
                    CalculatedMember objCalcMsr = (CalculatedMember)child;
                    Element elmCalcMsr = elmFacts.addElement("olap:calculatedMeasure");
                    elmCalcMsr.addAttribute(TAG_ATTR_name, objCalcMsr.getName());
                    elmCalcMsr.addAttribute(TAG_ATTR_visible, objCalcMsr.getHidden() ? "false" : "true");
                    if (objCalcMsr.getFormat() != null && !"".equals(objCalcMsr.getFormat())) {
                        elmCalcMsr.addAttribute(TAG_ATTR_format, objCalcMsr.getFormat());
                    }
                    elmCalcMsr.addElement("olap:V5Expression").addAttribute("template", objCalcMsr.getV5Expression(parentCube));
                    elmCalcMsr.addElement("olap:solveOrder").addAttribute("value", Integer.toString(objCalcMsr.getSolveOrder()));
                    this.addMultilingualCaptionElements(elmCalcMsr, TAG_ELE_caption, objCalcMsr);
                    elmCalcMsr.addElement("olap:aggregation").addAttribute("function", this.getAggregationFunctionForCalculatedMeasures(objCalcMsr.getRegularAggregate()));
                    break;
                }
                case measureFolder: {
                    MeasureFolder objMsrFld = (MeasureFolder)child;
                    this.exportMeasureDimensionChildren(parentCube, elmFacts, objMsrFld);
                    break;
                }
                case accessRules: 
                case filterFolder: 
                case queryItem: {
                    break;
                }
                default: {
                    FmMDException.ASSERT(false, "Invalid measure dimension child: " + child.getFmObjectTypeName() + " " + child.getID());
                }
            }
        }
    }

    private void exportMeasureDim(Cube parentCube, Element elmCubeModel, FmMeasureDimension objMsrDim) {
        Element elmFacts = this.exportFmObject(elmCubeModel, "olap:facts", objMsrDim);
        for (QueryItem objAttr : objMsrDim.getAllQueryItems()) {
            if (objAttr.getHidden()) continue;
            Element elmAttribute = this.exportFmObject(elmFacts, TAG_ELE_attribute, objAttr);
            this.genRefObj(elmAttribute, objAttr, null);
        }
        this.exportMeasureDimensionChildren(parentCube, elmFacts, objMsrDim);
        this.setDefaultMeasure(objMsrDim, elmFacts);
        this.exportSecurityRules(parentCube, objMsrDim, elmFacts);
    }

    private String getAggregationFunctionForCalculatedMeasures(FmRegularAggregate aggregate) {
        switch (aggregate) {
            case average: {
                return "average";
            }
            case maximum: {
                return "maximum";
            }
            case median: {
                return "median";
            }
            case minimum: {
                return "minimum";
            }
            case sum: {
                return "sum";
            }
            case standardDeviation: {
                return "standardDeviation";
            }
            case variance: {
                return "variance";
            }
            case count: {
                return "count";
            }
            case countDistinct: {
                return "countDistinct";
            }
            case countNonZero: {
                return "countNonZero";
            }
            case calculated: {
                return "calculated";
            }
        }
        FmMDException.ASSERT(false, "Unsupported aggregate rule for calculated measures: " + aggregate.toString());
        return "";
    }

    private String getSemiAggregate(AggregateRule ar) {
        switch (ar.getApplyAggregate()) {
            case average: {
                return "average";
            }
            case firstPeriod: {
                return "firstPeriod";
            }
            case lastPeriod: {
                return "lastPeriod";
            }
            case currentPeriod: {
                return "currentPeriod";
            }
            case maximum: {
                return "maximum";
            }
            case median: {
                return "median";
            }
            case minimum: {
                return "minimum";
            }
            case sum: {
                return "sum";
            }
            case standardDeviation: {
                return "standardDeviation";
            }
            case variance: {
                return "variance";
            }
            case count: {
                return "count";
            }
            case countDistinct: {
                return "countDistinct";
            }
            case countNonZero: {
                return "countNonZero";
            }
            case calculated: {
                return "calculated";
            }
            case unknown: {
                return "unknown";
            }
            case none: {
                return "none";
            }
        }
        FmMDException.ASSERT(false, "Unsupported semi-aggregate rule " + ar.getApplyAggregate().toString());
        return "";
    }

    private Element createCubeModelElement(Element elmMDScehma, String sName) {
        Element elmCubeModel = elmMDScehma.addElement("olap:cubeModel");
        elmCubeModel.addAttribute(TAG_ATTR_name, sName);
        elmCubeModel.addElement("olap:modelPath").addText("./model.xml");
        return elmCubeModel;
    }

    private void addMultilingualCaptionElements(Element elmParent, String tagName, ReportObject objFM) {
        List<String> locales = objFM.getProject().getSupportedLocales();
        for (String locale : locales) {
            String localizedName = objFM.getName(locale);
            if (localizedName == null || localizedName.equals("")) continue;
            Element elmNameChild = elmParent.addElement(tagName);
            elmNameChild.addAttribute(TAG_ATTR_locale, locale);
            elmNameChild.addText(localizedName);
        }
    }

    private Element exportFmObject(Element elmParent, String tagName, ReportObject objFM) {
        String temp;
        Element elmChild = elmParent.addElement(tagName);
        elmChild.addAttribute(TAG_ATTR_name, objFM.getName());
        if (!tagName.equals("olap:cubeFacts")) {
            this.addMultilingualCaptionElements(elmChild, TAG_ELE_name, objFM);
        }
        if ((temp = objFM.getComment()) != null && temp.length() > 0) {
            elmChild.addAttribute(TAG_ATTR_comments, temp);
        }
        if ((temp = objFM.getLastChangedBy()) != null && temp.length() > 0) {
            elmChild.addAttribute(TAG_ATTR_modifier, temp);
        }
        return elmChild;
    }

    private Element genNameReference(Element elmParent, String tagName, String targetName) {
        Element elmChild = elmParent.addElement(tagName).addAttribute(TAG_ATTR_name, targetName);
        return elmChild;
    }

    private void exportSecurityRules(Cube cube, AccessRuleParentInternal parent, Element elmParent) {
        if (parent instanceof FmRelationalHierarchy && ((FmRelationalHierarchy)parent).getHasRelativeTimeMembers()) {
            return;
        }
        List<AccessRule> accessRules = parent.getAccessRules();
        Element elmSecurityRules = null;
        for (AccessRule rule : accessRules) {
            if (rule.isEmpty()) continue;
            if (elmSecurityRules == null) {
                elmSecurityRules = elmParent.addElement(TAG_ELE_securityRules);
            }
            this.exportSecurityRule(cube, elmSecurityRules, rule.getName(), parent instanceof FmRelationalHierarchy ? (RelationalHierarchy)((Object)parent) : null, rule);
        }
    }

    private void exportHierarchySecurityRules(Cube cube, FmRelationalHierarchy hier, Element elmParent) {
        if (hier instanceof FmRelationalHierarchy && hier.getHasRelativeTimeMembers()) {
            return;
        }
        List<AccessRule> accessRules = hier.getAccessRules();
        Element elmSecurityRules = null;
        for (AccessRule rule : accessRules) {
            if (rule.isEmpty()) continue;
            if (elmSecurityRules == null) {
                elmSecurityRules = elmParent.addElement(TAG_ELE_securityRules);
            }
            this.exportSecurityRule(cube, elmSecurityRules, rule.getName(), hier instanceof FmRelationalHierarchy ? hier : null, rule);
        }
        if (cube != null) {
            List<AccessRule> rules = cube.getAccessRules();
            RelationalDimension objRegDim = hier.getDimension();
            if (rules.size() > 0) {
                for (AccessRule rule : cube.getAccessRules()) {
                    RelationalDimension dim;
                    AccessRule.RestrictObjectType objectType;
                    if (rule.isEmpty() || !(objectType = rule.getRestrictObjectType()).equals((Object)AccessRule.RestrictObjectType.attribute) || !(dim = (RelationalDimension)rule.getQueryItem().getRelationalParent()).equals(objRegDim)) continue;
                    if (elmSecurityRules == null) {
                        elmSecurityRules = elmParent.addElement(TAG_ELE_securityRules);
                    }
                    Map<Object, String> ruleNames = this.m_AttributeAccessRules.get(rule.getInternal());
                    boolean bInHierarchy = false;
                    if (hier.getParentChild()) {
                        bInHierarchy = true;
                    } else {
                        AttributeReference ref = hier.getAttributeReference(rule.getQueryItem());
                        boolean bl = bInHierarchy = ref != null;
                    }
                    if (!bInHierarchy) continue;
                    if (ruleNames == null) {
                        ruleNames = new HashMap<Object, String>();
                        this.m_AttributeAccessRules.put(rule.getInternal(), ruleNames);
                    }
                    String name = String.valueOf(rule.getName()) + " " + hier.getName();
                    this.exportSecurityRule(cube, elmSecurityRules, name, hier, rule);
                    ruleNames.put(hier.getInternal(), name);
                }
            }
        }
    }

    private Element exportSecurityRule(Cube someCube, Element elmSecurityRules, String ruleName, RelationalHierarchy hier, AccessRule rule) {
        AttributeReference ref;
        AccessRule.RestrictObjectType objectType = rule.getRestrictObjectType();
        if (objectType.equals((Object)AccessRule.RestrictObjectType.attribute) && !hier.getParentChild() && (ref = hier.getAttributeReference(rule.getQueryItem())) == null) {
            return null;
        }
        Element elmRule = elmSecurityRules.addElement("olap:rule");
        elmRule.addAttribute(TAG_ATTR_name, ruleName);
        switch (objectType) {
            case member: 
            case measure: {
                elmRule.addAttribute(TAG_ATTR_securityType, "member");
                break;
            }
            case dimension: {
                elmRule.addAttribute(TAG_ATTR_securityType, "dimension");
                break;
            }
            case attribute: {
                elmRule.addAttribute(TAG_ATTR_securityType, "attribute");
            }
        }
        Element elmPermission = null;
        switch (rule.getPermission()) {
            case grant: {
                elmPermission = elmRule.addElement("olap:grant");
                break;
            }
            case deny: {
                elmPermission = elmRule.addElement("olap:deny");
            }
        }
        if (rule.getRuleStyle() == AccessRule.RuleStyle.roleBased) {
            String ruleText = objectType == AccessRule.RestrictObjectType.attribute && hier != null ? rule.getV5Expression(someCube, hier) : rule.getV5Expression(someCube);
            if (ruleText != null) {
                elmPermission.addText(ruleText);
            }
        } else if (rule.getRuleStyle() == AccessRule.RuleStyle.lookupTableBased) {
            FmMDException.ASSERT(hier != null, "No hierarchy for member security filter");
            if (hier.getParentChild()) {
                Element elmKeyMapping = elmPermission.addElement("olap:lookupTableQueryItem");
                List<QueryItem> levelKeys = hier.getLevelKeys();
                FmMDException.ASSERT(levelKeys.size() == 1, "Bad number of level keys in a parent-child hierarchy.");
                QueryItem filterItem = rule.getLevelKeyToQueryItem(levelKeys.get(0));
                String idDMRObj = this.m_idMap.get(((FmQueryItemBase)((Object)filterItem)).getInternal());
                FmMDException.ASSERT(idDMRObj != null, "Didn't find an FM object corresponding to " + filterItem.getName());
                elmKeyMapping.addAttribute("queryItemRef", idDMRObj);
            } else {
                for (LevelReference levelRef : hier.getLevelReferences()) {
                    QueryItem filterItem;
                    Level level = levelRef.getLevel();
                    boolean exportFilterItems = true;
                    List<QueryItem> levelKeys = level.getLevelKeys();
                    for (QueryItem levelKey : levelKeys) {
                        filterItem = rule.getLevelKeyToQueryItem(levelKey);
                        if (filterItem != null) continue;
                        exportFilterItems = false;
                        break;
                    }
                    if (!exportFilterItems) continue;
                    for (QueryItem levelKey : levelKeys) {
                        filterItem = rule.getLevelKeyToQueryItem(levelKey);
                        Element elmKeyMapping = elmPermission.addElement("olap:lookupTableQueryItem");
                        elmKeyMapping.addAttribute("levelRef", level.getName());
                        String idDMRObj = this.m_idMap.get(((FmQueryItemBase)((Object)filterItem)).getInternal());
                        FmMDException.ASSERT(idDMRObj != null, "Didn't find an FM object corresponding to " + filterItem.getName());
                        elmKeyMapping.addAttribute("queryItemRef", idDMRObj);
                    }
                }
            }
            Element elmFilter = elmPermission.addElement("olap:lookupTableFilter");
            elmFilter.addText(rule.getFilterExpressionText(this.m_idMap));
        }
        if (objectType == AccessRule.RestrictObjectType.member) {
            switch (rule.getMemberAccess()) {
                case grantAll: {
                    elmPermission.addAttribute("all", "true");
                    break;
                }
                case grantMembers: {
                    elmPermission.addAttribute("scope", "self");
                    break;
                }
                case grantMembersAndDescendants: {
                    elmPermission.addAttribute("scope", "self_and_descendants");
                    break;
                }
                case grantMembersAndAncestors: {
                    elmPermission.addAttribute("scope", "self_and_ascendants");
                    break;
                }
                case grantMembersDescendantsAndAncestors: {
                    elmPermission.addAttribute("scope", "self_and_ascendants_descendants");
                    break;
                }
                case denyMembersAndDescendants: {
                    elmPermission.addAttribute("scope", "self_and_descendants");
                }
            }
        }
        return elmPermission;
    }

    private void exportSecurityViews(Cube someCube, Element elmCube) {
        List<AccessView> views = someCube.getAccessViews();
        if (views.size() > 0) {
            Element elmSecurity = null;
            Element elmViews = null;
            for (AccessView view : views) {
                List<AccessRule> rules = view.getAccessRules();
                if (rules.size() == 0) continue;
                Element elmView = null;
                for (AccessRule rule : rules) {
                    RelationalHierarchy hier;
                    Element elmDimension;
                    RelationalDimension dim;
                    if (rule.isEmpty()) continue;
                    if (elmSecurity == null) {
                        elmSecurity = elmCube.addElement("olap:security");
                        elmViews = elmSecurity.addElement("olap:views");
                    }
                    if (elmView == null) {
                        elmView = elmViews.addElement("olap:view");
                        elmView.addAttribute(TAG_ATTR_name, view.getName());
                    }
                    BaseObject parent = rule.getParent().getParent();
                    AccessRule.RestrictObjectType objectType = rule.getRestrictObjectType();
                    if (objectType == AccessRule.RestrictObjectType.measure) {
                        MeasureDimension measDim = (MeasureDimension)parent;
                        Element elmMeasDim = this.exportSecurityDimensionRef(elmView, measDim.getName(), "private");
                        Element elmHierarchy = this.genNameReference(elmMeasDim, "olap:securityHierarchyRef", measDim.getName());
                        this.genNameReference(elmHierarchy, "olap:ruleRef", rule.getName());
                        continue;
                    }
                    if (objectType == AccessRule.RestrictObjectType.dimension) {
                        dim = rule.getDimension();
                        elmDimension = this.exportSecurityDimensionRef(elmView, dim.getName(), "public");
                        this.genNameReference(elmDimension, "olap:ruleRef", rule.getName());
                        continue;
                    }
                    if (objectType == AccessRule.RestrictObjectType.attribute) {
                        dim = (RelationalDimension)rule.getQueryItem().getRelationalParent();
                        elmDimension = this.exportSecurityDimensionRef(elmView, dim.getName(), "public");
                        Map<Object, String> attrRules = this.m_AttributeAccessRules.get(rule.getInternal());
                        FmMDException.ASSERT(attrRules != null, "No rule objects for rule " + rule.getID());
                        for (RelationalHierarchy hier2 : dim.getAllHierarchies()) {
                            if (!attrRules.containsKey(hier2.getInternal())) continue;
                            String ruleName = attrRules.get(hier2.getInternal());
                            Element elmHierarchy = this.genNameReference(elmDimension, "olap:securityHierarchyRef", hier2.getName());
                            this.genNameReference(elmHierarchy, "olap:ruleRef", ruleName);
                        }
                        continue;
                    }
                    if (objectType != AccessRule.RestrictObjectType.member || (hier = (RelationalHierarchy)parent).getHasRelativeTimeMembers()) continue;
                    RelationalDimension dim2 = hier.getDimension();
                    Element elmDimension2 = this.exportSecurityDimensionRef(elmView, dim2.getName(), "public");
                    Element elmHierarchy = this.genNameReference(elmDimension2, "olap:securityHierarchyRef", hier.getName());
                    this.genNameReference(elmHierarchy, "olap:ruleRef", rule.getName());
                }
            }
        }
    }

    private Element exportSecurityDimensionRef(Element elmView, String name, String category) {
        Element secDimRef = elmView.addElement("olap:securityDimensionRef");
        secDimRef.addAttribute(TAG_ATTR_name, name);
        secDimRef.addAttribute(TAG_ATTR_category, category);
        return secDimRef;
    }

    public static void prepareFMSessionForROLAP(FMMDSession session, String newDefaultLocale) {
        Project proj = session.getProject();
        String oldDefaultLocale = proj.getDefaultLocale();
        if (oldDefaultLocale.equalsIgnoreCase(newDefaultLocale)) {
            return;
        }
        proj.setDefaultLocale(newDefaultLocale);
        ArrayList<String> oldLocales = new ArrayList<String>(1);
        oldLocales.add(oldDefaultLocale);
        proj.removeLocales(oldLocales);
    }

    public static void removeNonDefaultLocales(FMMDSession session) {
        Project proj = session.getProject();
        String defaultLocale = proj.getDefaultLocale();
        List<String> locales = proj.getSupportedLocales();
        Iterator<String> it = locales.iterator();
        while (it.hasNext()) {
            String locale = it.next();
            if (!locale.equals(defaultLocale)) continue;
            it.remove();
            break;
        }
        proj.removeLocales(locales);
    }

    private void exportNamedSets(NamedSetParent cube, Element elmCube) {
        List<NamedSet> sets = cube.getAllNamedSets();
        if (!sets.isEmpty()) {
            Element collector = null;
            collector = cube instanceof Cube ? elmCube.addElement(TAG_ELE_namedSets) : elmCube.addElement(TAG_ELE_virtualNamedSets);
            for (NamedSet set : sets) {
                this.exportNamedSet(cube, set, collector);
            }
        }
    }

    private void exportNamedSet(NamedSetParent cube, NamedSet set, Element parentElement) {
        Element setElement = null;
        setElement = cube instanceof Cube ? parentElement.addElement(TAG_ELE_namedSet).addAttribute(TAG_ATTR_name, set.getName()) : parentElement.addElement(TAG_ELE_virtualNamedSet).addAttribute(TAG_ATTR_name, set.getName());
        setElement.addElement("olap:V5Expression").addAttribute("template", set.getV5Expression((CubeBase)cube));
        this.addMultilingualCaptionElements(setElement, TAG_ELE_caption, set);
        List<LocalizedValue> setNames = set.getNames();
        for (LocalizedValue v : setNames) {
            BaseObject folder = set.getParent();
            String pathName = "";
            String locale = v.getLocale();
            while (folder != null && folder instanceof NamedSetFolder) {
                String folderName = ((NamedSetFolder)folder).getName(locale);
                if (folderName == null || folderName.isEmpty()) {
                    folderName = folder.getName();
                }
                if (!pathName.isEmpty()) {
                    pathName = "\\" + pathName;
                }
                pathName = String.valueOf(folderName) + pathName;
                folder = folder.getParent();
            }
            Element pathElement = setElement.addElement(TAG_ELE_displayPath);
            pathElement.addAttribute(TAG_ATTR_locale, locale);
            pathElement.addText(pathName);
        }
    }

    class ConvergentAttributeInfo {
        public String m_AttributeName;
        public String m_QueryItemRef;

        ConvergentAttributeInfo() {
        }
    }

    class ConvergentLevelInfo {
        public boolean m_Inject = false;
        public String m_LevelName;
        List<ConvergentAttributeInfo> m_AttributeList;

        ConvergentLevelInfo() {
        }
    }

    class CurrentPeriodExpressionHandler
    extends ExpressionHandler {
        private String m_V5Expr = "";

        public String getExpression() {
            return this.m_V5Expr;
        }

        public void doString(String value) {
            this.m_V5Expr = String.valueOf(this.m_V5Expr) + value;
        }

        public void doFmQueryItem(FmQueryItem value) {
            String id = (String)FmTaskExportToCognosROLAP.this.m_idMap.get(value.getInternal());
            FmMDException.ASSERT(id != null, "No converted ID found for " + value.getID());
            this.m_V5Expr = String.valueOf(this.m_V5Expr) + id;
        }

        public void doUnhandled(Object value) {
            if (value instanceof FmBaseObject) {
                FmMDException.ASSERT(false, "No current period expression handler for objects of type: " + ((FmBaseObject)value).getLocalizedType() + ":" + ((FmBaseObject)value).getID());
            } else {
                FmMDException.ASSERT(false, "No current period expression handler for objects of type: " + value.getClass().toString());
            }
        }
    }
}

