/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.cognos.developer.schemas.bibus.rolap._3.RolapService_PortType;
import com.cognos.developer.schemas.bibus.rolap._3.RolapService_ServiceLocator;
import com.cognos.developer.schemas.bibus.rolap._3.XMLBlob;
import com.ibm.cognos.fmeng.fmmd.helpers.XExecuteCommandHelper;
import com.ibm.cognos.fmeng.fmmd.helpers.XValidateCommandHelper;
import com.ibm.cognos.fmeng.fmmd.impl.task.planner.XAdaptor;
import com.ibm.cognos.fmeng.fmmd.model.TaskExpressionValidation;
import com.ibm.cognos.fmeng.fmmd.util.CmHelper;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmPreferences;
import com.ibm.cognos.fmeng.utility.V5DataItem;
import com.ibm.cognos.fmeng.utility.queryTemplates.ExecuteV5Query;
import com.ibm.cognos.fmeng.utility.soap.FmEngSoapRequest;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.rpc.ServiceException;
import javax.xml.soap.SOAPException;
import org.apache.axis.client.Stub;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmTaskExpressionValidation
implements TaskExpressionValidation {
    private FMMDSession m_session;

    public static TaskExpressionValidation getInstance(FMMDSession session) {
        return new FmTaskExpressionValidation(session);
    }

    private FmTaskExpressionValidation(FMMDSession session) {
        this.m_session = session;
    }

    @Override
    public List<TaskExpressionValidation.ExpressionResult> validateExpressions(List<String> expressions) {
        Document document = this.validateExpression("<connection><productLocale value='en'/><runLocale value='en'/></connection>", expressions);
        List exps = document.selectNodes("//*[local-name() = 'standaloneExpression']");
        ArrayList<TaskExpressionValidation.ExpressionResult> results = new ArrayList<TaskExpressionValidation.ExpressionResult>(exps.size());
        int i = 0;
        while (i < exps.size()) {
            Element elm = (Element)exps.get(0);
            FmExpressionResult res = new FmExpressionResult();
            res.m_hasError = false;
            String hasError = elm.attributeValue("hasError");
            if ("true".equals(hasError)) {
                res.m_hasError = true;
                Element error = (Element)elm.selectSingleNode(".//*[local-name()='error']");
                if (error != null) {
                    res.m_error = error.getText();
                }
            }
            results.add(res);
            ++i;
        }
        return results;
    }

    protected Document validateExpression(String connectionXML, List<String> expressions) {
        RolapService_ServiceLocator serviceLocator = new RolapService_ServiceLocator();
        try {
            RolapService_PortType rolapService = serviceLocator.getrolapService(new URL(FmPreferences.getInstance().getDispatcherEndPoint()));
            FmEngSoapRequest.initializeStub((Stub)rolapService, this.m_session.getPassport(), this.m_session.getActiveLocale().toString());
            XMLBlob connection = new XMLBlob(connectionXML);
            StringBuilder allExpressions = new StringBuilder("<expressions>");
            for (String expr : expressions) {
                allExpressions.append("<standaloneExpression>");
                allExpressions.append(StringEscapeUtils.escapeXml((String)expr));
                allExpressions.append("</standaloneExpression>");
            }
            allExpressions.append("</expressions>");
            XMLBlob expression = new XMLBlob(allExpressions.toString());
            rolapService.validateV5(connection, expression);
            String response = ((Stub)rolapService)._getCall().getResponseMessage().getSOAPEnvelope().getBody().toString();
            Document document = DocumentHelper.parseText((String)response);
            return document;
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
        catch (ServiceException se) {
            throw new RuntimeException(se.getMessage(), se);
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException(mue.getMessage(), mue);
        }
        catch (SOAPException se) {
            throw new RuntimeException(se.getMessage(), se);
        }
        catch (DocumentException de) {
            throw new RuntimeException(de.getMessage(), de);
        }
    }

    @Override
    public Element validateExpressions(V5DataItem dataItem) {
        CmHelper helper = CmHelper.get(this.m_session, this.m_session.getPassport());
        helper.validatePassport();
        ExecuteV5Query query = new ExecuteV5Query(dataItem);
        XExecuteCommandHelper hlprExecuteCmd = new XExecuteCommandHelper(this.m_session);
        Document document = DocumentHelper.createDocument();
        Element commandElement = document.addElement("command");
        hlprExecuteCmd.insertQuerySetWithModelPath(commandElement, query.getQuerySet(), dataItem.getCubeName());
        hlprExecuteCmd.insertProperties(commandElement, V5DataItem.getProperties());
        hlprExecuteCmd.setQOSSeverityLevel(XExecuteCommandHelper.EQOSSeverity.error);
        hlprExecuteCmd.addQueryFeedback(XExecuteCommandHelper.EQueryFeedback.nativeCommandText);
        hlprExecuteCmd.addQueryFeedback(XExecuteCommandHelper.EQueryFeedback.CognosCommandText);
        hlprExecuteCmd.addQueryFeedback(XExecuteCommandHelper.EQueryFeedback.connections);
        hlprExecuteCmd.addQueryFeedback(XExecuteCommandHelper.EQueryFeedback.nativeCommandType);
        hlprExecuteCmd.makeQueryFeedbacks(commandElement.element("execute"));
        XValidateCommandHelper hlprValidateCmd = new XValidateCommandHelper(commandElement);
        Element validateCommand = hlprValidateCmd.make();
        Element result = null;
        try {
            XAdaptor myAdaptor = XAdaptor.create(this.m_session, false, false, true);
            result = myAdaptor.doQsApiRequest(validateCommand, 500);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
        XValidateCommandHelper.checkReponse(result);
        return result;
    }

    class FmExpressionResult
    implements TaskExpressionValidation.ExpressionResult {
        String m_error;
        boolean m_hasError;

        public String getError() {
            return this.m_error;
        }

        public boolean hasError() {
            return this.m_hasError;
        }
    }
}

