/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.taskGenerateDDL.DDLFetcher;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskGenerateDDL.DDLFetcherFM;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskGenerateDDL.DDLFetcherRO;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskGenerateDDL.DDLGenerator;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskGenerateDDL.DDLGeneratorDB2;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskGenerateDDL.DDLGeneratorSQLServer;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.ParameterMapBase;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.Section;
import com.ibm.cognos.fmeng.fmmd.model.TaskGenerateDDL;
import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmTaskGenerateDDL
implements TaskGenerateDDL {
    protected FMMDSession m_session;

    public static TaskGenerateDDL getInstance(FMMDSession session) {
        return new FmTaskGenerateDDL(session);
    }

    private FmTaskGenerateDDL(FMMDSession session) {
        this.m_session = session;
    }

    @Override
    public void generateDDL(String filepath, TaskGenerateDDL.DDLStyle style) {
        List<DataSource> dataSrcs = this.m_session.getProject().getDataSources();
        if (dataSrcs.size() == 0) {
            return;
        }
        ArrayList<QuerySubject> qsList = new ArrayList<QuerySubject>();
        this.getDbQuerySubjects(qsList, this.m_session.getProject().getRootNamespace());
        DDLFetcher fetcher = null;
        if (qsList.size() > 0) {
            fetcher = new DDLFetcherFM(qsList);
        } else {
            List<RelationalObject> roList = this.m_session.getProject().getRootNamespace().getAllRelationalObjects();
            for (ParameterMapBase pm : this.m_session.getProject().getParameterMaps()) {
                if (!(pm instanceof RelationalObject)) continue;
                roList.add((RelationalObject)((Object)pm));
            }
            if (roList.size() > 0) {
                fetcher = new DDLFetcherRO(roList);
            }
        }
        if (fetcher == null) {
            return;
        }
        DDLGenerator ddl = null;
        switch (style) {
            case db2: {
                ddl = new DDLGeneratorDB2();
                break;
            }
            case sqlserver: {
                ddl = new DDLGeneratorSQLServer();
            }
        }
        try {
            ddl.writeDDLFile(filepath, dataSrcs, fetcher);
        }
        catch (IOException e) {
            FmEngApplicationLog.getApplicationLog().logException(e);
        }
    }

    private void getDbQuerySubjects(List<QuerySubject> qsList, Section rootNamespace) {
        List<BaseObject> clist = rootNamespace.getChildObjects();
        for (BaseObject o : clist) {
            QuerySubject qs;
            if (o instanceof QuerySubject && (qs = (QuerySubject)o).getDBQuery() != null) {
                qsList.add(qs);
            }
            if (!(o instanceof Section)) continue;
            this.getDbQuerySubjects(qsList, (Section)o);
        }
    }
}

