/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasureDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmNamespace;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTaskDimensionBuilder;
import com.ibm.cognos.fmeng.fmmd.impl.model.autoDesigner.SmdHelper;
import com.ibm.cognos.fmeng.fmmd.model.Association;
import com.ibm.cognos.fmeng.fmmd.model.BuilderFactory;
import com.ibm.cognos.fmeng.fmmd.model.Cardinality;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.Join;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.Namespace;
import com.ibm.cognos.fmeng.fmmd.model.Project;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.Role;
import com.ibm.cognos.fmeng.fmmd.model.Section;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.fmmd.model.TaskCubeBuilder;
import com.ibm.cognos.fmeng.fmmd.model.TaskDimensionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.TaskGenerateStarSchema;
import com.ibm.cognos.fmeng.fmmd.util.FmTree;
import com.ibm.cognos.fmeng.fmmd.util.FmTreeNode;
import com.ibm.cognos.fmeng.fmmd.util.StringHelper;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdForeignKey;
import com.ibm.cognos.fmeng.metadata.MdSchema;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.platform.EventCallbackHandler;
import com.ibm.cognos.fmeng.utility.DataSourceQuery;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import com.ibm.cognos.fmeng.utility.FmPreferences;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmTaskGenerateStarSchema
implements TaskGenerateStarSchema {
    private boolean m_useSMD = false;
    private int m_precentageComplete = 0;

    protected FmTaskGenerateStarSchema(boolean useSMD) {
        this.m_useSMD = useSMD;
    }

    public static TaskGenerateStarSchema getInstance(boolean useSMD) {
        return new FmTaskGenerateStarSchema(useSMD);
    }

    @Override
    public Cube generateStarSchema(Namespace parentNS, String cubeName, MdTable mdFactTable) {
        return this.generateStarSchema(parentNS, cubeName, mdFactTable, new TaskGenerateStarSchema.Options());
    }

    @Override
    public Cube generateStarSchema(Namespace parentNS, String cubeName, MdTable mdFactTable, TaskGenerateStarSchema.Options opts) {
        EventCallbackHandler callback;
        List<MdForeignKey> fKeys = mdFactTable.getForeignKeys();
        if (fKeys.size() == 0 && (callback = parentNS.getSession().getEventCallbackHandler()) != null && !callback.doBooleanPrompt(new FmMessage("BMT_MD_FACT_TABLE_WITH_NO_FOREIGN_KEYS", mdFactTable.getName()))) {
            throw new FmMDException("BMT_MD_CANCELED");
        }
        List<MdColumn> factColumns = this.getFacts(mdFactTable);
        if (factColumns.size() == 0) {
            throw new FmMDException("BMT_MD_NO_FACT_COLUMNS", mdFactTable.getName());
        }
        Cube newCube = parentNS.createCube(cubeName);
        this.generateStarSchemaInternal(newCube, mdFactTable, factColumns, opts.mbGenerateDegenerateDimensions);
        return newCube;
    }

    @Override
    public List<Cube> generateStarSchema(Namespace parentNS, MdSchema mdSchema) {
        ArrayList<Cube> cubeCollection = new ArrayList<Cube>();
        for (MdTable aTable : mdSchema.getTables()) {
            Cube aCube;
            if (!this.isFactTable(aTable) || (aCube = this.generateStarSchema(parentNS, StringHelper.prettyPrint(aTable.getName()), aTable)) == null) continue;
            cubeCollection.add(aCube);
        }
        return cubeCollection;
    }

    private FmRelationalDimension generateDimensionUsingSMD(Namespace parentNS, MdTable mdTable) {
        EventCallbackHandler callback;
        FmRelationalDimension dim = FmTaskGenerateStarSchema.createRegularDimension(parentNS.getProject(), StringHelper.prettyPrint(mdTable.getName()));
        TaskDimensionBuilder dimBuilder = FmTaskDimensionBuilder.getInstance(dim);
        if (parentNS.getSession().getProgressCallbackHandler().isCancelRequested()) {
            throw new FmMDException("BMT_MD_CANCELED");
        }
        DataSourceQuery dsQuery = new DataSourceQuery();
        String filePath = String.valueOf(FmPreferences.getInstance().getDataDirectory()) + "/" + mdTable.getName() + ".csv";
        dsQuery.dumpTableDataToCSV(parentNS.getSession(), mdTable, filePath);
        SmdHelper smd = SmdHelper.getSmdHelper(parentNS.getSession());
        FmMessage progMess2 = new FmMessage("BMT_UIP_ANALYZING_TABLE", mdTable.getName());
        parentNS.getSession().getProgressCallbackHandler().setProgressStatus(this.m_precentageComplete, progMess2.render(parentNS.getSession().getActiveLocale()));
        if (parentNS.getSession().getProgressCallbackHandler().isCancelRequested()) {
            throw new FmMDException("BMT_MD_CANCELED");
        }
        smd.processData(filePath);
        List<SmdHelper.LevelCandidate> levelColumns = smd.getCandidateLevels();
        if (levelColumns.isEmpty() && (callback = parentNS.getSession().getEventCallbackHandler()) != null && !callback.doBooleanPrompt(new FmMessage("BMT_MD_NO_AUTO_HIERARCHY", mdTable.getName()))) {
            throw new FmMDException("BMT_MD_CANCELED");
        }
        String hierarchyName = "";
        if (levelColumns.size() > 0) {
            FmMessage hierarchyNameMess = new FmMessage("BMT_MDS_HIERARCHY_NAME", levelColumns.get((int)0).name);
            hierarchyName = hierarchyNameMess.render(parentNS.getSession().getActiveLocale());
        }
        FmRelationalHierarchy hierarchy = dim.createHierarchy(hierarchyName);
        hierarchy.setMultiRoot(false);
        for (SmdHelper.LevelCandidate lc : levelColumns) {
            Level level = dim.createLevel(lc.name);
            hierarchy.addLevel(level);
            boolean captionSet = false;
            for (SmdHelper.LevelCandidate.ColumnCandidate cc : lc.columns) {
                MdColumn col = mdTable.findColumn(cc.columnName);
                if (col == null) continue;
                QueryItem qi = dimBuilder.createQueryItemFromColumn(level, col);
                if (level.getLevelKeys().isEmpty() && cc.canBeIndentifier()) {
                    level.addLevelKey(qi);
                }
                if (captionSet) continue;
                if (cc.canBeCaption()) {
                    qi.addDefaultRole(Role.EDefaultRoles.kRoleMemberCaption);
                    captionSet = true;
                    continue;
                }
                if (!cc.isString() || !cc.canBeIndentifier()) continue;
                qi.addDefaultRole(Role.EDefaultRoles.kRoleMemberCaption);
            }
        }
        boolean debug = false;
        FmPreferences prefs = FmPreferences.getInstance();
        String prefValue = prefs.getFMPreference("AutoDesign", "dumpSMD");
        if (prefValue != null) {
            debug = prefValue.equalsIgnoreCase("true");
        }
        if (!debug) {
            File f = new File(filePath);
            f.delete();
        }
        return dim;
    }

    @Override
    public RelationalDimension generateDimension(Namespace parentNS, MdTable mdTable) {
        FmRelationalDimension dim = null;
        if (this.m_useSMD) {
            dim = this.generateDimensionUsingSMD(parentNS, mdTable);
        } else {
            FmMDException.ASSERT(true, "Not implemented");
        }
        return dim;
    }

    private void generateStarSchemaInternal(Cube parentCube, MdTable factTable, List<MdColumn> factColumns, boolean bGenerateDegenerateDimensions) {
        Namespace commonFolder = parentCube.getProject().getRootNamespace();
        FmMeasureDimension measureDim = FmTaskGenerateStarSchema.createMeasureDimension(parentCube, factTable, factColumns);
        FmTree<MdForeignKey> joinData = new FmTree<MdForeignKey>();
        FmTreeNode<Object> fakeRoot = joinData.addChild(null);
        FmTaskGenerateStarSchema.collectDimensionJoins(factTable, fakeRoot, true);
        float numDimensions = fakeRoot.getChildren().size();
        float numDimsProcessed = 0.0f;
        for (FmTreeNode<Object> factJoinData : fakeRoot.getChildren()) {
            if (parentCube.getSession().getProgressCallbackHandler().isCancelRequested()) {
                throw new FmMDException("BMT_MD_CANCELED");
            }
            this.m_precentageComplete = (int)((double)(numDimsProcessed / numDimensions) * 100.0);
            FmRelationalDimension regularDim = this.findOrCreateCommonDimension(parentCube, commonFolder, factJoinData, joinData, factTable);
            TaskCubeBuilder builder = parentCube.getSession().getTaskCubeBuilder();
            builder.addDimension(parentCube, regularDim);
            numDimsProcessed += 1.0f;
        }
        if (bGenerateDegenerateDimensions) {
            FmTaskGenerateStarSchema.createDegenerateDimensions(parentCube, measureDim, factTable, factColumns);
        }
    }

    private static FmMeasureDimension createMeasureDimension(Cube parentCube, MdTable factTable, List<MdColumn> factColumns) {
        FmMeasureDimension measureDim = (FmMeasureDimension)parentCube.createMeasureDimension(StringHelper.prettyPrint(factTable.getName()));
        Table measureTable = measureDim.findOrCreateTable(factTable);
        for (MdColumn mdColumn : factColumns) {
            FmMeasure measure = measureDim.createMeasureFromColumn(StringHelper.prettyPrint(mdColumn.getName()), mdColumn);
            measureDim.createQueryItemMapping((QueryItemBase)measure, mdColumn.getName(), measureTable);
        }
        return measureDim;
    }

    private boolean isFactTable(MdTable aTable) {
        boolean isFactTable = aTable.getReferringForeignKeys().size() == 0 && aTable.getForeignKeys().size() > 0 ? this.getFacts(aTable).size() > 0 : false;
        return isFactTable;
    }

    public FmRelationalDimension findOrCreateCommonDimension(Cube parentCube, Section commonFolder, FmTreeNode<MdForeignKey> protoDimension, FmTree<MdForeignKey> protoDimensions, MdTable factTable) {
        List<RelationalDimension> listCandidateDimensions = FmTaskGenerateStarSchema.findCommonDimensionCandidates(commonFolder, protoDimension);
        if (listCandidateDimensions.size() > 0) {
            if (FmTaskGenerateStarSchema.isRolePlayingDimension(protoDimension, protoDimensions, factTable)) {
                for (RelationalDimension candidate : listCandidateDimensions) {
                    if (parentCube.getReferencedDimensions().contains(candidate)) continue;
                    return (FmRelationalDimension)candidate;
                }
            } else {
                return (FmRelationalDimension)listCandidateDimensions.get(0);
            }
        }
        return this.buildDimension(parentCube.getProject(), protoDimension);
    }

    public static FmRelationalDimension createRegularDimension(Project project, String objectName) {
        FmNamespace common = (FmNamespace)FmTaskGenerateStarSchema.getCommonDimensionContainer(project);
        FmRelationalDimension qs = FmRelationalDimension.createRelationalDimension(project.getSession(), common, objectName, DimensionBase.DimensionStyle.regular);
        return qs;
    }

    public static Namespace getCommonDimensionContainer(Project project) {
        return project.getRootNamespace();
    }

    private static void getColumns(FmTreeNode<MdForeignKey> protoDimension, List<MdColumn> listColumns) {
        MdTable table = protoDimension.getData().getPrimaryTable();
        for (MdColumn mdColumn : table.getColumns()) {
            if (FmTaskGenerateStarSchema.isFKeyColumn(mdColumn)) continue;
            listColumns.add(mdColumn);
        }
        for (FmTreeNode fmTreeNode : protoDimension.getChildren()) {
            FmTaskGenerateStarSchema.getColumns(fmTreeNode, listColumns);
        }
    }

    private static void getColumns(RelationalDimensionBase dim, List<MdColumn> listColumns) {
        for (QueryItemMapping dimQueryItemMapping : dim.getQueryItemMappings()) {
            String sColumnName = dimQueryItemMapping.getColumnName();
            MdColumn column = dimQueryItemMapping.getTable().getPhysicalTable(true).findColumn(sColumnName);
            if (column == null || FmTaskGenerateStarSchema.isFKeyColumn(column)) continue;
            listColumns.add(column);
        }
    }

    private static boolean isDimensionUsingTable(RelationalDimensionBase dim, MdTable table) {
        List<Table> listDimTables = dim.getTables();
        for (Table dimTable : listDimTables) {
            if (!dimTable.getPhysicalTable(true).equals(table)) continue;
            return true;
        }
        return false;
    }

    public static List<RelationalDimension> findCommonDimensionCandidates(Section commonFolder, FmTreeNode<MdForeignKey> protoDimension) {
        ArrayList<MdColumn> listProtoColumns = null;
        MdTable table = protoDimension.getData().getPrimaryTable();
        ArrayList<RelationalDimension> listCandidates = new ArrayList<RelationalDimension>();
        for (RelationalDimensionBase dim : commonFolder.getRelationalDimensions()) {
            if (!FmTaskGenerateStarSchema.isDimensionUsingTable(dim, table)) continue;
            if (listProtoColumns == null) {
                listProtoColumns = new ArrayList<MdColumn>();
                FmTaskGenerateStarSchema.getColumns(protoDimension, listProtoColumns);
            }
            ArrayList<MdColumn> listDimColumns = new ArrayList<MdColumn>();
            FmTaskGenerateStarSchema.getColumns(dim, listDimColumns);
            if (!listDimColumns.containsAll(listProtoColumns) || !listProtoColumns.containsAll(listDimColumns)) continue;
            listCandidates.add((RelationalDimension)dim);
        }
        return listCandidates;
    }

    private List<MdColumn> getFacts(MdTable factTable) {
        ArrayList<MdColumn> factColumns = new ArrayList<MdColumn>();
        for (MdColumn mdColumn : factTable.getColumns()) {
            if (mdColumn.isKey() || !FmDatatype.isNumeric(mdColumn.getDatatype()).booleanValue()) continue;
            factColumns.add(mdColumn);
        }
        return factColumns;
    }

    private static void createDegenerateDimensions(Cube parentCube, FmMeasureDimension measureDim, MdTable factTable, List<MdColumn> factColumns) {
        List<MdColumn> columns = factTable.getColumns();
        columns.removeAll(factColumns);
        for (MdForeignKey aFKey : factTable.getForeignKeys()) {
            columns.removeAll(aFKey.getColumns());
        }
        for (MdColumn degenColumn : columns) {
            FmRelationalDimension degenDim = FmTaskGenerateStarSchema.createRegularDimension(parentCube.getProject(), degenColumn.getName());
            DataSource ds = degenDim.getProject().findOrCreateDataSource(factTable);
            Table aTable = degenDim.createTable(ds, factTable.getName());
            FmRelationalHierarchy degenHierarchy = degenDim.createHierarchy(degenColumn.getName());
            Level degenLevel = degenDim.createLevel(degenColumn.getName());
            degenHierarchy.addLevel(degenLevel);
            FmTaskGenerateStarSchema.findOrCreateQueryItemAndMapping(degenDim, aTable, degenLevel, degenColumn);
            ExpressionBuilder expression = BuilderFactory.createExpressionBuilder();
            expression.addExpressionPart(ds, degenColumn.getName(), aTable.getName(), degenDim, null);
            expression.addExpressionPart("=", null);
            expression.addExpressionPart(ds, degenColumn.getName(), degenColumn.getTable().getName(), measureDim, null);
            parentCube.createRelationship(degenColumn.getName(), expression, degenDim, measureDim);
        }
    }

    private FmRelationalDimension buildDimension(Project project, FmTreeNode<MdForeignKey> protoDimension) {
        FmRelationalDimension dim = null;
        MdTable primaryTable = protoDimension.getData().getPrimaryTable();
        FmMessage progMess1 = new FmMessage("BMT_UIP_SAMPLING_TABLE", primaryTable.getName());
        project.getSession().getProgressCallbackHandler().setProgressStatus(this.m_precentageComplete, progMess1.render(project.getSession().getActiveLocale()));
        if (!protoDimension.hasChildren() && this.m_useSMD) {
            FmNamespace commonNS = (FmNamespace)FmTaskGenerateStarSchema.getCommonDimensionContainer(project);
            dim = this.generateDimensionUsingSMD(commonNS, primaryTable);
        } else {
            dim = FmTaskGenerateStarSchema.createRegularDimension(project, StringHelper.prettyPrint(primaryTable.getName()));
            ArrayList<FmTreeNode<MdForeignKey>> protoHierarchies = new ArrayList<FmTreeNode<MdForeignKey>>();
            this.addTable(dim, protoDimension, protoHierarchies);
            FmMDException.ASSERT(protoHierarchies.size() >= 1, "We have hierarchies, right?");
            List<Level> levels = dim.getAllLevels();
            FmMDException.ASSERT(levels.size() >= 1, "We have levels, right?");
            for (FmTreeNode fmTreeNode : protoHierarchies) {
                String hierName = StringHelper.prettyPrint(((MdForeignKey)fmTreeNode.getData()).getPrimaryTable().getName());
                FmRelationalHierarchy hierarchy = dim.createHierarchy(hierName);
                String allLevelName = FmMessage.render("BMT_MDS_OLAP_ALL_LEVEL_NAME", dim.getSession().getActiveLocale(), hierName);
                hierarchy.setMultiRoot(false);
                hierarchy.getAllLevel().setName(dim.getProject().getDefaultLocale(), allLevelName);
                FmTreeNode parent = fmTreeNode;
                while (parent.getData() != null) {
                    String levelName = StringHelper.prettyPrint(((MdForeignKey)parent.getData()).getPrimaryTable().getName());
                    for (Level level : levels) {
                        if (!level.getName().equals(levelName)) continue;
                        hierarchy.addLevel(level);
                        break;
                    }
                    parent = parent.getParent();
                }
            }
        }
        return dim;
    }

    private static boolean isRolePlayingDimension(FmTreeNode<MdForeignKey> aNode, FmTree<MdForeignKey> protoDimensions, MdTable factTable) {
        MdForeignKey theFKey = aNode.getData();
        String theFKeyTableName = theFKey.getTable().getName();
        String thePKeyTableName = theFKey.getPrimaryTable().getName();
        if (!theFKeyTableName.equals(factTable.getName())) {
            return false;
        }
        for (FmTreeNode<MdForeignKey> aProtoDimension : protoDimensions.getLeafNodes()) {
            if (aNode == aProtoDimension) continue;
            MdForeignKey aFKey = aProtoDimension.getData();
            String aFKeyTableName = aFKey.getTable().getName();
            String aPKeyTableName = aFKey.getPrimaryTable().getName();
            if (!aPKeyTableName.equals(thePKeyTableName) || !aFKeyTableName.equals(factTable.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isFKeyColumn(MdColumn column) {
        MdTable primaryTable = column.getTable();
        for (MdForeignKey fkey : primaryTable.getForeignKeys()) {
            if (!fkey.getColumns().contains(column)) continue;
            return true;
        }
        return false;
    }

    private Table addTable(RelationalDimension dim, FmTreeNode<MdForeignKey> protoLevel, List<FmTreeNode<MdForeignKey>> protoHierarchies) {
        MdForeignKey mdFKey = protoLevel.getData();
        Table table = dim.findOrCreateTable(mdFKey.getPrimaryTable());
        Level aLevel = FmTaskGenerateStarSchema.findOrCreateLevel(dim, mdFKey.getPrimaryTable());
        for (MdColumn mdColumn : mdFKey.getPrimaryTable().getColumns()) {
            if (FmTaskGenerateStarSchema.isFKeyColumn(mdColumn) || FmDatatype.isUnsupportedByROLAP(mdColumn.getDatatype()).booleanValue()) continue;
            FmTaskGenerateStarSchema.findOrCreateQueryItemAndMapping(dim, table, aLevel, mdColumn);
        }
        if (protoLevel.getChildren().size() == 0) {
            protoHierarchies.add(protoLevel);
        } else {
            for (FmTreeNode fmTreeNode : protoLevel.getChildren()) {
                Table childTable = this.addTable(dim, fmTreeNode, protoHierarchies);
                Join aJoin = dim.createJoin(mdFKey.getName(), table, childTable);
                aJoin.setLeftMincard(Cardinality.ECardinality.one);
                aJoin.setLeftMaxcard(Cardinality.ECardinality.many);
                aJoin.setRightMincard(Cardinality.ECardinality.one);
                aJoin.setRightMaxcard(Cardinality.ECardinality.one);
                int keys = mdFKey.getColumns().size();
                List<MdColumn> fColumns = ((MdForeignKey)fmTreeNode.getData()).getColumns();
                List<MdColumn> pColumns = ((MdForeignKey)fmTreeNode.getData()).getPrimaryTable().getPrimaryKey().getColumns();
                int i = 0;
                while (i < keys) {
                    if (fColumns.size() > i && pColumns.size() > i) {
                        MdColumn fKeyColumn = fColumns.get(i);
                        MdColumn pKeyColumn = pColumns.get(i);
                        aJoin.createAssociation(fKeyColumn.getName(), pKeyColumn.getName(), Association.EOperator.equals);
                    }
                    ++i;
                }
            }
        }
        return table;
    }

    public static QueryItem findOrCreateQueryItemAndMapping(RelationalDimension dim, Table someTable, Level someLevel, MdColumn column) {
        List<MdColumn> pkeyColumns;
        QueryItem item = dim.findQueryItem(column);
        if (item != null) {
            return item;
        }
        item = someLevel.createQueryItemFromColumn(StringHelper.prettyPrint(column.getName()), column);
        dim.createQueryItemMapping(item, column.getName(), someTable);
        MdTable table = someTable.getPhysicalTable(true);
        if (table.getPrimaryKey() != null && (pkeyColumns = someTable.getPhysicalTable(true).getPrimaryKey().getColumns()).size() > 0 && pkeyColumns.contains(column)) {
            someLevel.addLevelKey(item);
        }
        return item;
    }

    private static Level findOrCreateLevel(RelationalDimension dim, MdTable primaryTable) {
        List<Level> listLevels = dim.getAllLevels();
        String levelName = StringHelper.prettyPrint(primaryTable.getName());
        for (Level aLevel : listLevels) {
            if (!levelName.equals(aLevel.getName())) continue;
            return aLevel;
        }
        return dim.createLevel(levelName);
    }

    private static void collectDimensionJoins(MdTable table, FmTreeNode<MdForeignKey> parent, boolean bRecursive) {
        for (MdForeignKey fKey : table.getForeignKeys()) {
            MdTable primaryTable;
            boolean oldJoinFound = false;
            FmTreeNode<MdForeignKey> prev = parent;
            while (prev != null) {
                MdForeignKey prevKey = prev.getData();
                if (prevKey != null) {
                    MdTable fkPrimaryTable = fKey.getPrimaryTable();
                    MdTable prevPrimaryTable = prev.getData().getPrimaryTable();
                    if (fkPrimaryTable != null && prevPrimaryTable != null && fkPrimaryTable.equals(prevPrimaryTable)) {
                        oldJoinFound = true;
                        break;
                    }
                }
                prev = prev.getParent();
            }
            if (oldJoinFound) continue;
            FmTreeNode<MdForeignKey> child = parent.addChild(fKey);
            if (!bRecursive || (primaryTable = fKey.getPrimaryTable()) == null) continue;
            FmTaskGenerateStarSchema.collectDimensionJoins(primaryTable, child, bRecursive);
        }
    }
}

