/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmParameterMap;
import com.ibm.cognos.fmeng.fmmd.model.ParameterMap;
import com.ibm.cognos.fmeng.fmmd.model.ParameterMapEntry;
import com.ibm.cognos.fmeng.fmmd.model.TaskParameterMapImportExport;
import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class FmTaskParameterMapImportExport
implements TaskParameterMapImportExport {
    private FMMDSession m_session;

    private FmTaskParameterMapImportExport(FMMDSession session) {
        this.m_session = session;
    }

    public static FmTaskParameterMapImportExport getInstance(FMMDSession session) {
        return new FmTaskParameterMapImportExport(session);
    }

    public void exportParameterMap(ParameterMap map, String filePath, ExportType type) {
        if (!map.isManual()) {
            return;
        }
        try {
            File out = new File(filePath);
            OutputStreamWriter writer = null;
            BufferedWriter bw = null;
            switch (type) {
                case csv: {
                    writer = new OutputStreamWriter(new FileOutputStream(out));
                    bw = new BufferedWriter(writer);
                    this.exportParameterMapCSV(map, bw);
                    break;
                }
                case txt: {
                    writer = new OutputStreamWriter((OutputStream)new FileOutputStream(out), "UTF-16");
                    bw = new BufferedWriter(writer);
                    this.exportParameterMapTXT(map, bw);
                }
            }
            bw.close();
            writer.close();
        }
        catch (FileNotFoundException e) {
            FmEngApplicationLog.getApplicationLog().logException(e);
        }
        catch (IOException e) {
            FmEngApplicationLog.getApplicationLog().logException(e);
        }
    }

    private void exportParameterMapCSV(ParameterMap map, BufferedWriter bw) throws IOException {
        for (ParameterMapEntry entry : map.getParameterMapEntries()) {
            if (entry.getKey().contains(",")) {
                bw.write(34);
                bw.write(entry.getKey());
                bw.write(34);
            } else {
                bw.write(entry.getKey());
            }
            if (entry.getValue() != null) {
                bw.write(44);
                if (entry.getValue().contains(",")) {
                    bw.write(34);
                    bw.write(entry.getValue());
                    bw.write(34);
                } else {
                    bw.write(entry.getValue());
                }
            }
            bw.newLine();
        }
    }

    private void exportParameterMapTXT(ParameterMap map, BufferedWriter bw) throws IOException {
        for (ParameterMapEntry entry : map.getParameterMapEntries()) {
            bw.write(entry.getKey());
            bw.write(9);
            bw.write(entry.getValue());
            bw.newLine();
        }
    }

    public ParameterMap importParameterMap(String filePath) {
        ParameterMap pMap = this.m_session.getProject().createParameterMap(FmParameterMap.getDefaultName(this.m_session.getActiveLocale()), true);
        this.importParameterMap(pMap, filePath);
        return pMap;
    }

    public ParameterMap importParameterMap(String newMapName, String filePath) {
        ParameterMap pMap = this.m_session.getProject().createParameterMap(newMapName, true);
        this.importParameterMap(pMap, filePath);
        return pMap;
    }

    public void importParameterMap(ParameterMap map, String filePath) {
        map.clearMap();
        String ext = filePath.toUpperCase();
        if (ext.endsWith("CSV")) {
            this.importParameterMapCSV(map, filePath);
        } else if (ext.endsWith("TXT")) {
            this.importParameterMapTXT(map, filePath);
        }
    }

    private void importParameterMapTXT(ParameterMap map, String filePath) {
        try {
            File out = new File(filePath);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(out), "UTF-16"));
            String line = null;
            while ((line = br.readLine()) != null) {
                String[] entries = line.split("\t", 2);
                if (entries == null || entries[0] == null) continue;
                if (entries.length == 2) {
                    map.addEntry(entries[0], entries[1]);
                    continue;
                }
                if (entries.length != 1) continue;
                map.addEntry(entries[0], null);
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            FmEngApplicationLog.getApplicationLog().logException(e);
        }
        catch (IOException e) {
            FmEngApplicationLog.getApplicationLog().logException(e);
        }
    }

    private void importParameterMapCSV(ParameterMap map, String filePath) {
        try {
            File out = new File(filePath);
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(out)));
            CSVParser parser = new CSVParser((Reader)br);
            for (CSVRecord record : parser) {
                if (record == null) continue;
                if (record.size() >= 2) {
                    map.addEntry(record.get(0), record.get(1));
                    continue;
                }
                if (record.size() != 1) continue;
                map.addEntry(record.get(0), null);
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            FmEngApplicationLog.getApplicationLog().logException(e);
        }
        catch (IOException e) {
            FmEngApplicationLog.getApplicationLog().logException(e);
        }
    }

    public void exportParameterMap(ParameterMap map, String filePath) {
        if (filePath.endsWith(".csv")) {
            this.exportParameterMap(map, filePath, ExportType.csv);
        } else {
            this.exportParameterMap(map, filePath, ExportType.txt);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ExportType {
        csv,
        txt;

    }
}

