/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmPackage;
import com.ibm.cognos.fmeng.fmmd.impl.task.ModelPublisher;
import com.ibm.cognos.fmeng.fmmd.model.CubeBase;
import com.ibm.cognos.fmeng.fmmd.model.Package;
import com.ibm.cognos.fmeng.fmmd.model.PackageBase;
import com.ibm.cognos.fmeng.fmmd.model.PseudoPackage;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.TaskExportToCognosROLAP;
import com.ibm.cognos.fmeng.fmmd.model.TaskPublisher;
import com.ibm.cognos.fmeng.fmmd.model.VirtualCube;
import com.ibm.cognos.fmeng.fmmd.util.CmHelper;
import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.ProjectFactory;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FmTaskPublisher
implements TaskPublisher {
    private FMMDSession m_session;

    public static TaskPublisher getInstance(FMMDSession session) {
        return new FmTaskPublisher(session);
    }

    private FmTaskPublisher(FMMDSession session) {
        this.m_session = session;
    }

    public String publish(String filePath, ReportObject obj, Long deploymentOptions, String packageName, String packagePath) {
        return this.publish(filePath, obj, deploymentOptions, packageName, packagePath, true);
    }

    public String publish(String filePath, ReportObject obj, Long deploymentOptions, String packageName, String packagePath, boolean oldFilePath) {
        String results = "";
        TaskExportToCognosROLAP exportCubing = this.m_session.getTaskExportToCognosROLAP();
        if (filePath == null) {
            CmHelper cmHelper = CmHelper.get(this.m_session, this.m_session.getPassport());
            cmHelper.validatePassport();
        }
        if (filePath != null && oldFilePath) {
            if (!"nullnull".equals(filePath)) {
                File crFile = new File(filePath);
                String directory = crFile.getParent();
                if (directory == null) {
                    directory = ".";
                } else {
                    File parentPath = new File(directory);
                    parentPath.mkdirs();
                }
                try {
                    exportCubing.exportToCognosROLAP(directory, false, null);
                }
                catch (IOException e) {
                    FmEngApplicationLog.getApplicationLog().logException(e);
                }
            }
        } else if (obj != null) {
            List<Object> dataSourcePathList = new ArrayList();
            PackageBase kPackage = null;
            if (obj instanceof FmPackage) {
                kPackage = (FmPackage)obj;
            } else if (obj instanceof CubeBase) {
                kPackage = new PseudoPackage((CubeBase)obj, packageName, packagePath);
            } else {
                FmMDException.ASSERT(false, "Unexpected package object: " + obj.toString());
            }
            if (filePath == null && (kPackage.getPublishLocationCMPath() == null || "".equals(kPackage.getPublishLocationCMPath()))) {
                throw new FmMDException("BMT_MD_NO_CONTENT_MANAGER_PATH");
            }
            boolean isPublish = false;
            isPublish = 0L < (deploymentOptions & 8L);
            exportCubing.checkPackageSanity(kPackage, null, isPublish);
            if (0L < (deploymentOptions & 1L)) {
                if (filePath != null) {
                    String dataSources = String.valueOf(filePath) + "dataSources" + File.separator;
                    File parentPath = new File(dataSources);
                    parentPath.mkdirs();
                    try {
                        exportCubing.exportToCognosROLAP(kPackage, dataSources, false, null);
                    }
                    catch (IOException e) {
                        FmEngApplicationLog.getApplicationLog().logException(e);
                    }
                } else {
                    dataSourcePathList = exportCubing.exportToCognosROLAP(kPackage);
                }
                results = FmMessage.render("BMT_UIR_PUBLISH_SUCCESS", this.m_session.getActiveLocale());
            }
            if (obj instanceof CubeBase && filePath == null) {
                CubeBase cube = (CubeBase)obj;
                String dataSourcePath = (String)dataSourcePathList.get(0);
                if (0L < (deploymentOptions & 0x10L)) {
                    exportCubing.associateAccountWithRolapDataSource(dataSourcePath, cube instanceof VirtualCube);
                    results = FmMessage.render("BMT_UIR_PUBLISH_ASSOCATION_SUCCESS", this.m_session.getActiveLocale());
                }
                if (0L < (deploymentOptions & 2L)) {
                    exportCubing.registerCubeWithDefaultQueryService(cube.getName(), cube instanceof VirtualCube);
                    results = FmMessage.render("BMT_UIR_PUBLISH_REGISTER_SUCCESS", this.m_session.getActiveLocale());
                }
            }
            if (0L < (deploymentOptions & 8L)) {
                FMMDSession tempNewModelSession = FMMDSession.createFMMDSession(this.m_session);
                if (filePath == null) {
                    tempNewModelSession.create(ProjectFactory.createInMemoryProject());
                } else {
                    String packages = String.valueOf(filePath) + "packages" + File.separator;
                    File parentPath = new File(packages);
                    parentPath.mkdirs();
                    tempNewModelSession.create(ProjectFactory.createFileProject(String.valueOf(packages) + File.separator + kPackage.getName() + ".xml", null));
                }
                this.m_session.getTaskROLAPtoDMR().convertFromPackage(kPackage, tempNewModelSession);
                if (filePath == null) {
                    ModelPublisher publisher = new ModelPublisher(tempNewModelSession);
                    tempNewModelSession.setEventCallbackHandler(this.m_session.getEventCallbackHandler());
                    publisher.publishModelToCM(kPackage.getPublishLocationCMPath(), kPackage.getName(), "model", obj);
                    tempNewModelSession.setEventCallbackHandler(null);
                } else {
                    try {
                        tempNewModelSession.save();
                    }
                    catch (IOException e) {
                        FmEngApplicationLog.getApplicationLog().logException(e);
                    }
                }
                results = FmMessage.render("BMT_UIR_PUBLISH_PACKAGE_PUBLISHED", this.m_session.getActiveLocale());
                tempNewModelSession.destroy();
            }
            if (obj instanceof CubeBase && filePath == null && 0L < (deploymentOptions & 4L)) {
                results = exportCubing.startCubeOnServer(obj.getName());
            }
        }
        return results;
    }

    public void publish(String dir) {
        if (!dir.endsWith("\\") && !dir.endsWith("/")) {
            dir = String.valueOf(dir) + File.separator;
        }
        long deploymentOptions = 9L;
        for (ReportObject reportObject : this.m_session.getProject().getRootNamespace().getAllCubes()) {
            this.publish(dir, reportObject, deploymentOptions, reportObject.getName(), null, false);
        }
        for (Package package_ : this.m_session.getProject().getPackages()) {
            this.publish(dir, package_, deploymentOptions, null, null, false);
        }
    }
}

