/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmGovernorWithBooleanValue;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmGovernorWithIntValue;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmGovernorWithListValue;
import com.ibm.cognos.fmeng.fmmd.model.GovernorBase;
import com.ibm.cognos.fmeng.fmmd.model.TaskReadGovernorsDefinition;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmTaskReadGovernorsDefinition
implements TaskReadGovernorsDefinition {
    private List<GovernorBase> m_governors = null;
    private List<String> m_governorKeys = null;
    private Map<String, GovernorBase> m_keyToGovernorMap = null;
    private static FmTaskReadGovernorsDefinition m_ftrgd = null;
    private static String m_governorsDialogPath = ".." + File.separator + "templates" + File.separator + "bmt" + File.separator + "Cr1Model" + File.separator + "html" + File.separator + "governorsDialog.xml";
    DefaultHandler handler = new DefaultHandler(){
        private String key;
        private String value;
        private String type;
        private String id;
        private String label;
        private String maxValue;
        private String defaultValue;
        private String defaultListItemKey;
        private String queryMode;
        private int defaultValueInt;
        private int maxValueInt;
        private boolean defaultValueBoolean;
        private boolean governorApplies;
        private Map<String, String> values;
        private List<String> keys;
        private GovernorBase governor;
        private StringBuffer cdata;

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.cdata = new StringBuffer();
            AttributesImpl impl = new AttributesImpl();
            impl.setAttributes(attributes);
            if (qName.equalsIgnoreCase("property")) {
                this.queryMode = attributes.getValue("queryMode");
                boolean bl = this.governorApplies = this.queryMode.equalsIgnoreCase("all") || this.queryMode.equalsIgnoreCase("dqm");
                if (this.governorApplies) {
                    String defaultValue;
                    this.defaultListItemKey = "";
                    this.values = new HashMap<String, String>();
                    this.keys = new ArrayList<String>();
                    this.id = attributes.getValue("id");
                    this.type = attributes.getValue("type");
                    if (this.type.equalsIgnoreCase("uint")) {
                        this.defaultValue = attributes.getValue("default");
                        this.defaultValueInt = Integer.parseInt(this.defaultValue);
                        this.maxValue = attributes.getValue("maxValue");
                        if (this.maxValue != null) {
                            this.maxValueInt = Integer.parseInt(this.maxValue);
                            if (this.defaultValueInt > this.maxValueInt) {
                                throw new FmMDException("BMT_MD_GOVERNOR_MAX_VALUE_EXCEEDED", this.id, String.valueOf(this.maxValue));
                            }
                        } else {
                            this.maxValueInt = -1;
                        }
                    } else if (this.type.equalsIgnoreCase("checkbox") && (defaultValue = attributes.getValue("default")) != null) {
                        this.defaultValueBoolean = Boolean.parseBoolean(defaultValue);
                    }
                }
            } else if (qName.equalsIgnoreCase("listItem") && this.governorApplies) {
                this.key = attributes.getValue("id");
                this.defaultValue = attributes.getValue("default");
                if (this.defaultValue != null && this.defaultValue.equalsIgnoreCase("true")) {
                    this.defaultListItemKey = this.key;
                }
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if (this.governorApplies) {
                if (qName.equalsIgnoreCase("label")) {
                    this.label = this.cdata.toString().trim();
                } else if (qName.equalsIgnoreCase("listItem")) {
                    if (!this.key.equalsIgnoreCase("")) {
                        this.value = this.cdata.toString().trim();
                        this.values.put(this.key, this.value);
                        this.keys.add(this.key);
                    }
                } else if (qName.equalsIgnoreCase("property")) {
                    if (this.type.equalsIgnoreCase("uint")) {
                        this.governor = new FmGovernorWithIntValue(this.id, this.label, this.defaultValueInt, this.defaultValueInt, this.maxValueInt);
                    } else if (this.type.equalsIgnoreCase("list")) {
                        this.governor = new FmGovernorWithListValue(this.id, this.label, this.defaultListItemKey, this.values, this.keys);
                    } else if (this.type.equalsIgnoreCase("checkBox")) {
                        this.governor = new FmGovernorWithBooleanValue(this.id, this.label, this.defaultValueBoolean, this.defaultValueBoolean);
                    }
                    if (this.governor != null) {
                        FmTaskReadGovernorsDefinition.this.m_governors.add(this.governor);
                        FmTaskReadGovernorsDefinition.this.m_governorKeys.add(this.id);
                        FmTaskReadGovernorsDefinition.this.m_keyToGovernorMap.put(this.id, this.governor);
                    }
                }
            }
        }

        public void characters(char[] buffer, int start, int length) {
            if (this.governorApplies) {
                this.cdata.append(buffer, start, length);
            }
        }
    };

    private FmTaskReadGovernorsDefinition() {
    }

    public static FmTaskReadGovernorsDefinition getInstance() {
        if (m_ftrgd == null) {
            m_ftrgd = new FmTaskReadGovernorsDefinition();
        }
        return m_ftrgd;
    }

    public void setGovernorsDirectory(String path) {
        m_governorsDialogPath = path;
    }

    @Override
    public List<GovernorBase> getListOfGovernors() {
        if (this.m_governors == null) {
            this.readGovernorsXmlFile();
        }
        return this.m_governors;
    }

    @Override
    public List<String> getGovernorIds() {
        if (this.m_governorKeys == null) {
            this.readGovernorsXmlFile();
        }
        return this.m_governorKeys;
    }

    @Override
    public Map<String, GovernorBase> getKeyToGovernorMap() {
        if (this.m_keyToGovernorMap == null) {
            this.readGovernorsXmlFile();
        }
        return this.m_keyToGovernorMap;
    }

    private void readGovernorsXmlFile() {
        this.m_governors = new ArrayList<GovernorBase>();
        this.m_governorKeys = new ArrayList<String>();
        this.m_keyToGovernorMap = new HashMap<String, GovernorBase>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(m_governorsDialogPath, this.handler);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }
}

