/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmProxyDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationship;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualDimensionBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.RemoveListener;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.SourceObject;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.fmmd.model.VirtualDimension;
import com.ibm.cognos.fmeng.fmmd.model.VirtualHierarchy;
import com.ibm.cognos.fmeng.genmodel.CardinalityType;
import com.ibm.cognos.fmeng.genmodel.DimensionStyleType;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.VirtualDimensionType;
import com.ibm.cognos.fmeng.genmodel.VirtualHierarchyType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmVirtualDimension
extends FmVirtualDimensionBase
implements VirtualDimension {
    public static FmVirtualDimension createVirtualDimension(FMMDSession session, FmVirtualCube parent, String name, DimensionBase.DimensionStyle style) {
        if (name == null || name.length() == 0) {
            name = FmVirtualDimension.getDefaultName(session.getActiveLocale());
        }
        VirtualDimensionType vDimType = GenmodelFactory.eINSTANCE.createVirtualDimensionType();
        FmVirtualDimension.createVirtualObject(vDimType);
        FmVirtualDimension vDim = new FmVirtualDimension(session, vDimType);
        parent.addVirtualDimension(vDim);
        vDim.setName(session.getProject().getDefaultLocale(), vDim.makeUniqueName(name));
        vDim.setDimensionStyle(style);
        return vDim;
    }

    @Override
    public void setDimensionStyle(DimensionBase.DimensionStyle style) {
        switch (style) {
            case regular: {
                this.getVirtualDimensionType().setDimensionStyle(DimensionStyleType.REGULAR);
                return;
            }
            case time: {
                this.getVirtualDimensionType().setDimensionStyle(DimensionStyleType.TIME);
                return;
            }
        }
        FmMDException.ASSERT(false, "Invalid dimension style: " + style.toString());
    }

    public static FmVirtualDimension get(FMMDSession session, Object emfObject) {
        return new FmVirtualDimension(session, emfObject);
    }

    private FmVirtualDimension(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    @Override
    public FmObjectType getFmObjectType() {
        return FmObjectType.virtualDimension;
    }

    public static String getDefaultName(Locale locale) {
        return FmMessage.render("BMT_MDN_OBJECT_NAME_VIRTUAL_DIMENSION", locale);
    }

    public VirtualDimensionType getVirtualDimensionType() {
        return (VirtualDimensionType)this.m_emfObject;
    }

    @Override
    public DimensionBase.DimensionStyle getDimensionStyle() {
        if (this.getVirtualDimensionType().getDimensionStyle() == DimensionStyleType.TIME) {
            return DimensionBase.DimensionStyle.time;
        }
        return DimensionBase.DimensionStyle.regular;
    }

    @Override
    void addChild(Object eObj) {
        switch (this.m_session.getGateway().getClassifierType(eObj)) {
            case 174: {
                this.addVirtualHierarchy((VirtualHierarchyType)eObj);
                break;
            }
            default: {
                super.addChild(eObj);
            }
        }
    }

    private void addVirtualHierarchy(VirtualHierarchyType eObj) {
        this.getVirtualDimensionType().getVirtualHierarchy().add((Object)eObj);
        EList<VirtualHierarchyType> hiers = this.getVirtualDimensionType().getVirtualHierarchy();
        if (hiers.size() == 1) {
            this.getVirtualDimensionType().setDefaultHierarchy(eObj);
        }
    }

    public void addVirtualHierarchy(VirtualHierarchy vHier) {
        this.addVirtualHierarchy((VirtualHierarchyType)vHier.getInternal());
    }

    @Override
    public VirtualHierarchy createHierarchy(String name) {
        EList<VirtualHierarchyType> hiers = this.getVirtualDimensionType().getVirtualHierarchy();
        if (hiers.size() == 1 && ((VirtualHierarchyType)hiers.get(0)).isParentChild()) {
            throw new FmMDException("BMT_MD_NO_CREATE_LEVEL_HIER");
        }
        return FmVirtualHierarchy.createVirtualHierarchy(this.m_session, this, name, false);
    }

    @Override
    public VirtualHierarchy createParentChildHierarchy(String name) {
        if (this.getVirtualDimensionType().getVirtualHierarchy().size() > 0) {
            throw new FmMDException("BMT_MD_NO_CREATE_PARENT_CHILD_HIER");
        }
        return FmVirtualHierarchy.createVirtualHierarchy(this.m_session, this, name, true);
    }

    @Override
    public VirtualHierarchy getDefaultHierarchy() {
        EObject vHier = this.getVirtualDimensionType().getDefaultHierarchy();
        if (vHier != null) {
            return FmVirtualHierarchy.get(this.m_session, vHier);
        }
        return null;
    }

    @Override
    public List<VirtualHierarchy> getHierarchies() {
        ArrayList<VirtualHierarchy> vHiers = new ArrayList<VirtualHierarchy>();
        for (EObject vHier : this.getVirtualDimensionType().getVirtualHierarchy()) {
            vHiers.add(FmVirtualHierarchy.get(this.m_session, vHier));
        }
        return vHiers;
    }

    @Override
    public void setDefaultHierarchy(VirtualHierarchy hierarchy) {
        if (hierarchy != null) {
            EObject hier = (EObject)hierarchy.getInternal();
            if (hier.eContainer().equals(this.m_emfObject)) {
                this.getVirtualDimensionType().setDefaultHierarchy(hier);
            }
            return;
        }
        this.getVirtualDimensionType().setDefaultHierarchy(null);
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public boolean getParentChild() {
        return this.getVirtualDimensionType().getVirtualHierarchy().size() == 1 && ((VirtualHierarchyType)this.getVirtualDimensionType().getVirtualHierarchy().get(0)).isParentChild();
    }

    @Override
    public void prepareForObjectDeletion(RemoveInfo info, FmBaseObject object, RemoveListener listener) {
        VirtualHierarchy hDefault;
        super.prepareForObjectDeletion(info, object, listener);
        if (object instanceof FmRelationship) {
            CardinalityType left = ((FmRelationship)object).getRelationshipType().getLeft();
            for (SourceObject s : this.getSourceObjects()) {
                if (s.getModelSource() == null || left.getRefobj() == null || !left.getRefobj().equals(s.getModelSource().getInternal()) || s.getSourceParent() == null || !object.getParent().getName().equals(s.getSourceParent().getName())) continue;
                this.getSession().delete(s);
            }
            CardinalityType right = ((FmRelationship)object).getRelationshipType().getRight();
            for (SourceObject s : this.getSourceObjects()) {
                if (s.getModelSource() == null || right.getRefobj() == null || !right.getRefobj().equals(s.getModelSource().getInternal()) || s.getSourceParent() == null || !object.getParent().getName().equals(s.getSourceParent().getName())) continue;
                this.getSession().delete(s);
            }
        }
        if (object instanceof FmVirtualHierarchy && (hDefault = this.getDefaultHierarchy()) != null && hDefault.equals(object)) {
            for (VirtualHierarchy h : this.getHierarchies()) {
                if (h.equals(hDefault)) continue;
                this.setDefaultHierarchy(h);
                break;
            }
        }
    }

    @Override
    public List<FmProxyDimension> getProxyDimensions() {
        List<FmProxyDimension> proxyDims = FmProxyDimension.collectDimensions(this);
        return proxyDims;
    }

    @Override
    public boolean isSameAsBaseObjects() {
        boolean ret = this.doNamesMatchWithSourceObjects();
        if (ret) {
            List<VirtualHierarchy> hierarchies = this.getHierarchies();
            for (VirtualHierarchy h : hierarchies) {
                ret &= ((FmVirtualObject)((Object)h)).isSameAsBaseObjects();
                ret &= h.getVirtualMembers().size() == 0;
            }
        }
        return ret;
    }

    @Override
    public boolean leverageSharedMemberCache() {
        boolean ret = this.isSharingEnabledOnBaseDimensions();
        if (ret) {
            List<SourceObject> srcObjs = this.getSourceObjects();
            for (SourceObject obj : srcObjs) {
                ret &= obj.getModelSource() != null;
            }
        }
        if (ret) {
            ret = this.isSameAsBaseObjects();
        }
        return ret;
    }

    @Override
    public boolean isSharingEnabledOnBaseDimensions() {
        boolean sharingEnabled = true;
        List<SourceObject> srcObjs = this.getSourceObjects();
        for (SourceObject obj : srcObjs) {
            TopLevelObject dim = obj.getModelSource();
            if (dim != null) {
                if (dim instanceof RelationalDimension) {
                    sharingEnabled &= ((RelationalDimension)dim).isShareable();
                    continue;
                }
                if (!(dim instanceof VirtualDimension)) continue;
                sharingEnabled &= ((VirtualDimension)dim).isSharingEnabledOnBaseDimensions();
                continue;
            }
            sharingEnabled = false;
        }
        return sharingEnabled;
    }
}

