/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmExpression;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmProxyLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualObject;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.LevelStyle;
import com.ibm.cognos.fmeng.fmmd.model.VirtualLevel;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.LevelStyleType;
import com.ibm.cognos.fmeng.genmodel.VirtualLevelType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmVirtualLevel
extends FmVirtualObject
implements VirtualLevel {
    public static VirtualLevel createVirtualLevel(EMFSession session, FmVirtualHierarchy parent, String name) {
        if (name == null || name.length() == 0) {
            name = FmVirtualLevel.getDefaultName(session.getActiveLocale());
        }
        VirtualLevelType vLvlType = GenmodelFactory.eINSTANCE.createVirtualLevelType();
        FmVirtualLevel.createVirtualObject(vLvlType);
        FmVirtualLevel vLvl = new FmVirtualLevel(session, vLvlType);
        parent.addVirtualLevel(vLvl);
        vLvl.setName(session.getProject().getDefaultLocale(), vLvl.makeUniqueName(name));
        return vLvl;
    }

    public static String getDefaultName(Locale locale) {
        return FmMessage.render("BMT_MDN_OBJECT_NAME_VIRTUAL_LEVEL", locale);
    }

    private FmVirtualLevel(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    @Override
    public FmObjectType getFmObjectType() {
        return FmObjectType.virtualLevel;
    }

    public static FmVirtualLevel get(FMMDSession session, Object object) {
        return new FmVirtualLevel(session, object);
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    private VirtualLevelType getVirtualLevelType() {
        return (VirtualLevelType)this.m_emfObject;
    }

    @Override
    public LevelStyle getLevelStyle() {
        return LevelStyle.valueOf(this.getVirtualLevelType().getLevelStyle().toString());
    }

    @Override
    public void setLevelStyle(LevelStyle style) {
        this.getVirtualLevelType().setLevelStyle(LevelStyleType.valueOf(style.toString().toUpperCase()));
    }

    @Override
    public boolean getGenerateRelativeTimeMembers() {
        if (this.isTimeLevel()) {
            return this.getVirtualLevelType().isSetIncludeRelativeTimeMembers();
        }
        return false;
    }

    @Override
    public void setGenerateRelativeTimeMembers(boolean generateRelativeTimeMembers) {
        if (!this.isTimeLevel()) {
            throw new FmMDException("BMT_MD_INVALID_GENERATE_RELATIVE_TIME_MEMBERS");
        }
        this.getVirtualLevelType().setIncludeRelativeTimeMembers(generateRelativeTimeMembers);
    }

    @Override
    public boolean isTimeLevel() {
        return this.getLevelStyle().isTimeLevel();
    }

    @Override
    public Expression getCurrentPeriodExpression() {
        if (this.isTimeLevel() && this.getVirtualLevelType().getCurrentPeriodExpression() != null) {
            return FmExpression.get((FMMDSession)this.m_session, this.getVirtualLevelType().getCurrentPeriodExpression());
        }
        return null;
    }

    @Override
    public Expression setCurrentPeriodExpression(ExpressionBuilder exprBuilder) {
        if (this.isTimeLevel()) {
            FmExpression exp = FmExpression.create((FMMDSession)this.m_session, exprBuilder);
            this.getVirtualLevelType().setCurrentPeriodExpression(exp.getExpressionType());
            return exp;
        }
        throw new FmMDException("BMT_MD_CURRENT_PERIOD_EXPRESSIONS_IN_TIME_DIMENSIONS_ONLY");
    }

    @Override
    public List<FmProxyLevel> getProxyHierarchies() {
        List<FmProxyLevel> proxyLevels = FmProxyLevel.collectLevels(this);
        return proxyLevels;
    }

    @Override
    public boolean isSameAsBaseObjects() {
        boolean ret = this.doNamesMatchWithSourceObjects();
        return ret;
    }

    public FmVirtualDimension getDimension() {
        return (FmVirtualDimension)this.getParent().getParent();
    }
}

