/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSourceMember;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.MemberUniqueNameBuilder;
import com.ibm.cognos.fmeng.fmmd.model.SourceMember;
import com.ibm.cognos.fmeng.fmmd.model.SourceObject;
import com.ibm.cognos.fmeng.fmmd.model.VirtualMember;
import com.ibm.cognos.fmeng.fmmd.model.VirtualObject;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.MergeOperatorType;
import com.ibm.cognos.fmeng.genmodel.NameType;
import com.ibm.cognos.fmeng.genmodel.SourceMemberType;
import com.ibm.cognos.fmeng.genmodel.VirtualCubeType;
import com.ibm.cognos.fmeng.genmodel.VirtualMemberType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmVirtualMember
extends FmReportObject
implements VirtualMember {
    public static FmVirtualMember createVirtualMember(FMMDSession session, FmVirtualHierarchy parent, String name) {
        if (name == null || name.length() == 0) {
            name = FmVirtualMember.getDefaultName(session.getActiveLocale());
        }
        VirtualMemberType vMemType = GenmodelFactory.eINSTANCE.createVirtualMemberType();
        FmVirtualMember vMem = new FmVirtualMember(session, vMemType);
        parent.addVirtualMember(vMem);
        vMem.setName(session.getProject().getDefaultLocale(), name);
        EObject eParent = vMemType.eContainer();
        while (eParent != null) {
            if (eParent instanceof VirtualCubeType) {
                vMemType.setMergeOperator(((VirtualCubeType)eParent).getMergeOperator());
                break;
            }
            eParent = eParent.eContainer();
        }
        return vMem;
    }

    public static FmVirtualMember get(FMMDSession session, Object object) {
        return new FmVirtualMember(session, object);
    }

    public static String getDefaultName(Locale locale) {
        return FmMessage.render("BMT_MDN_OBJECT_NAME_VIRTUAL_MEMBER", locale);
    }

    private FmVirtualMember(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    private VirtualMemberType getVirtualMemberType() {
        return (VirtualMemberType)this.m_emfObject;
    }

    @Override
    void addChild(Object eObj) {
        switch (this.m_session.getGateway().getClassifierType(eObj)) {
            case 160: {
                this.addSourceMember((SourceMemberType)eObj);
                break;
            }
            default: {
                super.addChild(eObj);
            }
        }
    }

    @Override
    public FmObjectType getFmObjectType() {
        return FmObjectType.virtualMember;
    }

    @Override
    public VirtualObject.MergeOperator getMergeOperator() {
        return VirtualObject.MergeOperator.valueOf(this.getVirtualMemberType().getMergeOperator().toString());
    }

    @Override
    public void setMergeOperator(VirtualObject.MergeOperator op) {
        MergeOperatorType mergeOp = MergeOperatorType.SUM;
        switch (op) {
            case subtract: {
                mergeOp = MergeOperatorType.SUBTRACT;
                break;
            }
            case divide: {
                mergeOp = MergeOperatorType.DIVIDE;
                break;
            }
            case multiply: {
                mergeOp = MergeOperatorType.MULTIPLY;
                break;
            }
            case maximum: {
                mergeOp = MergeOperatorType.MAXIMUM;
                break;
            }
            case minimum: {
                mergeOp = MergeOperatorType.MINIMUM;
                break;
            }
            case none: {
                mergeOp = MergeOperatorType.NONE;
            }
        }
        this.getVirtualMemberType().setMergeOperator(mergeOp);
    }

    @Override
    public void setPrecedence(BigInteger precedence) {
        this.getVirtualMemberType().setPrecedence(precedence);
    }

    @Override
    public BigInteger getPrecedence() {
        return this.getVirtualMemberType().getPrecedence();
    }

    @Override
    public boolean getHidden() {
        return this.getVirtualMemberType().isHidden();
    }

    @Override
    public void setHidden(boolean hidden) {
        this.getVirtualMemberType().setHidden(hidden);
    }

    @Override
    public SourceMember createSourceMember(SourceObject srcHierarchy, MemberUniqueNameBuilder munBuilder) {
        return FmSourceMember.createSourceMember(this.m_session, this, srcHierarchy, munBuilder);
    }

    @Override
    public List<SourceMember> getSourceMembers() {
        ArrayList<SourceMember> sources = new ArrayList<SourceMember>();
        EObject obj = (EObject)this.m_emfObject;
        while (obj != null) {
            if (obj instanceof VirtualCubeType) {
                FmVirtualCube cube = FmVirtualCube.get(this.m_session, obj);
                block1: for (SourceObject srcCube : cube.getSourceObjects()) {
                    for (SourceMemberType source : this.getVirtualMemberType().getSourceMember()) {
                        FmSourceMember src = FmSourceMember.get(this.m_session, source);
                        if (!src.getCubeSource().equals(srcCube)) continue;
                        sources.add(src);
                        continue block1;
                    }
                }
                FmMDException.ASSERT(this.getVirtualMemberType().getSourceMember().size() == sources.size(), "Failed to fetch the correct number of source objects for " + this.getName());
            }
            obj = obj.eContainer();
        }
        return sources;
    }

    public void addSourceMember(FmSourceMember srcMember) {
        this.addSourceMember((SourceMemberType)srcMember.getInternal());
    }

    private void addSourceMember(SourceMemberType srcMember) {
        this.getVirtualMemberType().getSourceMember().add((Object)srcMember);
    }

    @Override
    public void removeSourceMember(SourceMember member) {
        SourceMemberType srcMember = (SourceMemberType)((FmSourceMember)member).getInternal();
        this.getVirtualMemberType().getSourceMember().remove((Object)srcMember);
    }

    @Override
    public void setName(String localeKey, String nameValue) {
        this.setMultilingualValue((List<NameType>)this.getReportObjectType().getName(), localeKey, nameValue);
    }

    @Override
    public String getID() {
        return "";
    }
}

