/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSourceObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualCube;
import com.ibm.cognos.fmeng.fmmd.model.LocalizedValue;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.SourceObject;
import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.genmodel.SourceObjectType;
import com.ibm.cognos.fmeng.genmodel.SourceObjectsType;
import com.ibm.cognos.fmeng.genmodel.VirtualCubeType;
import com.ibm.cognos.fmeng.genmodel.VirtualObjectType;
import com.ibm.cognos.fmeng.metadata.MdOLAPBase;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FmVirtualObject
extends FmReportObject {
    protected FmVirtualObject(FMMDSession session, Object emfObject) {
        super(session, emfObject);
    }

    protected static void createVirtualObject(VirtualObjectType vObject) {
        SourceObjectsType sourceObjectsType = GenmodelFactory.eINSTANCE.createSourceObjectsType();
        vObject.setSourceObjects(sourceObjectsType);
    }

    public abstract boolean isSameAsBaseObjects();

    public void addSourceObject(FmSourceObject source) {
        this.addSourceObject((SourceObjectType)source.getInternal());
    }

    protected void addSourceObject(SourceObjectType source) {
        this.getVirtualObjectType().getSourceObjects().getSourceObject().add((Object)source);
    }

    private VirtualObjectType getVirtualObjectType() {
        return (VirtualObjectType)this.m_emfObject;
    }

    public List<SourceObject> getSourceObjects() {
        ArrayList<SourceObject> sources = new ArrayList<SourceObject>();
        if (this instanceof FmVirtualCube) {
            for (SourceObjectType source : this.getVirtualObjectType().getSourceObjects().getSourceObject()) {
                sources.add(FmSourceObject.get(this.getSession(), source));
            }
        } else {
            EObject obj = (EObject)this.m_emfObject;
            while (obj != null) {
                if (obj instanceof VirtualCubeType) {
                    FmVirtualCube cube = FmVirtualCube.get(this.m_session, obj);
                    block2: for (SourceObject srcCube : cube.getSourceObjects()) {
                        for (SourceObjectType source : this.getVirtualObjectType().getSourceObjects().getSourceObject()) {
                            FmSourceObject src = FmSourceObject.get(this.m_session, source);
                            if (!src.getCubeSource().equals(srcCube)) continue;
                            sources.add(src);
                            continue block2;
                        }
                    }
                    FmMDException.ASSERT(this.getVirtualObjectType().getSourceObjects().getSourceObject().size() == sources.size(), "Failed to fetch the correct number of source objects for " + this.getName());
                }
                obj = obj.eContainer();
            }
        }
        return sources;
    }

    public void repair() {
        ArrayList<FmSourceObject> toDelete = new ArrayList<FmSourceObject>();
        for (SourceObjectType src : this.getVirtualObjectType().getSourceObjects().getSourceObject()) {
            FmSourceObject fmSrc = FmSourceObject.get(this.m_session, src);
            if (fmSrc.repair()) continue;
            toDelete.add(fmSrc);
        }
        if (toDelete.size() > 0) {
            this.m_session.delete(toDelete);
        }
    }

    public SourceObject createSourceObject(SourceObject parentSource, ReportObject sourceObject) {
        return FmSourceObject.createSourceObject(this.getSession(), this, (FmSourceObject)parentSource, sourceObject);
    }

    public SourceObject createSourceObject(SourceObject parentSource, MdOLAPBase sourceObject) {
        return FmSourceObject.createSourceObject(this.getSession(), this, (FmSourceObject)parentSource, sourceObject);
    }

    public boolean doNamesMatchWithSourceObjects() {
        List<LocalizedValue> nameValues = this.getNames();
        List<SourceObject> srcObjs = this.getSourceObjects();
        for (SourceObject srcObj : srcObjs) {
            ReportObject src = (ReportObject)srcObj.getModelSource();
            if (src == null) continue;
            for (LocalizedValue name : nameValues) {
                String locale = name.getLocale();
                String srcValue = src.getName(locale);
                if (srcValue != null && srcValue.equals(name.getValue())) continue;
                return false;
            }
        }
        return true;
    }
}

