/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.autoDesigner;

import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.smd.ISmartMetadata;
import com.ibm.cognos.aurora.api.smd.SMDAPI;
import com.ibm.cognos.aurora.api.smd.SmdReqContext;
import com.ibm.cognos.aurora.core.model.NavigationHelper;
import com.ibm.cognos.fmeng.fmmd.util.StringHelper;
import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmPreferences;
import com.ibm.cognos.smd.importer.Importer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmdHelper {
    private FMMDSession m_session = null;
    private NavigationHelper m_navHelper = null;
    private static Importer gImporter = null;

    public static SmdHelper getSmdHelper(FMMDSession session) {
        if (gImporter == null) {
            ISmartMetadata gSMD = SMDAPI.getInstance(null);
            Properties props = new Properties();
            props.put("aurora.temp_dir", "../temp");
            gImporter = new Importer(props, gSMD, null);
        }
        return new SmdHelper(session);
    }

    private SmdHelper(FMMDSession session) {
        this.m_session = session;
    }

    public void processData(String csvFilePath) {
        IAssociativeModel model = gImporter.importDocument(csvFilePath);
        SmdReqContext smdContext = new SmdReqContext(SmdReqContext.EScope.eBuildHierarchicalCategories);
        smdContext.addAnalysisOption(SmdReqContext.EOption.eContentLocale, (Object)new Locale(this.m_session.getDefaultLocale()));
        Document docReport = gImporter.getSMD().analyze(model, smdContext);
        this.m_navHelper = new NavigationHelper(model);
        boolean debug = false;
        FmPreferences prefs = FmPreferences.getInstance();
        String prefValue = prefs.getFMPreference("AutoDesign", "dumpSMD");
        if (prefValue != null) {
            debug = prefValue.equalsIgnoreCase("true");
        }
        if (debug) {
            try {
                FileOutputStream fos = new FileOutputStream("../logs/SDM_report.xml");
                OutputFormat format = OutputFormat.createPrettyPrint();
                XMLWriter writer = new XMLWriter((OutputStream)fos, format);
                writer.write(docReport);
                writer.flush();
                fos.close();
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream("../logs/SMD_model.xml"), Charset.forName("UTF-8"));
                this.m_navHelper.modelAsXML(osw);
            }
            catch (IOException e) {
                FmEngApplicationLog.getApplicationLog().logException(e);
            }
        }
    }

    public List<LevelCandidate> getCandidateLevels() {
        ArrayList<LevelCandidate> results = new ArrayList<LevelCandidate>();
        List hierarchies = this.m_navHelper.getDetectedHierarchies();
        if (hierarchies.isEmpty()) {
            hierarchies = this.m_navHelper.getRootNodes();
        }
        if (!hierarchies.isEmpty()) {
            INode hierarchy = (INode)hierarchies.get(0);
            List levelNodes = NavigationHelper.getPartNodes((INode)hierarchy);
            levelNodes.add(0, hierarchy);
            for (INode node : levelNodes) {
                String levelName = "";
                LevelCandidate toplc = new LevelCandidate(levelName, node);
                List rcolNode = NavigationHelper.getAttributeNodes((INode)node);
                for (INode col : rcolNode) {
                    if (levelName.isEmpty()) {
                        levelName = StringHelper.prettyPrint(col.getDataItem().getName());
                    }
                    if (col.getConcept().is("cCaption") || col.getConcept().is("cIdentifier")) {
                        levelName = StringHelper.prettyPrint(col.getDataItem().getName());
                    }
                    String columnName = col.getDataItem().getName();
                    String attributeName = String.valueOf(columnName) + " " + Integer.toString((int)col.getDataItem().getStats().distinctCount());
                    toplc.addColumn(columnName, attributeName, col);
                }
                toplc.name = levelName;
                results.add(toplc);
            }
        }
        return results;
    }

    public class LevelCandidate {
        public String name = null;
        public List<ColumnCandidate> columns = null;
        private INode optionalNode = null;

        public LevelCandidate(String levelName, INode node) {
            this.name = levelName;
            this.columns = new ArrayList<ColumnCandidate>();
            this.optionalNode = node;
        }

        public void addColumn(String colName, String attName, INode col) {
            this.columns.add(new ColumnCandidate(colName, attName, col));
        }

        public boolean isNominal() {
            if (this.optionalNode != null) {
                return this.optionalNode.getConcept().getName().equals("cNominal");
            }
            return false;
        }

        public class ColumnCandidate {
            public String columnName;
            public String attributeName;
            private INode column;

            public ColumnCandidate(String name, String aName, INode col) {
                this.columnName = name;
                this.attributeName = aName;
                this.column = col;
            }

            public boolean canBeCaption() {
                return this.column.getConcept().getName().equals("cCaption");
            }

            public boolean canBeIndentifier() {
                return this.column.getConcept().getName().equals("cIdentifier");
            }

            public boolean isString() {
                return this.column.getDataItem().getDataType().isString();
            }
        }
    }
}

