/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmAccessRule;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCalculatedMember;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmExpression;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevelReference;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMemberUniqueName;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.model.AccessRule;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.RelationalQuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.TaskAnalyseObject;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessRuleAnalyser
extends AnalyserBase<FmAccessRule> {
    private FmReportObject m_ParentObject = null;

    public AccessRuleAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public AccessRuleAnalyser(AnalyserConfig config) {
        super(config);
    }

    @Override
    protected void doAnalysis(FmAccessRule obj) {
        this.checkForInvalidROLAPCharacter(obj);
        this.m_ParentObject = (FmReportObject)obj.getParent().getParent();
        if (this.m_Config.getContext().equals((Object)TaskAnalyseObject.AnalysisContext.publish)) {
            switch (obj.getRestrictObjectType()) {
                case member: {
                    switch (obj.getRuleStyle()) {
                        case lookupTableBased: {
                            this.checkForMissingLevelKeyToQueryItemMapping(obj);
                            this.checkForGappedLevelKeyToQueryItemMapping(obj);
                            this.checkForChildItemMapping(obj);
                            break;
                        }
                        case roleBased: {
                            if (obj.getAllAccess()) break;
                            this.checkForRefrencesInAHierarchy(obj);
                        }
                    }
                    this.checkForFilterExpression(obj);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkForRefrencesInAHierarchy(FmAccessRule accessRule) {
        block10: {
            if (!(this.m_ParentObject instanceof FmRelationalHierarchy) || accessRule.getExpression() == null) break block10;
            parentDim = (FmRelationalDimension)this.m_ParentObject.getParent();
            for (Object obj : accessRule.getExpression().getComponents()) {
                block11: {
                    name = null;
                    if (!(obj instanceof FmReportObject)) break block11;
                    name = ((BaseObject)obj).getName();
                    if (!(obj instanceof FmCalculatedMember)) ** GOTO lbl12
                    if (!(((FmCalculatedMember)obj).getRelationalParent() instanceof FmRelationalDimension)) break block11;
                    obj = ((FmCalculatedMember)obj).getRelationalParent();
                    break block11;
lbl-1000:
                    // 1 sources

                    {
                        obj = ((FmBaseObject)obj).getParent();
lbl12:
                        // 2 sources

                        ** while (!(obj instanceof FmRelationalObject))
                    }
lbl13:
                    // 1 sources

                    if (!(obj instanceof FmRelationalDimension)) {
                        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_OBJ_IN_ACCESSRULE_EXPRESSION, FeedbackMessage.FeedbackSeverity.ERROR, accessRule.getName(), ((FmRelationalHierarchy)this.m_ParentObject).getParent().getName(), name, (FmBaseObject)this.m_ParentObject));
                    }
                }
                if (obj instanceof FmLevelReference) {
                    obj = ((FmLevelReference)obj).getLevel().getDimension();
                    name = ((BaseObject)obj).getName();
                }
                if (obj instanceof FmMemberUniqueName) {
                    name = ((FmMemberUniqueName)obj).getMemberCaption();
                    if (((FmMemberUniqueName)obj).getRawRefObjs().size() > 1) {
                        obj = ((FmMemberUniqueName)obj).getRawRefObjs().get(1);
                        while (!(obj instanceof FmRelationalDimension)) {
                            obj = ((FmBaseObject)obj).getParent();
                        }
                    }
                }
                if (!(obj instanceof FmRelationalDimension) || parentDim.equals(dim = (FmRelationalDimension)obj)) continue;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MULTI_REF_OBJ_IN_DIFF_DIM, FeedbackMessage.FeedbackSeverity.WARNING, accessRule.getName(), this.m_ParentObject.getName(), ((FmRelationalHierarchy)this.m_ParentObject).getParent().getName(), name, (FmBaseObject)this.m_ParentObject));
                break;
            }
        }
    }

    private void checkForMissingLevelKeyToQueryItemMapping(FmAccessRule accessRule) {
        FmRelationalHierarchy hier;
        if (this.m_ParentObject instanceof FmRelationalHierarchy && !(hier = (FmRelationalHierarchy)this.m_ParentObject).getParentChild()) {
            boolean found = false;
            if (accessRule.getRuleStyle().equals((Object)AccessRule.RuleStyle.lookupTableBased)) {
                if (accessRule.getMappedLevelKeys().isEmpty()) {
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MISSING_LEVEL_KEY_TO_QUERY_ITEM_MAP, FeedbackMessage.FeedbackSeverity.ERROR, accessRule.getName(), this.m_ParentObject.getName(), ((FmRelationalHierarchy)this.m_ParentObject).getParent().getName(), (FmBaseObject)this.m_ParentObject));
                } else {
                    List<QueryItem> levelKeys = accessRule.getMappedLevelKeys();
                    for (QueryItem levelKey : levelKeys) {
                        if (accessRule.getLevelKeyToQueryItem(levelKey) == null) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MISSING_LEVEL_KEY_TO_QUERY_ITEM_MAP, FeedbackMessage.FeedbackSeverity.ERROR, accessRule.getName(), this.m_ParentObject.getName(), ((FmRelationalHierarchy)this.m_ParentObject).getParent().getName(), (FmBaseObject)this.m_ParentObject));
                    }
                }
            }
        }
    }

    private void checkForGappedLevelKeyToQueryItemMapping(FmAccessRule accessRule) {
        List<QueryItem> levelKeys;
        boolean gapFound = false;
        if (accessRule.getRuleStyle().equals((Object)AccessRule.RuleStyle.lookupTableBased) && !(levelKeys = accessRule.getLevelKeys()).isEmpty()) {
            List<QueryItem> mappedLevelKeys = accessRule.getMappedLevelKeys();
            for (QueryItem levelKey : levelKeys) {
                if (accessRule.getLevelKeyToQueryItem(levelKey) != null && levelKey.getLevel() != null) {
                    for (QueryItem lvlKey : levelKey.getLevel().getLevelKeys()) {
                        if (!levelKeys.contains(lvlKey) || mappedLevelKeys.contains(lvlKey)) continue;
                        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.GAPPED_LEVEL_KEY_TO_QUERY_ITEM_MAP, FeedbackMessage.FeedbackSeverity.ERROR, accessRule.getName(), this.m_ParentObject.getName(), ((FmRelationalHierarchy)this.m_ParentObject).getParent().getName(), levelKey.getLevel().getName(), (FmBaseObject)this.m_ParentObject));
                        gapFound = true;
                        break;
                    }
                }
                if (gapFound) break;
            }
        }
    }

    private void checkForFilterExpression(AccessRule accessRule) {
        if (accessRule.getRuleStyle().equals((Object)AccessRule.RuleStyle.lookupTableBased)) {
            RelationalQuerySubject querySubject;
            FmExpression expr = (FmExpression)accessRule.getFilterExpression();
            if (!this.checkEmptyExpression((FmAccessRule)accessRule, expr) && (querySubject = accessRule.getFilterQuerySubject()) != null) {
                for (Object obj : accessRule.getFilterExpression().getComponents()) {
                    if (!(obj instanceof FmQueryItem)) continue;
                    boolean found = false;
                    for (QueryItem qItem : querySubject.getAllQueryItems()) {
                        if (!qItem.equals((QueryItem)obj)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.WRONG_QUERY_ITEM_IN_EXPR, FeedbackMessage.FeedbackSeverity.ERROR, accessRule.getName(), querySubject.getName(), this.m_ParentObject));
                    break;
                }
            }
        } else if (!accessRule.getAllAccess()) {
            FmExpression expr = (FmExpression)accessRule.getExpression();
            this.checkMDXExpression((FmAccessRule)accessRule, expr);
        }
    }

    private void checkForChildItemMapping(AccessRule accessRule) {
        QueryItem childItem;
        FmRelationalHierarchy hier;
        if (accessRule.getRuleStyle().equals((Object)AccessRule.RuleStyle.lookupTableBased) && this.m_ParentObject instanceof FmRelationalHierarchy && (hier = (FmRelationalHierarchy)this.m_ParentObject).getParentChild() && ((childItem = hier.getChildItem()) == null || accessRule.getLevelKeyToQueryItem(childItem) == null)) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.CHILD_ITEM_NOT_MAPPED, FeedbackMessage.FeedbackSeverity.ERROR, this.m_ParentObject.getName(), this.m_ParentObject));
        }
    }
}

